/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.patch;

import org.eclipse.compare.internal.core.patch.DiffProject;
import org.eclipse.compare.internal.core.patch.FileDiffResult;
import org.eclipse.compare.internal.core.patch.FilePatch2;
import org.eclipse.compare.internal.core.patch.HunkResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ui.synchronize.patch.FilePatchResourceMapping;
import org.eclipse.team.internal.ui.synchronize.patch.HunkResourceMapping;

public class DiffProjectResourceMapping
extends ResourceMapping {
    private final DiffProject object;

    public DiffProjectResourceMapping(DiffProject adaptableObject) {
        this.object = adaptableObject;
    }

    public Object getModelObject() {
        return this.object;
    }

    public String getModelProviderId() {
        return "org.eclipse.team.ui.patchModelProvider";
    }

    public IProject[] getProjects() {
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(this.object.getName());
        return new IProject[]{p};
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.getResource()}, 2, 0)};
    }

    private IResource getResource() {
        return this.getProjects()[0];
    }

    public boolean contains(ResourceMapping mapping) {
        if (mapping instanceof DiffProjectResourceMapping) {
            DiffProject diffProject = (DiffProject)mapping.getModelObject();
            return diffProject.getName().equals(this.object.getName());
        }
        if (mapping instanceof FilePatchResourceMapping) {
            FilePatch2[] filePatches;
            FileDiffResult filePatch = (FileDiffResult)mapping.getModelObject();
            FilePatch2[] filePatch2Array = filePatches = this.object.getFileDiffs();
            int n = filePatches.length;
            int n2 = 0;
            while (n2 < n) {
                FilePatch2 filePatche = filePatch2Array[n2];
                if (filePatche.getPath(false).equals((Object)filePatch.getTargetPath())) {
                    return true;
                }
                ++n2;
            }
        } else if (mapping instanceof HunkResourceMapping) {
            HunkResult hunk = (HunkResult)mapping.getModelObject();
            DiffProject diffProject = hunk.getHunk().getParent().getProject();
            return diffProject.getName().equals(this.object.getName());
        }
        return super.contains(mapping);
    }
}

