package org.jabref.logic.importer.fileformat;

import java.io.IOException;
import java.util.function.Predicate;
import java.util.stream.Stream;

import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CopacImporterFilesTest {

    private static final String FILE_ENDING = ".txt";

    private static Stream<String> fileNames() throws IOException {
        Predicate<String> fileName = name -> name.startsWith("CopacImporterTest")
                && name.endsWith(FILE_ENDING);
        return ImporterTestEngine.getTestFiles(fileName).stream();
    }

    private static Stream<String> nonCopacfileNames() throws IOException {
        Predicate<String> fileName = name -> !name.startsWith("CopacImporterTest");
        return ImporterTestEngine.getTestFiles(fileName).stream();
    }

    @ParameterizedTest
    @MethodSource("fileNames")
    public void isRecognizedFormat(String fileName) throws IOException {
        ImporterTestEngine.testIsRecognizedFormat(new CopacImporter(), fileName);
    }

    @ParameterizedTest
    @MethodSource("nonCopacfileNames")
    public void isNotRecognizedFormat(String fileName) throws IOException {
        ImporterTestEngine.testIsNotRecognizedFormat(new CopacImporter(), fileName);
    }

    @ParameterizedTest
    @MethodSource("fileNames")
    public void importEntries(String fileName) throws Exception {
        ImporterTestEngine.testImportEntries(new CopacImporter(), fileName, FILE_ENDING);
    }
}
