# Development Conventions

## Coding Style

*   **Linting**: Run `flake8 src/M2Crypto/` (Configured in `setup.cfg`).
*   **Type Checking**: Run `make mypy`.
*   **Formatting**: Follow PEP 8.
*   **Imports**: Group by standard lib, third-party, local. Blank lines between groups.

## Naming Conventions

*   `snake_case`: Variables, functions, methods.
*   `CamelCase`: Class names.
*   `UPPER_CASE`: Constants.
*   `_leading_underscore`: Protected members.
*   `__double_leading_underscore`: Private members.

## Documentation

*   Use docstrings for modules, classes, and functions.
*   Update `doc/` when making significant changes.

## File Structure

```
m2crypto/
├── src/
│   └── M2Crypto/      # Source code
├── tests/             # Unit tests (test_*.py)
├── doc/               # Documentation
├── Makefile           # Build management
├── setup.py           # Python package config
└── .gitlab-ci.yml     # CI configuration
```
