################################################################################
# inc/gcol_rejected.inc                                                        #
#                                                                              #
# Purpose:                                                                     #
#  Testing rejected generated column additions.                                #
#                                                                              #
################################################################################

CREATE TABLE t1 (
 pk INTEGER PRIMARY KEY,
 i8 BIGINT,
 i4 INTEGER,
 i2 SMALLINT,
 i1 TINYINT,
 i8u BIGINT UNSIGNED,
 i4u INTEGER UNSIGNED,
 i2u SMALLINT UNSIGNED,
 i1u TINYINT UNSIGNED,
 f4 REAL,
 f8 DOUBLE PRECISION,
 dc DECIMAL(10, 2),
 fc CHAR(10),
 vc VARCHAR(10),
 fb BINARY(8),
 vb VARBINARY(8),
 d  DATE,
 t  TIME,
 dt DATETIME,
 ts TIMESTAMP
);

INSERT INTO t1 VALUES
(0, -9223372036854775808, -2147483648, -32768, -128,
 0, 0, 0, 0, -99999999.99, -99999999.99, -99999999.99,
 'abcdefgh', 'abcdefgh', 'abcdefgh', 'abcdefgh',
 DATE '1000-01-01', TIME '00:00:00', TIMESTAMP '1000-01-01 00:00:00',
 TIMESTAMP '1970-01-01 12:00:00'),
(1, 9223372036854775807, 2147483647, 32767, 127,
 18446744073709551615, 4294967295, 65535, 255, 99999999.99, 99999999.99,
 99999999.99, 'abcdefgh', 'abcdefgh', 'abcdefgh', 'abcdefgh',
 DATE '9999-12-31', TIME '23:59:59', TIMESTAMP '9999-12-31 23:59:59',
 TIMESTAMP '2038-01-01 23:59:59');

# MySQL does not report a range error for signed <-> unsigned conversion.
# Note also there are several similar anomalies below.
#--error ER_WARN_DATA_OUT_OF_RANGE
#ALTER TABLE t1 ADD gc BIGINT AS (i8u) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc BIGINT UNSIGNED AS (i8) STORED;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc BIGINT AS (fc) STORED;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc BIGINT AS (vc) STORED;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc BIGINT AS (fb) STORED;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc BIGINT AS (vb) STORED;

--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc INTEGER AS (i8) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc INTEGER AS (i8u) STORED;
#--error ER_WARN_DATA_OUT_OF_RANGE
#ALTER TABLE t1 ADD gc INTEGER AS (i4u) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc INTEGER UNSIGNED AS (i8) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc INTEGER UNSIGNED AS (i8u) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc INTEGER UNSIGNED AS (i4) STORED;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc INTEGER AS (fc) STORED;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc INTEGER AS (vc) STORED;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc INTEGER AS (fb) STORED;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc INTEGER AS (vb) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc INTEGER AS (d) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc INTEGER AS (dt) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc INTEGER AS (ts) STORED;

--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (i8) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (i8u) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (i4) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (i4u) STORED;
#--error ER_WARN_DATA_OUT_OF_RANGE
#ALTER TABLE t1 ADD gc SMALLINT AS (i2u) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (dc) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (f4) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (f8) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT UNSIGNED AS (i8) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT UNSIGNED AS (i8u) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT UNSIGNED AS (i4) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT UNSIGNED AS (i4u) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT UNSIGNED AS (i2) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT UNSIGNED AS (dc) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT UNSIGNED AS (f4) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT UNSIGNED AS (f8) STORED;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc SMALLINT AS (fc) STORED;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc SMALLINT AS (vc) STORED;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc SMALLINT AS (fb) STORED;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc SMALLINT AS (vb) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (t) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (d) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (dt) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (ts) STORED;

--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (i8) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (i8u) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (i4) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (i4u) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (i2) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (i2u) STORED;
#--error ER_WARN_DATA_OUT_OF_RANGE
#ALTER TABLE t1 ADD gc TINYINT AS (i1u) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (dc) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (f4) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (f8) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT UNSIGNED AS (i8) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT UNSIGNED AS (i8u) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT UNSIGNED AS (i4) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT UNSIGNED AS (i4u) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT UNSIGNED AS (i2) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT UNSIGNED AS (i2u) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT UNSIGNED AS (i1) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT UNSIGNED AS (dc) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT UNSIGNED AS (f4) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT UNSIGNED AS (f8) STORED;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc TINYINT AS (fc) STORED;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc TINYINT AS (vc) STORED;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc TINYINT AS (fb) STORED;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc TINYINT AS (vb) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (t) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (d) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (dt) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (ts) STORED;

--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc DECIMAL(10,2) AS (i8) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc DECIMAL(10,2) AS (i8u) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc DECIMAL(10,2) AS (i4) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc DECIMAL(10,2) AS (i4u) STORED;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc DECIMAL(10,2) AS (fc) STORED;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc DECIMAL(10,2) AS (vc) STORED;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc DECIMAL(10,2) AS (fb) STORED;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc DECIMAL(10,2) AS (vb) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc DECIMAL(10,2) AS (dt) STORED;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc DECIMAL(10,2) AS (ts) STORED;

--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATE AS (i8) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATE AS (i4) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATE AS (i2) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATE AS (i1) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATE AS (dc) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATE AS (f4) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATE AS (fc) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATE AS (vc) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATE AS (fb) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATE AS (vb) STORED;

--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIME AS (i8) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIME AS (i4) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIME AS (i2) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIME AS (dc) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIME AS (f4) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIME AS (fc) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIME AS (vc) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIME AS (fb) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIME AS (vb) STORED;

--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATETIME AS (i8) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATETIME AS (i4) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATETIME AS (i2) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATETIME AS (i1) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATETIME AS (dc) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATETIME AS (f4) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATETIME AS (fc) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATETIME AS (vc) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATETIME AS (fb) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATETIME AS (vb) STORED;

--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIMESTAMP AS (i8) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIMESTAMP AS (i4) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIMESTAMP AS (i2) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIMESTAMP AS (i1) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIMESTAMP AS (dc) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIMESTAMP AS (f4) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIMESTAMP AS (fc) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIMESTAMP AS (vc) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIMESTAMP AS (fb) STORED;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIMESTAMP AS (vb) STORED;

#--error ER_WARN_DATA_OUT_OF_RANGE
#ALTER TABLE t1 ADD gc BIGINT AS (i8u) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc BIGINT UNSIGNED AS (i8) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc BIGINT AS (fc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc BIGINT AS (vc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc BIGINT AS (fb) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc BIGINT AS (vb) VIRTUAL;

--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc INTEGER AS (i8) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc INTEGER AS (i8u) VIRTUAL;
#--error ER_WARN_DATA_OUT_OF_RANGE
#ALTER TABLE t1 ADD gc INTEGER AS (i4u) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc INTEGER UNSIGNED AS (i8) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc INTEGER UNSIGNED AS (i8u) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc INTEGER UNSIGNED AS (i4) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc INTEGER AS (fc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc INTEGER AS (vc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc INTEGER AS (fb) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc INTEGER AS (vb) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc INTEGER AS (d) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc INTEGER AS (dt) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc INTEGER AS (ts) VIRTUAL;

--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (i8) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (i8u) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (i4) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (i4u) VIRTUAL;
#--error ER_WARN_DATA_OUT_OF_RANGE
#ALTER TABLE t1 ADD gc SMALLINT AS (i2u) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (dc) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (f4) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (f8) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT UNSIGNED AS (i8) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT UNSIGNED AS (i8u) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT UNSIGNED AS (i4) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT UNSIGNED AS (i4u) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT UNSIGNED AS (i2) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT UNSIGNED AS (dc) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT UNSIGNED AS (f4) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT UNSIGNED AS (f8) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc SMALLINT AS (fc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc SMALLINT AS (vc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc SMALLINT AS (fb) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc SMALLINT AS (vb) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (t) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (d) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (dt) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc SMALLINT AS (ts) VIRTUAL;

--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (i8) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (i8u) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (i4) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (i4u) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (i2) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (i2u) VIRTUAL;
#--error ER_WARN_DATA_OUT_OF_RANGE
#ALTER TABLE t1 ADD gc TINYINT AS (i1u) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (dc) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (f4) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (f8) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT UNSIGNED AS (i8) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT UNSIGNED AS (i8u) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT UNSIGNED AS (i4) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT UNSIGNED AS (i4u) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT UNSIGNED AS (i2) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT UNSIGNED AS (i2u) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT UNSIGNED AS (i1) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT UNSIGNED AS (dc) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT UNSIGNED AS (f4) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT UNSIGNED AS (f8) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc TINYINT AS (fc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc TINYINT AS (vc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc TINYINT AS (fb) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc TINYINT AS (vb) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (t) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (d) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (dt) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc TINYINT AS (ts) VIRTUAL;

--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc DECIMAL(10,2) AS (i8) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc DECIMAL(10,2) AS (i8u) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc DECIMAL(10,2) AS (i4) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc DECIMAL(10,2) AS (i4u) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc DECIMAL(10,2) AS (fc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc DECIMAL(10,2) AS (vc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc DECIMAL(10,2) AS (fb) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE_FOR_FIELD
ALTER TABLE t1 ADD gc DECIMAL(10,2) AS (vb) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc DECIMAL(10,2) AS (dt) VIRTUAL;
--error ER_WARN_DATA_OUT_OF_RANGE
ALTER TABLE t1 ADD gc DECIMAL(10,2) AS (ts) VIRTUAL;

--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATE AS (i8) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATE AS (i4) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATE AS (i2) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATE AS (i1) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATE AS (dc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATE AS (f4) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATE AS (fc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATE AS (vc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATE AS (fb) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATE AS (vb) VIRTUAL;

--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIME AS (i8) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIME AS (i4) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIME AS (i2) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIME AS (dc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIME AS (f4) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIME AS (fc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIME AS (vc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIME AS (fb) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIME AS (vb) VIRTUAL;

--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATETIME AS (i8) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATETIME AS (i4) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATETIME AS (i2) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATETIME AS (i1) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATETIME AS (dc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATETIME AS (f4) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATETIME AS (fc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATETIME AS (vc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATETIME AS (fb) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc DATETIME AS (vb) VIRTUAL;

--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIMESTAMP AS (i8) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIMESTAMP AS (i4) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIMESTAMP AS (i2) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIMESTAMP AS (i1) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIMESTAMP AS (dc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIMESTAMP AS (f4) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIMESTAMP AS (fc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIMESTAMP AS (vc) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIMESTAMP AS (fb) VIRTUAL;
--error ER_TRUNCATED_WRONG_VALUE
ALTER TABLE t1 ADD gc TIMESTAMP AS (vb) VIRTUAL;

drop table t1;
