 TITLE '                    CMPSC -- Compression Call instruction test'
***********************************************************************
*
*             CMPSC -- Compression Call instruction test
*
***********************************************************************
*
*   PLEASE NOTE that this test only performs the simplest most basic
*   test of the CMPSC instruction.  It does NOT test all aspects of
*   the instruction.  We have a separate much more thorough and much
*   longer running test program for that.  This test only compresses
*   a small amount of data and then expands it and verifies that what
*   was expanded matches what it started with.  It does NOT check for
*   a valid condition code or anything else.  It's designed to be run
*   as part of "make test" after a build of Hercules and thus cannot
*   run for a very long time (and besides, as I said, we already have
*   a separate offline program that does a much better job of that).
*
*
*                    -- Sample runtest script --
*
*
*   *Testcase CMPSC (Compression Call)
*   mainsize  2
*   numcpu    1
*   sysclear
*   archlvl   z/Arch
*   loadcore  "$(testpath)/CMPSC.core"
*   runtest   1
*   *Done
*
*
***********************************************************************
                                                                EJECT
         PRINT OFF
         COPY  'satk.mac'
         PRINT ON
         PRINT DATA
                                                                SPACE
***********************************************************************
*        SATK prolog stuff...
***********************************************************************
                                                                SPACE
         ARCHLVL  MNOTE=NO
                                                                EJECT
***********************************************************************
*        Initiate the CMPSC CSECT in the CODE region
*        with the location counter at 0
***********************************************************************
                                                                SPACE
CMPSC    ASALOAD  REGION=CODE
                                                                EJECT
***********************************************************************
*        Define the z/Arch RESTART PSW
***********************************************************************
                                                                SPACE
PREVORG  EQU   *
         ORG   CMPSC+X'1A0'
*        PSWZ  <sys>,<key>,<mwp>,<prog>,<addr>[,amode]
         PSWZ  0,0,0,0,X'200',64
         ORG   PREVORG
                                                                SPACE 3
***********************************************************************
*        Create IPL (restart) PSW
***********************************************************************
                                                                SPACE
         ASAIPL   IA=BEGIN
                                                                EJECT
***********************************************************************
*               The actual CMPSC program itself...
***********************************************************************
                                                                SPACE
         USING CMPSC,R0           No base registers needed
                                                                SPACE 2
BEGIN    DS    0H
*
**       COMPRESS the data...
*
         LG    R0,CMP_R0          R0 <== Compress
         LG    R1,CMP_R1          R1 <== Compress
         LG    R2,=AD(CMPADDR)    R2 --> Compression buffer
         LG    R3,=AD(1024)       R3 <== Compression buffer size
         LG    R4,=AD(INADDR)     R4 --> Input data
         LG    R5,=AD(INSIZE)     R5 <== Input size
         CMPSC R2,R4              Compress data
*
**       Calculate length of compressed data
*
         LG    R6,=AD(1024)       R6 <== Original R3 value
         SGR   R6,R3              Subtract ending R3 value
         AG    R6,=AD(1)          Plus +1 to get true length
*
**       EXPAND what we compressed...
*
         LG    R0,EXP_R0          R0 <== Expand
         LG    R1,EXP_R1          R0 <== Expand
         LG    R2,=AD(EXPADDR)    R2 --> Expansion buffer
         LG    R3,=AD(1024)       R3 <== Expansion vuffer size
         LG    R4,=AD(CMPADDR)    R4 --> Input data
         LGR   R5,R6              R5 <== Input size
         CMPSC R2,R4              Expand data
*
**       VERIFY it matches original input data...
*
         LG    R2,=AD(INADDR)     R2 --> Original input data
         LG    R3,=AD(INSIZE)     R3 <== Original input size
         LG    R4,=AD(EXPADDR)    R4 --> Expanded data
         LG    R5,=AD(INSIZE)     R5 <== R3 (same size)
         CLCL  R2,R4              Compare expanded data with original
         BE    GOODEOJ            If it's identical then all is well
         B     FAILEOJ            Otherwise something is VERY WRONG!
                                                                EJECT
***********************************************************************
*                            PSWs
***********************************************************************
                                                                SPACE
GOODEOJ  MVI      TESTFLAG,X'FF'        Indicate test SUCCESS
         DWAITEND LOAD=YES              PSW 0000000000... Test SUCCESS
                                                                SPACE 2
FAILEOJ  DWAIT    LOAD=YES,CODE=BAD     10BAD: One of the tests FAILED!
                                                                EJECT
***********************************************************************
*                       Working Storage
***********************************************************************
                                                                SPACE
         LTORG ,                  Literals pool
                                                                SPACE 3
FLAGADDR EQU   X'500'             Fixed address of test results flag

INADDR   EQU   X'1000'            Address of input data
CMPADDR  EQU   X'2000'            Address of compression buffer
EXPADDR  EQU   X'3000'            Address of expansion buffer
CDICTADR EQU   X'20000'           Address of 64K compression dictionary
EDICTADR EQU   X'30000'           Address of 64K expansion dictionary
                                                                SPACE 3
         DC    0D'0'                    (alignment)
CMP_R0   DC    XL8'0000000000005200'    R0 Compression options
EXP_R0   DC    XL8'0000000000005300'    R0 Expansion options
CMP_R1   DC    AD(CDICTADR)             R1 addr Compression dictionary
EXP_R1   DC    AD(EDICTADR)             R1 addr Expansion dictionary
                                                                SPACE 3
         ORG   CMPSC+FLAGADDR     Fixed address of result flag
                                                                SPACE
TESTFLAG DC    X'00'              Failing test number or X'FF' = good
                                                                EJECT
***********************************************************************
*                     Input "File" (data)
***********************************************************************
                                                                SPACE
         ORG   CMPSC+INADDR       Fixed address of input buffer
                                                                SPACE
INFILE   EQU   *                  Original input data
 DC X'02C5E2C440404040404000304040000140404040404040400400000000000000'
 DC X'C9C7E6D3C4E2E3C10000000006001B00C9C7E6D3D5D9C8C200001B0006000004'
 DC X'4040404040404040F0F0F0F0F0F0F0F102E3E7E3400000004040003840400002'
 DC X'A7F4001728C9C7E6D3C4E2E3C1F0F561F3F161F1F9C8C4E9F2F2F3F040E4C1F9'
 DC X'F9F5F2F240F1F77AF0F37AF1F0000BE0B24000E051C00000F0F0F0F0F0F0F0F2'
 DC X'02E3E7E340000038404000384040000218CFB91700CC51B0CFFFB91700BBC090'
 DC X'00000B75B9170099B24D009C5800900441F00000B24D001C010D41100050010D'
 DC X'18FD1BF158EF0040F0F0F0F0F0F0F0F302C5D5C4404040404040404040404040'
 DC X'40404040404040404040404040404040F2F5F6F9F6F2F3F4F0F040F0F1F0F6F1'
 DC X'F9F1F5F1D7D361E760F3F9F04040F0F2F0F4F1F9F1F5F140F0F0F0F0F0F1F3F6'
INSIZE   EQU   *-INFILE           Size of input data
                                                                EJECT
***********************************************************************
*                    Compression dictionary
***********************************************************************
                                                                SPACE
         ORG   CMPSC+CDICTADR     Compression dictionary
                                                                SPACE
CMPDICT  EQU   *                  Compression dictionary
 DC X'DF81000001385840DF042A001C47500CDF847CE300C5D940DF4526D0D1D2D3F0'
 DC X'DF05775841500047DC05B9EF00304B18D1061A40504160C5DC062400FF07D247'
 DC X'DF0643005847414058067100FF000000B90675405000890520067B0000000000'
 DC X'DF067C00584147F07C06AB0001040000B806C3400E004147D906D14010D05058'
 DC X'DFC6DC00D0F0D1D47C07370043310000DB073C05FF9000440000000000000000'
 DC X'DF075C1812404100DD077C004B505818DA078A0547C94058D30797181258054B'
 DC X'DF079E12581740D26007F00058500000DC07F3F578F05875DF080600F0556678'
 DC X'DC0825000547584130083D0000000000AC083E47074041586008454B58FF0000'
 PRINT OFF
 DC X'DF084800D040D250300882410000000000000000000000000000000000000000'
 DC X'DF08834058470550000000000000000094089340474192000000000000000000'
 DC X'DB089A40004147D200000000000000009208AE40504758000000000000000000'
 DC X'DE08B4415840005000000000000000006C08C35840D200002008C8D100000000'
 DC X'DEC8C9400058D250C008F4E8BA52F0B4DB08FE58405046D2CF0908000AD6DC50'
 DC X'D10910400028504186091E741E1C8C00C509224858F018D23009291A00000000'
 DC X'DB092A40584150D2400957470000000074095940BE2C000074095E00269E0000'
 DC X'DD0962405800505A200970D200000000940971405805F400C8097766E2646E98'
 DC X'DFC98A4000F0D050DF8CB610705000207C0D4E5840410000A10D547050804090'
 DC X'DF0D590040585047500D7BE0400000009A0D7F4005475000DF0D8380F0700040'
 DC X'DB0E135840500090DE0E2E6040709010B90E3A704A305040DC0E414B61151070'
 DC X'DA0E58506C414058D10E67E0F25DD5959E0E6F400547D200200E7C4000000000'
 DC X'DF8E7D007050D060500F6E4418000000B10F704058411B470000000000000000'
 DC X'D90F764000507041DB0F8900705047BF740FA140051B00000000000000000000'
 DC X'DFCFA4F070504020DC10BE005070F0A0DC10D15060400010AB10EC5B93A24740'
 DC X'B010F1400050585A7C10F8407A000000D010FC405070304196110A50D058F000'
 DC X'DF111000D04060F0D311664B84A293C340116F58410000000000000000000000'
 DC X'B2117100587040500000000000000000B1117740434147D248117E4749000000'
 DC X'D51180004140501B000000000000000090118F414058470050119440F1000000'
 DC X'DE119984A26C9300DF11AD89858183957411C640411500002011CCD200000000'
 DC X'DF11CD00D0D1F080000000000000000058125147400000000000000000000000'
 DC X'DC1253400747584158125F70800000003012674100000000BF1268BF50064347'
 DC X'DE1273004058D2470000000000000000B5128C4000F058F50000000000000000'
 DC X'B01294400041E2580000000000000000DF129C40F04C58F15012A770D0000000'
 DC X'DE52AA00D0403430DD1306A393958399D213229385410058DF132B6DA3858196'
 DC X'DE134640898500A2DF935F994084A295DF13944000478186DC13AB8885A84099'
 DC X'DF93B858D2400041DF93E2959387A25048140C505A00000030140EE000000000'
 DC X'98141040D200580000000000000000007414174041D20000301421F000000000'
 DC X'DFD4220058504047C0144F8001400218DE14564010029900DF146885934089A2'
 DC X'DD147B4058854150DF148FA340009687DFD4B69995408084DE14DC9983856D96'
 DC X'DF14EE5840F04100DDD516854089968348153858400000000000000000000000'
 DC X'DE153A415840470000000000000000007C154840410500000000000000000000'
 DC X'DF154C00D04140580000000000000000DD15694085A36DD7DF157E858940966D'
 DC X'DFD59EA29940D2A35815C185A30000009215C441405847007815C9156C400000'
 DC X'DF15CD40584100D000000000000000009015E240474158000000000000000000'
 DC X'DC15E9504000413000000000000000006815F558404700000000000000000000'
 DC X'DB15F80050D04058301619090000000094161A40471941000000000000000000'
 DC X'D7161E400041475830162E400000000030162F40000000000000000000000000'
 DC X'DE16345847404150000000000000000070164940B95A00000000000000000000'
 DC X'60164F414750000030165291000000007016534000580000DD16590F5F7FFF2F'
 DC X'DF167340000C7458DC1692E3D9E2D340DB16AD40D4F4D300DD16BB44C5D6E2D3'
 DC X'DF16D44041C5C100DE16FDE2E4D5C540D0173440F589D658A31742E6F0C50040'
 DC X'DF1747400047D258D71760E340D3D5C230177140000000000000000000000000'
 DC X'CD17794158D20C0000000000000000007C17834021B100000000000000000000'
 DC X'DFD789880C909CA8DE985F1C085800CCDB18980300011807DC5901C4C5D61040'
 DC X'D7192C401041F008DF194FC403E3D6C1D8196BD540D4E258DE197F03E3C1C9C3'
 DC X'DF19964000584750D619A9C5E3D3D6F0DE19C458404708410000000000000000'
 DC X'AA19D04740D2F0585019D7FFA00000008219DB41495040002019DFD200000000'
 DC X'DFD9E000D0F040040000000000000000DF1A0DC440E3C5C9DF1A37E740F0C9C1'
 DC X'D71A90E55040D300D21AA6E2D9C3E9F0901AAE4058E7F000781AB6E3C36B0000'
 DC X'DE1AD14000584750641AE7F0C5E90000301AEAD2000000000000000000000000'
 DC X'DA1AECD0404105470000000000000000B81AFC40475000D2DE1B065850471241'
 DC X'DF9B2FF0F1D002F3DF1D2D02F0F5F1F8DF1D9202F0F7F6F9DF1DCB02F7F9F1F5'
 DC X'DFDE1A02F0F1F7F9DF1E6202F6F7F3F5DF1EAE02F1F0F5F8DF1EF502F1F0F6F7'
 DC X'DFDF2A02F9F4F7F8DF1F8102F9F5F3F6481FC241000000000000000000000000'
 DC X'D21FC440005041580000000000000000D41FD04041FFD747DF1FDCFF100047F0'
 DC X'DE41780001034004DF42AE1C000C475030030D4000000000DE0321F070605080'
 DC X'7403384000F00000FFFF470250F0410378035A8070F00000B10368000C405841'
 DC X'DE0371D0007050089A0384F00C001000D8039210F07050A09C039C000B195000'
 DC X'7803A300EF4B00007C03AA00C51600007003B403FF0000009203B99CB8909100'
 DC X'7803BEB8B0F400005803CC40000000009A03D000585098000000000000000000'
 DC X'FF7F1012200BD1804803D900410000005803DB00770000003003E20000000000'
 DC X'3003E6000000000000000000000000003003EA00000000003003EF0000000000'
 DC X'4003F3101E0000003003F500000000003003F70C000000005003FD0040000000'
 DC X'300402000000000058040500400000003004080000000000FF790E70140D1730'
 DC X'30040A000000000020040B000000000030040C000000000030040D0000000000'
 DC X'0000000000000000300411400000000030041200000000003004130000000000'
 DC X'300414E000000000000000000000000000000000000000003004151000000000'
 DC X'30041600000000003004177800000000FC4AC527340FC9FF300418E400000000'
 DC X'3004190000000000000000000000000000000000000000000000000000000000'
 DC X'30041AFF000000000000000000000000000000000000000020041C0000000000'
 DC X'000000000000000030041D000000000000000000000000000000000000000000'
 DC X'30041EFF00000000F1AA211D3B90D72200000000000000000000000000000000'
 DC X'000000000000000030041F000000000030042003000000000000000000000000'
 DC X'2004220000000000000000000000000030042300000000000000000000000000'
 DC X'3004246000000000000000000000000000000000000000000000000000000000'
 DC X'F6A184A2964995A0000000000000000020042500000000002004268000000000'
 DC X'0000000000000000200427000000000000000000000000003004280000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'300429A20000000000000000000000000000000000000000F02082462B543791'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000400084D20000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000090788955486732710000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0020008400000000002000040000000000200018000000000020009E00000000'
 DC X'DFC1B400400104F07C027B00C540000020028400000000003002854000000000'
 DC X'0000000000000000FFF350F00C0858027802905070200000300295F000000000'
 DC X'50029AF00000000058029D00200000008E02A080506010002002A4F000000000'
 DC X'3002A500000000003002A66F0000000000000000000000000000000000000000'
 DC X'2002A800000000003002A9000000000000000000000000003002AA6000000000'
 DC X'FE069913750B252400800098000001002002ABE0000000000080007800000600'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000000000000000000000008000D8000000002002AC5800000000'
 DC X'000000000000000000000000000000000060005800000000FF5E8680FFA0201A'
 DC X'006000200000000000600000000100003002ADFF00000000004000000A000000'
 DC X'0000000000000000004000900000000000000000000000000040004000000000'
 DC X'0040007800000000004000E800000000004000D0000000000000000000000000'
 DC X'00000000000000000000000000000000957814472C44C90A0000000000000000'
 DC X'004000F0F0000000000000000000000000400080010000000000000000000000'
 DC X'0020005400000000002000B800000000002000E400000000002000F800000000'
 DC X'DF01D000010740F0300244400000000058025700400000009C025E1416D01700'
 DC X'300266F000000000FFFD5810080207A830026A800000000030026B0000000000'
 DC X'30026F0000000000200272F00000000030027300000000002002750000000000'
 DC X'2002760000000000300277000000000030027800000000003002790000000000'
 DC X'000000000000000020027A00000000000060000000000000004000001D000000'
 DC X'7CE0A05003171920004000001400000000400000D10000000000000000000000'
 DC X'000000000000000000200028000000000020000000000000002000FF00000000'
 DC X'D801DB000102080C30023A000000000030023B000000000030023D4000000000'
 DC X'30023FF0000000005C0002060804050030024200000000003002430000000000'
 DC X'000000000000000000000000000000000000000000000000D001E20001020C04'
 DC X'3002290000000000000000000000000000000000000000000000000000000000'
 DC X'10000600000000000000000000000000B901EA00020C08070000000000000000'
 DC X'0000000000000000000000000000000000000000000000002800F01000000000'
 DC X'006000F0F0F7000000000000000000007C01EF00F00C0000200228F000000000'
 DC X'0000000000000000000000000000000000200021000000007801F200F0010000'
 DC X'300225F00000000030022700000000005801F500F0000000300223F000000000'
 DC X'00000000000000005801F700F0000000200222F0000000005801F90001000000'
 DC X'006000F0F0F000003001FB000000000000400000F00000003001FC0000000000'
 DC X'3001FD00000000005801FE00F00000005002000002000000004000F0F0000000'
 DC X'5002020002000000000000000000000030020400000000000000000000000000'
 DC X'3002050000000000300206000000000030020700000000003002080000000000'
 DC X'300209000000000030020A000000000030020B000000000030020C0000000000'
 DC X'30020D000000000030020E000000000030020F00000000003002100000000000'
 DC X'3002110000000000300212000000000030021300000000003002140000000000'
 DC X'3002150000000000300216000000000030021700000000003002180000000000'
 DC X'300219000000000030021A000000000030021B000000000030021C0000000000'
 DC X'30021D000000000030021E000000000030021F00000000003002200000000000'
 DC X'200221000000000000000000000000000000000000000000200224F000000000'
 DC X'0000000000000000200226F00000000000000000000000000020000200000000'
 DC X'000000000000000030022A000000000030022B000000000030022C0000000000'
 DC X'58022D004000000030022F000000000000200040000000003002300000000000'
 DC X'3002310000000000300232000000000030023300000000003002340000000000'
 DC X'3002350000000000300236000000000030023700000000003002380000000000'
 DC X'30023900000000000080000000000000008000000000010020023C0000000000'
 DC X'000000000000000030023E40000000000080004040404000480240F0F1000000'
 DC X'0000000000000000002000F90000000000200000000000000020000000000000'
 DC X'3002454000000000300246400000000078024740C5E2000030024A4000000000'
 DC X'300253E400000000000000000000000030024B400000000030024C4000000000'
 DC X'30024D400000000030024E400000000030024F40000000003002504000000000'
 DC X'300251F000000000200252F0000000000000000000000000300254E500000000'
 DC X'400255D7D9000000000000000000000000000000000000003002590000000000'
 DC X'002000400000000030025A000000000030025B000000000030025C4000000000'
 DC X'30025D400000000000800040404040003002621200000000200263C900000000'
 DC X'3002640000000000000000000000000000400090BD0000000000000000000000'
 DC X'20026500000000000000000000000000300267F000000000300268F000000000'
 DC X'300269F000000000004000F1F5000000004000D08800000030026C0000000000'
 DC X'30026D000000000030026E000000000000600000000000003002700000000000'
 DC X'3002710000000000004000000000000000000000000000003002740000000000'
 DC X'00400004E2000000000000000000000000000000000000000040000000000000'
 DC X'00400000000000000020000000000000000000000000000058027E0002000000'
 DC X'004000E4E5000000004000404000000030028000000000000020000200000000'
 DC X'5802810002000000300283000000000000400000000000000060000000000000'
 DC X'00000000000000003002864000000000300287400000000058028840C5000000'
 DC X'30028A400000000030028EE40000000030028B400000000030028C4000000000'
 DC X'30028D4000000000008000404040400020028FE5000000000000000000000000'
 DC X'200293D000000000200294D00000000000000000000000000000000000000000'
 DC X'0000000000000000500296F0F1000000480298F0F20000000000000000000000'
 DC X'0000000000000000002000F60000000030029CF0000000000000000000000000'
 DC X'004000F0F900000020029F000000000000400000000000000000000000000000'
 DC X'0000000000000000004000D088000000004000D0900000000020004000000000'
 DC X'000000000000000000400000000000003002A750000000000060000060000000'
 DC X'0000000000000000004000000000000000400000000000000000000000000000'
 DC X'0000000000000000002000FF000000005002CC00010000005802DD0001000000'
 DC X'3002EC00000000007002F1F070D000007002F69020700000FFE00D4013584114'
 DC X'2002F900000000003002FA40000000005803014850000000300305F000000000'
 DC X'58030610E0000000300309CE0000000030030AE4000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'000000000000000020030C03000000009038373CD118347C0000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000000020003800000000002000F8000000000020004800000000'
 DC X'C002CE160E5E1517000000000000000000000000000000000000000000000000'
 DC X'00000000000000000000000000000000000000000000000090F8A824021914F2'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'004000E800000000002000A00000000000200074000000000020007400000000'
 DC X'00200010000000005802DF00100000005802E60C0D0000003002E10000000000'
 DC X'002000E8000000003002E200000000003002E300000000003002E40000000000'
 DC X'3002E5000000000000400000000000003002E800000000003002EA0000000000'
 DC X'2002E9000000000000000000000000002002EB01000000000000000000000000'
 DC X'8202ED4715000400000000000000000000000000000000000000000000000000'
 DC X'00200080000000004802F430F000000000000000000000000000000000000000'
 DC X'00000000000000000020003600000000004000D0BC0000000000000000000000'
 DC X'000000000000000000000000000000003002FB40000000003002FC4000000000'
 DC X'3002FD40000000003002FE40000000003002FF40000000002003004000000000'
 DC X'0000000000000000300303000000000000400000000000002003040000000000'
 DC X'00000000000000000020003F00000000200308D100000000002000F000000000'
 DC X'0000000000000000008000A18600000020030BE5000000000000000000000000'
 DC X'000000000000000030030E400000000058030F00400000005803110102000000'
 DC X'0040004000000000D6031358504147D030031F000000000030031C5000000000'
 DC X'000000000000000020031DE00000000020031EF0000000000000000000000000'
 DC X'30000035D2000000000000000000000000000000000000000000000000000000'
 DC X'0020003F00000000000000000000000000000000000000002003200000000000'
 DC X'000000000000000030032B200000000030032DD00000000048033160D0000000'
 DC X'300333D00000000000000000000000004B00401090200000300335D000000000'
 DC X'0000000000000000200336D000000000300337D20000000020032C4800000000'
 DC X'000000000000000030032E880000000048032F58D20000000000000000000000'
 DC X'0020000300000000000000000000000000400088580000002003348800000000'
 DC X'000000000000000000600088D203000000000000000000000020000400000000'
 DC X'58033B40000000000000000000000000300358F00000000030033D4000000000'
 DC X'58035238040000007C033E40C5C300003003414000000000300350E400000000'
 DC X'004000C5C5000000300342400000000030034340000000003003444000000000'
 DC X'30034540000000003003464000000000300347400000000058034840F0000000'
 DC X'30034A4000000000002000F00000000030034B400000000030034C4000000000'
 DC X'30034D400000000030034E400000000030034F40000000000080004040404000'
 DC X'200351E500000000000000000000000030035440000000000040004040000000'
 DC X'3003554000000000300356000000000020035701000000000000000000000000'
 DC X'300359F000000000002000F700000000C1035D313032343888036433F0313000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000002000F20000000018003C00000000000020002000000000'
 DC X'0000000000000000004000F0F000000000000000000000000000000000000000'
 DC X'50036D0100000000000000000000000000000000000000000000000000000000'
 DC X'002000000000000030036F0C0000000000000000000000002003700000000000'
 DC X'00000000000000003003792000000000200380D000000000300381D100000000'
 DC X'300382600000000000000000000000002C00801000000000200383D000000000'
 DC X'006000D08844000030037A040000000030037B180000000030037CD200000000'
 DC X'30037D050000000030037E300000000030037F44000000000020000000000000'
 DC X'0000000000000000002000300000000000200018000000000000000000000000'
 DC X'500388F0F1000000300391470000000000000000000000000040001E02000000'
 DC X'92038AF0F3F2F500000000000000000060038EF0F1F400000000000000000000'
 DC X'0000000000000000002000F00000000000000000000000000000000000000000'
 DC X'00000000000000000060008033D6000020039AD10000000030039B0000000000'
 DC X'0000000000000000000000000000000000000000000000002000408000000000'
 DC X'0000000000000000000000000000000000000000000000000020001C00000000'
 DC X'3003A00100000000006000D800000000004000A8000000000000000000000000'
 DC X'3003A11C000000002003A2000000000000000000000000003003A60100000000'
 DC X'2003A9580000000000000000000000003003A71C000000003003A80000000000'
 DC X'002000BE0000000000000000000000003003AD01000000003003B1E400000000'
 DC X'00200078000000005803AE1C0C0000002003B000000000000020000000000000'
 DC X'00000000000000003003B2E5000000002003B3E2000000000000000000000000'
 DC X'4003B7D0D3000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000003003BD580000000000000000000000000000000000000000'
 DC X'0020004700000000004000F0350000003003C158000000004003CA4158000000'
 DC X'00000000000000003003C2D0000000003003C3D0000000003003C40400000000'
 DC X'3003C558000000003003C6E0000000003003C7D0000000003003C80C00000000'
 DC X'2003C99800000000000000000000000000000000000000000000000000000000'
 DC X'3003CE40000000003003CF000000000000400000010000000020000000000000'
 DC X'3003D401000000003003D8F00000000000000000000000000040000CD0000000'
 DC X'5803D51C0C0000002003D7000000000000200000000000000000000000000000'
 DC X'004000D1340000000000000000000000002000FF000000003003DD0100000000'
 DC X'3003E047000000003003DE1C000000002003DF00000000000000000000000000'
 DC X'2003E1800000000000000000000000005803E3471A0000002003E58000000000'
 DC X'006000101A20000000000000000000003003E701000000003003E81C00000000'
 DC X'2003E9000000000000000000000000005803EB58000000002003ED7000000000'
 DC X'2003EE0000000000000000000000000000000000000000007C03F01A58000000'
 DC X'006000581A68000000400050D000000000400000000000000000000000000000'
 DC X'00000000000000002003F6010000000000000000000000003003F84700000000'
 DC X'3003F920000000003003FAF0000000005803FB1E2600000000400058F0000000'
 DC X'00200058000000003003FF010000000000000000000000003004001C00000000'
 DC X'2004010000000000000000000000000030040301000000002004041C00000000'
 DC X'0000000000000000300407010000000000400040000000000040001C00000000'
 DC X'30040901000000000020000C00000000006000011C0000000000000000000000'
 DC X'004000011C00000030040E010000000030040F1C000000002004100000000000'
 DC X'000000000000000000600040000D0000006000011C000000008000011C004000'
 DC X'00200047000000000060001A201B0000006000011C0000000040004740000000'
 DC X'004000E5E2000000004000000000000030041BFF000000000020000000000000'
 DC X'0000000000000000006000011C00000000800010002000000040000000000000'
 DC X'300421D000000000002000B40000000000000000000000000020000100000000'
 DC X'0020006000000000000000000000000000000000000000000000000000000000'
 DC X'002000D3000000000020004000000000BD044D001901132D30045B0000000000'
 DC X'6C045FD070F0000020046420000000002004650000000000FBAF40580DD0F070'
 DC X'3004664000000000000000000000000020046E000000000030046F8800000000'
 DC X'300470F000000000000000000000000030047210000000000000000000000000'
 DC X'300474E400000000200476CE00000000300477C500000000300478FF00000000'
 DC X'00000000000000000000000000000000E4888006120530010000000000000000'
 DC X'30047B00000000000000000000000000000000000000000000600000CB280000'
 DC X'0000000000000000000000000000000000000000000000000040000001000000'
 DC X'0000000000000000000000000000000000000000000000000040005141000000'
 DC X'0000000000000000300452000000000048045878F000000020045A0D00000000'
 DC X'0000000000000000002000180000000058045300400000003004550000000000'
 DC X'0020000000000000300456000000000030045700000000000040000000000000'
 DC X'00000000000000000040004740000000000000000000000060045CA85E140000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'3004623000000000200463F00000000000200052000000000000000000000000'
 DC X'0000000000000000000000000000000030046740000000003004684000000000'
 DC X'300469400000000030046A400000000030046B400000000030046C4000000000'
 DC X'30046DF000000000002000F00000000000000000000000000020005800000000'
 DC X'200471F0000000000000000000000000200473D1000000000000000000000000'
 DC X'200475E50000000000000000000000000000000000000000004000C500000000'
 DC X'300479100000000020047A00000000000000000000000000002000DC00000000'
 DC X'300492E7000000005804DF00010000005804F8E2D500000030050ED300000000'
 DC X'3005214000000000F40958470C70021E0000000000000000200525F000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000600000C00C00000000000000000000'
 DC X'0000000000000000004000904100000000400007200000000000000000000000'
 DC X'1800040000000000004000000D000000300493E3000000003004944000000000'
 DC X'B104950001020403D1049A000306050100000000000000000000000000000000'
 DC X'0000000000000000002000D9000000005804D700380000000000000000000000'
 DC X'000000000000000000000000000000003004DCD000000000F80010020A110E0C'
 DC X'3004DDD800000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000000000000000000000F20044181D150B130000000000000000'
 DC X'00000000000000003004DE460000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000F000211A1627244000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'A81C67742A3B8842004000544000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'002000BC000000000020008E00000000002000A8000000003004D94000000000'
 DC X'00600040400000003004DA40000000002004DB00000000000000000000000000'
 DC X'0020004000000000004000404000000000200040000000003004E10000000000'
 DC X'0040000C000000003004E240000000003004E340000000003004E44000000000'
 DC X'3004E540000000005804E640C50000003004E840000000003004F3E400000000'
 DC X'3004E940000000003004EA40000000003004EB40000000003004EC4000000000'
 DC X'3004ED40000000003004EE40000000003004EFF0000000003004F0F000000000'
 DC X'3004F1F0000000002004F2F00000000000000000000000003004F4E500000000'
 DC X'4804F5D9D700000000000000000000003004F7F100000000002000D200000000'
 DC X'3004FAC400000000300507C4000000003004FB40000000003004FC4000000000'
 DC X'3004FD40000000003004FE40000000003004FF40000000003005004000000000'
 DC X'3005010000000000580502302000000030050440000000000020004000000000'
 DC X'3005054000000000200506000000000000000000000000003005084000000000'
 DC X'300509400000000030050A400000000030050B400000000030050C4000000000'
 DC X'30050D4000000000008000404040400030050FC4000000003005104000000000'
 DC X'3005114000000000300512400000000030051340000000003005144000000000'
 DC X'30051540000000003005160000000000BF0517382834302C30051C4000000000'
 DC X'0040004040000000004000404000000000200040000000000020004000000000'
 DC X'30051D400000000030051E400000000030051F40000000002005200000000000'
 DC X'0000000000000000300522000000000030052338000000003005244000000000'
 DC X'00800040000128000000000000000000D2853F909CB0A0B8C00558A800387840'
 DC X'A30567B40804481420056C180000000030056DF000000000F7A0D450706010D6'
 DC X'0000000000000000300570000000000030057200000000002005740000000000'
 DC X'3005750800000000000000000000000020057600000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000004000025A0000004300D804004700000000000000000000'
 DC X'0000000000000000004000000A00000000400080310000004805554050000000'
 DC X'00000000000000000000000000000000200557D0000000000000000000000000'
 DC X'F001B4DCBC98CCA8000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'004000D09C000000004000D0E800000000000000000000001000C00000000000'
 DC X'0000000000000000000000000000000000200000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000009FF8EC9868B88064004000D1EC0000000020003300000000'
 DC X'0020003A00000000002000D0000000000020003900000000002000D000000000'
 DC X'002000D100000000002000D100000000002000D0000000000000000000000000'
 DC X'000000000000000000000000000000000020003F00000000002000D100000000'
 DC X'000000000000000040056EF0F100000000000000000000000000000000000000'
 DC X'300571500000000000400000D200000030057370000000000020000000000000'
 DC X'0000000000000000004000D0900000000000000000000000DA0591E050F07080'
 DC X'94059E1040F070002005A370000000003005A400000000006005A58070F00000'
 DC X'FFD04018D201F0043005A840000000003005AED2000000003005B30300000000'
 DC X'2005B54A000000003005B6F0000000002005B804000000000000000000000000'
 DC X'00600007185F0000000000000000000000000000000000000000000000000000'
 DC X'00000000000000000000000000000000000000000000000051801BEC125ABF00'
 DC X'000000000000000000000000000000000000000000000000002000E000000000'
 DC X'0020006F00000000300598D00000000030059BD0000000000000000000000000'
 DC X'30059CD000000000000000000000000010000000000000000000000000000000'
 DC X'3005990C0000000020059A980000000000000000000000000040008858000000'
 DC X'20059D880000000000000000000000003005A2D2000000000000000000000000'
 DC X'0040000000000000000000000000000000200008000000000000000000000000'
 DC X'0040000000000000000000000000000000000000000000000000000000000000'
 DC X'3005A900000000005805AA38010000003005AC40000000003005AD4700000000'
 DC X'0080004000014700002000F0000000003005AF05000000003005B03000000000'
 DC X'3005B158000000002005B2400000000000000000000000003005B4D300000000'
 DC X'002000380000000000000000000000002005B7F0000000000000000000000000'
 DC X'0000000000000000DF05C2585012474130061600000000003006185000000000'
 DC X'000000000000000000000000000000003A001E40E00000000040000707000000'
 DC X'000000000000000000400012EE000000DF05D070506040F03005ECF000000000'
 DC X'5805FFFF66000000200604F000000000AF060560F00070408FF0F018BFD20095'
 DC X'30060AF00000000064060D7F5F4F00005806100F7F0000002006140300000000'
 DC X'2006150000000000004000FED000000000400000C1000000002000F000000000'
 DC X'5805D8F0D00000005805E0D0F00000004805E736350000003005E9D000000000'
 DC X'3005EAD00000000028000080000000002005EB35000000000000000000000000'
 DC X'3005DA00000000003005DD88000000003005DB50000000002005DC7000000000'
 DC X'00000000000000003005DE58000000002005DF70000000000000000000000000'
 DC X'3005E288000000003005E600000000003005E358000000003005E45000000000'
 DC X'2005E5500000000000000000000000000080005060D1C8000000000000000000'
 DC X'002000AA00000000004000885000000000200090000000000000000000000000'
 DC X'B705EDD0D1F0D270D805F298B4949CC00000000000000000004000F0F1000000'
 DC X'002000B40000000000200014000000002005FD58000000003005FE4700000000'
 DC X'0000000000000000000000000000000000000000000000005000B8C8A0D89000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000000000000000000000002000F0000000003006014700000000'
 DC X'0020004700000000400602708000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000400000000000000020000000000000'
 DC X'002000D000000000002000D00000000040060BF0F10000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000040005050000000'
 DC X'58061250D0000000004000D0A40000000040000047000000002000BC00000000'
 DC X'0000000000000000000000000000000020061700000000000000000000000000'
 DC X'3006191000000000008000D08844000030062240000000000000000000000000'
 DC X'00000000000000000000000000000000006000E4E5E200002000584800000000'
 DC X'0000000000000000000000000000000030062300000000000060003840400000'
 DC X'DF062D5800D247D7200641900000000030064200000000000000000000000000'
 DC X'00000000000000003C00F0FE50000000004000F0F000000000400090EC000000'
 DC X'0000000000000000940636708060F00020063C000000000020063D0300000000'
 DC X'20063EF00000000030063F03000000003E004401F000000000600000C1B80000'
 DC X'0040001C00000000004000F0F000000020063AD0000000000000000000000000'
 DC X'20063BD000000000000000000000000000000000000000000000000000000000'
 DC X'000000000000000000000000000000000000000000000000200640D000000000'
 DC X'000000000000000000000000000000000060000010CE00009C06550001406700'
 DC X'96065DF070605000600662F07080000050066510700000003006684000000000'
 DC X'CEABD250F018D7D130066B030000000020066D000000000030066EF000000000'
 DC X'000000000000000030067003000000000000000000000000006000E0F0100000'
 DC X'0000000000000000004000E4E50000000000000000000000004000EF50000000'
 DC X'0020004D00000000300659000000000030065B000000000020065C0000000000'
 DC X'000000000000000030065A00000000000080000000000000006000010D000000'
 DC X'00000000000000002006613F0000000000000000000000000040006000000000'
 DC X'002000F000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000300667D00000000000000000000000000040009058000000'
 DC X'300669000000000030066A3800000000008000404000010020066CD200000000'
 DC X'0000000000000000000000000000000030066FF000000000004000F0F0000000'
 DC X'002000D0000000002006730000000000200674FF000000000000000000000000'
 DC X'000000000000000030067A400000000000600010F0F000000000000000000000'
 DC X'0000000000000000004000EF5800000000800000384040000000000000000000'
 DC X'D7068C004101470F9C0694208030F00064069E10706000004806A18020000000'
 DC X'3006A3F000000000AE5CD298045001402006A603000000003006A72900000000'
 DC X'3006A80500000000000000000000000000000000000000003006A94000000000'
 DC X'00000000000000002006AAEF00000000004000FED70000000020000C00000000'
 DC X'200693000000000000000000000000000040001C01000000002000C000000000'
 DC X'0020000C0000000018000C00000000000020002C000000000000000000000000'
 DC X'300698D00000000030069DD00000000000400030000000000000000000000000'
 DC X'3006994C0000000030069A410000000030069B000000000020069C2000000000'
 DC X'0000000000000000002000880000000000000000000000000000000000000000'
 DC X'00200000000000000000000000000000004000F0240000004806A4F1F0000000'
 DC X'0000000000000000002000F8000000000000000000000000006000D01C050000'
 DC X'0040009C0000000000800000384040000000000000000000C206AE011C380010'
 DC X'4006BF429E0000004806C1646300000000000000000000000000000000000000'
 DC X'00000000000000003006BD0800000000000000000000000090780E08040F3B17'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000004000480C000000002000AC000000000020000000000000'
 DC X'00200028000000003006BE0C0000000000800000000C00000000000000000000'
 DC X'00000000000000000000000000000000002000FC000000003006C84000000000'
 DC X'3006D00E00000000000000000000000000000000000000000000000000000000'
 DC X'5806C900400000003006CB380000000000600040404000003006CC4000000000'
 DC X'3006CD40000000003006CE00000000002006CF01000000000000000000000000'
 DC X'0040000E0E0000003006D900000000003006DB00000000000000000000000000'
 DC X'0000000000000000006000FF001000002400F012000000000000000000000000'
 DC X'004000FF000000002006DA47000000000000000000000000002000BD00000000'
 DC X'D207010041582047D1070BA8B088F0E8300716F00000000030071C2800000000'
 DC X'58071D1008000000FFBF58D204504110400721F0500000002007230300000000'
 DC X'3007245800000000200725300000000030072660000000000000000000000000'
 DC X'300727000000000020072B410000000030072C700000000058072D5450000000'
 DC X'30072F4000000000300732000000000020073400000000002007354100000000'
 DC X'F151D33736E0D718000000000000000000000000000000000000000000000000'
 DC X'0060000050100000000000000000000030073658000000000000000000000000'
 DC X'004000EF47000000000000000000000000000000000000000000000000000000'
 DC X'0040009C05000000000000000000000000000000000000001800C10000000000'
 DC X'002000F400000000300709000000000000000000000000000000000000000000'
 DC X'006000004780000000000000000000002C0001F000000000002000F000000000'
 DC X'002000000000000030070A000000000000400000000000003007155800000000'
 DC X'00000000000000000000000000000000000000000000000000400058F0000000'
 DC X'4300B89878A0000000000000000000000000000000000000004000F0F0000000'
 DC X'0020000100000000004000F032000000500717F0F1000000500719F0F7000000'
 DC X'000000000000000030071BF7000000000000000000000000004000F0F8000000'
 DC X'002000580000000030071F580000000000600058F0360000200720F000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'004000F0A70000000000000000000000002000D3000000003007285000000000'
 DC X'300729D00000000030072A20000000000080000418D205000000000000000000'
 DC X'0020003200000000004000402200000000400000D00000003007300000000000'
 DC X'30073138000000000040004040000000300733DD00000000004000FF10000000'
 DC X'00000000000000000000000000000000002000500000000030073ADD00000000'
 DC X'20073B1000000000002000FC00000000004000FF100000000000000000000000'
 DC X'30074CEF00000000580751470600000000000000000000003007554700000000'
 DC X'3007574700000000AB947720668655EE20075947000000000000000000000000'
 DC X'20075A470000000020075B280000000000600047807400000000000000000000'
 DC X'0000000000000000004000477000000000000000000000000020004700000000'
 DC X'58074D125800000030074F440000000030075000000000000020004700000000'
 DC X'00200035000000004807537080000000004000F0470000000000000000000000'
 DC X'00400030DA000000300756700000000000200032000000002007588000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'58076D154100000040076F909B00000030077140000000004807747010000000'
 DC X'2007760000000000BBE60547C650CED2200777EF000000000000000000000000'
 DC X'300778E400000000300779100000000030077AA10000000020077B0300000000'
 DC X'004000F0F000000000000000000000000000000000000000004000FE47000000'
 DC X'002000100000000000400058A00000000020005E000000000000000000000000'
 DC X'0000000000000000300772000000000030077338000000000020004000000000'
 DC X'0000000000000000004000D0BC00000000000000000000000000000000000000'
 DC X'006000D5C3E30000002000470000000000400086000000000000000000000000'
 DC X'9E078340C5014C00004000103700000000400080D40000000000000000000000'
 DC X'004000515E00000018000F000000000000200047000000003007874000000000'
 DC X'006000E4E5E200000040001C0000000000400060600000003007884000000000'
 DC X'30078940000000000060004040400000300794EF00000000300796F000000000'
 DC X'00000000000000000060004000380000000000000000000042001800F0500000'
 DC X'00000000000000000000000000000000004000F0F00000000000000000000000'
 DC X'300795BF000000000020000F00000000004000F026000000006000715E700000'
 DC X'00000000000000000000000000000000004000EF920000000040001032000000'
 DC X'1800470000000000004000D0350000005807C5051B0000006C07CDF070600000'
 DC X'7407D005185800003007D440000000004807D80305000000FFF700471601411F'
 DC X'2007DB00000000004007DC70F00000005807DE18580000003007E0DD00000000'
 DC X'3007E460000000003007E50F000000004807E658050000003007E84700000000'
 DC X'00000000000000003007E94B000000003007EA05000000003007EC0500000000'
 DC X'00000000000000000000000000000000FD9AF71A10F84EF63007EED200000000'
 DC X'00800005EF58F00000000000000000003007EFD20000000000600005EF000000'
 DC X'0000000000000000000000000000000000400089500000000040005E50000000'
 DC X'0000000000000000004000000F00000000000000000000000000000000000000'
 DC X'004000410A0000003E00F17FB100000000200044000000000020005000000000'
 DC X'002000F0000000003007C7EF000000002007CC10000000007407C81258180000'
 DC X'2007CB550000000000000000000000000020006F000000000000000000000000'
 DC X'000000000000000000000000000000000020003F00000000002000D000000000'
 DC X'2007D3EF000000000000000000000000004000203B0000000000000000000000'
 DC X'5807D500400000003007D7380000000000400040F00000000060004040000000'
 DC X'00000000000000002007DA300000000000000000000000000000000000000000'
 DC X'00000000000000000000000000000000004000F705000000004000F03F000000'
 DC X'3007E1FF000000003007E210000000003007E30000000000008000A000182100'
 DC X'004000D0B4000000004000E0470000000000000000000000002000EF00000000'
 DC X'004000F03000000000400010390000002007EBEF000000000000000000000000'
 DC X'2007EDEF00000000000000000000000000400003D40000000020000300000000'
 DC X'0000000000000000000000000000000000000000000000003007FE9800000000'
 DC X'3008024400000000300804440000000000000000000000000000000000000000'
 DC X'5980055667414000200805EF0000000000000000000000000000000000000000'
 DC X'00400050D000000000400040000000003007FFF000000000300800F000000000'
 DC X'30080108000000000040004DE000000020080370000000000000000000000000'
 DC X'004000F0320000000000000000000000580813964300000058081747D2000000'
 DC X'58081A43BF00000058081D43BF0000002008204700000000776010771115FF17'
 DC X'000000000000000058082143BF000000300824430000000000800018515E5000'
 DC X'000000000000000000600018715E000000400070340000003008158000000000'
 DC X'00400000D000000030081610000000000080000458F57000200819B000000000'
 DC X'004000FF10000000000000000000000020081C50000000000040005360000000'
 DC X'000000000000000030081F600000000000400063700000000040005000000000'
 DC X'0000000000000000200823700000000000200073000000000000000000000000'
 DC X'00400010F0000000C0083040150216A83008391E0000000020083C8000000000'
 DC X'000000000000000000000000000000005A804018F0920F000060004000380000'
 DC X'0000000000000000006000F0F0F0000000000000000000000020001200000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'000000000000000030000E001400000000000000000000000000000000000000'
 DC X'000000000000000030083A070000000020083B07000000000000000000000000'
 DC X'0000000000000000002000010000000000000000000000003008430700000000'
 DC X'0080004000384000000000000000000000000000000000002008440000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'B8086650004147033008704C0000000050087140000000002008790300000000'
 DC X'20087A0000000000FAE4F0D14110044830087BF0000000000000000000000000'
 DC X'20087D0000000000000000000000000030087E180000000030087F9200000000'
 DC X'300880E00000000000000000000000000000000000000000200881F000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'92083F081B34386000000000000000000000000000000000004000F047000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000002000580000000030086BD00000000040086E0002000000'
 DC X'00000000000000000000000000000000000000000000000030086C2000000000'
 DC X'30086D040000000000800018D205300000000000000000000000000000000000'
 DC X'0060004100200000580873004000000000000000000000003008753800000000'
 DC X'3008774000000000300876400000000000800040000141003008784000000000'
 DC X'00200040000000000000000000000000000000000000000020087CF000000000'
 DC X'00000000000000000000000000000000008000D2053044000040001020000000'
 DC X'004000697F0000000000000000000000006000101100000030088C4000000000'
 DC X'20088F7000000000200890F000000000200891EF000000002008925000000000'
 DC X'32004100D2000000000000000000000000000000000000000020000300000000'
 DC X'30088D000000000030088E380000000000600040400000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000003008974000000000'
 DC X'0000000000000000004000101100000000000000000000003008980000000000'
 DC X'300899380000000000200040000000003008A440000000003008A80000000000'
 DC X'00000000000000004008ABF0800000002008AD03000000004500585550800000'
 DC X'0000000000000000004000002000000000000000000000000040000000000000'
 DC X'5808A500400000003008A7380000000000800040404040000080004040000100'
 DC X'3008A900000000003008AA000000000000400000000000000000000000000000'
 DC X'000000000000000000000000000000003008B240000000000000000000000000'
 DC X'0000000000000000004000F03B0000003008B300000000000080003840400000'
 DC X'6408BB70105000002008BE30000000003008BF40000000002008C20000000000'
 DC X'00000000000000001800050000000000004000EF500000000000000000000000'
 DC X'0000000000000000004000000100000000000000000000003008C00000000000'
 DC X'3008C13800000000006000404000000000000000000000000000000000000000'
 DC X'3008C6400000000000600003D0E000002008C700000000000000000000000000'
 DC X'00000000000000005808E140000000007008EC00020100004808F040F0000000'
 DC X'2008F303000000000000000000000000F05B41D0D11074F00000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'006000F0F1F00000000000000000000000400041100000000040009250000000'
 DC X'000000000000000000400050C300000000200058000000000020000700000000'
 DC X'00200080000000003E00A6700400000000200058000000000020000400000000'
 DC X'0020007C000000005808E3004000000000200000000000007408E53801300000'
 DC X'00400040400000003008E8400000000000000000000000000040004040000000'
 DC X'3008E940000000003008EA00000000002008EB01000000000000000000000000'
 DC X'3008EF0000000000000000000000000000000000000000000020000000000000'
 DC X'00000000000000003008F23F00000000002000A0000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000004F0030AC0570000000200040000000000020004100000000'
 DC X'002000EF00000000002000580000000030090540000000003009064000000000'
 DC X'00000000000000000040001AF000000000200003000000001800940000000000'
 DC X'0020005800000000004000D08800000020090700000000000000000000000000'
 DC X'0000000000000000004000580000000000400018F6000000004000BF0F000000'
 DC X'00400030100000002C0092FC00000000002000D2000000000020004100000000'
 DC X'30091B4000000000000000000000000000000000000000000000000000000000'
 DC X'20091D10000000005180563C2430720000000000000000000000000000000000'
 DC X'00000000000000000020000700000000002000470000000020091C0000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0020005800000000002000D20000000000000000000000000000000000000000'
 DC X'004000F0F1000000000000000000000000200050000000001800CA0000000000'
 DC X'0020004100000000004000586000000058093740000000003009537500000000'
 DC X'000000000000000030095420000000003009550300000000706000C8F047A4C4'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000000020005800000000002000EF000000005809390040000000'
 DC X'004000000100000078093B01380200002009524000000000DE093E41580050D0'
 DC X'30094D4000000000000000000000000048094770E0000000400949F060000000'
 DC X'20094B000000000030094C700000000000000000000000003000D2D118000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'004000F042000000000000000000000000000000000000000000000000000000'
 DC X'002000D20000000030094E400000000030094F00000000004009500102000000'
 DC X'0000000000000000000000000000000000000000000000000040007000000000'
 DC X'004000D0CC000000300956D1000000000020009C000000000000000000000000'
 DC X'000000000000000030095C40000000000000000000000000002000D200000000'
 DC X'30095D0000000000008000384040000030096100000000000000000000000000'
 DC X'0040005A50000000002000370000000030096B400000000020096EF000000000'
 DC X'30096F0000000000000000000000000000400050C3000000360088F03F000000'
 DC X'0000000000000000004000F0F1000000002000560000000030096C0000000000'
 DC X'30096D0400000000004000404000000000000000000000000020000000000000'
 DC X'000000000000000030097540000000000000000000000000004000EF50000000'
 DC X'0000000000000000300976000000000000600038404000000000000000000000'
 DC X'2009895000000000000000000000000000000000000000000000000000000000'
 DC X'C77F4EDECC00584A000000000000000000400058850000000040005820000000'
 DC X'00400041700000000000000000000000004000D2030000000020005800000000'
 DC X'002000D200000000002000D2000000000020005800000000002000D200000000'
 DC X'00200040000000000000000000000000DE09D70040F00260DF8C0A3801000204'
 DC X'300C63F000000000BA0C6E889C94A098480C750004000000FFFDC3D904E2A260'
 DC X'740C77D6964400008E0C7BC5F2858900500C7F5841000000580C81E3A3000000'
 DC X'580C83A385000000300C8A4000000000740C8C9995A70000580C91C2D5000000'
 DC X'300C954000000000200C96D6000000000000000000000000300C970000000000'
 DC X'300C9E8600000000480C9F5040000000FEA7868310C684D4300CA18100000000'
 DC X'200CA29600000000400CA3000C0000000000000000000000300CA5A400000000'
 DC X'0000000000000000300CA6850000000000000000000000000000000000000000'
 DC X'300CA79600000000200CA95000000000200CAA50000000000000000000000000'
 DC X'0000000000000000FFD89958F141E44D300CAB9700000000200CACF000000000'
 DC X'300CADF900000000300CB01000000000300CB19500000000300CB29500000000'
 DC X'0000000000000000300CB34000000000200CB595000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'F0043FE3E5C4D7A4000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000600081958400000000000000000000'
 DC X'000000000000000000000000000000000040008030000000B89E93F50881A536'
 DC X'0040008995000000000000000000000000000000000000000000000000000000'
 DC X'004000819300000000000000000000000000000000000000004000EF58000000'
 DC X'0040005E70000000002000D200000000002000AA00000000DFC9E03801023014'
 DC X'DE0AFF4000F0C57C300C07F00000000000800000000040000000000000000000'
 DC X'3A00C5C1F1000000004000E4E50000000000000000000000004000F2F0000000'
 DC X'3009FB4000000000DF0AA200144758409E0ACE00404D4B00300AD64000000000'
 DC X'300ADC4000000000FFFA08041A281826300AE24000000000300AE94000000000'
 DC X'300AF14000000000300AF74000000000300AFA40000000000080004040000100'
 DC X'300AFE4000000000006000404040000000600000000700000000000000000000'
 DC X'0060004040000000000000000000000000400040400000000040004040000000'
 DC X'6FC032360C2B1706004000404000000000400040400000000040004040000000'
 DC X'0040004040000000002000400000000000200040000000003009FC4000000000'
 DC X'3009FD00000000005809FE0102000000DFCA00410058D050D20A8D0040844C04'
 DC X'9C0A36E070105000500A410002000000DC0A4E7050F06040D80A5888A894B8D0'
 DC X'800A63705000F000FFE84740D2D1BF05920A678070F0B000500A6C4000000000'
 DC X'500A790300000000200A7C6C00000000400A7D5FFF000000300A7FEF00000000'
 DC X'300A8389000000000000000000000000300A8403000000000000000000000000'
 DC X'00000000000000000000000000000000200A860000000000300A877700000000'
 DC X'F74C3407C37090990000000000000000300A890000000000300A8A4400000000'
 DC X'300A8B00000000000000000000000000008000898788A3000000000000000000'
 DC X'000000000000000000600050C3440000006000A2856B00000000000000000000'
 DC X'000000000000000000000000000000000000000000000000F2003F8960443B31'
 DC X'00000000000000000000000000000000300A8C00000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'000000000000000000400048580000003E009239100000000020000000000000'
 DC X'0020003C000000000020001800000000300A3AF000000000200A3E4000000000'
 DC X'400A3FD1D000000000000000000000007C0A3B4A3E3C000000800058F0C07400'
 DC X'00600058F0C0000000400058F000000000000000000000000000000000000000'
 DC X'0000000000000000580A4300500000000000000000000000300A450000000000'
 DC X'00400050D0000000300A460000000000300A470000000000300A480000000000'
 DC X'300A490000000000300A4A0000000000300A4B0000000000300A4C0000000000'
 DC X'300A4D00000000000080000000000000200A55D000000000300A563F00000000'
 DC X'200A573500000000000000000000000000000000000000001800750000000000'
 DC X'00200070000000000000000000000000002000BC000000000000000000000000'
 DC X'300A5F5800000000300A62470000000000000000000000000000000000000000'
 DC X'00000000000000001800A000000000000020005800000000580A605070000000'
 DC X'0020005000000000002000D000000000002000B0000000000000000000000000'
 DC X'000000000000000000000000000000000000000000000000300A6B3300000000'
 DC X'00000000000000000000000000000000004000338E0000000020008200000000'
 DC X'300A6E40000000000000000000000000300A6F4000000000300A704000000000'
 DC X'300A714000000000300A724000000000300A734000000000300A744000000000'
 DC X'300A754000000000300A764000000000300A774000000000300A784000000000'
 DC X'0080004040404000300A7BD3000000000000000000000000002000C800000000'
 DC X'0000000000000000000000000000000000000000000000006C0A805847500000'
 DC X'0000000000000000002000F000000000002000F0000000000060008385950000'
 DC X'300A85D000000000002000BC000000000000000000000000200A884700000000'
 DC X'0000000000000000004000D2FF00000000600058703000000020005000000000'
 DC X'002000BD00000000300A9D000000000000000000000000000000000000000000'
 DC X'00600060604000000000000000000000A05CA350479981A20000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'004000858300000000000000000000000020001000000000002000A200000000'
 DC X'0020004D00000000300A9E0000000000300A9F0000000000300AA00000000000'
 DC X'200AA100000000000000000000000000580AB20001000000300ABACE00000000'
 DC X'300AC3F000000000680AC5F060700000300AC84000000000AB6441D0050E50D2'
 DC X'300ACBE0000000000000000000000000300ACCEF000000000080000E00001D00'
 DC X'000000000000000000400003D1000000004000FFFF0000000000000000000000'
 DC X'00000000000000000040008983000000300AB40000000000300AB90D00000000'
 DC X'300AB50000000000300AB60000000000300AB70000000000300AB80000000000'
 DC X'00400000000000000020000000000000580ABBA121000000300ABD8600000000'
 DC X'300AC18600000000300ABE0000000000300ABF0000000000200AC00000000000'
 DC X'0000000000000000300AC200000000000040000000000000200AC4F000000000'
 DC X'00000000000000000000000000000000004000D0C80000000000000000000000'
 DC X'580AC9004000000000400001400000000020004000000000004000F03C000000'
 DC X'300ACD5000000000004000F0D0000000200AD20000000000300AD34000000000'
 DC X'300AD599000000000020004B000000000000000000000000200AD40000000000'
 DC X'00000000000000000040009783000000300AD74000000000300AD80000000000'
 DC X'300AD90100000000300ADA0000000000200ADB00000000000000000000000000'
 DC X'300ADD4000000000300ADE0000000000300ADF0100000000300AE00000000000'
 DC X'200AE100000000000000000000000000300AE34000000000300AE40000000000'
 DC X'300AE50100000000580AE61400000000200AE8CE000000000040000000000000'
 DC X'0000000000000000300AEA4000000000300AEB0000000000500AEC0102000000'
 DC X'300AEE47000000000000000000000000300AEFF000000000200AF0F000000000'
 DC X'0000000000000000300AF24000000000300AF30000000000300AF40100000000'
 DC X'580AF5C114000000004000B858000000004000CE21000000300AF84000000000'
 DC X'300AF900000000000040000114000000300AFB4000000000300AFC0000000000'
 DC X'200AFD0100000000000000000000000000400040000000009E0B074000F0C500'
 DC X'9A0BF73801043000300C03F000000000006000E4E5D700000000000000000000'
 DC X'2C00F10200000000004000F2F000000000400000000000009E0B0B40F000C100'
 DC X'DF0BE30106303438300BEFF000000000004000E4E50000007C0B0F4000F00000'
 DC X'300BDDF000000000300BE230000000000040009393000000580B1240F0000000'
 DC X'300BD63000000000300BDAF000000000580B1440F0000000300BD1F000000000'
 DC X'580B1640F0000000300BCBF000000000580B1840F0000000300BC9F000000000'
 DC X'580B1A40F0000000300BC7F000000000580B1C40F0000000300BC4F000000000'
 DC X'580B1E40F0000000300BBFF000000000580B2040F0000000300BBBF000000000'
 DC X'580B2240F0000000300BB8F000000000580B2440F0000000300BB3F000000000'
 DC X'580B2640F0000000300BACF000000000580B2840F0000000300BA9F000000000'
 DC X'580B2A40F0000000300BA5F0000000007C0B2C40F0F10000300BA2F000000000'
 DC X'7C0B2F40F1F00000300BA0F000000000002000F500000000580B3240F0000000'
 DC X'002000F500000000002000F000000000580B3440F0000000004000F0F0000000'
 DC X'580B3640F0000000300B9EF000000000580B3840F0000000300B9CF000000000'
 DC X'580B3A40F0000000006000F0F0F00000580B3C40F0000000006000F0F0F90000'
 DC X'7C0B3E40F0F10000300B9AF000000000580B4140F0000000300B97F000000000'
 DC X'004000F5F6000000580B4340F0000000300B94F000000000580B4540F0000000'
 DC X'300B91F000000000580B4740F0000000300B8FF000000000580B4940F0000000'
 DC X'300B8BF000000000580B4B40F0000000300B89F000000000580B4D40F0000000'
 DC X'006000F0F0F10000580B4F40F0000000200B88F000000000580B5140F0000000'
 DC X'300B85F000000000300B534000000000006000F0F0F80000580B5440F0000000'
 DC X'580B5640F0000000004000F0F0000000580B5840F0000000004000F0F0000000'
 DC X'580B5A40F0000000006000F0F0F40000300B5C4000000000006000F0F0F20000'
 DC X'580B5D40F0000000580B5F40F0000000006000F0F0F00000580B6140F0000000'
 DC X'200B84F000000000580B6340F0000000300B82F000000000580B6540F0000000'
 DC X'300B80F000000000300B674000000000300B7CF000000000580B6840F0000000'
 DC X'580B6A40F0000000004000F0F0000000580B6CF040000000300B7AF000000000'
 DC X'300B6EF000000000480B7840F0000000500B6FF0F1000000AD0B71F4F0F3F1F8'
 DC X'00000000000000000000000000000000200B76F000000000300B77F100000000'
 DC X'0000000000000000002000F1000000000000000000000000002000F300000000'
 DC X'0000000000000000004000F0F0000000200B7BF0000000000000000000000000'
 DC X'580B7DF0F1000000200B7FF000000000006000F8F9F300000000000000000000'
 DC X'200B81F0000000000000000000000000200B83F0000000000000000000000000'
 DC X'0000000000000000480B86F0F10000000000000000000000002000F700000000'
 DC X'0000000000000000200B8AF0000000000000000000000000300B8CF000000000'
 DC X'300B8DF000000000300B8EF000000000002000F800000000200B90F000000000'
 DC X'0000000000000000300B92F000000000200B93F3000000000000000000000000'
 DC X'480B95F0F10000000000000000000000002000F300000000300B98F000000000'
 DC X'300B99F000000000002000F100000000300B9BF100000000002000F400000000'
 DC X'200B9DF0000000000000000000000000200B9FF0000000000000000000000000'
 DC X'200BA1F0000000000000000000000000300BA3F000000000300BA4F400000000'
 DC X'004000F3F4000000580BA6F0F1000000300BA8F000000000004000F8F2000000'
 DC X'002000F200000000300BAAF000000000300BABF000000000002000F800000000'
 DC X'500BADF0F10000007C0BAFF0F3F700000000000000000000300BB2F400000000'
 DC X'002000F200000000002000F700000000002000F500000000500BB4F0F1000000'
 DC X'580BB6F5F00000000000000000000000002000F900000000002000F000000000'
 DC X'400BB9F0F100000000000000000000000000000000000000580BBCF0F1000000'
 DC X'300BBEF100000000002000F100000000002000F600000000580BC0F0F1000000'
 DC X'580BC2F5F2000000002000F000000000004000F5F0000000002000F800000000'
 DC X'300BC5F000000000200BC6F7000000000000000000000000200BC8F000000000'
 DC X'0000000000000000200BCAF0000000000000000000000000500BCCF1F0000000'
 DC X'640BCEF1F7F80000000000000000000000000000000000000000000000000000'
 DC X'002000F500000000580BD2F0F1000000300BD4F000000000004000F1F2000000'
 DC X'300BD5F000000000002000F700000000300BD74000000000300BD84000000000'
 DC X'200BD900000000000000000000000000300BDBF000000000200BDCF000000000'
 DC X'0000000000000000500BDEF0F1000000300BE0F0000000000000000000000000'
 DC X'200BE1F00000000000000000000000000080004040000100300BEA0000000000'
 DC X'00800000011C0000300BEE400000000000400040400000000040004040000000'
 DC X'18000C00000000000020000000000000300BEB0100000000300BEC0D00000000'
 DC X'200BED000000000000000000000000000040004000000000580BF0F0F1000000'
 DC X'300BF2F000000000200BF6F100000000500BF3F7F0000000300BF5F000000000'
 DC X'0000000000000000002000F0000000000000000000000000300BFB4000000000'
 DC X'300BFF000000000000000000000000000060004040000000300BFC4000000000'
 DC X'300BFD0000000000200BFE01000000000000000000000000300C000100000000'
 DC X'300C010D00000000200C0200000000000000000000000000500C04F0F1000000'
 DC X'200C06F00000000000000000000000000000000000000000300C08F000000000'
 DC X'200C09F0000000000000000000000000300C214000000000DF0C390047415814'
 DC X'580C530100000000480C5C0099000000300C5E4000000000F8003008120C0615'
 DC X'300C5F4000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0040004040000000000000000000000020001C09000000000000000000000000'
 DC X'0000000000000000300C224000000000300C230000000000580C240102000000'
 DC X'DF0C264158500047300C380000000000300C31E000000000200C33B000000000'
 DC X'300C341000000000300C350000000000200C3780000000005000D0D105408000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000200C32F00000000000000000000000000000000000000000'
 DC X'006000D078580000300C36000000000000600000000000000000000000000000'
 DC X'0040000036000000580C460001000000300C4CF000000000300C4E1000000000'
 DC X'300C4F7000000000300C50CE00000000786005D040D1D2FF200C52EF00000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'004000FFFF000000002000C500000000300C480000000000300C4A0D00000000'
 DC X'200C4900000000000000000000000000200C4B00000000000000000000000000'
 DC X'200C4DF000000000000000000000000000200011000000000020003F00000000'
 DC X'300C51A100000000004000860000000000000000000000007C0C55C5407C0000'
 DC X'300C5B0000000000300C58E4000000000080004040404000006000E2E3F00000'
 DC X'300C59E500000000200C5AE20000000000000000000000000020000700000000'
 DC X'0000000000000000002000A3000000000080004000014700300C604000000000'
 DC X'300C610000000000200C6201000000000000000000000000580C64F0F1000000'
 DC X'B10C66F0F4F8F5F1200C6DF900000000400C6BF0F10000000000000000000000'
 DC X'00000000000000000000000000000000002000F6000000000000000000000000'
 DC X'00000000000000000000000000000000300C73D200000000300C745800000000'
 DC X'00000000000000000060005850D0000000000000000000000040000340000000'
 DC X'004000404000000000000000000000000040005040000000300C7AD400000000'
 DC X'00000000000000000040005040000000004000D7C90000000000000000000000'
 DC X'00600040D4F00000004000A2A3000000004000878800000000600040D0880000'
 DC X'0000000000000000006000C1D9E3000000400081A3000000300C858100000000'
 DC X'00400099A5000000300C86A300000000300C87A400000000300C88A200000000'
 DC X'200C897E000000000000000000000000300C8BD7000000000040009996000000'
 DC X'300C8F9900000000000000000000000000400089A3000000300C909500000000'
 DC X'004000967E000000300C93D40000000000400040C4000000200C944000000000'
 DC X'000000000000000000400058800000000000000000000000300C980000000000'
 DC X'300C990000000000300C9A4000000000300C9B4000000000300C9C4000000000'
 DC X'200C9D4000000000000000000000000000600040C9C200000000000000000000'
 DC X'0020001600000000004000899300000000000000000000000000000000000000'
 DC X'000000000000000000400097930000000040004084000000200CA84000000000'
 DC X'0000000000000000000000000000000000000000000000000020008300000000'
 DC X'0000000000000000300CAEF900000000300CAFF5000000000020004000000000'
 DC X'002000D0000000000040008182000000002000A400000000200CB46C00000000'
 DC X'00000000000000000000000000000000DF0CC9D0D2D1D411D10CF900D140D0F0'
 DC X'D90D0D00D050D1F0DE0D1FD000D301D2500D2B00D0000000DFFAF06040803090'
 DC X'B30D3100E010D0F0740D3700D0400000780D3D0040D10000580D4200F0000000'
 DC X'200D460000000000300D470000000000480D49F000000000200D4B0000000000'
 DC X'300D4C0000000000000000000000000000400070000000000000000000000000'
 DC X'0020006000000000DF0CD5A898B090A09A0CE310A818C0007C0CE700E8A00000'
 DC X'580CEC1008000000300CEF000000000068C0D3DFD6DDF0D8300CF82800000000'
 DC X'000000000000000000000000000000000000000000000000004000F0F1000000'
 DC X'002000E800000000300CDD5800000000300CE05800000000300CE15800000000'
 DC X'00600058F031000000400058F00000002C009478000000000040005010000000'
 DC X'00400058F0000000300CDEF000000000200CDF32000000000000000000000000'
 DC X'002000F000000000200CE2F000000000000000000000000000600058F03F0000'
 DC X'00600058F03A0000000000000000000000400058F0000000300CEA5800000000'
 DC X'00400058F000000000400058F0000000200CEBF0000000000000000000000000'
 DC X'300CEE580000000000600058F0360000002000F000000000300CF0DD00000000'
 DC X'300CF1FF00000000300CF21000000000300CF30000000000300CF42000000000'
 DC X'300CF50000000000300CF64700000000200CF780000000000000000000000000'
 DC X'00400058F0000000900D03000109080000000000000000000000000000000000'
 DC X'0000000000000000300D0AF00000000040003F8042D300000000000000000000'
 DC X'000000000000000000000000000000000000000000000000300D075000000000'
 DC X'000000000000000000000000000000000000000000000000300D087000000000'
 DC X'200D09D0000000000000000000000000580D0BF1F0000000002000F700000000'
 DC X'002000F2000000007C0D1400017000009A0D1BB0D4D898000000000000000000'
 DC X'0000000000000000004000F0F100000010004100000000000000000000000000'
 DC X'300D175000000000300D1A5A000000000020005900000000300D185000000000'
 DC X'300D19D000000000002000F80000000000400050D00000000040005050000000'
 DC X'004000505000000000000000000000000040005050000000200D27BC00000000'
 DC X'480D280100000000300D2AD4000000000080000019F047000000000000000000'
 DC X'2400D1F000000000000000000000000000200034000000000000000000000000'
 DC X'000000000000000000400050000000000020001500000000500D2D0103000000'
 DC X'0000000000000000300D2F50000000000000000000000000200D302000000000'
 DC X'0000000000000000300D36000000000000000000000000000000000000000000'
 DC X'002000B400000000002000010000000000600047F0300000580D3A0001000000'
 DC X'00000000000000000020002800000000300D3C50000000000040004120000000'
 DC X'00400060D2000000400D4001030000000040003C500000000000000000000000'
 DC X'00000000000000000000000000000000400D440001000000004000F0F0000000'
 DC X'000000000000000000000000000000000000000000000000200D480800000000'
 DC X'000000000000000000000000000000000020001C000000000000000000000000'
 DC X'300D4DAD0000000000400018F7000000480D51F080000000300D534000000000'
 DC X'0020009000000000000000000000000000200030000000000060000038400000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'002000C000000000580D65C1F0000000300D714000000000500D736070000000'
 DC X'200D784000000000200D7970000000006940BF7041D2F092300D7A5F00000000'
 DC X'0000000000000000000000000000000000400003F00000000000000000000000'
 DC X'0020000800000000580D67B8B0000000002000F000000000300D695800000000'
 DC X'300D6F5800000000300D6AD000000000300D6BD000000000300D6C0400000000'
 DC X'580D6D58F0000000006000E0D00C0000004000F0F0000000200D707000000000'
 DC X'0000000000000000200D7200000000000000000000000000300D75F000000000'
 DC X'0000000000000000300D76F000000000200D77F0000000000000000000000000'
 DC X'000000000000000000000000000000000020005000000000300D7DF000000000'
 DC X'0000000000000000300D7EF000000000004000F0F00000000060004000380000'
 DC X'004000EF5000000000000000000000000040005010000000DE0D8E3135323330'
 DC X'D80DBD32F0313330D00DDE3034323331580DEE00F00000006C0E0D3036350000'
 DC X'5A00D0B020E01000300E1031000000000000000000000000300E11F000000000'
 DC X'00000000000000000000000000000000300DA6B400000000300DAA9C00000000'
 DC X'580DAE02A2000000580DB0CC880000000000000000000000F6743E3639343DF0'
 DC X'0000000000000000580DB24828000000500DB5B2420000000000000000000000'
 DC X'0000000000000000300DB8F000000000300DBB7C00000000300DBCE600000000'
 DC X'0000000000000000006000004940000000000000000000000000000000000000'
 DC X'000000000000000000000000000000003000C3C6910000000000000000000000'
 DC X'00000000000000000000000000000000300DA74900000000300DA87000000000'
 DC X'200DA933000000000000000000000000300DAB4900000000300DAC4000000000'
 DC X'200DAD370000000000000000000000000040005870000000002000BF00000000'
 DC X'004000D2030000000020005800000000300DB4490000000000600049603A0000'
 DC X'004000603F000000300DB749000000000000000000000000004000603F000000'
 DC X'300DB9F000000000300DBAF300000000002000F1000000000020005800000000'
 DC X'0020004700000000300DD31000000000580DD5F0280000000000000000000000'
 DC X'00000000000000000000000000000000F4013D3E3436373F0000000000000000'
 DC X'300DDA7200000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000400038070000000000000000000000'
 DC X'00000000000000001800B100000000000040003194000000300DD4D200000000'
 DC X'0040000340000000500DD7F0F10000000060004040400000300DD9F000000000'
 DC X'0000000000000000004000F0F4000000300DDB4700000000300DDCF000000000'
 DC X'200DDD3F000000000000000000000000200DEDAE000000000000000000000000'
 DC X'00000000000000000000000000000000000000000000000092783637F0CB3541'
 DC X'00000000000000000000000000000000006000F0F0F200000000000000000000'
 DC X'0000000000000000004000BC500000000020003C000000000020003C00000000'
 DC X'0020004C000000000000000000000000500DF00008000000200E0CF000000000'
 DC X'DF0DF258D241D7470000000000000000DA0DFC4070F05060300E060300000000'
 DC X'300E087000000000200E0A0300000000200E0BF0000000004E00494407500000'
 DC X'004000503600000000400000C100000000400000F00000000000000000000000'
 DC X'200E03D000000000200E04D0000000000000000000000000200E05D000000000'
 DC X'00000000000000001800800000000000004000D0880000000000000000000000'
 DC X'00000000000000000000000000000000200E07D0000000000000000000000000'
 DC X'200E09D000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000000000000000000000004000581B0000000040001C1B000000'
 DC X'00400038F0000000300E121E0000000000400058F0000000480E245070000000'
 DC X'300E2640000000000000000000000000300E290000000000300E2AF000000000'
 DC X'B5824105709247F00000000000000000200E2CEF000000000000000000000000'
 DC X'0080001020005000200E2D700000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000020000000000000'
 DC X'00000000000000000020007000000000580E2740000000000060004040400000'
 DC X'00600038404000000040001490000000300E2B20000000000080004892102000'
 DC X'00000000000000000000000000000000400E353F3A000000200E373F00000000'
 DC X'200E383E00000000200E39320000000000000000000000001800F00000000000'
 DC X'00400035B6000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000000000000000000000200E3F3F00000000200E404A00000000'
 DC X'0000000000000000000000000000000000400040000000000000000000000000'
 DC X'0000000000000000300E4C6100000000300E524B00000000300E560000000000'
 DC X'000000000000000000000000000000005280F0F8904000000000000000000000'
 DC X'00000000000000000040003FDA0000000000000000000000004000E2E3000000'
 DC X'580E4D4BA2000000300E4F4B000000000040009983000000300E506100000000'
 DC X'300E514B000000000040004B61000000300E534B00000000300E546100000000'
 DC X'300E554B000000000060004B61A20000300E5740000000000020004000000000'
 DC X'300E632000000000008000846E1500000000000000000000300E644000000000'
 DC X'00000000000000005480001847BFD2000000000000000000300E661400000000'
 DC X'0000000000000000000000000000000000400003D0000000004000D124000000'
 DC X'300E65000000000000200038000000000020000500000000200E6EF000000000'
 DC X'0000000000000000000000000000000000000000000000000040008186000000'
 DC X'1800F100000000000020005D000000000000000000000000300E734000000000'
 DC X'300E7AEF00000000004000F03400000000400003D1000000300E740000000000'
 DC X'300E753800000000300E764000000000300E774000000000300E780000000000'
 DC X'200E7901000000000000000000000000300E7B00000000000040000000000000'
 DC X'0000000000000000DF0EADD4D1D0D200DC0ED4D0D1D2D6D3D10EE7D0D1D2D400'
 DC X'D80EF98898B094B8C40F12D000D4D204FFFD40F020803010DC0F1FD040F010D4'
 DC X'B80F31D0F0D140D2CB0F3ED1D0D2D6F0980F46D0D3D10800920F4C10D0D2B500'
 DC X'A40F53D0DFF0D1D2300F584400000000400F62D2DD000000200F64D000000000'
 DC X'400F65D2D30000000000000000000000200F67D000000000300F680300000000'
 DC X'0000000000000000F81A413F3A080F18200F6910000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000300F6A4100000000200F6C2C000000000000000000000000'
 DC X'200F6DD200000000000000000000000000000000000000000000000000000000'
 DC X'C01132C02CD8064F000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'004000D203000000000000000000000000000000000000000000000000000000'
 DC X'0040005850000000680EBE101C280000400EC170D8000000300EC3F000000000'
 DC X'300EC40300000000580EC65000000000BF46584147600250640ECA50F0400000'
 DC X'300ECD1000000000200ECF8000000000300ED000000000000000000000000000'
 DC X'200ED30000000000000000000000000000000000000000000000000000000000'
 DC X'0040004C92000000002000590000000000000000000000000060004110F00000'
 DC X'000000000000000000000000000000000000000000000000002000D200000000'
 DC X'300EC5D1000000000020000C00000000300EC850000000000040000000000000'
 DC X'300EC96000000000002000140000000000000000000000000000000000000000'
 DC X'002000D000000000200ECED10000000000000000000000000000000000000000'
 DC X'580ED11A00000000004000581A00000000200000000000000000000000000000'
 DC X'860EDE9CE8FCE0008A0EE22C58342800200EE64C000000000000000000000000'
 DC X'00000000000000004500D500DD50000000000000000000000060005050600000'
 DC X'000000000000000000400000F000000000000000000000000000000000000000'
 DC X'002000D200000000002000580000000000000000000000000040005880000000'
 DC X'000000000000000000200041000000000000000000000000600EF4A4BCB80000'
 DC X'000000000000000000000000000000000000000000000000200EF75000000000'
 DC X'74602060D35010140000000000000000200EF800000000000000000000000000'
 DC X'0000000000000000000000000000000000200058000000000020009500000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000007C0F0858D2410000580F0F50F00000000000000000000000'
 DC X'000000000000000000000000000000009178E4A09C2090A80000000000000000'
 DC X'000000000000000000000000000000000060000418D200000000000000000000'
 DC X'004000D203000000002000470000000000200050000000000020004700000000'
 DC X'300F0B5000000000200F0E03000000000020004000000000300F0C5000000000'
 DC X'300F0D0400000000004000D7030000000000000000000000200F115000000000'
 DC X'004000F0F1000000000000000000000000000000000000000000000000000000'
 DC X'300F1C1000000000000000000000000000000000000000004A0010D10CF00000'
 DC X'200F1D08000000000000000000000000300F1E47000000000000000000000000'
 DC X'002000F00000000000000000000000000040008037000000200F289400000000'
 DC X'300F290000000000300F2EF00000000000000000000000000000000000000000'
 DC X'300050D186000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000300F2A3800000000300F2B4000000000300F2C4000000000'
 DC X'200F2D00000000000000000000000000300F2FF000000000300F30F000000000'
 DC X'004000F0F10000006C0F36B0C4940000580F39F0F10000000000000000000000'
 DC X'000000000000000000000000000000000000000000000000002000D200000000'
 DC X'0020004700000000200F3BF000000000480F3CF6F00000000000000000000000'
 DC X'0000000000000000002000F9000000000000000000000000300F45C000000000'
 DC X'00000000000000000040004CF0000000004000F0F00000001000D30000000000'
 DC X'00000000000000000020004100000000300F4AA800000000200F4B8C00000000'
 DC X'0000000000000000000000000000000000200041000000000000000000000000'
 DC X'6C0F50000414000000000000000000000000000000000000004000D458000000'
 DC X'000000000000000000400058F000000000400058300000000000000000000000'
 DC X'0000000000000000006000F0F1F2000000000000000000000000000000000000'
 DC X'9E0F59D2BF585000300F5D0300000000300F5F5F00000000300F615000000000'
 DC X'00400050D1000000200F5ED1000000000000000000000000300F605000000000'
 DC X'0060000047800000004000500000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'004000D4080000000000000000000000200F6B10000000000000000000000000'
 DC X'0000000000000000000000000000000000400058500000000000000000000000'
 DC X'300F754000000000000000000000000000000000000000000000000000000000'
 DC X'004000F0300000000080000038404000300F824000000000580F850001000000'
 DC X'00000000000000000000000000000000300F8840000000006A4047903058F005'
 DC X'004000803D000000000000000000000000400024200000000000000000000000'
 DC X'0000000000000000002000EF00000000300F830000000000300F843800000000'
 DC X'0060004040000000300F87000000000000400000010000000020000000000000'
 DC X'0020000000000000500F93C0D0000000500F9D80D00000000000000000000000'
 DC X'200F9F7000000000300FA0530000000047006043401000000000000000000000'
 DC X'0040005070000000002000D0000000000020003D00000000300F950C00000000'
 DC X'0000000000000000300F964700000000300F972000000000300F98F000000000'
 DC X'9E0F992C1E30240000800058F0D0480000400058F000000000400058F0000000'
 DC X'00200058000000000060000C4170000000000000000000000000000000000000'
 DC X'004000F0F0000000008000400038400000000000000000000020007700000000'
 DC X'DF0FBED03FC03435D51006D03F703EF0D4102DD03FF0503E9E104DD04030F000'
 DC X'D81061D0F020903FFFFF6080750010E0D8106ED06050D132981080D080F07000'
 DC X'58108B70F000000088109D00F034D0009810A2D0F01020005010AAD020000000'
 DC X'4810AED0C30000005010B0D0900000002010B3D0000000003010B4D000000000'
 DC X'2010B8D0000000005810B970800000002010BB70000000003010BC0000000000'
 DC X'5380C04105115D0000000000000000000000000000000000004000EF58000000'
 DC X'00200000000000000020005A00000000740FDB4890880000740FF1AE50560000'
 DC X'300FF47400000000200FFC5400000000300FFDD000000000FC24F03638323931'
 DC X'740FFEF0F10C0000301003400000000000000000000000000000000000000000'
 DC X'000000000000000000000000000000003010043E000000000000000000000000'
 DC X'0000000000000000301005000000000000000000000000000000000000000000'
 DC X'000000000000000000000000000000008000C33770604B240000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'000000000000000000000000000000000000000000000000300FDE9000000000'
 DC X'00000000000000000020009200000000300FDFF000000000300FE02000000000'
 DC X'300FE14800000000300FE29200000000300FE31000000000300FE42000000000'
 DC X'300FE50000000000300FE65000000000300FE7D000000000300FE82000000000'
 DC X'300FE90400000000300FEA1800000000300FEBD200000000300FEC0500000000'
 DC X'300FED3000000000580FEE505800000000800010D0884400200FF04000000000'
 DC X'000000000000000000600005EF50000000000000000000000020000500000000'
 DC X'300FF50700000000300FF6FF00000000300FF790000000009E0FF8E8E5E7EB00'
 DC X'008000D00C582000008000D00C582000004000D00C000000004000D00C000000'
 DC X'00000000000000000020000500000000301001F0000000000000000000000000'
 DC X'0020005800000000201002F00000000000000000000000000020000500000000'
 DC X'002000050000000000600058E0F00000BB1018889490BCA80000000000000000'
 DC X'4810290010000000000000000000000030102BF000000000C05734D135366031'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'000000000000000000400098580000000000000000000000004000AC55000000'
 DC X'00000000000000000040000458000000002000C4000000000020000C00000000'
 DC X'7C101DD258BF0000581027D25800000000000000000000000040004180000000'
 DC X'0020004B00000000301020030000000030102370000000000040007F70000000'
 DC X'401021D0D1000000000000000000000000000000000000003010247000000000'
 DC X'581025080C000000002000D70000000000200058000000000020000300000000'
 DC X'00200070000000000000000000000000002000590000000030102CF000000000'
 DC X'004000F0F900000074103A8890A800000000000000000000581049F000000000'
 DC X'0000000000000000000000000000000071A035604038513B0000000000000000'
 DC X'00000000000000000000000000000000004000D05A0000000040000CD2000000'
 DC X'0000000000000000002000B0000000007C103D58D24100000000000000000000'
 DC X'002000D200000000501040506000000030104603000000000040004060000000'
 DC X'3010425000000000000000000000000050104300140000002010455800000000'
 DC X'00000000000000000000000000000000401047D1D00000000000000000000000'
 DC X'000000000000000040104BF0F100000000200050000000000000000000000000'
 DC X'000000000000000050105188A000000030105A00000000000020002C00000000'
 DC X'002000F00000000058105358D200000000000000000000003010554000000000'
 DC X'3010580300000000301056400000000020105700000000000000000000000000'
 DC X'201059D000000000000000000000000030105B380000000030105C4000000000'
 DC X'30105D400000000030105E000000000040105F01020000000000000000000000'
 DC X'00000000000000005810684C78000000006000F0F0F000000000000000000000'
 DC X'0000000000000000000000000000000010005000000000000000000000000000'
 DC X'30106A4100000000004000586000000030106B000000000048106C2024000000'
 DC X'00000000000000000020004800000000301077880000000020107F0000000000'
 DC X'0000000000000000000000000000000000000000000000003600203435000000'
 DC X'00000000000000000020000E00000000002000D00000000058107858D2000000'
 DC X'30107A600000000030107D030000000030107B600000000020107C0000000000'
 DC X'000000000000000020107ED40000000000000000000000000000000000000000'
 DC X'921084889098940030108A140000000000000000000000000000000000000000'
 DC X'3010885800000000000000000000000000000000000000000020004000000000'
 DC X'30108980000000000080008004587000004000417000000030108D0000000000'
 DC X'004000F0F00000009E108E5012F0BF0030109270000000003010977700000000'
 DC X'004000F0F00000000020007F00000000741093D1D0D300002010969800000000'
 DC X'00000000000000000020002000000000000000000000000058109847F0000000'
 DC X'58109A8070000000006000F0F1F0000020109C33000000000020003200000000'
 DC X'000000000000000000000000000000003010A110000000000000000000000000'
 DC X'00000000000000000040001E020000003010A688000000003010A8F000000000'
 DC X'000000000000000000000000000000003010A7D20000000000400007D1000000'
 DC X'2010A9F00000000000000000000000003010AC0C000000000000000000000000'
 DC X'2010AD9800000000000000000000000000000000000000000040004441000000'
 DC X'3010B28800000000000000000000000000400058900000000000000000000000'
 DC X'3010B504000000005810B6581B000000008000E0D00C9800006000FF58E00000'
 DC X'00000000000000000060000058F0000000400000580000000000000000000000'
 DC X'3010BD100000000000800007FF0C0B005810C7F0D30000005810CDD060000000'
 DC X'3010D0D000000000000000000000000000000000000000003E00644060000000'
 DC X'002000F000000000002000D000000000002000F0000000003010C90C00000000'
 DC X'008000E0478033003010CA47000000003010CB80000000003010CC3400000000'
 DC X'00200088000000003010CF9C000000000060000C478000000020004700000000'
 DC X'00400090470000003010D9C3000000003010E5C3000000005810E940C3000000'
 DC X'00000000000000000000000000000000240058F0000000000000000000000000'
 DC X'004000F0F00000003010DA4400000000BF10DBD2BF58501B3010E00300000000'
 DC X'3010E25F000000003010E4600000000000400050D20000000040000096000000'
 DC X'2010E1D10000000000000000000000003010E350000000000060000047800000'
 DC X'00600050005800003010E644000000004810E758410000000000000000000000'
 DC X'00200050000000003010EB000000000000600044504000000080003840400000'
 DC X'0000000000000000004000A7400000000000000000000000004000808C000000'
 DC X'00200040000000003010F6400000000000000000000000000000000000000000'
 DC X'000000000000000000000000000000002010F700000000000000000000000000'
 DC X'3010FBC30000000000400040F00000000020004000000000006000D6D4D70000'
 DC X'3011034000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000001800E00000000000004000CAA40000003011040000000000'
 DC X'3011053800000000301106400000000030110740000000003011080000000000'
 DC X'2011090100000000000000000000000030110E00000000000000000000000000'
 DC X'008000F0C31C1800004000F0F000000020110F47000000000000000000000000'
 DC X'DC11350058414918881144889CCC900058114940D70000005811510040000000'
 DC X'581156F00C000000F67A3F045008D258000000000000000058115B5847000000'
 DC X'20115D00000000000000000000000000000000000000000020115E7000000000'
 DC X'20115F7000000000301160440000000030116241000000000000000000000000'
 DC X'201164EF00000000000000000000000000000000000000000000000000000000'
 DC X'F204183E01D3360C000000000000000000000000000000003011655000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000000000000000000000004000A4A20000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000001800B20000000000'
 DC X'002000940000000030113FD200000000501140506000000000600060D0DC0000'
 DC X'00000000000000000000000000000000400020D2500300000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000080006F50006000'
 DC X'301142D000000000000000000000000030114388000000000020005800000000'
 DC X'0000000000000000201148580000000000000000000000000000000000000000'
 DC X'000000000000000030114B0000000000004000999600000030114C3800000000'
 DC X'30114D400000000030114E400000000030114F00000000002011500100000000'
 DC X'0000000000000000301153580000000030115599000000003011546000000000'
 DC X'00400060140000000040009783000000301158F0000000000060004780320000'
 DC X'301159F00000000030115AF300000000004000F0F10000000020007000000000'
 DC X'002000F000000000000000000000000000000000000000000000000000000000'
 DC X'3011615800000000004000503A00000020116350000000000000000000000000'
 DC X'0000000000000000002000400000000030116D4B000000000000000000000000'
 DC X'00000000000000000040008982000000004000A8830000001000920000000000'
 DC X'000000000000000020116E610000000000000000000000000000000000000000'
 DC X'0000000000000000201176000000000000000000000000000000000000000000'
 DC X'00600040003800000000000000000000000000000000000030117C4000000000'
 DC X'0000000000000000000000000000000000000000000000000020000300000000'
 DC X'30117D0000000000008000384040000000000000000000000020007000000000'
 DC X'30118B0000000000000000000000000030118D40000000000000000000000000'
 DC X'0060007847B000005F80F05512D23500004000F0F000000000400070D0000000'
 DC X'004000FF500000000020000300000000002000C20000000030118C0500000000'
 DC X'002000040000000030118E00000000000040003840000000301193F000000000'
 DC X'0000000000000000000000000000000000000000000000000020000000000000'
 DC X'741196D599F100000000000000000000004000D6C20000000000000000000000'
 DC X'004000F9F90000005811A56E6B0000004811A76B6E0000003011A96C00000000'
 DC X'2011AAA700000000000000000000000064405840504797F10000000000000000'
 DC X'3011AB4000000000000000000000000000000000000000000000000000000000'
 DC X'0020005B000000000020004B0000000000200040000000000000000000000000'
 DC X'00400040D30000000060006C6C6C000000000000000000002011AC0000000000'
 DC X'00000000000000003011BE95000000003011C093000000003011C18300000000'
 DC X'3011C293000000003011C38500000000BC2ED6A49799C3862011C4D500000000'
 DC X'3011C5A300000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000000040008599000000000000000000000000400085F0000000'
 DC X'004000966D00000000200087000000003011BF98000000000040006D95000000'
 DC X'004000A36D000000004000936D0000000040009683000000004000A7A3000000'
 DC X'000000000000000000400089930000003011C940000000000000000000000000'
 DC X'00200000000000003011CA00000000003011CB38000000000080004040000100'
 DC X'0000000000000000DF11FC50001241D2DC122288909894A46412330834040000'
 DC X'301236F00000000058123D0C00000000F3CD333F0436D2400000000000000000'
 DC X'000000000000000050124141470000003012447C000000005812450370000000'
 DC X'30124840000000000000000000000000000000000000000030124C5800000000'
 DC X'30124D5800000000000000000000000020124E00000000000000000000000000'
 DC X'0000000000000000F4804131D53B3542000000000000000030124F5400000000'
 DC X'00000000000000000000000000000000201250FE000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'B20E58390D3C4305000000000000000000000000000000000040000022000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000000020004600000000002000AC000000000020008800000000'
 DC X'58120C70100000005012105000000000301214770000000020121A1000000000'
 DC X'30121B0300000000AF8C58800107084758121D807000000030121F0000000000'
 DC X'3012204700000000006000557080000030122158000000000000000000000000'
 DC X'0000000000000000000000000000000000200000000000000020000000000000'
 DC X'40120ED1D0000000004000D08800000000000000000000000000000000000000'
 DC X'30121270000000000000000000000000301213D000000000002000B000000000'
 DC X'301215470000000030121680000000006C121731303300000000000000000000'
 DC X'002000A800000000002000C400000000000000000000000020121CD000000000'
 DC X'0000000000000000004000D08800000000200070000000000040005870000000'
 DC X'004000D03C000000002000900000000058122C58D20000002012315800000000'
 DC X'3012325000000000000000000000000000000000000000004100E89CB8BC0000'
 DC X'0000000000000000000000000000000000000000000000000020004700000000'
 DC X'30122E700000000000400003D200000030122F70000000003012300C00000000'
 DC X'0040005870000000000000000000000000200070000000000000000000000000'
 DC X'00000000000000000020004100000000581237F0F1000000581239F0F2000000'
 DC X'20123CF40000000020123BF000000000004000F2F10000000000000000000000'
 DC X'000000000000000030123F410000000000400058900000002012407000000000'
 DC X'0000000000000000201243100000000000000000000000000000000000000000'
 DC X'0020005800000000301247D10000000000400041700000000020007400000000'
 DC X'301249000000000030124A380000000030124B40000000000080004000010000'
 DC X'00600070D0880000002000700000000000000000000000000040005020000000'
 DC X'0000000000000000006000F03E720000006000400038000030125A4000000000'
 DC X'30125CFF0000000020125EF00000000000000000000000000000000000000000'
 DC X'1000500000000000000000000000000020125B00000000000000000000000000'
 DC X'20125D9000000000000000000000000000000000000000003012610000000000'
 DC X'30126600000000007C12625012F0000020126570000000000040007747000000'
 DC X'002000F00000000000000000000000000040004780000000002000F000000000'
 DC X'30126D730000000020127070000000000080007047D033002012717000000000'
 DC X'201272800000000048126E80D000000000000000000000000020009200000000'
 DC X'00000000000000000000000000000000000000000000000030127E0000000000'
 DC X'301280400000000060128880F070000020128B03000000000000000000000000'
 DC X'53805018051A440000000000000000000000000000000000006000EF12FF0000'
 DC X'00400085F0000000004000703B00000020127F00000000000000000000000000'
 DC X'5812810040000000301283380000000000400040400000003012844000000000'
 DC X'3012854000000000301286000000000020128701000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'30129140000000000000000000000000201293F1000000000000000000000000'
 DC X'004000F57A000000301292000000000000800038404000000000000000000000'
 DC X'3012994000000000000000000000000000000000000000000000000000000000'
 DC X'000000000000000030129A000000000030129B38000000000060004040000000'
 DC X'4812A36C400000003012A5A7000000000040006C8400000000400050D0000000'
 DC X'0040005D400000001800000000000000002000F0000000000000000000000000'
 DC X'00400000380000002012A66C0000000000000000000000003012A90000000000'
 DC X'00000000000000000040004770000000DE12D700582002415012EB88A8000000'
 DC X'5812F140000000004012F92E6C0000000000000000000000F6323180F0353332'
 DC X'00000000000000004812FB00140000003012FDF0000000000000000000000000'
 DC X'0000000000000000000000000000000030130158000000003013034100000000'
 DC X'0000000000000000000000000000000020130448000000000000000000000000'
 DC X'00000000000000003013051A00000000F000D13FB07050140000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000000000000000000000000000000000000000600003D1D00000'
 DC X'00000000000000009038083C473ED36000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0020008800000000002000DE00000000002000F6000000009E12DF0100D25800'
 DC X'5012E480700000003012E700000000002012EA58000000000000000000000000'
 DC X'2C0050400000000000400070D000000000400040400000002012E30000000000'
 DC X'00800000000000000060006F7000000000200070000000000000000000000000'
 DC X'3012E68000000000000000000000000000800014417000003012E80000000000'
 DC X'3012E92400000000002000500000000000000000000000005812ED5841000000'
 DC X'00000000000000003012EF800000000000200070000000002012F08000000000'
 DC X'00000000000000003012F3000000000000200000000000003012F43800000000'
 DC X'3012F540000000003012F640000000003012F700000000002012F80100000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'00200041000000005812FEF0F1000000201300F100000000002000F000000000'
 DC X'000000000000000030130290000000000040003FDE0000000040007000000000'
 DC X'0000000000000000004000586000000074131085818900007413179340A40000'
 DC X'50131C9540000000000000000000000030131E95000000004D008294A2840000'
 DC X'58131F930000000020132185000000000000000000000000004000846D000000'
 DC X'3013139900000000000000000000000030131496000000000040008981000000'
 DC X'30131595000000002013164000000000000000000000000058131A4096000000'
 DC X'0000000000000000004000857E00000000400040400000000040008381000000'
 DC X'00400096A3000000000000000000000000200089000000000040008540000000'
 DC X'0020004000000000000000000000000030132985000000000000000000000000'
 DC X'0000000000000000004000000000000000000000000000001000960000000000'
 DC X'000000000000000030132A4000000000004000A39600000058133A94F0000000'
 DC X'7C133C898540000058133FF095000000201341A3000000003013428400000000'
 DC X'9D189399920088A43013436D0000000020134485000000000000000000000000'
 DC X'3013454000000000000000000000000000000000000000000000000000000000'
 DC X'004000A2C300000000400040400000000040008794000000002000F000000000'
 DC X'00600096954000000060008440D90000002000A600000000002000F000000000'
 DC X'002000A2000000000000000000000000004000854B000000002000A200000000'
 DC X'00000000000000000020004000000000301356400000000030135A9900000000'
 DC X'30135B830000000020135C00000000000000000000000000AC1C99416D845807'
 DC X'30135D6D0000000030135E100000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000040008540000000'
 DC X'002000EF00000000002000850000000058135700400000003013593800000000'
 DC X'0060004040F00000002000400000000000400085830000000040009684000000'
 DC X'00000000000000000020008600000000004000F0F0000000AC137240A299A56D'
 DC X'301378950000000058137940850000009A137E85A3A24000581384A383000000'
 DC X'DF32A38393946D9768138A85A440000068138DA3A46D0000581390A385000000'
 DC X'2013929600000000000000000000000000000000000000002013938400000000'
 DC X'006000005880000000000000000000000000000000000000004000F0F0000000'
 DC X'0000000000000000002000810000000000000000000000003013774000000000'
 DC X'006000969940000000000000000000000000000000000000004000D985000000'
 DC X'00200081000000006C137BD140D4000000400095A30000000000000000000000'
 DC X'0040004040000000002000810000000030138299000000002013839900000000'
 DC X'00000000000000000020008100000000004000A5850000000000000000000000'
 DC X'30138640000000003013889600000000301387E400000000006000A285990000'
 DC X'20138984000000000000000000000000000000000000000000800099954D8400'
 DC X'000000000000000000000000000000000060009989A300000000000000000000'
 DC X'0040006D89000000004000A38500000000000000000000000000000000000000'
 DC X'3013A040000000003013A300000000003013A6F0000000003013A98900000000'
 DC X'3013AA8500000000654099205885899300000000000000000040002212000000'
 DC X'0000000000000000004000994000000000000000000000000020008100000000'
 DC X'3013A100000000003013A2380000000000800040400001004013A40001000000'
 DC X'000000000000000000000000000000003013A7F0000000003013A82800000000'
 DC X'004000404000000000400093A400000000400099400000003013B3A300000000'
 DC X'3013B6A3000000000040006D9700000000000000000000000000000000000000'
 DC X'2C009695000000000040006D8700000000200089000000003013B4A200000000'
 DC X'2013B5400000000000000000000000002013B76D000000000000000000000000'
 DC X'BF13CB507060F0803013D503000000003013D940000000003013DC0000000000'
 DC X'3013DE4000000000D3D55047A38144F000000000000000000000000000000000'
 DC X'3013DFA2000000002013E0950000000000600000C1B000002013E1F000000000'
 DC X'0000000000000000006000807000000000000000000000000040007F70000000'
 DC X'0000000000000000002000A800000000002000A3000000003013D05000000000'
 DC X'2013D370000000002013D46000000000004000F0F00000000020008000000000'
 DC X'3013D100000000002013D2580000000000000000000000000000000000000000'
 DC X'00000000000000005013D6D0D10000003013D890000000000000000000000000'
 DC X'00200040000000003013DA00000000003013DB38000000000040004040000000'
 DC X'2013DD0000000000000000000000000000400002BD00000000400040D9000000'
 DC X'00000000000000000000000000000000B713F5878584A3403013FB8500000000'
 DC X'3013FD8800000000481401A3830000003014030000000000DD9F96A383F0A985'
 DC X'3014059500000000301407880000000000000000000000002014080000000000'
 DC X'30140985000000000000000000000000000000000000000030140A0000000000'
 DC X'20140B0000000000004000857A00000000400000020000000040000014000000'
 DC X'00200000000000002013FA40000000000000000000000000004000D485000000'
 DC X'0040008599000000002000A20000000000000000000000002013FC4000000000'
 DC X'00000000000000003013FEA3000000005813FFA240000000008000406040F000'
 DC X'002000C90000000000000000000000000060009396A200002014040200000000'
 DC X'00000000000000002014064000000000000000000000000000400040C9000000'
 DC X'0000000000000000004000409600000000400004890000000000000000000000'
 DC X'0000000000000000002000600000000020140F00000000000000000000000000'
 DC X'3014144000000000201416030000000000000000000000000000000000000000'
 DC X'20141500000000000000000000000000000000000000000030141A4000000000'
 DC X'0000000000000000002000030000000030141B000000000030141C3800000000'
 DC X'30141D400000000030141E400000000030141F00000000002014200100000000'
 DC X'00000000000000000040000041000000501438000100000020143BF000000000'
 DC X'58143C705000000030143F400000000078144680D0700000FD0441F0D0D22004'
 DC X'481449107000000058144B20F0000000000000000000000020144E0300000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000004000D00C00000000000000000000000000000000000000'
 DC X'002000C4000000000020004C000000001800D100000000000020000400000000'
 DC X'20143A0000000000000000000000000000000000000000000000000000000000'
 DC X'20143ED000000000002000D00000000000000000000000003014400000000000'
 DC X'3014413800000000301442400000000030144340000000003014440000000000'
 DC X'2014450100000000000000000000000000400030960000000040003520000000'
 DC X'0000000000000000000000000000000000200000000000000080004892102000'
 DC X'30144DF000000000004000F4F100000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'1800040000000000002000800000000030146140000000003014622000000000'
 DC X'581463D5D1000000301465820000000000000000000000005E800891F0010500'
 DC X'301467D100000000004000D014000000004000F0F00000000000000000000000'
 DC X'002000EF0000000000800000384040000080000050D02000002000C000000000'
 DC X'0020006400000000301466F50000000000200061000000000020007C00000000'
 DC X'50147140840000003014744000000000581476D9890000002014788500000000'
 DC X'301479400000000032009681A400000000000000000000000000000000000000'
 DC X'0020008500000000301473C300000000000000000000000000400061F3000000'
 DC X'3014758900000000002000950000000000400089870000000020009500000000'
 DC X'000000000000000030147A600000000000200040000000003014884000000000'
 DC X'50148AF06000000058148C9540000000000000000000000030148E7000000000'
 DC X'7BA082BFD2A3A4810060008599400000000000000000000000400003D1000000'
 DC X'0040006D85000000004000A38500000000000000000000000040000000000000'
 DC X'20148900000000000000000000000000004000D0880000000000000000000000'
 DC X'004000A3400000000020004C00000000002000D1000000007414A78589990000'
 DC X'2014AB40000000004014ACD0700000003014AEA3000000002014B04000000000'
 DC X'FF840189928695A22014B1D1000000003014B2A3000000003014B39500000000'
 DC X'2014B496000000003014B5850000000000000000000000000000000000000000'
 DC X'000000000000000000000000000000000060008293F000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000003A00034193000000'
 DC X'004000D090000000000000000000000000200096000000002014AA9900000000'
 DC X'0000000000000000004000898500000000000000000000000000000000000000'
 DC X'000000000000000000000000000000002014AF40000000000000000000000000'
 DC X'00000000000000000000000000000000006000898193000000800096A6954000'
 DC X'000000000000000000400083A30000007C14CA40979400003014D34000000000'
 DC X'3014D640000000002014D810000000002014D98500000000E1A1A4A3976D8908'
 DC X'0000000000000000000000000000000000000000000000003014DAA600000000'
 DC X'3014DB9500000000000000000000000000600040C9C200000000000000000000'
 DC X'000000000000000000000000000000000000000000000000004000F0F0000000'
 DC X'0020000000000000002000F0000000003014CD40000000003014CE4B00000000'
 DC X'3014D1810000000000200040000000005814CF00400000000020000000000000'
 DC X'002000F1000000002014D2A30000000000000000000000005814D4D186000000'
 DC X'002000810000000000200093000000003014D700000000000080003840400000'
 DC X'000000000000000000000000000000000020008900000000004000A385000000'
 DC X'4814E696850000003014E86D000000005814EB996D0000003014ED8500000000'
 DC X'0000000000000000430093A38187000000000000000000000000000000000000'
 DC X'0040008392000000004000966D00000000000000000000000020008300000000'
 DC X'5814E9946D00000000400087940000000020008300000000006000A3A8400000'
 DC X'002000810000000000200093000000005014FDF0800000003015004000000000'
 DC X'301509F00000000050151010700000003015130000000000941850E0180C2947'
 DC X'0000000000000000006000D0C847000000000000000000000000000000000000'
 DC X'000000000000000000000000000000000000000000000000004000D00C000000'
 DC X'00200000000000003014FF3F000000000000000000000000002000B800000000'
 DC X'5815010040000000301503380000000000400040400000003015044000000000'
 DC X'3015054000000000301506000000000040150702010000000000000000000000'
 DC X'000000000000000058150A08F000000030150C4D00000000002000F000000000'
 DC X'30150DE00000000030150EF00000000030150F10000000000080004700000400'
 DC X'301512D1000000000000000000000000002000B0000000004015140201000000'
 DC X'0000000000000000000000000000000060152A818340000058152D406C000000'
 DC X'58152F95A300000000000000000000003015326100000000EE04A281976D99A8'
 DC X'2015346D000000002015359400000000581536834B0000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000004000858400000000000000000000000000000000000000'
 DC X'0020004C00000000002000F00000000000000000000000000000000000000000'
 DC X'00000000000000000060004040400000002000A2000000003015318700000000'
 DC X'0020008800000000004000408400000030153399000000000040009783000000'
 DC X'000000000000000000000000000000000040006D6D00000000400040F1000000'
 DC X'0000000000000000004000400000000048154210F00000003015446000000000'
 DC X'3015454000000000201547700000000000000000000000002C00485000000000'
 DC X'00400000B400000000400040D20000000000000000000000002000D100000000'
 DC X'004000335C000000301546000000000000800038404000000000000000000000'
 DC X'30154B40000000000040004000000000002000EF000000000080000038404000'
 DC X'50155A000100000030155D940000000030155E10000000005015604000000000'
 DC X'201565F0000000008B105004F0D205D130156600000000000000000000000000'
 DC X'301567F000000000201568030000000000000000000000000000000000000000'
 DC X'0000000000000000002000200000000030155C00000000000000000000000000'
 DC X'0020000000000000004000F0F000000020155FD2000000000000000000000000'
 DC X'3015620000000000000000000000000030156338000000003015644000000000'
 DC X'0080004000011B000000000000000000004000D703000000004000F0F0000000'
 DC X'00000000000000009A1573D9838440007C1577998483000020157C9900000000'
 DC X'000000000000000020157D6D000000004100896B004B00000000000000000000'
 DC X'00000000000000000000000000000000002000830000000000400085A2000000'
 DC X'00400081930000000000000000000000002000000000000030157AA500000000'
 DC X'20157B40000000000040006D9900000000400085990000000000000000000000'
 DC X'0000000000000000000000000000000058158C99840000005815909695000000'
 DC X'20159481000000002015956D0000000058159689850000008E7081A48899A8A2'
 DC X'301598A300000000581599A29900000030159C85000000000000000000000000'
 DC X'000000000000000020159D4000000000004000F0F00000000020008500000000'
 DC X'30158E890000000020158F40000000000060008193A200000000000000000000'
 DC X'3015929500000000002000870000000020159340000000000000000000000000'
 DC X'000000000000000000000000000000000040009598000000004000976D000000'
 DC X'004000A4A200000030159B7E000000000020009500000000002000F000000000'
 DC X'00400095A300000000000000000000004015B285400000003015B48500000000'
 DC X'3015B640000000003015B803000000003015BB8500000000E53E509541945885'
 DC X'00000000000000002015BCA30000000000000000000000003015BD8200000000'
 DC X'000000000000000000000000000000002015BEF00000000000600084A2000000'
 DC X'00600086859900003015BF01000000002015C0F0000000000000000000000000'
 DC X'0020000300000000002000850000000000000000000000000000000000000000'
 DC X'2015B5400000000000000000000000002015B700000000000000000000000000'
 DC X'4815B9D1DF0000000000000000000000002000A8000000000020004000000000'
 DC X'0000000000000000004000859900000000000000000000000020000000000000'
 DC X'00000000000000002015C39900000000002000E2000000000000000000000000'
 DC X'2015C81000000000000000000000000000000000000000000040007040000000'
 DC X'00000000000000002015CC0000000000004000F84B0000000000000000000000'
 DC X'00000000000000003015DA40000000004815DCF0500000003015DE1000000000'
 DC X'2015E000000000003015E1A00000000070E0A2D2615095050000000000000000'
 DC X'000000000000000000000000000000000000000000000000002000F000000000'
 DC X'002000EF00000000002000F0000000002015DB00000000000000000000000000'
 DC X'0000000000000000004000D0880000003015DFD000000000002000B000000000'
 DC X'000000000000000000200041000000003015E640000000000000000000000000'
 DC X'000000000000000000000000000000003015E700000000003015E83800000000'
 DC X'00800040400001002015F120000000003015F240000000000080000000000000'
 DC X'000000000000000000000000000000002000D018000000000000000000000000'
 DC X'000000000000000000000000000000003015F300000000003015F43800000000'
 DC X'0040004040000000000000000000000000400040000000000000000000000000'
 DC X'501608004100000030160E7000000000000000000000000030160F4000000000'
 DC X'3016154000000000AE084741F030D4D2201616F0000000003016177000000000'
 DC X'201618F000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000000000000000000000004000ECD00000000000000000000000'
 DC X'74160A0004010000000000000000000020160D00000000000000000000000000'
 DC X'0020005A000000000000000000000000002000D1000000003016100000000000'
 DC X'3016113800000000301612400000000030161340000000002016140000000000'
 DC X'0000000000000000004000D08800000000000000000000000020003400000000'
 DC X'0000000000000000004000FFFF00000000800040003840000000000000000000'
 DC X'0040000200000000000000000000000030162740000000000000000000000000'
 DC X'30162A100000000030162B800000000030162C70000000003C00D2F050000000'
 DC X'00600003D0B8000020162DF00000000000000000000000003016280000000000'
 DC X'30162938000000000020004000000000004000D2A8000000002000C600000000'
 DC X'002000D000000000000000000000000000400040000000003016304000000000'
 DC X'3016310000000000301632380000000030163340000000000080004000015800'
 DC X'58163DD0F000000048164080F000000030164240000000003016481000000000'
 DC X'000000000000000036000005480000000000000000000000002000EF00000000'
 DC X'0020009000000000008000D00458E00030163F34000000000020005800000000'
 DC X'0000000000000000004000345800000030164300000000003016443800000000'
 DC X'3016454000000000301646400000000020164700000000000000000000000000'
 DC X'002000D20000000030164C400000000000000000000000000000000000000000'
 DC X'30164D000000000030164E380000000000600040400000000000000000000000'
 DC X'0000000000000000000000000000000000200080000000003016564000000000'
 DC X'0000000000000000000000000000000030165700000000003016583800000000'
 DC X'0080004040000100B7166640D06050F030166D5000000000301670D000000000'
 DC X'0000000000000000201672D10000000072604FAF6FEF1F830000000000000000'
 DC X'0000000000000000004000D09C00000000000000000000000000000000000000'
 DC X'0020009000000000002000F80000000030166B00000000000000000000000000'
 DC X'00400000470000000040000047000000002000000000000020166C4700000000'
 DC X'000000000000000030166E000000000020166F47000000000000000000000000'
 DC X'30167194000000000040004780000000000000000000000030167F4000000000'
 DC X'3016870000000000301689470000000030168C070000000058168F75F0000000'
 DC X'69C0D25041050DF0201691030000000000000000000000000000000000000000'
 DC X'006000EFD20700000020000000000000002000F0000000003016800000000000'
 DC X'3016813800000000301682400000000030168340000000003016840000000000'
 DC X'4016850102000000000000000000000000000000000000002016880000000000'
 DC X'000000000000000030168A200000000020168BF0000000000000000000000000'
 DC X'30168DFF0000000020168E900000000000000000000000000020007000000000'
 DC X'002000370000000000000000000000004816A4C5E30000004816A6E3C7000000'
 DC X'2016A8C30000000000000000000000000000000000000000CE58F4D7D4F0C3B8'
 DC X'3016A941000000002016AA6D000000003016ABC5000000000000000000000000'
 DC X'000000000000000000600058D0D000000000000000000000004000C508000000'
 DC X'004000C2D5000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000004000C1C20000000000000000000000004000C5E3000000'
 DC X'0000000000000000002000400000000000000000000000002016AC4000000000'
 DC X'00000000000000003016B540000000003016B840000000000000000000000000'
 DC X'004000C54000000000200000000000002C00AEF0000000000020009100000000'
 DC X'002000F5000000003016B600000000003016B738000000000080004040000100'
 DC X'5816B940C3000000006000404040000000200096000000005016CA5850000000'
 DC X'3016CEC5000000003016D1D40000000000000000000000003016D3C500000000'
 DC X'930096F05D61C1400000000000000000000000000000000000600040C3960000'
 DC X'004000F3F7000000000000000000000000000000000000000000000000000000'
 DC X'000000000000000000000000000000003016CC60000000000000000000000000'
 DC X'3016CD600000000000200000000000005816CFE200000000006000E3C1D90000'
 DC X'00400000000000002016D2D7000000000000000000000000004000C1D9000000'
 DC X'3016E240000000002016F610000000003016F7C2000000002016F8E300000000'
 DC X'2016F900000000008FE058C9F061D2473016FA75000000002016FBE300000000'
 DC X'2016FCF000000000006000C3A883000000400003D1000000004000F032000000'
 DC X'00400000D400000000000000000000005816E340000000003016E54000000000'
 DC X'3016F538000000003016E640000000003016E740000000005816E80040000000'
 DC X'3016EA30000000003016EE40000000003016EB40000000003016EC4000000000'
 DC X'2016ED000000000000000000000000003016EF40000000003016F04000000000'
 DC X'3016F140000000003016F240000000003016F340000000003016F44000000000'
 DC X'008000404040400000600040400000000000000000000000004000E4C7000000'
 DC X'0000000000000000000000000000000000400070000000000000000000000000'
 DC X'0000000000000000BE170FC4E3C7E2C530171BE500000000581723C4E3000000'
 DC X'581729E2000000000000000000000000CFE9E3D9C4C1E74D20172DC500000000'
 DC X'30172E6D0000000050172F6D400000003017314000000000301732C300000000'
 DC X'301733D700000000006000E4C76D0000000000000000000000400040E3000000'
 DC X'00000000000000000000000000000000004000E2020000003017144000000000'
 DC X'30171AC100000000006000F0F0F80000004000C6E40000000000000000000000'
 DC X'3017154000000000301716400000000030171740000000003017184000000000'
 DC X'30171940000000000080000030404000004000D9E300000096171CD9E2D7E300'
 DC X'301720C3000000000000000000000000481721F0F1000000002000F100000000'
 DC X'002000D4000000000000000000000000002000D2000000003017254000000000'
 DC X'00400040E3000000301726400000000030172740000000003017284000000000'
 DC X'008000404040400058172BE3C70000000040000001000000006000C1D9E30000'
 DC X'006000F0F0F800000000000000000000002000A600000000006000D6D56D0000'
 DC X'00000000000000000040006040000000004000C500000000004000D6E2000000'
 DC X'30173B4000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000001000470000000000000000000000000030173C0000000000'
 DC X'30173D380000000030173E400000000030173F40000000003017400000000000'
 DC X'2017410100000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000002000000000000000200000000000003017524000000000'
 DC X'301758000000000050175A70F000000020175C030000000030175D3000000000'
 DC X'5D004155F0C5500020175E200000000000600000C00C00000000000000000000'
 DC X'30175FC300000000000000000000000030175300000000003017543800000000'
 DC X'3017554000000000301756400000000020175700000000000000000000000000'
 DC X'2017590000000000000000000000000000400030F40000000000000000000000'
 DC X'00000000000000000020003E000000000000000000000000002000D200000000'
 DC X'30176BC500000000000000000000000030176CC50000000030176EC700000000'
 DC X'30176FD4000000005300D4C7F0D6C30000000000000000000000000000000000'
 DC X'004000F0F1000000004000D5400000000000000000000000002000D400000000'
 DC X'20176DC400000000000000000000000000400040D40000002017704000000000'
 DC X'0000000000000000301772400000000030177300000000003017743800000000'
 DC X'3017754000000000301776400000000030177700000000002017780100000000'
 DC X'0000000000000000000000000000000020178170000000002017820300000000'
 DC X'000000000000000000400000070000002C00CDF000000000004000CECF000000'
 DC X'004000F0F1000000000000000000000000000000000000003017864000000000'
 DC X'004000864700000000400009FF00000030178700000000003017883800000000'
 DC X'0080004040000100BC17BE58D241911B7C17D75898470000BD17E358504741D2'
 DC X'C417ED4758415018BD17F64158D25089FFFF9894A4B0A0B8C517FD501B581847'
 DC X'D018055841471850AA180D584750D2419E181341475850009E181958D2504100'
 DC X'88182058D241500070182504505800009E18294158D2500078182F41D2500000'
 DC X'301833050000000058183B41D000000040183ED25000000048184058D2000000'
 DC X'3018420000000000FECB5804E8C440E0401845F050000000581847581B000000'
 DC X'7C184A58D2D70000000000000000000030184E40000000003018554100000000'
 DC X'0000000000000000000000000000000030185604000000000000000000000000'
 DC X'58185741D0000000301859900000000020185A700000000030185B4100000000'
 DC X'F0C0E4C8F0F44124000000000000000000000000000000000000000000000000'
 DC X'000000000000000048185C103000000030185E47000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000002400D40D00000000'
 DC X'00000000000000000020000000000000BF17C350706020903017D20300000000'
 DC X'2017D64000000000000000000000000000000000000000003017C85000000000'
 DC X'3017CD70000000004817D0605000000000200020000000000020009000000000'
 DC X'5817C900040000003017CB58000000003017CCD2000000000040005050000000'
 DC X'00200003000000004817CE00040000000000000000000000002000BF00000000'
 DC X'000000000000000000200000000000003017D3D0000000004817D4F0A0000000'
 DC X'0000000000000000006000400058000000000000000000005017DA20E0000000'
 DC X'3017E22600000000004000F0CE0000003017DCD0000000000000000000000000'
 DC X'3017DD4C000000003017DE41000000003017DF00000000003017E02000000000'
 DC X'3017E1A0000000000020005500000000004000D01C0000002017E8F000000000'
 DC X'3017E970000000004817EB807000000000000000000000000020000300000000'
 DC X'00000000000000002017EAD00000000000000000000000000000000000000000'
 DC X'0020003200000000000000000000000000000000000000003017F51000000000'
 DC X'000000000000000000000000000000002C00D2BF0000000000400003F0000000'
 DC X'0020005F00000000004000D1680000002017FB10000000002017FCF000000000'
 DC X'00600003D0AC0000000000000000000000200070000000000000000000000000'
 DC X'000000000000000000000000000000000000000000000000301804F000000000'
 DC X'0000000000000000004000F0380000001800F00000000000004000F0F1000000'
 DC X'002000F00000000030180C700000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000018001B00000000000020008800000000'
 DC X'002000D000000000000000000000000020181280000000000000000000000000'
 DC X'00400003D0000000000000000000000000000000000000002018171000000000'
 DC X'301818F000000000004000F03400000000400000D20000000000000000000000'
 DC X'002000350000000058181DF07000000000400003D000000000400070D0000000'
 DC X'00400010D000000020181F1000000000002000D0000000000000000000000000'
 DC X'0000000000000000201824030000000000000000000000000000000000000000'
 DC X'0000000000000000301828580000000000000000000000000000000000000000'
 DC X'004000E0D000000030182D1000000000006000F034EA000000400003D2000000'
 DC X'002000500000000020182ED200000000000000000000000000600010D4280000'
 DC X'2018320300000000000000000000000000000000000000003018341E00000000'
 DC X'301835070000000030183607000000007C18370016D2000020183A0000000000'
 DC X'004000C9A00000000020000000000000000000000000000020183D1000000000'
 DC X'002000A000000000000000000000000000000000000000000000000000000000'
 DC X'000000000000000000400003D000000040184305000000000000000000000000'
 DC X'000000000000000000000000000000000000000000000000301849E000000000'
 DC X'004000FF58000000006000D00CF0000020184DF00000000000400003D0000000'
 DC X'0020000300000000000000000000000030184F00000000003018503800000000'
 DC X'3018514000000000301852400000000030185300000000003018540100000000'
 DC X'002000990000000000400010D200000000800018D20530000020001000000000'
 DC X'002000EC00000000008000F02048920000000000000000000040000020000000'
 DC X'00000000000000000020000000000000006000F0E004000020188E4700000000'
 DC X'20188F4100000000301890580000000030189258000000000000000000000000'
 DC X'F98068A4046C783C201894180000000000000000000000000000000000000000'
 DC X'2018955800000000201896580000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000301897D2000000000000000000000000F00020281488A02C'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000000000000000000000B0FE7048EC4C647D0000000000000000'
 DC X'000000000000000000000000000000000000000000000000002000D200000000'
 DC X'002000D2000000000020004100000000002000D200000000002000D200000000'
 DC X'0020004100000000002000580000000000000000000000000000000000000000'
 DC X'301891F0000000000020003E0000000020189370000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000020000300000000'
 DC X'DF18B4D0D1D2D3D45818F6005000000000000000000000004818F84158000000'
 DC X'6418FAD120F00000FE0005F0FF2050043018FD30000000003018FFF200000000'
 DC X'3019001000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'7720A4A024347074000000000000000000400041500000000040005070000000'
 DC X'004000477000000000000000000000000000000000000000002000D200000000'
 DC X'CC98C590989CB8B4C118DBA0AC609C0C9618E410084054005818E8082C000000'
 DC X'3018EA0800000000BBDCF0D6D550DA703018EBF0000000000000000000000000'
 DC X'3018EF40000000002018F000000000002018F150000000002018F20000000000'
 DC X'00000000000000002018F300000000003018F460000000002018F50800000000'
 DC X'000000000000000000000000000000003018D830000000003018D93300000000'
 DC X'00000000000000000000000000000000D107E0A894F0DCA00000000000000000'
 DC X'000000000000000000000000000000003018DA38000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'004000387A000000004000D08800000000200036000000000020003700000000'
 DC X'002000F400000000002000B20000000000200068000000000000000000000000'
 DC X'00000000000000000000000000000000000000000000000000400038F4000000'
 DC X'3600F0847000000000000000000000000020003F000000000020007000000000'
 DC X'004000D0A8000000000000000000000000200036000000000020003F00000000'
 DC X'0020003F00000000002000D000000000004000366A0000005018ECF0F1000000'
 DC X'2018EEF100000000000000000000000000000000000000000020003900000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0020004000000000000000000000000000400000000000000020000700000000'
 DC X'0000000000000000004000F03800000000000000000000000000000000000000'
 DC X'00200064000000002018FE580000000000000000000000000060000200000000'
 DC X'004000002000000030191540000000005819254DC400000020192AC300000000'
 DC X'00000000000000000000000000000000E200B0D300D4C0C10000000000000000'
 DC X'000000000000000030192B000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'002000D000000000301916400000000030191740000000003019184000000000'
 DC X'301919400000000030191A400000000030191B00000000007C191C3834300000'
 DC X'30191F4000000000301924400000000000400040400000003019204000000000'
 DC X'3019214000000000301922400000000020192300000000000000000000000000'
 DC X'0080004040400000301927D7000000000040006DD6000000301928D600000000'
 DC X'301929E200000000008000C9E75D400000000000000000000020000000000000'
 DC X'301945400000000000000000000000003019481000000000201949F000000000'
 DC X'30194A5800000000FCB058C5D750002820194B300000000020194CD400000000'
 DC X'0000000000000000000000000000000020194D00000000000000000000000000'
 DC X'006000E24040000020194EC40000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'4300C918F130000000000000000000000000000000000000002000F900000000'
 DC X'0020001800000000581946400000000000400040400000000040003840000000'
 DC X'002000F0000000000000000000000000004000F0360000000000000000000000'
 DC X'00000000000000000000000000000000000000000000000058195C4002000000'
 DC X'301967F0000000002019684000000000301969400000000030196AD400000000'
 DC X'7100C300E26DC540000000000000000000000000000000000000000000000000'
 DC X'006000D4E5E20000000000000000000000000000000000000000000000000000'
 DC X'30195E4000000000004000000000000030195F40000000003019604000000000'
 DC X'3019614000000000301962400000000030196340000000003019644000000000'
 DC X'3019654000000000301966400000000000800040404040000020000000000000'
 DC X'00000000000000000040000200000000006000C540000000481978406D000000'
 DC X'30197A4000000000000000000000000000000000000000000000000000000000'
 DC X'75E0D7D9C3C9E341000000000000000020197D40000000000000000000000000'
 DC X'006000404040000020197E400000000000400000BF000000004000C540000000'
 DC X'0000000000000000004000D4E500000030197B000000000030197C3800000000'
 DC X'004000404000000000000000000000000000000000000000D1198AD0D1D3D251'
 DC X'301992C900000000301994D900000000301995D3000000000000000000000000'
 DC X'50806DF0C5C69900000000000000000000000000000000000000000000000000'
 DC X'00000000000000000020009600000000301991D8000000000000000000000000'
 DC X'0000000000000000000000000000000000400044510000001800700000000000'
 DC X'0040000070000000002000D000000000301993D400000000006000C9E9C50000'
 DC X'004000C1D4000000004000C5C400000030199E40000000002019A50000000000'
 DC X'3019A6F0000000002019A7F0000000002019A87000000000240038D200000000'
 DC X'0000000000000000002000030000000030199F00000000003019A03800000000'
 DC X'3019A140000000003019A240000000003019A300000000002019A40100000000'
 DC X'00000000000000000000000000000000004000344E0000000000000000000000'
 DC X'00000000000000005019B8C5C100000000000000000000003019BAC400000000'
 DC X'2019C2C700000000000000000000000098F885D5C9C7C3D42019C3A200000000'
 DC X'000000000000000000000000000000000000000000000000004000F0F4000000'
 DC X'004000C1E30000000020005000000000002000C300000000002000C300000000'
 DC X'006000404040000000000000000000003019BB40000000003019BC4000000000'
 DC X'3019BD40000000003019BE40000000003019BF40000000003019C04000000000'
 DC X'2019C10000000000000000000000000000000000000000000000000000000000'
 DC X'3019CD80000000003019CE40000000002019CFF00000000000400050C0000000'
 DC X'000000000000000036001CD2F0000000000000000000000000400003D1000000'
 DC X'004000F0F0000000002000B50000000000800000384040000000000000000000'
 DC X'00000000000000003019D540000000000000000000000000004000F0F0000000'
 DC X'00000000000000002019D6000000000000000000000000003019D91000000000'
 DC X'00000000000000002019DA000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000400040000000000000000000000000'
 DC X'7819F400585000005019F90CA00000009619FC10F04E4C00301A014000000000'
 DC X'301A080700000000E5C15047204158D20000000000000000201A0AD000000000'
 DC X'0000000000000000201A0B1000000000301A0C500000000000600003D2A80000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'000000000000000000200066000000000020004700000000002000AA00000000'
 DC X'3019F702000000003019F8F00000000000000000000000000020009400000000'
 DC X'004000F0180000002019FB980000000000000000000000000000000000000000'
 DC X'301A004700000000000000000000000000400058F00000000020005800000000'
 DC X'00800000000C5000301A020000000000301A033800000000301A044000000000'
 DC X'301A054000000000301A060000000000301A070200000000002000C900000000'
 DC X'201A090700000000000000000000000000000000000000000000000000000000'
 DC X'0020003B00000000301A1E40000000007C1A2AC740E20000781A30D9F0C10000'
 DC X'301A33E300000000301A35E700000000B382C1D2A35000010000000000000000'
 DC X'000000000000000000800081A3A4A20000600050D0E00000301A364000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000002000E700000000301A1F4000000000301A204000000000'
 DC X'301A214000000000301A224000000000301A234000000000301A240000000000'
 DC X'301A253000000000301A264000000000301A274000000000301A280000000000'
 DC X'301A290100000000002000C500000000301A2D9600000000301A2F4000000000'
 DC X'004000E4C2000000301A2EA50000000000800085999594000060004040400000'
 DC X'006000D5C3D70000004000F0F00000000000000000000000301A346D00000000'
 DC X'004000C4C50000000040005D40000000002000F000000000301A46E300000000'
 DC X'B51A7800D6D901E3201A89F000000000501A8AD6D4000000301A8DD900000000'
 DC X'9148C5C3D64DE402000000000000000000000000000000000000000000000000'
 DC X'006000D3C55D0000000000000000000000400000000000000000000000000000'
 DC X'00000000000000000040000073000000301A474000000000901A480001020400'
 DC X'DC1A4C0006010215000000000000000000000000000000000000000000000000'
 DC X'301A750000000000301A764000000000301A7788000000000000000000000000'
 DC X'0000000000000000F000050E0322081000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'F0001F2618091C11000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000000000000000000000000000000000000057800733272A5300'
 DC X'0000000000000000002000DC00000000002000E800000000002000AE00000000'
 DC X'002000D800000000006000404000000000200040000000000040004040000000'
 DC X'C01A7D02050007030000000000000000004000C5D50000000000000000000000'
 DC X'002000C100000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000060400A1B0C12010F0000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'002000D0000000000000000000000000201A8CD5000000000000000000000000'
 DC X'0000000000000000581A8EC7E3000000004000C5E300000000400040D9000000'
 DC X'AE1A9AE2D7D9E3C10000000000000000301AA14000000000201AA4D300000000'
 DC X'201AA50000000000420058D0A2D5000000000000000000000000000000000000'
 DC X'004000859900000000000000000000000000000000000000201A9FF100000000'
 DC X'301AA0F800000000004000F1F200000000000000000000000000000000000000'
 DC X'002000D400000000301AA20000000000301AA338000000000040004040000000'
 DC X'00000000000000000000000000000000301AAD40000000000000000000000000'
 DC X'0000000000000000004000F0F300000000000000000000001000C50000000000'
 DC X'00000000000000000040004040000000301AB240000000000000000000000000'
 DC X'00000000000000000000000000000000301AB30000000000301AB43800000000'
 DC X'301AB540000000000080004000014100301AB94000000000301ACFC500000000'
 DC X'0000000000000000701ABA0002010000C01ABD0022041E060000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000000000000000000000C00F123B0B0705230000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000020007000000000'
 DC X'002000C40000000000200018000000000020007A00000000301AD00000000000'
 DC X'0020000000000000301ADB4000000000301AE20000000000201AE5F000000000'
 DC X'201AE6F000000000000000000000000049001AD0D7F000000060007595000000'
 DC X'00000000000000000000000000000000002000F200000000301ADC0000000000'
 DC X'301ADD3800000000301ADE4000000000301ADF4000000000301AE00000000000'
 DC X'201AE101000000000000000000000000581AE30500000000004000B4F0000000'
 DC X'0020000000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000000040000000000000201AEB03000000000000000000000000'
 DC X'301AF50C00000000301AF740000000000000000000000000201AFAEF00000000'
 DC X'00000000000000003E0000D250000000301AFB000000000000400003D1000000'
 DC X'0020000000000000301AF65800000000006000E0F8E60000301AF80000000000'
 DC X'301AF93800000000006000404000000000000000000000000020000000000000'
 DC X'301B014000000000201B05800000000000000000000000000000000000000000'
 DC X'0000000000000000301B020000000000301B033800000000301B044000000000'
 DC X'008000400001D2000000000000000000BA1B1550706040F0301B1FF000000000'
 DC X'301B23F000000000301B25FF0000000000000000000000009BB8BF18F000D292'
 DC X'581B280F5F0000000000000000000000301B2BF000000000301B2C0000000000'
 DC X'201B2E0300000000000000000000000000400000C100000000400003F0000000'
 DC X'004000ADF0000000581B1AD037000000481B1C3FF00000000000000000000000'
 DC X'301B1ED000000000000000000000000000400088410000000020004600000000'
 DC X'000000000000000000600000507000000040008850000000641B20D0D1F00000'
 DC X'00000000000000000000000000000000002000F000000000201B243F00000000'
 DC X'0000000000000000301B264700000000201B2770000000000000000000000000'
 DC X'301B2AF000000000002000D0000000000020000000000000004000F0F0000000'
 DC X'201B2D000000000000000000000000000000000000000000DF1B70F0F1F2F3F4'
 DC X'DF1C82F0F1F7F2F3D81CB0489CB498A07C1CC0E300D90000B11CCA02F7F9F0F8'
 DC X'FFFF00F5F2F7F440601CD20058500000B31CD502F5F4F0F1D01CE002F4F2F0F7'
 DC X'BD1CE902F9F4F3F5A41CF5F1F502F9F2501CFB4000000000AB1D05F602F4F9F2'
 DC X'581D0ABE7E000000201D0C5C00000000301D0D7400000000781D1302F7F60000'
 DC X'881D18F302F5F000201D1D00000000000000000000000000F269313610353320'
 DC X'00000000000000000000000000000000581D1E471E0000000000000000000000'
 DC X'0000000000000000301D214800000000401D2340B00000000000000000000000'
 DC X'481D25F06000000000000000000000000000000000000000301D274700000000'
 DC X'0000000000000000301D287200000000F0D8323908D1D2440000000000000000'
 DC X'000000000000000000000000000000000000000000000000301D29FF00000000'
 DC X'201D2AF0000000000000000000000000201D2B0400000000201D2C6C00000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000E160182770A0565400000000000000000000000000000000'
 DC X'0000000000000000004000440500000000000000000000000040003720000000'
 DC X'004000EF50000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000200010000000000020006200000000'
 DC X'DF1B7FF0F1F2F3F4DF1C1FF0F3F6F1F9D81C45F1F0F7F5F8D81C52F4F5F9F7F8'
 DC X'C01C5CF4F1F0F5F89FE8F9F5F7F6F808C21C64F8F5F7F4F1861C6CF8F0F6F300'
 DC X'AB1C70F3F0F6F1F9901C76F7F4F1F3008A1C7BF9F3F5F600301C7F4D00000000'
 DC X'581C8000E300000000000000000000000060004040400000DF1B8AF0F1F2F3F8'
 DC X'DB1BDBF0F3F1F5F9DC1BECF2F9F8F5F1D21BF9F3F2F1F6F7C21C04F1F3F4F9F0'
 DC X'5F80F7F9F6F5F800A11C0CF4F3F6F2F7A11C11F5F8F2F9F4861C16F4F2F8F600'
 DC X'401C1AF8F1000000601C1CF2F9F80000DD1B95F0F1F2F4F8C41BBFF0F8F9F5F1'
 DC X'B01BCBF2F1F8F3F9641BD1F9F2F30000781BD4F4F9F200005D00F4F5F6F7F900'
 DC X'401BD7F6F3000000201BD9F5000000000000000000000000201BDAF000000000'
 DC X'0000000000000000C01BA0F2F5F8F6F0C11BACF3F5F8F6F9641BB4F9F5F20000'
 DC X'0000000000000000601BB7F0F3F700005E00F3F6F5F9F700401BBAF1F2000000'
 DC X'501BBCF8F2000000301BBEF50000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000004C00F4F7F1F30000301BAAF800000000301BABF900000000'
 DC X'0000000000000000000000000000000000200002000000000020000200000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'00400002E30000002800F0F10000000000400002E30000000000000000000000'
 DC X'00000000000000000000000000000000004000F4020000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'004000F5020000000000000000000000004000F3020000000000000000000000'
 DC X'0000000000000000301BC9F10000000000000000000000000000000000000000'
 DC X'4800F3F6F2F70000301BCAF30000000000000000000000000000000000000000'
 DC X'00000000000000000020000200000000002000F500000000201BD0F200000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'000000000000000000000000000000000000000000000000004000F5F5000000'
 DC X'004000F602000000004000F20200000000000000000000000000000000000000'
 DC X'000000000000000000000000000000000000000000000000201BE6F100000000'
 DC X'201BE7F1000000000000000000000000301BE8F200000000201BEAF600000000'
 DC X'5800F2F8F4F7F600201BEBF50000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'301BE9F900000000004000F1F300000000000000000000000000000000000000'
 DC X'201BF6F600000000201BF7F500000000201BF8F7000000000000000000000000'
 DC X'00000000000000004000F6F4F3F0000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000301C02F20000000000000000000000000000000000000000'
 DC X'301C03F20000000000000000000000003000F4F9F80000000000000000000000'
 DC X'00000000000000000000000000000000002000F000000000002000F300000000'
 DC X'000000000000000000000000000000000000000000000000004000F0F2000000'
 DC X'00000000000000002400F2F5000000000000000000000000002000F300000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'004000F2F3000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000002000F50000000000000000000000000000000000000000'
 DC X'002000F300000000002000F60000000000000000000000000000000000000000'
 DC X'000000000000000000000000000000000000000000000000A21C2AF1F4F6F0F9'
 DC X'901C30F1F5F4F800A31C35F5F8F2F4F6641C3AF2F0F80000201C3DF400000000'
 DC X'5D80F5F4F2F7F800301C3EF500000000581C40F6F90000000000000000000000'
 DC X'301C43F100000000201C44F00000000000000000000000000000000000000000'
 DC X'0000000000000000301C2FF6000000000000000000000000002000F300000000'
 DC X'301C34F000000000000000000000000000000000000000000000000000000000'
 DC X'002000F100000000000000000000000000000000000000000000000000000000'
 DC X'002000F400000000002000F80000000000000000000000000000000000000000'
 DC X'002000F2000000000000000000000000301C3FF300000000002000F200000000'
 DC X'201C42F200000000002000F2000000000000000000000000004000F1F1000000'
 DC X'0000000000000000201C4FF000000000301C50F4000000000000000000000000'
 DC X'000000000000000000000000000000004800F9F2F3F60000301C51F000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'002000F3000000000020000200000000301C5AF300000000201C5BF000000000'
 DC X'0000000000000000000000000000000000000000000000002400F6F300000000'
 DC X'0000000000000000004000F8F3000000002000F4000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000002C00F3F700000000002000F700000000002000F000000000'
 DC X'000000000000000000000000000000000000000000000000004000F5F7000000'
 DC X'00000000000000002C00F9F20000000000400002E3000000004000F602000000'
 DC X'00000000000000000000000000000000004000F1F5000000002000F100000000'
 DC X'0000000000000000201C75F8000000000000000000000000002000F300000000'
 DC X'002000F6000000000000000000000000201C7AF2000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'004000F0F10000000000000000000000002000F500000000008000E0F0104700'
 DC X'0060000000400000004000E7E3000000A31C8FF3F1F7F6F9741C94F6F8F10000'
 DC X'841C98F4F3F0F7006C1C9CF5F7F10000581C9FF7F30000007FE0F6F5F8F9F402'
 DC X'201CA2F100000000501CA3F8F20000006C1CA6F8F6F50000581CA9F6F1000000'
 DC X'6C1CABF0F7F80000581CAEE300000000002000F1000000000000000000000000'
 DC X'00000000000000000000000000000000002000F100000000002000F100000000'
 DC X'201C97F4000000000000000000000000004000F0020000000000000000000000'
 DC X'00000000000000000000000000000000004000F5F10000000000000000000000'
 DC X'000000000000000000400002E3000000002000F900000000201CA1F100000000'
 DC X'002000F40000000000000000000000000000000000000000201CA5F900000000'
 DC X'000000000000000000000000000000000000000000000000004000F3F0000000'
 DC X'002000F700000000004000F1F5000000002000F7000000000000000000000000'
 DC X'004000F2F9000000002000F600000000008000E7E34000000020000000000000'
 DC X'301CB89000000000301CBF470000000000000000000000000000000000000000'
 DC X'00000000000000002C00A4900000000000400041700000000020004100000000'
 DC X'301CB9F000000000301CBA2000000000301CBB4800000000301CBC9200000000'
 DC X'301CBD1000000000301CBE20000000000080000050D02000002000F000000000'
 DC X'301CC3E7000000000060000000400000004000D3C4000000301CC4E300000000'
 DC X'301CC54000000000301CC60000000000641CC705000800000000000000000000'
 DC X'0000000000000000002000B200000000581CCFE3000000000000000000000000'
 DC X'00000000000000000000000000000000004000F502000000301CD1E700000000'
 DC X'0080000000404000008000E34000020000000000000000000000000000000000'
 DC X'0000000000000000581CDAE30000000000000000000000000000000000000000'
 DC X'004000F802000000002000F400000000301CDCE7000000000040000000000000'
 DC X'301CDDE300000000301CDE4000000000201CDF00000000000000000000000000'
 DC X'581CE700E3000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000001000F8000000000000000000000000000080000000404000'
 DC X'004000E7E3000000301CEEE300000000301CF30200000000201CF40200000000'
 DC X'000000000000000000400002E3000000301CEFE700000000301CF0E300000000'
 DC X'301CF14000000000201CF200000000000000000000000000002000E300000000'
 DC X'000000000000000000000000000000000000000000000000301CFAE300000000'
 DC X'00000000000000000000000000000000004000E7E3000000581CFD0040000000'
 DC X'0000000000000000301CFF3800000000301D044000000000301D004000000000'
 DC X'301D014000000000301D020000000000301D0302000000000020005000000000'
 DC X'00200040000000000000000000000000004000E3E70000000000000000000000'
 DC X'00400002E3000000002000F20000000000400005EF0000000020000500000000'
 DC X'0000000000000000301D0E0700000000301D0FFF00000000301D109000000000'
 DC X'581D11E9E8000000006000D00C580000004000D00C000000301D16E300000000'
 DC X'201D17C9000000000000000000000000008000E7E34000000000000000000000'
 DC X'0000000000000000301D1C000000000000000000000000000000000000000000'
 DC X'00200000000000000000000000000000201D2000000000000040000255000000'
 DC X'0000000000000000301D22920000000000400010200000000000000000000000'
 DC X'00000000000000000000000000000000004000D0880000000040007031000000'
 DC X'00400047F0000000006000100020000000000000000000000000000000000000'
 DC X'00000000000000007C1D3DE3C5000000921D4AF0F3F70200D01D5002F5F8F6F0'
 DC X'D81D5D02F7F9F8F3AD1D67F6F802F0F2AFF8F7F2F6F9F3F4DD1D6E02F9F4F7F6'
 DC X'741D7702F0F40000D21D7B02F5F140F8581D82F902000000701D8702F7F90000'
 DC X'581D8BF5020000006C1D8EF0D9400000201D91F000000000004000F0F2000000'
 DC X'0000000000000000301D40E700000000301D49E2000000000040000000000000'
 DC X'301D41E300000000301D424000000000501D430001000000821D450025040800'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'002000D000000000002000C400000000581D4E02F90000000000000000000000'
 DC X'0000000000000000006000E3E7E30000004000E3E7000000004000F5F2000000'
 DC X'301D58E300000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000002C00F1F200000000002000F000000000002000F500000000'
 DC X'301D59E700000000301D5AE300000000301D5B4000000000201D5C0000000000'
 DC X'0000000000000000301D65E300000000301D6602000000000000000000000000'
 DC X'000000000000000000000000000000002000F5F0000000000000000000000000'
 DC X'0000000000000000008000E7E3400000004000E3E70000000000000000000000'
 DC X'301D6C0200000000301D6DE3000000000000000000000000002000F000000000'
 DC X'004000E3E7000000004000E7E3000000301D75E300000000301D76F600000000'
 DC X'004000F5020000000000000000000000002000F4000000001800F30000000000'
 DC X'002000F500000000008000E7E3400400002000F200000000301D7AE300000000'
 DC X'00000000000000000020000200000000008000E7E3400000004000E3E7000000'
 DC X'00000000000000000000000000000000004000E5F10000000000000000000000'
 DC X'1800F3000000000000400002E30000007C1D84F6F4F50000006000E3E7E30000'
 DC X'00400040400000000040006B400000000020004000000000301D8AE300000000'
 DC X'00000000000000000000000000000000008000E7E3400000301D8D0200000000'
 DC X'006000E3E7E30000002000E3000000000000000000000000004000F240000000'
 DC X'00400040400000000000000000000000301DA3E300000000B41DACF0F602F4F1'
 DC X'961DB202F3F94000961DB702F5F4F800741DBC02F4F20000BFCCF5F1F2F3F4F8'
 DC X'501DC102F2000000401DC3F602000000301DC5F000000000581DC6027E000000'
 DC X'301DC9F900000000301DCA020000000000000000000000000000000000000000'
 DC X'004000A215000000004000001B0000000000000000000000301DA4E700000000'
 DC X'301DA5E300000000301DA64000000000301DA700000000008E1DA80830002200'
 DC X'00000000000000000040002E400000000040009A40000000002000DE00000000'
 DC X'301DB1F0000000000000000000000000006000E3E7E300000000000000000000'
 DC X'0000000000000000002000F200000000301DB6E3000000000000000000000000'
 DC X'002000F100000000002000F100000000006000E7E3400000301DBBE300000000'
 DC X'000000000000000000600002E3E700000020000200000000008000E7E3400000'
 DC X'301DBFE3000000000000000000000000004000F902000000301DC0E700000000'
 DC X'008000E340008F00006000E3E7E3000000000000000000000000000000000000'
 DC X'00000000000000000020000200000000301DC8E300000000004000F1F9000000'
 DC X'008000E7E3400000002000F400000000006000E3E7E300009E1DD8E3C500D900'
 DC X'941DEC02F9F0F800581DF502F9000000581DFC02F5000000501E0102F3000000'
 DC X'7FE0F3F6F0F4F2F8581E0802F0000000681E0FF6F5020000641E12F302F70000'
 DC X'301E15F600000000501E1602F2000000301E1802000000000040007A40000000'
 DC X'301DDCE700000000301DE9E2000000000040000000000000004000D3C4000000'
 DC X'301DDDE300000000301DDE4000000000301DDF0000000000C01DE0060124190D'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'00000000000000003A000A000400000000400054400000000000000000000000'
 DC X'0020006800000000301DEAC400000000301DEB40000000000080004040404000'
 DC X'301DF0E300000000000000000000000000600040404000000000000000000000'
 DC X'301DF1E700000000301DF2E300000000301DF34000000000201DF40000000000'
 DC X'0000000000000000301DF7E30000000000400002D9000000301DF8E700000000'
 DC X'301DF9E300000000301DFA4000000000201DFB00000000000000000000000000'
 DC X'581DFEE3C5000000002000F000000000301E00E700000000002000D500000000'
 DC X'008000E340000B00301E03E3000000000000000000000000301E04E700000000'
 DC X'301E05E300000000301E064000000000201E0700000000000000000000000000'
 DC X'301E0AE30000000000400079E1000000301E0BE700000000301E0CE300000000'
 DC X'301E0D4000000000201E0E000000000000000000000000000000000000000000'
 DC X'00400002E3000000000000000000000000000000000000000000000000000000'
 DC X'002000F400000000002000F800000000006000E3E7E300000000000000000000'
 DC X'301E19C500000000002000E2000000007C1E31E3D9C50000741E3E02F8F50000'
 DC X'861E42F702F6F2009E1E4602F5F1F300741E4B02F2F70000FFEDF3F258F640F4'
 DC X'781E4E02F7F40000581E5102F2000000201E5450000000007C1E5502F7F00000'
 DC X'301E584000000000301E5C0200000000301E5E02000000000000000000000000'
 DC X'481E5FF1F0000000201E6103000000000000000000000000006000EF50F00000'
 DC X'004000F0F400000000400040E40000002400501B000000000000000000000000'
 DC X'0020001F00000000301E34E700000000301E3AD300000000581E3CE2D5000000'
 DC X'301E35E300000000301E364000000000501E370001000000201E391000000000'
 DC X'00000000000000000000000000000000301E3BC4000000000080004040404000'
 DC X'004000C440000000002000C400000000301E41E3000000000000000000000000'
 DC X'002000F700000000008000E7E340000000000000000000000000000000000000'
 DC X'00400002E3000000004000F1F4000000301E4AE30000000000400002E3000000'
 DC X'004000F902000000002000F400000000006000E7E3400000008000E3E7E34000'
 DC X'0000000000000000002000F200000000008000E3E7E34000004000F9F9000000'
 DC X'0000000000000000301E53E3000000000020000200000000008000E7E3400000'
 DC X'0000000000000000008000E3E7E3400000600002E3E700000020000200000000'
 DC X'301E590000000000301E5A3800000000301E5B4000000000008000400001D100'
 DC X'301E5DE300000000008000E7E3400000006000E3E7E300000000000000000000'
 DC X'002000F2000000000000000000000000581E72E3C5000000581E7EF802000000'
 DC X'701E8602F5F30000781E8A02F1F00000301E920200000000AFFCF8F1F2F0F9F4'
 DC X'701E9402F2F10000581E9802F6000000581E9FF102000000501EA102F5000000'
 DC X'501EA302F4000000481EA6F702000000301EA8F000000000301EAD4000000000'
 DC X'004000F7610000000020000000000000301E74E700000000004000D5C4000000'
 DC X'301E75E300000000301E764000000000501E770001000000A31E79013B041102'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'00400038400000000020001A00000000581E80F802000000301E85E300000000'
 DC X'301E82F200000000006000E3E7E30000301E83F100000000301E84F600000000'
 DC X'008000404040F100008000E7E3400000301E89E3000000000000000000000000'
 DC X'0000000000000000008000E7E3400000301E8DE300000000004000F702000000'
 DC X'0000000000000000301E8EE700000000301E8FE300000000301E904000000000'
 DC X'201E9100000000000000000000000000301E93E300000000006000E7E3400000'
 DC X'301E97E30000000000000000000000000000000000000000008000E7E3400000'
 DC X'301E9AE300000000002000F800000000301E9BE700000000301E9CE300000000'
 DC X'301E9D4000000000201E9E0000000000000000000000000000400002E3000000'
 DC X'002000E300000000008000E3E7E340000000000000000000301EA5E300000000'
 DC X'0000000000000000004000E7E30000000000000000000000004000E3E7000000'
 DC X'301EA9F000000000301EAA0800000000301EAB4D00000000301EACE000000000'
 DC X'008000F0104700000040004040000000581EBEE3C5000000701EC702F1F90000'
 DC X'801ECF02F4F7F000741ED302F5F80000301ED7F800000000AFECF7F9F3F240F4'
 DC X'7C1ED902F7F10000301EE00200000000301EE60200000000501EE802F0000000'
 DC X'301EEB4000000000581EF2F5F3000000301EF4F8000000000000000000000000'
 DC X'00400003D1000000004000EF58000000301EC0E700000000006000D5C4400000'
 DC X'301EC1E300000000301EC24000000000301EC300000000006C1EC402170F0000'
 DC X'00000000000000000020000400000000002000B200000000301ECAE300000000'
 DC X'00000000000000000000000000000000301ECBE700000000301ECCE300000000'
 DC X'301ECD4000000000201ECE000000000000000000000000000000000000000000'
 DC X'000000000000000000000000000000000000000000000000301ED6E300000000'
 DC X'0000000000000000002000F900000000008000E7E3400000301ED8F200000000'
 DC X'008000F1F640E500301EDCE300000000004000F202000000002000F300000000'
 DC X'301EDDE700000000301EDEE300000000201EDF40000000000000000000000000'
 DC X'301EE1E300000000301EE2E700000000301EE3E300000000301EE44000000000'
 DC X'201EE500000000000000000000000000301EE7E300000000008000E7E3400000'
 DC X'301EEAE3000000000000000000000000008000E7E3400000301EEC0000000000'
 DC X'301EED3800000000301EEE4000000000301EEF4000000000301EF00000000000'
 DC X'201EF10100000000000000000000000000800060F0F0F100002000F700000000'
 DC X'002000F900000000781F03E3D9C50000781F1002F5F10000741F140240F00000'
 DC X'501F1902F3000000581F1C02F70000008FE0F9F2F3F5F4F8741F1F02F2F80000'
 DC X'301F220200000000481F2302F3000000301F250200000000581F2602F1000000'
 DC X'301F280200000000301F2940000000000000000000000000301F06E700000000'
 DC X'301F0FD3000000000000000000000000301F07E300000000301F084000000000'
 DC X'501F090001000000801F0B061900040000000000000000000000000000000000'
 DC X'000000000000000000000000000000000000000000000000008000C440404000'
 DC X'008000E3E7E34000301F1302000000000000000000000000002000E300000000'
 DC X'301F17E30000000000000000000000000020000200000000301F18E700000000'
 DC X'008000E340001100301F1BE3000000000000000000000000008000E7E3400000'
 DC X'301F1EE300000000002000F200000000006000E7E3400000008000E3E7E34000'
 DC X'0000000000000000002000F100000000002000E3000000000000000000000000'
 DC X'00400002E3000000006000E3E7E30000008000E3E7E340000020000200000000'
 DC X'002000E30000000000200040000000007C1F44E3C5D90000741F4E02F8F00000'
 DC X'961F5602F8F7F600961F5A02F5F2F7008E1F63F502F4F200FFF2F2F1F6F3F0F5'
 DC X'781F6802F1F20000301F6C0200000000501F7202F0000000581F7402F4000000'
 DC X'781F7802F9F80000501F7B02F1000000301F7D0000000000201F7F4000000000'
 DC X'00000000000000000000000000000000201F80F0000000000000000000000000'
 DC X'004000EF44000000004000F8A70000005D80C59618D2A70000400040C6000000'
 DC X'0040008050000000000000000000000000200003000000000020001500000000'
 DC X'301F47E700000000004000D5C4000000004000D3C4000000301F48E300000000'
 DC X'301F494000000000301F4A0000000000641F4B04051600000000000000000000'
 DC X'0000000000000000002000F400000000301F51E3000000000000000000000000'
 DC X'0020000200000000301F52E700000000301F53E300000000301F544000000000'
 DC X'201F5500000000000000000000000000008000E3E7E340000000000000000000'
 DC X'00400002E30000000020000200000000301F5EE3000000000000000000000000'
 DC X'00400002E3000000004000F102000000301F5FE700000000301F60E300000000'
 DC X'301F614000000000201F62000000000000000000000000000000000000000000'
 DC X'301F67E30000000000600002E3E70000004000F1F6000000002000E700000000'
 DC X'301F6BE30000000000400002D90000000000000000000000008000E7E3400000'
 DC X'301F6DE300000000301F6EE700000000301F6FE300000000301F704000000000'
 DC X'201F7100000000000000000000000000008000E3E7E340000000000000000000'
 DC X'301F76E3000000000020000200000000301F77E700000000008000E340000000'
 DC X'006000E3E7E3000000400002E30000000000000000000000006000E3E7E30000'
 DC X'0000000000000000301F7E000000000000200000000000000000000000000000'
 DC X'0000000000000000781F8EE3D9C50000941F9802F6F4F500301FA00200000000'
 DC X'7C1FA602F5F80000BB1FABF002F2F6F57FE0F7F4F8F1F0F2741FB102F6F30000'
 DC X'701FB5F8F0020000301FB90200000000581FBB02F0000000301FBF0200000000'
 DC X'581FC002F20000000020000200000000301F91E700000000006000D3C4400000'
 DC X'0000000000000000301F92E300000000301F934000000000301F940000000000'
 DC X'641F95005015000000000000000000000000000000000000002000E800000000'
 DC X'301F9CE30000000000000000000000000040006B400000000000000000000000'
 DC X'301F9DE700000000301F9EE300000000201F9F40000000000000000000000000'
 DC X'301FA1E300000000301FA2E700000000301FA3E300000000301FA44000000000'
 DC X'201FA500000000000000000000000000301FA9E300000000201FAA0200000000'
 DC X'004000F502000000006000E7E34000000000000000000000301FB00200000000'
 DC X'006000E3E7E3000000000000000000000020000200000000002000F600000000'
 DC X'002000C500000000301FB4E3000000000000000000000000002000F800000000'
 DC X'008000E7E3400000301FB8020000000000000000000000000000000000000000'
 DC X'002000E300000000301FBAE300000000008000E7E3400000301FBDE300000000'
 DC X'0020000200000000301FBEE700000000008000E340003700004000E3E7000000'
 DC X'004000E3E7000000002000F60000000000000000000000000060000000000000'
 DC X'301FCD400000000000000000000000000000000000000000201FCF1000000000'
 DC X'00000000000000003E000D18D2000000004000001C0000000040004040000000'
 DC X'00400003D2000000301FCE000000000000600038404000000000000000000000'
 DC X'301FD740000000000000000000000000201FDAFF000000000000000000000000'
 DC X'00000000000000001800900000000000201FDBEC00000000301FD80000000000'
 DC X'301FD93800000000006000404000000000000000000000000000000000000000'
 DC X'961FE9FFFCFE0000301FF60000000000301FFA0000000000401FFC8070000000'
 DC X'301FFEF00000000072A058FE0690430400000000000000000000000000000000'
 DC X'006000F047D00000000000000000000000400085000000000000000000000000'
 DC X'002000A000000000581FEDFF0000000000000000000000000040000001000000'
 DC X'0020000000000000581FEFFF00000000301FF30000000000301FF1FF00000000'
 DC X'0080000000000000301FF2FF00000000004000FFFF000000301FF40000000000'
 DC X'301FF503000000000020001C00000000301FF72000000000301FF80000000000'
 DC X'301FF94700000000006000803AAE0000201FFB00000000000000000000000000'
 PRINT ON
 DC X'00000000000000000000000000000000201FFFF0000000000000000000000000'
CDICTSIZ EQU   *-CMPDICT          Compression dictionary size
                                                                EJECT
***********************************************************************
*                     Expansion dictionary
***********************************************************************
                                                                SPACE
         ORG   CMPSC+EDICTADR     Expansion dictionary
                                                                SPACE
EXPDICT  EQU   *                  Expansion dictionary
 DC X'23700400D3E9C4C800000000004000000002000000010000FFFF000000001EDB'
 DC X'00002000000000200000000000005300000052004654FD380000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 PRINT OFF
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0000000000000000000000000000000000000000000000000000000000000000'
 DC X'0200000000000000020001000000000002003800000000000200580000000000'
 DC X'02004000000000000508D2D0C1040C1802004700000000000200020000000000'
 DC X'02005000000000000200F0000000000002004100000000000200030000000000'
 DC X'020005000000000002000800000000000200D200000000000200D00000000000'
 DC X'0200C10000000000020004000000000002000C00000000000200180000000000'
 DC X'601B06C0090A2407020010000000000002001200000000000200200000000000'
 DC X'02000B00000000000200D1000000000002008000000000000200600000000000'
 DC X'02001B000000000002000600000000000200C000000000000200090000000000'
 DC X'02000A0000000000020024000000000002000700000000001315D3D41C1A1F19'
 DC X'02000E00000000000200700000000000020014000000000002000D0000000000'
 DC X'0200170000000000020030000000000002001300000000000200150000000000'
 DC X'0200D300000000000200D4000000000002001C000000000002001A0000000000'
 DC X'02001F0000000000020019000000000043BF4425162635DD0200C50000000000'
 DC X'0200270000000000020034000000000002000F00000000000200C90000000000'
 DC X'0200FF000000000002004300000000000200BF00000000000200440000000000'
 DC X'0200250000000000020016000000000002002600000000000200350000000000'
 DC X'0200DD0000000000B0E0112D4C1E832C020021000000000002001D0000000000'
 DC X'02003B000000000002009000000000000200D700000000000200220000000000'
 DC X'0200B000000000000200E00000000000020011000000000002002D0000000000'
 DC X'02004C000000000002001E0000000000020083000000000002002C0000000000'
 DC X'5923922E996CC34202008400000000000200A200000000000200960000000000'
 DC X'020049000000000002009500000000000200A000000000000200590000000000'
 DC X'0200230000000000020092000000000002002E00000000000200990000000000'
 DC X'02006C00000000000200C3000000000002004200000000003FA8735B77A4E23A'
 DC X'0200820000000000020046000000000002002B00000000000200540000000000'
 DC X'0200370000000000020091000000000004003F84D20000000200A80000000000'
 DC X'020073000000000002005B000000000002007700000000000200A40000000000'
 DC X'0200E2000000000002003A0000000000D5743900000000000200890000000000'
 DC X'0200550000000000020048000000000002006700000000000200320000000000'
 DC X'03007184000000000300D5040000000003007418000000000300399E00000000'
 DC X'0300000000000000030000010000000003000003000000000300004000000000'
 DC X'030000040000000005D27306071041210300005000000000030000F000000000'
 DC X'0300000C00000000030000080000000003000058000000000300000200000000'
 DC X'0300000500000000030000D20000000003000073000000000300000600000000'
 DC X'0300000700000000030000100000000003000041000000000300002100000000'
 DC X'181209C7D02322A7070000999800000103000013000000000700007578000006'
 DC X'0300000B00000000030000250000000003000024000000000300001800000000'
 DC X'03000012000000000300000900000000070000C7D8000000030000D000000000'
 DC X'03000023000000000300002200000000060000A75800000017783DE536549C1E'
 DC X'06000086200000000600008000000100030000FF00000000050000A0000A0000'
 DC X'03000020000000000500001A9000000003000017000000000500007840000000'
 DC X'0500003D78000000050000E5E800000005000036D00000000300005400000000'
 DC X'0300009C000000000300001E0000000019C53900000000000300001400000000'
 DC X'05000047F0F000000300002C000000000500004480010000030000C900000000'
 DC X'0400000A5400000004000019B8000000040000C5E400000004000039F8000000'
 DC X'0400000000000000040000004000000004000000010000000400000004000000'
 DC X'04000000F00000000C051F06D29880B804000000580000000400000010000000'
 DC X'04000000080000000400000002000000040000000700000004000000A8000000'
 DC X'040000000C0000000400000005000000040000001F0000000400000006000000'
 DC X'04000000D20000000400000098000000070000008000000006000000B8001D00'
 DC X'FF0000000000000006000000A0001400060000005000D1000400000003000000'
 DC X'04000000170000000500000019280000050000002000000005000000FFFF0000'
 DC X'0500000000000000050000000001000005000000000700000500000000400000'
 DC X'0500000000F00000000000000000000005000000000200000500000000060000'
 DC X'0500000000080000050000000004000005000000000500000600000000000000'
 DC X'0600000000000100060000000000020006000000000008000600000000000C00'
 DC X'0000000000000000060000000000060007000000000000000700000000000001'
 DC X'0700000000000002070000000000000C07000000000000040000000000000000'
 DC X'A1D000F0F0F0F7050700000000000010A178000000000003A178000000000203'
 DC X'A178000000000C03A178000000000803A1B4000000072104A1B4000000000004'
 DC X'A1B400000000F004A1B4000000000C04A1D0000000000005A1D000000000F005'
 DC X'A1D0000000000105A1DB000000000006A1DB00000000F006A1E2000000000007'
 DC X'A1F200F0F0F0F00AA1EA000000000008A1F200000100F00AA1EF000000000009'
 DC X'A1F200000000000AA1F500000000000BA1F700000000000CA1FB0000F0F0F00E'
 DC X'A1F900000000000DA1F900000000020DA1FB00000000000EA1FB00000000020E'
 DC X'A1FC00000000000FA1FD000000000010A1FE000000000011A200000000000012'
 DC X'A202000000000013A204000000000014A205000000000015A206000000000016'
 DC X'A207000000000017A208000000000018A209000000000019A20A00000000001A'
 DC X'A20B00000000001BA20C00000000001CA20D00000000001DA20E00000000001E'
 DC X'A20F00000000001FA210000000000020A211000000000021A212000000000022'
 DC X'A213000000000023A214000000000024A215000000000025A216000000000026'
 DC X'A217000000000027A218000000000028A219000000000029A21A00000000002A'
 DC X'A21B00000000002BA21C00000000002CA1E2000000F0F007A1DB000000F0F006'
 DC X'A1E20000F0F0F007A1D0000000F0F005A1DB0000F0F0F006A1DB00000C000206'
 DC X'A1B400000002F0040700000000000100A178000001000003A1B4000100000004'
 DC X'A1D0010000000005A1DC000000000006A229000000404007A229000000000007'
 DC X'A22A000000000008A22B000000000009A22C00000000000AA22D00000000000B'
 DC X'A22F00000000000CA23000000000000DA23100000000000EA23200000000000F'
 DC X'A233000000000010A238000000000015A1D10000000001050600000000070000'
 DC X'07000000000700000600000000404000A23D4040404040060600000000F0F000'
 DC X'0700000000F0F0F0A17800F0F0F1F90307000000000200000700000000060000'
 DC X'050000004040000006000000404040000700000040404040A178404040404003'
 DC X'A17840404040C503A17840404040E203A1B5404040404004A244404040404005'
 DC X'A245404040404006A246404040404007A247404040404008A24A404040404009'
 DC X'A24B40404040400AA24C40404040F00BA24D404040F0F00CA1B5404040C5E404'
 DC X'A2444040C5E4E505A24540C5E4E5D706A24540C5E4E5D9060500000001000000'
 DC X'060000000140400006000000010000000700000001000000A178010000000003'
 DC X'A1B6000000004004A25C40404040400905000000041400000500000004160000'
 DC X'0500000004D000000500000004170000A17804141290BD03060000000416C900'
 DC X'0600000004D000000700000004D0000005000000F0F0000006000000F0F0F000'
 DC X'07000000F0F0F0F0A266F0F0F0F1F505070000005880D0880500000010000000'
 DC X'06000000100000000700000010000000A26C0000000000060500000008000000'
 DC X'0600000008000000A1BC0000000000040500000002F000000500000007000000'
 DC X'A17807000004E20305000000A8000000050000000C0000000700000005000000'
 DC X'070000001F000000060000000600000005000000980000000400000100000000'
 DC X'06000001C5E4E500060000014040400005000001000000000600000100020200'
 DC X'06000001000000000700000100000000A27B000002000004A280000000000006'
 DC X'0400000300000000040000404000000005000040404000000600004040404000'
 DC X'070000404040404007000040404040C5A17B404040404003A285404040404004'
 DC X'A286404040404005A28C40404040400AA17B404040C5E403A2854040C5E4E504'
 DC X'0400005050000000040000507000000004000050200000000500005050D00000'
 DC X'0500005070D00000040000F0F0000000050000F0F0F00000050000F0F0F10000'
 DC X'060000F0F0F0F000070000F0F0F0F2F60400000CF00000000400000C00000000'
 DC X'0700000CF0F0F0F9040000080000000006000008200000000500000800000000'
 DC X'04000058800000000600005850D088000600005860D090000500005810400000'
 DC X'04000002F00000000600000500000000040000D26F000000A1856F5000600003'
 DC X'04000007000000000600001000000000060000216000000004000013E0000000'
 DC X'040000D058000000050000FFFFFF00000300011C000000000300010000000000'
 DC X'0300010C0000000003000147000000000300015000000000C5D0F0C4125A9ED2'
 DC X'0300010D00000000030001400000000003000113000000000300015800000000'
 DC X'03000141000000000300011400000000030001C500000000030001D000000000'
 DC X'030001F000000000030001C40000000003000112000000000300015A00000000'
 DC X'0300019E00000000030001D200000000604A3F00000000000300013700000000'
 DC X'0300013C00000000030001D10000000003000118000000000300013400000000'
 DC X'0300017C0000000004000160380000000400014AF80000000400013F48000000'
 DC X'0400011C000000000400011C010000000500011C001600000500011C000E0000'
 DC X'0500011C005E00000500011C001500000500011C001700002306BE0000000000'
 DC X'0500011C00A800000500011C002400000500011C000200000500011C00190000'
 DC X'0700011C0014E8000600011C00F2A0000600011C002374000600011C00067400'
 DC X'0600011C00BE1000040001000000000004000100010000000500010000000000'
 DC X'060001000010E80006000100000000000700010000000000A2AF000000000003'
 DC X'A2DD000000000004A2E200000000000705000100010C000005000100010D0000'
 DC X'06000100010C000007000100010C000006000100010D000007000100010D0001'
 DC X'0400010C000000000500010C004700000500010C001500000500010C00000000'
 DC X'0600010C0004800004000147F0000000040001477000000004000147D0000000'
 DC X'05000147F030000006000147F0F036000600015090D0BC000400015020000000'
 DC X'04000150700000000400010D0000000004000140400000000500014040400000'
 DC X'06000140404040000700014040404040A2B5404040404003A2FA404040404004'
 DC X'A2FB404040404005040001134800000006000113500000000500011348000000'
 DC X'060001134800000005000158F03F0000040001411000000005000141E0F00000'
 DC X'0500014110D10000A2B9CEA186000003040001C5E4000000050001C5E4E50000'
 DC X'040001D203000000030038400000000004003840400000000500384040000000'
 DC X'0700384040404000060038404000010006003840400002000700384040000158'
 DC X'07003840400001500700384040000141070038404000014707003840400001D0'
 DC X'00000000000000000700384040000100070038404000013507003840400001D2'
 DC X'A30E000158503F04A30D40000141E003A30D40000147F0030700384040000200'
 DC X'A30D400002000003030058F00000000003005870000000000300586000000000'
 DC X'0300585000000000030058800000000000000000000000000300584000000000'
 DC X'030058100000000003005890000000000300582000000000040058F020000000'
 DC X'050058F02048000004005870D000000005005870D088000006005870D0885800'
 DC X'07005870D088D203040058606000000006005860D088580004005850D0000000'
 DC X'05005850D088000007005840D088D20304005890D000000005005820D2040000'
 DC X'03004040000000000300400000000000030040F0000000000400404040000000'
 DC X'040040400000000005004040404000000600404040404000060040404040C500'
 DC X'A3384040C3C5C5030700404040404040A338404040404003A33B404040404004'
 DC X'A33D404040404005A33E404040404006A341404040404007A342404040404008'
 DC X'A343404040404009A344404040F0F00AA34440404040400AA34540404040400B'
 DC X'A34640404040400CA34740404040400DA34840404040400EA34E404040404013'
 DC X'070040404040C5E4A3384040C5E4E50305004040003800000700404000044040'
 DC X'06004040003840000700404000384040A338003840400003A33C384040000104'
 DC X'040040F0F0000000060040F0F0F0F70003004780000000000300477000000000'
 DC X'030047F000000000040047803100000004004780300000000400478032000000'
 DC X'04004780340000000500478038F200000000000000000000050047803C200000'
 DC X'040047703300000006004770F0F0F00004004770310000000400477030000000'
 DC X'03000200000000000300020C0000000003000240000000000300025800000000'
 DC X'04000241000000000400020001000000040002000000000005000200010C0000'
 DC X'06000200010C0000030050D00000000003005000000000000300507000000000'
 DC X'0300505000000000030050080000000000000000000000000300508000000000'
 DC X'06005010D0884400040050D020000000050050D020040000060050D020041800'
 DC X'070050D0200418D2A371200418D20503A3790418D2053004A37BD20530440006'
 DC X'04005000D000000005005070D1300000050050506018000004005080D0000000'
 DC X'0300F0F0000000000300F00C000000000300F000000000000500F0101E020000'
 DC X'0400F0F0F00000000400F0F0F10000000500F0F0F0F000000500F0F0F0F30000'
 DC X'0500F0F0F0F200000600F0F0F0F5F0000600F0F0F0F0F0000600F0F0F0F0F100'
 DC X'0600F0F0F0F0F4000700F00C478033D60300411000000000030041F000000000'
 DC X'03004170000000000300415000000000030041A0000000000000000000000000'
 DC X'0300414000000000030041800000000004004110D1000000050041F0001C0000'
 DC X'03000300000000000600030BD800000005000319A80000000300035000000000'
 DC X'040003000100000005000300011C000006000300011C00000300050000000000'
 DC X'030005EF000000000300054B00000000040005000100000005000500011C0000'
 DC X'07000500011C00BE040005EF580000000300080000000000030008C500000000'
 DC X'0400081678000000040008000100000005000800011C000006000800010C0000'
 DC X'06000800011C0000040008C5E4000000050008C5E4E50000060008C5E4E5E200'
 DC X'0300D203000000000300D2FF000000000300D200000000000400D203D0000000'
 DC X'0400D203D30000000300D09C000000000300D0B8000000000300D09000000000'
 DC X'0400D091470000000600D09C58F035000300C1B8000000000300C1B000000000'
 DC X'0300C1F4000000000400C1B8580000000500C1B858D000000600C1B858D0D000'
 DC X'0700C1B858D0D004A3BE58D0D0045803A3C1D0D00458E004A3C2D00458E0D005'
 DC X'A3C30458E0D00C06A3C458E0D00C98070400C1B0410000000400C1B058000000'
 DC X'0300044000000000030004000000000006000440400001000500040000000000'
 DC X'03000C000000000003000C580000000003000C500000000005000C980CD00000'
 DC X'04000C000100000005000C00011C000006000C00010C000006000C00011C0000'
 DC X'06000C58F0D13400030010000000000004001041FF0000000300120000000000'
 DC X'0300127700000000040012000100000005001200011C000006001200011C0000'
 DC X'0400127747000000050012774780000003002000000000000400200047000000'
 DC X'070020001A101A20050020004780000003000B000000000004000B0001000000'
 DC X'05000B00011C000006000B00011C000003008000000000000400800058000000'
 DC X'0400800000000000050080005870000005008000000000000300600000000000'
 DC X'070060001A581A68060060005850D000060060000000000003001B1000000000'
 DC X'03001B1E00000000030006000000000004000600010000000300C00C00000000'
 DC X'0400C00C470000000500C00C472000000600C00C4720F000A3F820F01E58F004'
 DC X'A3F74720F0265803030009000000000003000940000000000400090001000000'
 DC X'05000900011C000006000900011C000003000A000000000004000A0001000000'
 DC X'05000A00011C00000300240000000000050024404000000006002400011C0000'
 DC X'030007000000000005000700010C000006000E00011C00000300700000000000'
 DC X'05001400011C000003000D000000000004000D000100000005000D00011C0000'
 DC X'06000D00011C00000600304040000D0006001300011C000007001500011C0040'
 DC X'0400D3E04700000006001A101A201B0006001F00011C00000500197847400000'
 DC X'0500C5E4E5E2000005002700000000000300FFFF000000000500FFFFFF000000'
 DC X'030044000000000006001600011C00000700DDFF100020000500900000000000'
 DC X'0300D703000000000500D703D0B400000300B000000000000400110001000000'
 DC X'04004C60600000000300A2000000000003009680000000000300950000000000'
 DC X'04005900D300000004006CA240000000020100000000000002011C0000000000'
 DC X'0201470000000000020150000000000002010C000000000041D3C514C3DD0F5A'
 DC X'0201400000000000020158000000000002010D00000000000201D00000000000'
 DC X'0201F00000000000020170000000000002014100000000000201D30000000000'
 DC X'0201C5000000000002011400000000000201C300000000000201DD0000000000'
 DC X'02010F000000000002015A00000000001E4A549E42D157340201800000000000'
 DC X'02010600000000000201120000000000020105000000000005013000CB280000'
 DC X'020101000000000002011E000000000002014A00000000000401540001000000'
 DC X'02019E000000000002014200000000000201D100000000000401575141000000'
 DC X'0201340000000000030100000000000003010019000000000301000100000000'
 DC X'03010013000000000401002D1800000004010000000000000501000000000000'
 DC X'060100000040000006010000000000000701000000000000A453000000000005'
 DC X'040100197800000006010019F0474000040100010D00000003011C0000000000'
 DC X'04011C00A800000004011C005E00000004011C0014000000030147D000000000'
 DC X'0301477000000000030147F0000000000501477030520000040147F0F0000000'
 DC X'030150200000000003010C000000000003014040000000000401404040000000'
 DC X'050140404040000006014040404040000701404040404040A466404040404003'
 DC X'A467404040404004A469404040F0F00603010D00000000000401D08858000000'
 DC X'0301F0F0000000000401F0F0F0000000030141100000000004014110D1000000'
 DC X'0301C5E4000000000401C5E4E5000000030114CE000000000501C3C5C5000000'
 DC X'0301DDFF000000000401DDFF100000000501DDFF1000000004010600DC000000'
 DC X'0202E3000000000002020000000000000202C500000000000202D90000000000'
 DC X'020240000000000041505559D1D0D2F002025800000000000202470000000000'
 DC X'02020C00000000000202700000000000020202000000000002021E0000000000'
 DC X'0202410000000000020250000000000005025500C00C00000202590000000000'
 DC X'0202D100000000000402D090410000000402D207200000000202F00000000000'
 DC X'0000000000000000040204000D0000000302E3E7000000000402E3E7E3000000'
 DC X'0502E3E7E34000000602E3E7E34000000602E3E7E34001000602E3E7E3400200'
 DC X'0602E3E7E34004000702E3E7E34003D90702E3E7E34000000702E3E7E3400003'
 DC X'0702E3E7E34000060702E3E7E34000050702E3E7E34000010D042625121F0817'
 DC X'0702E3E7E34000100702E3E7E34000020702E3E7E340000A0702E3E7E3400011'
 DC X'0702E3E7E340000E0702E3E7E340000C0702E3E7E340000D0702E3E7E3400004'
 DC X'0702E3E7E34000260702E3E7E34000250702E3E7E34000120702E3E7E340001F'
 DC X'0702E3E7E34000080702E3E7E340001714291928501B070F0702E3E7E3400044'
 DC X'0702E3E7E34000180702E3E7E340001D0702E3E7E34000150702E3E7E340000B'
 DC X'0702E3E7E34000130702E3E7E34000140702E3E7E34000290702E3E7E3400019'
 DC X'0702E3E7E34000280702E3E7E34000500702E3E7E340001B0702E3E7E3400007'
 DC X'0702E3E7E340000F0920F62E3F59222C0702E3E7E34000210702E3E7E340001A'
 DC X'0702E3E7E34000160702E3E7E34000270702E3E7E34000240702E3E7E3400040'
 DC X'0702E3E7E34000090702E3E7E34000200702E3E7E34000F60702E3E7E340002E'
 DC X'0702E3E7E340003F0702E3E7E34000590702E3E7E34000220702E3E7E340002C'
 DC X'1C56467900000000A4934000675440040702E3E7E34000740702E3E7E340002A'
 DC X'0702E3E7E340003B0702E3E7E34000880702E3E7E34000420702E3E7E340001C'
 DC X'A492E3400056BC03A492E34000468E03A492E3400079A803A492E34000000003'
 DC X'A495003840400006A493400000004004A494000000404005A495000040400006'
 DC X'A493400001D04004A4940010D8404005A49340001D4640040302000000000000'
 DC X'050200010C000000040200000000000005020000004000000602000000404000'
 DC X'0702000000404040A4DF004040404003A4E1404040404004A4E140404040C504'
 DC X'A4E2404040404005A4E3404040404006A4E4404040404007A4E5404040404008'
 DC X'A4E6404040404009A4E840404040400AA4E940404040400BA4EA40404040F00C'
 DC X'A4EB404040F0F00DA4EC4040F0F0F00EA4ED40F0F0F0F00FA4E2404040C5E405'
 DC X'A4E34040C5E4E506A4E440C5E4E5D907A4E440C5E4E5D707A4E7E4E5D7F1D209'
 DC X'0302C5E2000000000302C5D5000000000402C5E2C40000000502C5E2C4400000'
 DC X'0602C5E2C44040000702C5E2C4404040A4F8C44040404003A4FA404040404004'
 DC X'A4FB404040404005A4FC404040400006A4FD404040003007A4FE404000204008'
 DC X'A4FE404000304008A4FF400030404009A50000304040000A0402C5D5C4000000'
 DC X'0502C5D5C44000000602C5D5C44040000702C5D5C4404040A4F9C44040404003'
 DC X'A507404040404004A50C4040404040090302D9D3000000000402D9D3C4000000'
 DC X'0502D9D3C44000000602D9D3C44040000702D9D3C4404040A50EC44040404003'
 DC X'A50F404040404004A510404040404005A511404040400006A512404040003807'
 DC X'A514400028404009A514400034404009A513404000304008A5134040002C4008'
 DC X'A513404000384008A514400038404009A51500384040400AA51638404040400B'
 DC X'A51740404040000C030240400000000004024040000000000502404000380000'
 DC X'A523404000012805030247F0000000000203D000000000000203D10000000000'
 DC X'0203D200000000000203D300000000000203F000000000003080D5DD40D90316'
 DC X'0203D40000000000020350000000000002037000000000000203600000000000'
 DC X'02031000000000000203D6000000000002033000000000000203800000000000'
 DC X'0203D500000000000203DD000000000002034000000000000203D90000000000'
 DC X'0203030000000000040316025A00000000000000000000000203D80000000000'
 DC X'0203040000000000040300000A00000004034780310000000303D09000000000'
 DC X'0303D09C000000000303D0B0000000000303D0A0000000000303D0B800000000'
 DC X'94D0E8D8ACA4ECC40303D0B4000000000303D0DC000000000303D0BC00000000'
 DC X'0303D098000000000303D0CC000000000303D0A8000000000303D09400000000'
 DC X'0303D0D0000000000303D0E8000000000303D0D8000000000303D0AC00000000'
 DC X'0503D0A4D09C00000503D0ECD0E800000303D0C4000000000000000000000000'
 DC X'0303D0C0000000000403D090400000000503D090500000000403D0A0D0000000'
 DC X'0303D1A8000000000303D100000000000303D138000000000303D17800000000'
 DC X'0303D14000000000D0F4F000000000000503D1ECD1EC00000403D19833000000'
 DC X'0403D1683A0000000403D1B8D00000000403D180390000000403D164D0000000'
 DC X'0403D1D0D10000000403D1F4D10000000403D1F0D00000000303D2B400000000'
 DC X'0303D208000000000303D204000000000403D2483F0000000403D214D1000000'
 DC X'0303D318000000000303F0F0000000000403F0F0F00000000403F0F0F1000000'
 DC X'0303500000000000060350005000D20003037000000000000503700070000000'
 DC X'030360000000000005031008D090000003033000000000000204580000000000'
 DC X'0204410000000000020450000000000002040000000000000204470000000000'
 DC X'32071905630B97D5020440000000000002041800000000000204D20000000000'
 DC X'02040100000000000204F0000000000002040400000000000204320000000000'
 DC X'05040707185F0000020419000000000002040500000000000204630000000000'
 DC X'02040B000000000002049700000000000204D500000000000000000000000000'
 DC X'02041B00000000000204EC0000000000020412000000000003045AE000000000'
 DC X'0304BF6F00000000030458E0000000000304585000000000030458F000000000'
 DC X'0304587000000000030458800000000000000000000000000304580000000000'
 DC X'040458E0D0000000050458E0D00C0000060458E0D00C980006045850D0885800'
 DC X'04045870D000000005045870D088000003044110000000000304414000000000'
 DC X'050441F000000000030441700000000005044110D20800000304507000000000'
 DC X'050400000000000003044780000000000304477000000000030447F000000000'
 DC X'0304404000000000040440400000000005044040003800000504404000010000'
 DC X'A5AA40400001470507044040000147F0030418D200000000040418D205000000'
 DC X'050418D205300000060418D205305800070418D2053058400304D20300000000'
 DC X'0504D203D33800000304014A000000000304F0F0000000000404F0F0F0000000'
 DC X'03040404000000000205EF000000000002050000000000000205300000000000'
 DC X'02054B00000000000205180000000000000000000000000004051E0707000000'
 DC X'02054000000000000405E012EE0000000305EF58000000000305EF5000000000'
 DC X'0305EF12000000000305EF47000000000305EF41000000004449000000000000'
 DC X'0305EFF0000000000305EF18000000000305EFBF000000000305EFD200000000'
 DC X'0305EF00000000000505EF95FED000000505EF4400C100000405EF49F0000000'
 DC X'0405EF58700000000405EF58500000000405EF58600000000405EF5840000000'
 DC X'0405EF58F000000000000000000000000405EF58000000000405EF5880000000'
 DC X'0505EF5870F000000505EF5870D000000605EF5870F000000705EF5870F00050'
 DC X'A5C270F0005070030605EF5870D088000705EF5870D08858A5C270D088587003'
 DC X'0505EF5850D000000505EF5850F000000605EF5850D088000705EF5850D08858'
 DC X'A5C250D088585003A5D1D08858505004A5E1005060D1C8050505EF5860360000'
 DC X'0605EF586035AA000705EF5840D088500605EF58F0D090000505EF5800350000'
 DC X'0405EF50F00000000505EF50F0D000000505EF50F0D100000705EF50F0F0F0F1'
 DC X'0605EF50F0D2B4000605EF50F07014000605EF50F0D098000605EF50F0D0B400'
 DC X'0605EF50F0D094000605EF50F0D09C000605EF50F0D0C0000000000000000000'
 DC X'0605EF50F0D0B8000605EF50F0D0C8000605EF50F0D0A0000605EF50F0D0D800'
 DC X'0605EF50F0D090000705EF50F0D09858A5C3F0D0B447F0030405EF12FF000000'
 DC X'0505EF12664700000505EF12FF4700000605EF12FF4770000605EF12FF478000'
 DC X'0405EF47F00000000405EF41600000000605EF41F00000000505EF4100000000'
 DC X'0505EF4170D000000505EF4140D000000405EFF0F00000000505EFF0F0F00000'
 DC X'0505EFF0F0F100000405EF187F0000000405EF185F0000000605EF184F505000'
 DC X'0405EFBF0F0000000605EFBF7FD0A4000705EFBF0F5000470605EFBF0FD0BC00'
 DC X'0405EFD2030000000405EF000000000003050000000000000405000000000000'
 DC X'0305305000000000A61810D08844000302064000000000000206500000000000'
 DC X'020641000000000002066000000000000506C5E4E5E200000000000000000000'
 DC X'0206580000000000020648000000000003064040000000000706404000384040'
 DC X'02070000000000000207FF000000000002070700000000000207D20000000000'
 DC X'020747000000000000000000000000000407F0F0F00000000407FE90EC000000'
 DC X'020750000000000003070058000000000307000000000000030700D200000000'
 DC X'0307004700000000030700D70000000000000000000000000607004400C1B800'
 DC X'050700011C000000050700F0F0F0000004070058700000000407005880000000'
 DC X'040700586000000004070058F00000000507005870D000000507005860D00000'
 DC X'0407000000000000040700D20300000004070047F0000000040700D703000000'
 DC X'050700D703D000000307FF9000000000060707000010CE000208000000000000'
 DC X'0208580000000000020847000000000002084100000000000208400000000000'
 DC X'4D70C5D005A200000208D2000000000002085000000000000208F00000000000'
 DC X'02081800000000000208D700000000000208D1000000000005084DE0F0100000'
 DC X'02087000000000000408C5E4E50000000208D00000000000040805EF50000000'
 DC X'0308A24D00000000030800000000000003080001000000000308004000000000'
 DC X'03080067000000000408000000000000A6590000000000040708000100010D00'
 DC X'0408004000000000030858F00000000003085870000000000508586060000000'
 DC X'04085850F0000000040858F03F000000030847F0000000000308477000000000'
 DC X'03084780000000000308411000000000030841700000000006084110D0905800'
 DC X'03084040000000000408404000000000A6693840400001040308D20300000000'
 DC X'0408D203D200000003085000000000000308F0F0000000000608F0F0F0F0F000'
 DC X'0408D703D000000002090000000000000209FF00000000000309000000000000'
 DC X'0309FFFF00000000020A400000000000050A5010F0F00000020A000000000000'
 DC X'020A890000000000040A05EF58000000070A404000384040020B000000000000'
 DC X'020C000000000000020C580000000000020C410000000000020C470000000000'
 DC X'020CF000000000000205077000000000020CD20000000000020C980000000000'
 DC X'020C040000000000020C500000000000020C010000000000020C400000000000'
 DC X'020C020000000000020C050000000000040C07FED7000000030C700C00000000'
 DC X'030C000000000000030C004100000000050C00011C010000040C0047C0000000'
 DC X'040C000F0C0000000000000000000000040C000C2C000000040C000000000000'
 DC X'030C582000000000030C588000000000050C583030000000030C58F000000000'
 DC X'040C5820D0000000050C5820D04C0000060C5820D04C4100070C5820D04C4100'
 DC X'A694D04C41002003050C5880D0880000030C411000000000030C417000000000'
 DC X'040C416000000000030C478000000000050C4720F0240000030CF0F000000000'
 DC X'040CF0F0F1000000050CF0F0F0F80000030CD20300000000060C9829D01C0500'
 DC X'050C04059C000000070C404000384040030C05EF00000000020D000000000000'
 DC X'020D010000000000020D040000000000030D000100000000030D001C00000000'
 DC X'030D003800000000030D000000000000030D0010000000000D2F0C0000000000'
 DC X'030D000E00000000030D000800000000030D000400000000030D000F00000000'
 DC X'030D003B00000000050D0017480C0000040D000DAC000000040D002F00000000'
 DC X'040D000C28000000040D000008000000A6BD0C00000C0004030D014200000000'
 DC X'030D019E00000000030D046400000000040D0463FC000000020E400000000000'
 DC X'020E0E0000000000020E000000000000020E410000000000020E470000000000'
 DC X'030E404000000000040E404000000000070E404040404040050E404000380000'
 DC X'060E404000384000070E404000384040A6C8003840400003A6C9384040000104'
 DC X'050E0E0E0E0E0000020F400000000000020F100000000000020FD00000000000'
 DC X'020F500000000000050F58FF001000000000000000000000020FF00000000000'
 DC X'040F12FF00000000030F400000000000040F400047000000040F1000BD000000'
 DC X'02100000000000000210D000000000000210F000000000000210D10000000000'
 DC X'0210D40000000000200C47084011600102105800000000000210D20000000000'
 DC X'0210040000000000021050000000000002104100000000000210100000000000'
 DC X'021020000000000002100C000000000002104700000000000210080000000000'
 DC X'0210400000000000021011000000000002106000000000000210010000000000'
 DC X'3D05353A0D8683340210D3000000000002103700000000000210360000000000'
 DC X'0510E000501000000210D70000000000021018000000000002103D0000000000'
 DC X'041005EF47000000021035000000000002103A000000000002100D0000000000'
 DC X'0410869C05000000021083000000000002103400000000000000000000000000'
 DC X'0310C1F400000000031000000000000003100041000000000310005800000000'
 DC X'06100020004780000310004700000000000000000000000004100001F0000000'
 DC X'041000F000000000041000000000000007100000000000000310D0A800000000'
 DC X'0310D0B0000000000310D088000000000310D0F0000000000510D0E858F00000'
 DC X'00000000000000000310D0B8000000000310D098000000000510D078F0F00000'
 DC X'0410D0A0010000000610D0A858F032000310F0F0000000000410F0F0F0000000'
 DC X'0410F0F0F10000000510F0F0F0F000000510F0F0F0F70000A716F0F0F7F0F803'
 DC X'0410D128580000000310D410000000000610D40858F036000410D41058000000'
 DC X'0510D41058F00000031058F00000000003105850000000000310D20300000000'
 DC X'05100458F0A70000031050300000000004104160D30000000310200000000000'
 DC X'04102000500000000510200050D00000A729200418D2050503100C4100000000'
 DC X'041047703200000005100854402200000510085000D000000310404000000000'
 DC X'04104040000000000710404000384040031011000000000006101100DDFF1000'
 DC X'0310600000000000031001410000000004101858500000000211000000000000'
 DC X'0211430000000000031131FC00000000051100DDFF1000000311431000000000'
 DC X'02120500000000000212FF000000000002129000000000000212000000000000'
 DC X'0212440000000000998858C30000000002127700000000000212200000000000'
 DC X'0212660000000000021286000000000005125547807400000212EE0000000000'
 DC X'0212990000000000041288477000000002125800000000000312C34700000000'
 DC X'031205EF00000000041205EF12000000041205EF58000000061205EF12444700'
 DC X'061205EF580035000312FF47000000000512FF06F04700000412FF4770000000'
 DC X'0612FF478030DA00031200470000000005120047703200000312444700000000'
 DC X'0412444780000000031277470000000003126647000000000312862800000000'
 DC X'0214180000000000021412000000000002144000000000000214410000000000'
 DC X'0214000000000000F05836074B00000002140500000000000214470000000000'
 DC X'0214C6000000000002145000000000000214CE00000000000214D20000000000'
 DC X'0414F0F0F000000002145800000000000214360000000000041407FE47000000'
 DC X'03144B10000000000514181558A00000041418415E0000000314129000000000'
 DC X'0314129B00000000031440400000000004144040000000000614404000384000'
 DC X'031441700000000005144110D0BC00000314000000000000031405EF00000000'
 DC X'0614C6E4D5C3E30004145010470000000514CEA1860000000314D20300000000'
 DC X'021500000000000004154B103700000004155080D40000000215580000000000'
 DC X'041518515E000000000000000000000003150F47000000000315004000000000'
 DC X'061500C5E4E5E200051500011C0000000515004C606000000415004040000000'
 DC X'0515004040400000A78740404040400402160500000000000216470000000000'
 DC X'0216C90000000000051640400038000002165800000000000000000000000000'
 DC X'021618000000000002160000000000000416F0F0F00000000216500000000000'
 DC X'031605EF00000000051605EFBF0F0000051647F0F0260000051718715E700000'
 DC X'02171200000000000217580000000000041705EF9200000004174B1032000000'
 DC X'0000000000000000041747D03500000002181200000000000218580000000000'
 DC X'021817000000000002184000000000000218D2000000000019F0501518145981'
 DC X'0218000000000000021847000000000002181600000000000218010000000000'
 DC X'021841000000000002181F000000000002181900000000000218F00000000000'
 DC X'0218500000000000021815000000000002181800000000000218140000000000'
 DC X'02185900000000000218810000000000DE56511B0D670FE20218F70000000000'
 DC X'06181A05EF58F00002181000000000000218F8000000000005184E05EF000000'
 DC X'0218F600000000000218DE000000000004185689500000000418515E50000000'
 DC X'02181B000000000004180D000F000000021867000000000002180F0000000000'
 DC X'0418E2410A00000000000000000000000318F1440000000003187F5000000000'
 DC X'0318B1F00000000003181205000000000318121B0000000004181205EF000000'
 DC X'05181205EF12000005181205EF58000006181205EF186F0006181205EF125500'
 DC X'0418121B10000000031858F000000000041858703F00000004185860D0000000'
 DC X'0318170500000000031817180000000005181758203B000004181705EF000000'
 DC X'03184040000000000418404000000000061840404040F000A7D4003840400003'
 DC X'0318D203000000000318D205000000000418D205300000000318000000000000'
 DC X'0318477000000000031847F00000000005181618F705000005181658F03F0000'
 DC X'031801DD00000000041801DDFF000000051801DDFF100000A7E200A000182105'
 DC X'05184160D0B4000005181F0FE0470000031819580000000004181905EF000000'
 DC X'0518F047F03000000518154B10390000031818050000000004181805EF000000'
 DC X'031814050000000004181405EF0000000518F7D203D400000418F8D203000000'
 DC X'021900000000000002195800000000000219500000000000021AF50000000000'
 DC X'021A780000000000021AF00000000000021A580000000000021A750000000000'
 DC X'0000000000000000021A050000000000021A560000000000021A670000000000'
 DC X'041A4150D0000000041A404000000000031AF59800000000041AF598F0000000'
 DC X'051AF598F0F00000A7FEF0F0084DE003031A784400000000041A784470000000'
 DC X'051AF044F0320000031A05EF00000000021B000000000000021BF00000000000'
 DC X'021B550000000000021B660000000000021B7800000000004700000000000000'
 DC X'021B100000000000021B770000000000021B110000000000061B1518515E5000'
 DC X'021BFF0000000000051B1718715E0000041B477034000000031B009600000000'
 DC X'051B004300D00000041B009680000000A815100458F57004031BF04700000000'
 DC X'051BF0D2FF100000041BF047B0000000031B554300000000051B55BF53600000'
 DC X'041B554350000000031B664300000000051B66BF63700000061B664360500000'
 DC X'031B784700000000031B774300000000041B77BF73000000041B774370000000'
 DC X'051B114310F00000021C000000000000021C050000000000021C470000000000'
 DC X'021C580000000000021C4100000000000000000000000000051C404000380000'
 DC X'021C180000000000051CF0F0F0F00000021C920000000000031C0F1200000000'
 DC X'031C004000000000031C001500000000031C000200000000031C001600000000'
 DC X'031C00A8000000000000000000000000031C000E00000000031C000000000000'
 DC X'031C001400000000031C051E00000000041C051E07000000051C051E07070000'
 DC X'031C478000000000031D000100000000021E470000000000021E070000000000'
 DC X'061E404000384000021E410000000000021E580000000000031E070700000000'
 DC X'041E070700000000021F4B0000000000021F580000000000021FFF0000000000'
 DC X'02200000000000000220D0000000000002204000000000000220D20000000000'
 DC X'0220500000000000479020581801053A0220F000000000000220D10000000000'
 DC X'0220410000000000022010000000000002200400000000000220480000000000'
 DC X'0220470000000000022090000000000002202000000000000220580000000000'
 DC X'02201800000000000220010000000000022005000000000002203A0000000000'
 DC X'3E0C4C000000000002203F0000000000022008000000000004201BF047000000'
 DC X'02203400000000000220380000000000022060000000000002203E0000000000'
 DC X'02200C000000000003204C580000000003200050000000000320000000000000'
 DC X'03200041000000000320004700000000032000030000000004200050D0000000'
 DC X'05200050D0200000A86C0418D205300504200000000000000420000002000000'
 DC X'0620D04C41002000032040400000000003204000000000000420404000000000'
 DC X'04204040400000000520404000380000A8754040000141050520404040400000'
 DC X'07204040404040400320D2030000000003205000000000000320F0F000000000'
 DC X'0420F0F0F0000000032041000000000007200418D20530440520489210200000'
 DC X'052047E0697F0000032058F00000000005214110110000000224400000000000'
 DC X'0224580000000000022447000000000002240500000000000224500000000000'
 DC X'0000000000000000022441000000000002240000000000000324D20300000000'
 DC X'03244040000000000424404000000000A88C0038404000030324587000000000'
 DC X'032447F000000000032405EF0000000003245050000000000226400000000000'
 DC X'0226470000000000042641101100000002269200000000000326404000000000'
 DC X'0426404000000000062640400038400002284000000000000228000000000000'
 DC X'022841000000000002284700000000000228D200000000000000000000000000'
 DC X'0228580000000000042855002000000002285000000000000428800000000000'
 DC X'03284040000000000428404000000000A8A4404040404003A8A5384040000104'
 DC X'032800000000000004280000000000000728000000000000032847F000000000'
 DC X'03284780000000000328D20300000000022A400000000000022A500000000000'
 DC X'022A470000000000042A58F03B000000032A404000000000A8B2003840400003'
 DC X'022C410000000000022C580000000000022C400000000000022C000000000000'
 DC X'022C5000000000000000000000000000042C05EF50000000032C417000000000'
 DC X'032C411000000000052C415000010000032C583000000000032C404000000000'
 DC X'042C404000000000A8BF003840400003032C000000000000022E580000000000'
 DC X'022E400000000000052ED203D0E00000032E404000000000042E404000000000'
 DC X'022FD10000000000023040000000000002300000000000000230580000000000'
 DC X'0230D200000000000230500000000000057E20185AB46A470230410000000000'
 DC X'0230D000000000000230D1000000000002301000000000000230740000000000'
 DC X'0530F0F0F1F00000023005000000000004307E41100000000430209250000000'
 DC X'023018000000000004305A50C30000000330B4580000000003306A0700000000'
 DC X'033047800000000000000000000000000330A658000000000330700400000000'
 DC X'0330047C00000000033040400000000004304000000000000430404000000000'
 DC X'0630404040404000053040400038000005304040000100000730404000304040'
 DC X'06304040003840000730404000384040A8E1003840400003A8E3384040000104'
 DC X'0330000000000000033000020000000003300001000000000530000000000000'
 DC X'0330584000000000033058F000000000053058F03FA000000330D20300000000'
 DC X'0231E800000000000231BA000000000002315200000000000231F00000000000'
 DC X'0231B40000000000000000000000000003313040000000000331AC4100000000'
 DC X'033105EF00000000033170580000000002325800000000000232400000000000'
 DC X'02325000000000000432461AF00000000332D203000000000000000000000000'
 DC X'033294580000000005325840D088000003324040000000000432404000000000'
 DC X'023300000000000004330A58000000000433D618F60000000433DCBF0F000000'
 DC X'04335030100000000000000000000000033392D2000000000333FC4100000000'
 DC X'0234400000000000023400000000000002342800000000000234500000000000'
 DC X'02344100000000000000000000000000023456000000000002343C0000000000'
 DC X'0234240000000000033430070000000003347247000000000334404000000000'
 DC X'04344040000000000334411000000000023574000000000002351E0000000000'
 DC X'03351C580000000003358CD20000000002364800000000000236580000000000'
 DC X'0436F0F0F100000002361800000000000336D250000000000000000000000000'
 DC X'0336CA410000000004371A586000000002384000000000000238580000000000'
 DC X'023841000000000002385000000000000238D200000000000500000000000000'
 DC X'02380000000000000238C800000000000238F000000000000238470000000000'
 DC X'0238A400000000000338C45800000000033805EF000000000338404000000000'
 DC X'0538400000010000043840400000000004384040400000000538404000010000'
 DC X'0538404000380000053840400002000006384040000141000638404000015800'
 DC X'06384040000100000638404000015000063840400001D0000000000000000000'
 DC X'063840400001D200063840400001D10006384040000118000738404000014170'
 DC X'A9390141E0F0420407384040000158F007384040000158600738404000010000'
 DC X'A93700015070D20306384040003840000738404000384040A937003840400003'
 DC X'A939384040000104A93938404000020405384040404000000538587570000000'
 DC X'05385020D0CC00000338D203000000000538D203D19C00000239470000000000'
 DC X'0239000000000000023A400000000000023ABE0000000000033A2CD200000000'
 DC X'033A404000000000A95C003840400003023B000000000000023B260000000000'
 DC X'043B9E5A50000000043B000037000000023C400000000000023C580000000000'
 DC X'023C000000000000023C500000000000043C5A50C30000000000000000000000'
 DC X'023C880000000000043CF0F0F1000000033C3F5600000000033C404000000000'
 DC X'043C404000000000073C404000044040033C58F000000000043C000000000000'
 DC X'023DD20000000000023E400000000000023E580000000000043E05EF50000000'
 DC X'023EF40000000000033E404000000000073E404000384040023F660000000000'
 DC X'023FE20000000000023F640000000000023F6E0000000000023F980000000000'
 DC X'0C6852B28C400000023F4E0000000000043FDE5885000000043FCC5820000000'
 DC X'043F004170000000023F580000000000043F4AD203000000033F0C5800000000'
 DC X'033F68D200000000033F52D200000000033FB25800000000033F8CD200000000'
 DC X'033F404000000000033FE2500000000002404000000000000240000000000000'
 DC X'0240F000000000000240D00000000000024050000000000085C9D1D56C029690'
 DC X'0240C300000000000240D9000000000002400400000000000240E20000000000'
 DC X'0240A20000000000024060000000000002408500000000000240C90000000000'
 DC X'0240D100000000000240D5000000000002406C00000000000240020000000000'
 DC X'0240960000000000024090000000000082C101A37080C2C50240860000000000'
 DC X'024083000000000002401000000000000240C600000000000240840000000000'
 DC X'0240D4000000000002408200000000000240C100000000000240010000000000'
 DC X'0240A30000000000024070000000000002408000000000000240C20000000000'
 DC X'0240C50000000000D27E89302018E0D302409900000000000240580000000000'
 DC X'0240F1000000000002404100000000000240E4000000000002404D0000000000'
 DC X'0240D2000000000002407E000000000002408900000000000240300000000000'
 DC X'024020000000000002401800000000000240E000000000000240D30000000000'
 DC X'9794A688313A374702403F00000000000240E300000000000240E50000000000'
 DC X'0240C400000000000240D700000000000240A400000000000240970000000000'
 DC X'02409400000000000240A6000000000005408881958400000240310000000000'
 DC X'02403A000000000002403700000000000440478030000000D6050A0C32000000'
 DC X'04409389950000000240F5000000000002400800000000000240810000000000'
 DC X'0440A5819300000002403600000000000240D60000000000044005EF58000000'
 DC X'04400A5E7000000003400CD200000000034032AA000000000340400000000000'
 DC X'0340404000000000034040F00000000007404002000000400340406000000000'
 DC X'0000000000000000054040C5E4E50000034040C100000000054040F1F2F00000'
 DC X'0440400038000000044040000100000004404000020000000440400030000000'
 DC X'04404000140000001234000E1003242E04404000080000000440400004000000'
 DC X'044040001A00000004404000280000000440400018000000A9D7264040000103'
 DC X'044040001200000007404000344040400740400000000007044040000E000000'
 DC X'074040001040400004404000030000000640400024404000064040002E404000'
 DC X'000000000000000006404000324040000640400036404000064040000C404000'
 DC X'064040002B404000054040001740000005404000064000000540400038400000'
 DC X'06404000384040000740400038404000A9D7384040000103A9D7384040000203'
 DC X'A9E0404000014104A9E0404000010004A9E0404000015804A9E040400001D004'
 DC X'A9E0404000015004D336D73533328012A9E0404000014704A9E0404000014004'
 DC X'A9E040400001D204A9E040400001D104A9E040400001BF04A9E0404000010504'
 DC X'A9E040400001D304A9E0404000013604A9E040400001D704A9E0404000013504'
 DC X'A9E0404000013304A9E0404000013204A9E0404000018004A9E0404000011204'
 DC X'F0305AE437595ED5A9E0404000013404A9E0404000010704A9E040400001C304'
 DC X'A9E0404000017004A9E0404000019004A9FE99898788A308A9E040400001F004'
 DC X'A9E0404000013004A9FD015A50C34407A9FD01E4A2856B07A9E0404000013704'
 DC X'A9E0404000015904A9E0404000015E04A9E040400001D5043E3A91D618481A61'
 DC X'A9E0404000013F04A9E0404000018904A9E0404000016004A9E0404000014404'
 DC X'A9E0404000013B04A9E0404000013104A9E0404000013E04A9E0404000013A04'
 DC X'A9E0404000019104A9E040400001D604A9E0404000011804A9E0404000014804'
 DC X'A9E0404000011A04A9FC0001614858060000000000000000A9FB400001920005'
 DC X'A9FB400001393C05A9FB400001101805A9FB40000141E005A9FB400001417005'
 DC X'A9FB400001411005A9FB400001415005A9FC000141E0F006AA3A4A58F0C0740B'
 DC X'AA36F03E58F0C00AAA00E0F03C58F009A9FC000141704006A9FC00014110D106'
 DC X'A9FC00014110D006A9FB400001000005A9FB400001000205A9FC000100000006'
 DC X'A9FE00005050D008A9FD010000000007A9FE000000000008AA01000000000009'
 DC X'AA4100000000000AAA4300000000000BAA4500000000000CAA4600000000000D'
 DC X'AA4700000000000EAA4C000000000013A9FB400001587005A9FB400001585005'
 DC X'A9FB40000158F005A9FB400001586005A9FB4000015840050000000000000000'
 DC X'A9FC000158757006A9FC00015870D006A9FD0158503FBC07A9FC000158F03506'
 DC X'A9FB400001D08805A9FB400001D0A805A9FB400001D09405A9FB400001D0B805'
 DC X'A9FB400001D0D0050000000000000000A9FC0001D0A05806A9FC0001D0885806'
 DC X'A9FED08858505008A9FED0885870D008A9FD01D0A847B007A9FB400001507005'
 DC X'A9FB400001505005A9FB400001500005A9FB40000150F005A9FB400001478005'
 DC X'A9FB400001477005A9FB40000147F005A9FD0147B0338E07A9FD014780338207'
 DC X'A9FB400001404005A9FB400001400005A9FC000140404006A9FD014040404007'
 DC X'A9FE404040404008AA07404040404009AA6C40404040400AAA6E40404040400B'
 DC X'AA6F40404040400CAA7040404040400DAA7140404040400EAA7240404040400F'
 DC X'AA77404040404014A9FB400001D20305A9FB400001D20005A9FD01D203D3C807'
 DC X'A9FB400001D16C05A9FB400001BF5F05A9FB400001BFFF05A9FB40000105EF05'
 DC X'A9FC000105EF5806A9FD0105EF47F007A9FD0105EF50F007A9FED38983859508'
 DC X'A9FB400001D70305A9FD01D703D0BC07A9FB400001800005A9FB400001127705'
 DC X'A9FC000112774706A9FD010700D2FF07A9FEC34458703008A9FC000170005006'
 DC X'A9FC00016000BD06A9E0404000020004A9E0404000024004A9E0404000028404'
 DC X'A9FD024C60604007A9E040400002040494416C8500000000A9E040400002A304'
 DC X'A9E0404000025004A9E0404000024704A9E0404000029904A9E0404000028104'
 DC X'A9FC0002A2858306A9E0404000029404A9FB400002411005A9FB4000026CA205'
 DC X'A9FB400002854D05A9FB400002000005A9FC000200000006A9FD020000000007'
 DC X'A9FF000000000008AA8D00000000000905404000010000000540400001140000'
 DC X'054040000147000005404000015800000540400001400000FFC3D1A300000000'
 DC X'05404000014100000540400001D000000540400001050000A9E10E0E00001D04'
 DC X'05404000015000000740400001D203D10740400001FFFFFF0540400001C30000'
 DC X'0540400001D100000740400001A3898306404000010000000640400001000100'
 DC X'0740400001000000A9D7010000000003A9E1000000000004AAA2000000000005'
 DC X'AAB5000000000008A9D70100010D0003064040000114CE00074040000114CEA1'
 DC X'074040000114CE21A9D70114CEA18603A9E114CEA1860004AAA3CEA186000005'
 DC X'AABAA18600000006A9D70114CE218603AABA218600000006064040000147F000'
 DC X'074040000147F0F0064040000158F000A9D7015860D0C8030640400001587000'
 DC X'0640400001404000A9E1404000014004A9D7014040404003A9D70141E0F03C03'
 DC X'064040000105EF00A9E105EF50F0D00405404000020000000540400002400000'
 DC X'05404000024D000006404000024B4B0006404000020000000640400002404000'
 DC X'0740400002404000A9D7024D9997830305404000304000000640400030404000'
 DC X'0740400030404000A9D7304040000103A9E3404000010004AAD6400001000005'
 DC X'054040001440000006404000144040000740400014404000A9D7144040000103'
 DC X'A9E4404000010004AADC40000100000505404000084000000640400008404000'
 DC X'0740400008404000A9D7084040000103A9E6404000011404AAE3000100000006'
 DC X'AAE240000114CE05054040000440000006404000044040000740400004404000'
 DC X'A9D7044040000103A9D7044040000203A9E7404000014704AAE940000147F005'
 DC X'AAEA000147F0F006054040001A400000064040001A404000074040001A404000'
 DC X'A9D71A4040000103AAF20001C1B85806AAF2000114CE21060540400028400000'
 DC X'0640400028404000A9E940400001140405404000184000000640400018404000'
 DC X'0740400018404000A9D718404000010307404000124040000440404040000000'
 DC X'044040400000000004404040F000000007404040C5E4E5D7044040407C000000'
 DC X'000000000000000006404040F1F2F00006404040020000000540404040400000'
 DC X'05404040400000000540404040F000000740404040C5E4E50640404040404000'
 DC X'064040404040F0000640404040400000A9D84040C19393030740404040404040'
 DC X'074040404040400007404040404040F0A9D8404040404003A9D840404040F003'
 DC X'AAFF404040404004AAFF40404040F004AB07404040404005AB0740404040F005'
 DC X'AB0B404040404006AB0B40404040F006AB0F404040404007AB0F40404040F007'
 DC X'AB12404040404008AB1240404040F008AB14404040404009AB1440404040F009'
 DC X'AB1640404040400AAB1640404040F00AAB1840404040400BAB1840404040F00B'
 DC X'AB1A40404040400CAB1A40404040F00CAB1C40404040400DAB1C40404040F00D'
 DC X'AB1E40404040400EAB1E40404040F00EAB2040404040400FAB2040404040F00F'
 DC X'AB22404040404010AB2240404040F010AB24404040F1F511AB24404040404011'
 DC X'AB26404040F1F512AB26404040F0F012AB26404040404012AB2A4040F0F0F014'
 DC X'AB28404040404013AB2840404040F013AB2A404040404014AB2A40404040F014'
 DC X'AB2C404040404015AB3440F0F0F0F018AB2F404040404016AB3640F0F0F0F919'
 DC X'AB32404040404017AB3240404040F017AB34404040404018AB3440404040F018'
 DC X'AB384040F1F5F61AAB36404040404019AB3640404040F019AB3840404040401A'
 DC X'AB3840404040F01AAB3A40404040401BAB3A40404040F01BAB3C40404040401C'
 DC X'AB3C40404040F01CAB3E40404040401DAB3E40404040F01DAB4140404040401E'
 DC X'AB4740F0F0F0F121AB4340404040401FAB4340404040F01FAB45404040404020'
 DC X'AB4540404040F020AB47404040404021AB4D40F0F0F0F824AB49404040404022'
 DC X'AB4B404040404023AB4F4040F0F0F025AB4D404040404024AB514040F0F0F026'
 DC X'AB4F404040404025AB5440F0F0F0F428AB51404040404026AB5640F0F0F0F229'
 DC X'AB53404040404027AB54404040404028AB5A40F0F0F0F02BAB56404040404029'
 DC X'AB5640404040F029AB5840404040402AAB5840404040F02AAB5A40404040402B'
 DC X'AB5A40404040F02BAB5C40404040402CAB5C40404040F02CAB5D40404040402D'
 DC X'AB5F40404040402EAB634040F0F0F030AB6140404040402FAB6140404040F02F'
 DC X'AB6340404040F030AB63404040404030AB65404040F0F031AB674040F0F0F032'
 DC X'AB674040F0F0F132AB6840F0F0F0F433AB6840F0F0F0F033AB6840F0F0F0F333'
 DC X'AB6840F0F0F0F133AB6AF0F0F0F8F134AB6AF0F0F0F0F034AB6CF0F0F3F1F335'
 DC X'AB65404040404031AB684040F0F0F033AB63404040F0F030AB654040F0F0F031'
 DC X'AB5D404040F0F02DAB5F4040F0F0F02EAB66F0F1F8F9F331AB6140F0F0F0F02F'
 DC X'AB5C404040F0F02CAB5D4040F0F0F02DAB5A404040F0F02BAB5C4040F0F0F02C'
 DC X'AB58404040F0F02AAB47404040F0F021AB494040F0F0F022AB4B40F0F0F1F723'
 DC X'AB45404040F0F020AB41404040F0F01EAB434040F0F0F01FAB3E404040F0F01D'
 DC X'AB414040F0F0F01EAB4340F0F0F0F01FAB48F0F0F0F0F821AB3C404040F0F01C'
 DC X'AB3E4040F0F0F01DAB3A404040F0F01BAB3C4040F0F0F01CAB3E40F0F0F0F31D'
 DC X'AB38404040F0F01AAB3A4040F0F0F01BAB3C40F0F0F1F31CAB36404040F0F019'
 DC X'AB384040F0F0F01AAB3CF0F0F0F0F11CAB34404040F0F018AB3840F0F0F1F41A'
 DC X'AB2C404040F0F015AB2F4040F0F0F016AB2A404040F0F014AB2C4040F0F0F015'
 DC X'AB24404040F0F011AB264040F0F0F012AB22404040F0F010AB244040F0F0F011'
 DC X'AB2BF0F0F4F3F414AB20404040F0F00FAB224040F0F0F010AB26F0F0F1F8F212'
 DC X'AB26F0F0F0F0F212AB1E404040F0F00EAB204040F0F0F00FAB24F0F0F0F0F811'
 DC X'AB1C404040F0F00DAB1E4040F0F0F00EAB1E4040F0F0F10EAB2040F0F0F0F00F'
 DC X'AB22F0F0F0F3F210AB22F0F0F0F7F710AB25F0F0F0F4F511AB1A404040F0F00C'
 DC X'AB1C4040F0F0F00DAB1C4040F0F0F10DAB20F0F0F0F5F90FAB20F0F0F0F0F00F'
 DC X'AB18404040F0F00BAB1A4040F0F0F00CAB1A4040F0F0F10CAB16404040F0F00A'
 DC X'AB184040F0F0F00BAB1A40F0F0F1F10CAB1CF0F0F0F1F60DAB14404040F0F009'
 DC X'AB164040F0F0F00AAB1840F0F0F1F00BAB1DF0F0F5F5F00DAB1AF0F0F0F2F80C'
 DC X'AB12404040F0F008AB144040F0F0F009AB1640F0F0F0F70AAB0F404040F0F007'
 DC X'AB124040F0F0F008AB0B404040F0F006AB0F4040F0F0F007AB07404040F0F005'
 DC X'AB0B4040F0F0F106AB0B4040F0F0F006AB0F40F0F0F1F107AB0F40F0F0F1F707'
 DC X'AB12F0F0F1F8F508AAFF404040F0F004AB074040F0F0F005AB0FF0F0F1F1F207'
 DC X'AB0B40F0F0F0F006AB13F0F0F0F0F708A9D8404040003003AAFF404000304004'
 DC X'AB07400030404005AB0B003040400006A9D8404040F0F003AAFF4040F0F0F004'
 DC X'AB0740F0F0F0F005074040404040F0F0A9D84040F0F0F003A9D84040F0F0F103'
 DC X'AAFF40F0F0F0F004AB07F0F0F0F0F005AB0D3040400001060640404040000100'
 DC X'AB080600011C00050640404040003000A9D8400034404003A9D8400038404003'
 DC X'00000000000000000740404040000C000740404040000100A9D8400001000103'
 DC X'AAFF000100010D04AB080100010D0005AAFF0030404000040640404040F0F000'
 DC X'0740404040F0F0F00740404040F0F0F1A9D840F0F0F0F003AAFFF0F0F0F0F704'
 DC X'AAFFF0F0F0F0F004ABEFF0F0F7F0F006A9D840F0F0F1F1030540404000380000'
 DC X'05404040000100000540404000040000A9D80030404000030640404000384000'
 DC X'0740404000384040A9D8003840400003AB003840400001040640404000010000'
 DC X'0740404000010001A9D8000100010D03AB000100010D000405404040F0F00000'
 DC X'06404040F0F0F00006404040F0F0F10007404040F0F0F0F0044040F0F0000000'
 DC X'054040F0F0F00000064040F0F0F0F00003400038000000000340000100000000'
 DC X'034000000000000003400002000000000340000400000000589510470D071420'
 DC X'0340003000000000034000080000000003400012000000000340000C00000000'
 DC X'0340000600000000034000150000000003400058000000000340009500000000'
 DC X'034000100000000003400047000000000340000D000000000340000700000000'
 DC X'0540001440400000034000200000000000000000000000000340001C00000000'
 DC X'0340000900000000044000384000000005400038404000000640003840400000'
 DC X'07400038404000010740003840400002AC0A404000014103AC0A404000015803'
 DC X'AC0A404000015003AC0A404000010003AC0A4040000147030000000000000000'
 DC X'AC0A40400001D003AC0A40400001D103AC0A404000010503AC0A404000014003'
 DC X'AC0A404000018003AC2140000141E004AC22000141E0F005AC2140000158B004'
 DC X'AC245010D0785807AC21400001000004AC29000000000008AC21400001478004'
 DC X'AC22000200003605044000010000000004400001470000000440000141000000'
 DC X'04400001580000000440000114000000C3000000000000000440000105000000'
 DC X'04400001D0000000044000014000000004400001D100000004400001D2000000'
 DC X'06400001FFFFFF0005400001C3C5000005400001000000000540000100010000'
 DC X'064000010000000007400001000000000640000100010D000740000100010D00'
 DC X'0540000147F000000640000147F0F00006400001411011000640000158703F00'
 DC X'0540000114CE0000AC0B14CEA18600030540000105EF00000440000001000000'
 DC X'04400000000000000540000001C50000AC53404040404004AC0C017CE2E3F003'
 DC X'0640000001C5E4000740000001C5E4E5AC0C01C5E4E5E2030640000000000700'
 DC X'04400002000000000540000299A30000AC0E4040000147030440003040000000'
 DC X'0540003040400000064000304040000007400030404000010340F0F000000000'
 DC X'0440F0F0F00000000440F0F0F10000000540F0F0F0F000000540F0F0F0F40000'
 DC X'0540F0F0F0F800000540F0F0F0F500000640F0F0F0F1F6000640F0F0F0F0F000'
 DC X'0640F0F0F0F0F1000540F0F0F1F900000340D088000000000340D09C00000000'
 DC X'0340D094000000000640D0A05850D0000340D098000000000640D088D2034000'
 DC X'0640D09C58404000034050000000000005405004504000000340C3D600000000'
 DC X'0340C396000000000540C344504000000640C3D6D4D7C9000340D9C500000000'
 DC X'0640D9F240D4F0000540D985A2A300000540D989878800000640045840D08800'
 DC X'03400441000000000640E2E3C1D9E3000540E2A381A300000340A2A300000000'
 DC X'0540A28599A500000440A2A3810000000540A2A381A300000640A2A381A3A400'
 DC X'0740A2A381A3A4A2AC8381A3A4A27E03034060400000000006406040D7999600'
 DC X'03408599000000000340859500000000054085A789A300000440859999000000'
 DC X'074085999995967E0340C9C2000000000540C9D540C400000440C9C2D4000000'
 DC X'0540C9C2D44000000540D140588000000340D5D6000000000340020000000000'
 DC X'0440020000000000054002000000000006400200000040000740020000004040'
 DC X'AC97000040404003AC980040404040040640968640C9C2000340905000000000'
 DC X'0440904016000000054086818993000003408396000000000340100000000000'
 DC X'0340100C00000000054084A49793000005408285408400000340A39600000000'
 DC X'0440A39640000000034070500000000003408050000000000440999783000000'
 DC X'034058F0000000000340F1F9000000000440F1F9F90000000640F1F9F9F54000'
 DC X'04404110D00000000540E4958182000004404D95A400000003407E4000000000'
 DC X'04407E406C000000034089950000000002411000000000000241700000000000'
 DC X'024150000000000002410000000000000241200000000000E0A0B07565A85400'
 DC X'0241F00000000000024160000000000002414000000000000241800000000000'
 DC X'024130000000000002419000000000000241E000000000000241A00000000000'
 DC X'0241B00000000000024175000000000004416570000000000241A80000000000'
 DC X'0341546000000000034110D000000000034110D200000000034110D100000000'
 DC X'034110D40000000003411011000000000000000000000000034110D300000000'
 DC X'034110DF00000000034110D600000000034110DD00000000054110F0F0F10000'
 DC X'044110D8E8000000044110D0A8000000044110D098000000044110D0B0000000'
 DC X'074110D09058F031064110D0A058F0000000000000000000064110D094501000'
 DC X'064110D07858F000054110D0A8580000064110D0A858F000074110D0A858F032'
 DC X'064110D09858F000054110D0B0580000064110D0B058F000074110D21058F03F'
 DC X'074110D2A858F03A044110D218000000064110D2C058F000044110D100000000'
 DC X'064110D1E858F000064110D1A058F000054110D100580000064110D10058F000'
 DC X'044110D410000000074110D40858F036064110D41058F0000441101100000000'
 DC X'0541101100DD00000641101100DDFF000741101100DDFF10ACCD00DDFF100003'
 DC X'ACEFDDFF10002004ACF0FF1000200005ACF1100020004706ACF2002000478007'
 DC X'064110D32858F0000341700000000000034170D1000000000341704000000000'
 DC X'034170D000000000034170F00000000000000000000000000341703F00000000'
 DC X'03417080000000000341704200000000034170D3000000000441700000000000'
 DC X'0441700001000000044170000900000004417000080000000541700000500000'
 DC X'064170000050700007417000005070D0044170F0F0000000064170F0F0F1F700'
 DC X'064170F0F0F0F2000341500000000000034150D0000000000341505000000000'
 DC X'034150D100000000054150F0F0F1000000000000000000000341504100000000'
 DC X'0441500000000000044150000100000005415000705900000541500000500000'
 DC X'0641500000505000AD0D005050D0F80307415000015A50D0064150D0B0505000'
 DC X'064150D0D4505000044150D0D8000000064150D098505000034100D000000000'
 DC X'0341000000000000034100D300000000074100010019F047034100D200000000'
 DC X'0000000000000000034100D100000000044100F034000000044100D0BC000000'
 DC X'04410000010000000641000000500000054100D3D41500000341200000000000'
 DC X'034120D000000000044120000100000004412000030000000541200001500000'
 DC X'06412000015020000341F000000000000341F0E0000000000341F01000000000'
 DC X'0441F0D0B40000000441F0F0010000000741F0000047F0300341600000000000'
 DC X'034160D000000000044160402800000004416000000000000641600001412000'
 DC X'07416000005060D20341400000000000054140403C500000034140D100000000'
 DC X'044140000100000004414000030000000341800000000000054180F0F0F00000'
 DC X'0441800000000000044180000100000003413000000000000341900000000000'
 DC X'04419000080000000341E0F0000000000441E0001C0000000341A00000000000'
 DC X'0341B000000000000641B000AD18F70002425800000000000242400000000000'
 DC X'0342419000000000034258F00000000004425880300000000642404000384000'
 DC X'0243700000000000024350000000000002438000000000000243400000000000'
 DC X'034390C000000000024400000000000002444000000000000244580000000000'
 DC X'0244500000000000024447000000000000000000000000000244BF0000000000'
 DC X'024470000000000002444100000000000444D203F00000000244F00000000000'
 DC X'0344920800000000034400C100000000044400F0F0000000044400C1B8000000'
 DC X'044400C1B0000000054400C1B8580000064400C1B858D000074400C1B858D0D0'
 DC X'AD65B858D0D00403AD6B0458E0D00C07AD6AD004F0F0F006054400C1B0580000'
 DC X'064400C1B0587000034440400000000004444040000000000344586000000000'
 DC X'034458700000000004445860F000000005445860F0F0000006445860F0F0F000'
 DC X'034450400000000003444770000000000444BF5F500000000245E00000000000'
 DC X'02454000000000000345E0F0000000000645E0F0F0F0F0000546404000380000'
 DC X'044605EF50000000024647000000000004465050100000000247800000000000'
 DC X'0247F00000000000024770000000000002470000000000000247400000000000'
 DC X'00000000000000000247D000000000000247B000000000000247200000000000'
 DC X'0247E00000000000024710000000000003478031000000000347803500000000'
 DC X'034780320000000003478033000000000347803000000000383A3B3F373C2043'
 DC X'0347803E00000000034780360000000003478039000000000347803400000000'
 DC X'0347803D00000000034780F00000000003478038000000000347803A00000000'
 DC X'0347803B000000000647803F0049400003478037000000000347803C00000000'
 DC X'034780200000000003478043000000000000000000000000034780C300000000'
 DC X'034780C600000000034780910000000004478031B400000005478031B4490000'
 DC X'06478031B449700007478031B4497033044780359C000000054780359C490000'
 DC X'064780359C494000074780359C494037064780320258700005478032A2BF0000'
 DC X'06478033CCD2030005478033885800000447803648000000074780362849603A'
 DC X'074780364849603F04478039B2000000044780394200000007478039B249603F'
 DC X'044780F0F0000000054780F0F0F00000074780F0F0F0F3F1054780387C580000'
 DC X'0547803AE64700000347F032000000000347F0F0000000000347F03100000000'
 DC X'0347F033000000000347F030000000003B353C3A384A40C00347F03D00000000'
 DC X'0347F03E000000000347F034000000000347F036000000000347F03700000000'
 DC X'0347F03F000000000347F03B000000000347F035000000000347F03C00000000'
 DC X'0347F03A000000000347F038000000000547F04A380700000347F04000000000'
 DC X'0347F0C00000000000000000000000000547F0B1319400000447F03210000000'
 DC X'0747F03210D203400447F0F0F00000000747F0F0284040400547F0F0F0F00000'
 DC X'0547F0F0F0F10000ADBEF0F0F0F0F4030447F03E720000000547F03E72470000'
 DC X'0647F03E7247F0000747F03E7247F03F03477030000000000347703400000000'
 DC X'0347703200000000034770330000000003477031000000003A39C20000000000'
 DC X'03477036000000000347703700000000064770F0F0F0F200034770CB00000000'
 DC X'034770350000000005477041BC5000000447703A3C000000044770393C000000'
 DC X'044770C24C00000004477030AE0000000347000000000000034700F000000000'
 DC X'0447000000000000044700000800000005470000005800000547000000D20000'
 DC X'05470000004100000547000000D7000005470000004700000000000000000000'
 DC X'074700000049503607470000004400C107470000000700F00547000000500000'
 DC X'06470000005840000647000000587000064700000058F0000647000000585000'
 DC X'06470000005860000000000000000000ADEE005880D0880307470000005840D0'
 DC X'07470000005870D007470000005850D00647000000D203000747000000D203D0'
 DC X'064700000041700007470000004170D00647000000D70300064700000047F000'
 DC X'044700F0F0000000034740300000000005474036581B0000054740351C1B0000'
 DC X'0547D03138F00000034720F000000000064720F01E58F0000248580000000000'
 DC X'0248400000000000024850000000000002480000000000000248900000000000'
 DC X'201049300D000000024841000000000002480500000000000248700000000000'
 DC X'064892102000500002484700000000000248F000000000000248200000000000'
 DC X'02481000000000000248490000000000024830000000000003480D0000000000'
 DC X'0348585000000000044858707000000003484040000000000748404040404040'
 DC X'07484040003840400548000014900000034890F000000000AE2A204892102003'
 DC X'034805EF00000000034847700000000002496000000000000249400000000000'
 DC X'0249700000000000024990000000000002491000000000000000000000000000'
 DC X'0449F035B60000000349603F000000000349603A000000000349403F00000000'
 DC X'0349703E000000000349903200000000024A700000000000024A4A0000000000'
 DC X'024A300000000000024A500000000000044A404000000000034A703F00000000'
 DC X'034A4A4A00000000024B4B0000000000024B610000000000024B150000000000'
 DC X'024B100000000000024B7000000000000000000000000000024BF00000000000'
 DC X'024BF80000000000044B903FDA000000024B400000000000044B00E2E3000000'
 DC X'034B4B6100000000044B4B614B000000064B4B61A2998300054B4B614B4B0000'
 DC X'064B4B614B4B6100AE4D4B614B4B6104034B614B00000000044B614B4B000000'
 DC X'054B614B4B610000AE53614B4B61A204034B150000000000054B150040400000'
 DC X'024C500000000000064C6C846E150000024C410000000000024C400000000000'
 DC X'024C5800000000000000000000000000024C000000000000024C180000000000'
 DC X'024C470000000000024CBF0000000000044CD203D0000000054C5020D1240000'
 DC X'034C404000000000054C404000380000044C181405000000024DE00000000000'
 DC X'024DF20000000000024D5D0000000000024DD50000000000044D958186000000'
 DC X'0000000000000000034DF15D00000000034DE0F000000000024E400000000000'
 DC X'024E050000000000044E47F034000000044ED203D1000000034E404000000000'
 DC X'044E404000000000054E404000380000064E404000384000074E404000384040'
 DC X'AE73003840400003AE74384040000104034E05EF00000000064E05EF00000000'
 DC X'024F400000000000025000000000000002507000000000000250500000000000'
 DC X'0250D000000000000250600000000000C3A090B004E0D2D10250400000000000'
 DC X'0250F00000000000025020000000000002508000000000000250300000000000'
 DC X'02501000000000000250C300000000000250A000000000000250900000000000'
 DC X'0250B0000000000002500400000000000250E000000000000250D20000000000'
 DC X'0250D10000000000D314620C28D4353E025041000000000002503F0000000000'
 DC X'02503A0000000000025008000000000002500F00000000000250180000000000'
 DC X'0250D300000000000250140000000000025062000000000002500C0000000000'
 DC X'02502800000000000250D40000000000025035000000000002503E0000000000'
 DC X'138458363454000002503200000000000250C0000000000002502C0000000000'
 DC X'0250D80000000000025006000000000002504F00000000000250130000000000'
 DC X'045084D203000000025058000000000002503600000000000250340000000000'
 DC X'0450545850000000035000D400000000035000D100000000035000D000000000'
 DC X'035000D20000000003500000000000000105DFE0700000000350005800000000'
 DC X'0350004100000000035000470000000003500060000000000350000200000000'
 DC X'035000500000000003500001000000000350000500000000035000DF00000000'
 DC X'055000E04C9200000450007059000000045000D410000000075000D41C4110F0'
 DC X'045000D428000000045000D170000000045000D1D8000000055000D0F0D20000'
 DC X'045000D203000000065000D203D10C0004500000500000000650000000000000'
 DC X'05500000505000000750000050506014045000585000000004500058F0000000'
 DC X'0550005840D0000004500041100000000550004110D100000450004780000000'
 DC X'045000600000000007500060001A581A06500060000000000450005000000000'
 DC X'035070D000000000035070D100000000035070D200000000035070D600000000'
 DC X'035070D3000000000000000000000000035070D5000000000650700050506000'
 DC X'035070DD000000000550705000F00000045070D09C000000045070D0E8000000'
 DC X'055070D0FCD20000055070D0E0580000045070D12C000000065070D158588000'
 DC X'045070D134000000055070D128410000045070D24C000000035050D000000000'
 DC X'035050D100000000035050D200000000035050D4000000000350500000000000'
 DC X'080000000000000003505020000000000350506000000000035050D300000000'
 DC X'0350505000000000035050100000000004505014580000000450500895000000'
 DC X'045050D0A4000000045050D0BC000000045050D0B80000000450500050000000'
 DC X'04505060000000000350D088000000000350D098000000000350D0B000000000'
 DC X'0350D094000000000350D0B800000000D8C0BC00000000000350D0E400000000'
 DC X'0350D0A0000000000350D09C000000000650D0200418D2000350D09000000000'
 DC X'0550D0A8D20300000450D0D8470000000450D0C0500000000450D0BC47000000'
 DC X'0450D088580000000450D088D20000000550D088414000000550D08858500000'
 DC X'0650D08858505000AF08505004D703040550D088D20300000450D09850000000'
 DC X'0650D098F0F0F1000550D09850500000035060D0000000000350600000000000'
 DC X'035060D400000000035060D20000000003506004000000000000000000000000'
 DC X'0350601000000000035060D1000000000350600C00000000035060F000000000'
 DC X'055060D410F0000004506010080000000650600C47803700035040D000000000'
 DC X'0350404000000000035040F0000000000350401000000000035040D400000000'
 DC X'00000000000000000350405000000000035040D1000000000350408600000000'
 DC X'045040D094000000045040400000000005504040003800000650404000384000'
 DC X'0750404000384040AF20003840400003045040F0F0000000055040F0F0F00000'
 DC X'AF21F0F0F0F0F1030350F0D0000000000350F0F0000000000350F0D100000000'
 DC X'0350F040000000000350F0D2000000000450F0D0B00000000550F0D0C4D20000'
 DC X'0550F0D0944700000450F0F0F00000000450F0F0F10000000550F0F0F0F00000'
 DC X'0550F0F0F1F600000650F0F0F1F0F900035020D100000000035020D000000000'
 DC X'035020D200000000055020D64CF00000055020F0F0F000000000000000000000'
 DC X'035020D300000000055020D0C0410000035080D000000000035080D300000000'
 DC X'035080D1000000000350800800000000055080D0A8410000045080D38C000000'
 DC X'0350301000000000035030D000000000035030D200000000055030B5D4580000'
 DC X'0450301000000000065030100458F0000650301014583000035010D000000000'
 DC X'035010DF00000000065010F0F0F1F200035010D100000000035010D200000000'
 DC X'0350C344000000000450C344D20000000450C344BF0000000450C34458000000'
 DC X'0650C3445050D1000550C344D20300000650C344D203D1000550C344BF5F0000'
 DC X'AF5A5F50004780040750C344585050000350A0D2000000000350A0DD00000000'
 DC X'035090D0000000000350B0D2000000000350B0D3000000000350E0D000000000'
 DC X'0550D203D4080000035041100000000003501441000000000450144110000000'
 DC X'0350622C00000000035028D20000000004514458500000000251180000000000'
 DC X'02524000000000000252580000000000025241000000000002521B0000000000'
 DC X'045247F030000000075240400038404002544000000000000254000000000000'
 DC X'0254500000000000025470000000000002544100000000000000000000000000'
 DC X'045447803D000000025490000000000004543024200000000254580000000000'
 DC X'0254F00000000000035405EF0000000003544040000000000454404000000000'
 DC X'AF82003840400003035400000000000005540001000100000554000000000000'
 DC X'0454414000000000025500000000000002557000000000000255500000000000'
 DC X'02554700000000000255BF000000000000000000000000000255600000000000'
 DC X'0455435070000000035540D0000000000355103D00000000035500C000000000'
 DC X'035500D000000000045500C00C000000055500C00C470000065500C00C472000'
 DC X'075500C00C4720F0AF982C58F0D04807AF9620F01E58F005AF9620F03058F005'
 DC X'AF954720F0245804065570800C417000035570D0000000000355477000000000'
 DC X'0555BF53F0F000000656404000384000025605000000000003561B7700000000'
 DC X'0258F00000000000025870000000000002585000000000000258400000000000'
 DC X'0258200000000000A09030D0B08558FF02586000000000000258800000000000'
 DC X'0258750000000000025800000000000002581000000000000258E00000000000'
 DC X'0258A00000000000025890000000000002583000000000000258D00000000000'
 DC X'0258B00000000000025885000000000002585800000000000258FF0000000000'
 DC X'00000000000000000258C000000000000258410000000000045805EF58000000'
 DC X'035811000000000003585D5A000000000358F0D0000000000358F03F00000000'
 DC X'0358F0C0000000000358F034000000000358F035000000003E303A203C3D333B'
 DC X'0358F0F0000000000358F036000000000358F038000000000358F03200000000'
 DC X'0358F039000000000358F031000000000358F03E000000000358F03000000000'
 DC X'0358F03A000000000358F020000000000358F03C000000000358F03D00000000'
 DC X'0358F033000000000358F03B0000000063230000000000000358F0C300000000'
 DC X'0358F037000000000358F070000000000358F060000000000358F04B00000000'
 DC X'0358F024000000000358F063000000000358F023000000000458F0D048000000'
 DC X'0458F0D0900000000558F0D0889200000558F0D0489000000658F0D04890F000'
 DC X'0758F0D04890F020AFBE4890F0204803AFDB90F020489204AFDEF02048921005'
 DC X'AFDF204892102006AFE0489210200007AFE1921020005008AFE210200050D009'
 DC X'AFE3200050D0200AAFE40050D020040BAFE550D02004180CAFE6D0200418D20D'
 DC X'AFE7200418D2050EAFE80418D205300FAFED5010D0884414AFE918D205305810'
 DC X'AFEAD205305840110758F03FAE05EF500458F03F500000000558F03F56050000'
 DC X'0458F0C0740000000558F0C0740700000658F0C07407FF000758F0C07407FF90'
 DC X'AFF7E8D00C582007AFF7E5D00C582007AFF5FF90E7D00C05AFF5FF90EBD00C05'
 DC X'0458F034540000000558F035D00500000458F0F0F00000000458F0F0F1000000'
 DC X'0558F0F00C5800000558F0F0F0F000000658F0F0F0F0F0000558F03640050000'
 DC X'0558F03E3E0500000758F0200058E0F0035870D0000000000358703F00000000'
 DC X'03587070000000000358703E00000000035870F0000000003837208039610000'
 DC X'0358703400000000035870D10000000003587035000000000358703600000000'
 DC X'03587060000000000558703198580000035870380000000005587037AC550000'
 DC X'0358702000000000055870800458000004587039C4000000045870610C000000'
 DC X'045870D088000000045870D094000000045870D090000000065870D0BC418000'
 DC X'055870D0A84B0000055870D088D20000055870D088580000075870D088BF7F70'
 DC X'065870D088D20300075870D088D203D0075870D088D203D1065870D088587000'
 DC X'075870D088587070B01858707008D704B0185870700C5804065870D094D20300'
 DC X'065870D09458700004587070000000000558707010590000045870F0F0000000'
 DC X'075870F0F0F0F0F9035850D0000000000358503F00000000035850F000000000'
 DC X'03585050000000000358503E000000003A000000000000000358503500000000'
 DC X'0358506000000000035850400000000005585038D05A0000055850510CD20000'
 DC X'0358503B000000000458503AB0000000045850D088000000045850D090000000'
 DC X'055850D0A8D20000055850D088580000055850D088D20000075850D088414060'
 DC X'065850D088585000065850D088586000075850D088585050B02D885850500003'
 DC X'B02D885850501403B03A585050005804065850D088D20300075850D088D203D1'
 DC X'075850D088D203D0045850F0F0000000055850F000500000055850F0F0F00000'
 DC X'055850F0F0F10000035840D0000000000358404000000000045840302C000000'
 DC X'045840F0F0000000045840D088000000045840D0A0000000055840D088580000'
 DC X'055840D088D20000065840D088584000075840D088584040B04D885840400003'
 DC X'065840D088D20300075840D088D203D004584040000000000558404000380000'
 DC X'06584040003840000758404000384040B04E003840400003B05A384040000104'
 DC X'B05A384040000204035820D000000000065820F0F0F0F0000358202000000000'
 DC X'03582090000000000358203F0000000000000000000000000358205000000000'
 DC X'045820D04C000000065820D078586000055820D04C410000065820D04C410000'
 DC X'075820D04C410020B0614C4100244803035860D0000000000358606000000000'
 DC X'0358605000000000035860D10000000003586032000000000000000000000000'
 DC X'0358602000000000045860340E00000004586035D0000000045860D088000000'
 DC X'055860D088580000055860D088D20000065860D088586000075860D088586060'
 DC X'B06E885860600003065860D088D20300075860D088D203D40458606000000000'
 DC X'035880D0000000000358808000000000035880F0000000000358807000000000'
 DC X'045880D088000000045880D090000000045880D098000000055880D094400000'
 DC X'055880D088580000B08880800458700506588080144170000358757000000000'
 DC X'055875F0F0F00000045875700000000005587570005000000558757000120000'
 DC X'0758757000F0F0F00658757000BF7F00065875700050700007587570005070D1'
 DC X'07587570005070D0B08B005070D32003B08B005070D198030658757000127700'
 DC X'0758757000127747B08F77F0F0F1F005B08B001277478003B08D127747703204'
 DC X'B08D1277478033040358000000000000035800F0000000000358003400000000'
 DC X'035800D000000000065800F0101E0200035810D000000000035810F000000000'
 DC X'03581010000000000358102000000000045810D088000000075810D088D207D1'
 DC X'045810F0F0000000055810F0F0F000000358E0D0000000000358E02000000000'
 DC X'0458E0D00C0000000558E0D00C9800000358A0D0000000000558A0C344410000'
 DC X'035890D0000000000358909000000000065890D088589000035830D000000000'
 DC X'0358D0D0000000000458D0D004000000B0B558E0D00C9804B0B4041BFF58E003'
 DC X'0358B0D000000000065885700058F00005588580005800000358587000000000'
 DC X'0358FF0000000000B0BC1007FF0C0B0302590000000000000259500000000000'
 DC X'02597000000000000259F000000000000259A000000000000000000000000000'
 DC X'035964F000000000035940D000000000035960F000000000035900F000000000'
 DC X'075900D3E0478033045900F00C000000055900F00C470000065900F00C478000'
 DC X'B0C70C4780348803035950D000000000065950600C478000055950D09C470000'
 DC X'055970D090470000025A500000000000025A600000000000025A400000000000'
 DC X'025A000000000000025A1000000000000000000000000000025A580000000000'
 DC X'045AF0F0F0000000035A50C300000000045A50C344000000055A50C344D20000'
 DC X'055A50C344BF0000055A50C344580000075A50C3445050D2075A50C3441B0096'
 DC X'065A50C344D20300075A50C344D203D1065A50C344BF5F00B0DC5F5000478005'
 DC X'B0DA586050005804035A60C300000000045A60C344000000055A60C344580000'
 DC X'065A60C344415000035A404000000000065A40C344504000B0E9003840400003'
 DC X'025B5B0000000000045B93A740000000025BA20000000000045B47808C000000'
 DC X'035B404000000000025C400000000000025C000000000000025C500000000000'
 DC X'025C580000000000025C5A0000000000035C404000000000045C404000000000'
 DC X'025D400000000000045D7A40F0000000035D004000000000065D40C3D6D4D700'
 DC X'025E400000000000025E500000000000025E700000000000025E300000000000'
 DC X'025E4100000000000000000000000000045EE0CAA4000000035E404000000000'
 DC X'045E404000000000055E404000380000065E404000384000075E404000384040'
 DC X'B103003840400003B104384040000104025F500000000000025FD00000000000'
 DC X'065F58F0C31C1800045FF0F0F0000000035F500000000000045F500047000000'
 DC X'02600000000000000260D0000000000002604000000000000260600000000000'
 DC X'0260F0000000000047C314320570102202603F00000000000260040000000000'
 DC X'026050000000000002600800000000000260D200000000000260580000000000'
 DC X'02604700000000000260C3000000000002601400000000000260320000000000'
 DC X'0260050000000000026070000000000002601000000000000260220000000000'
 DC X'33D40B6E3431F102026018000000000002603E00000000000260010000000000'
 DC X'0260D30000000000026036000000000002600C00000000000260330000000000'
 DC X'0260D4000000000002600B000000000004606EA4A20000000260340000000000'
 DC X'02603100000000000260F1000000000002600200000000000000000000000000'
 DC X'0360B29400000000036000000000000003600058000000000660004160D0DC00'
 DC X'0360004900000000036000180000000000000000000000000360002000000000'
 DC X'036000D20000000003600050000000000360000300000000B135D26F50006003'
 DC X'046000585000000004600058600000000560005850D000000760005850D08858'
 DC X'0360D088000000000360D09C000000000360D0CC000000000360D09000000000'
 DC X'0460D09C580000000360404000000000056040D7999600000460404000000000'
 DC X'056040400038000006604040003840000760404000384040B149003840400003'
 DC X'B14B384040000104036060000000000003606040000000000460600058000000'
 DC X'076060005860601406606040999783000360F0F0000000000660F00C47803200'
 DC X'0460F0F0F00000000560F0F0F0F00000B156F0F0F3F0F1030460045870000000'
 DC X'04600447F0000000036050000000000003605870000000000360477000000000'
 DC X'0360C344000000000660C34458503A0003601441000000000460144150000000'
 DC X'036005EF00000000046001504000000002614B00000000000261840000000000'
 DC X'0261A2000000000004619389820000000461C3A8830000000000000000000000'
 DC X'026192000000000003614B4B0000000004614B4B610000000262580000000000'
 DC X'0262410000000000026400000000000002645800000000000264700000000000'
 DC X'0564404000380000026450000000000003640000000000000266400000000000'
 DC X'0266430000000000026641000000000002664700000000000366D20300000000'
 DC X'0366404000000000B17C00384040000302674700000000000367497000000000'
 DC X'0268000000000000026841000000000002684000000000000268500000000000'
 DC X'05681B7847B0000000000000000000000468F0F0F000000004685570D0000000'
 DC X'046812FF500000000368D20300000000036835C2000000000368000000000000'
 DC X'056800000504000003684040000000000668404000384000026A410000000000'
 DC X'026A400000000000026A580000000000026A470000000000046A41F000000000'
 DC X'026B400000000000026BF10000000000056B40D5D6C20000036B409900000000'
 DC X'056B40F1F9F90000026C840000000000026CA20000000000026C6C0000000000'
 DC X'026C930000000000026C0000000000000000000000000000026C580000000000'
 DC X'026C400000000000026C500000000000026C470000000000026C970000000000'
 DC X'036CF15B00000000046C846E4B000000046C846B40000000036CA26B00000000'
 DC X'056CA26E40D30000066C6C6C6C6C6C00036C93A700000000036C404000000000'
 DC X'046C404000000000026D890000000000026D850000000000026D810000000000'
 DC X'026D830000000000026D950000000000A28487A394000000026DD60000000000'
 DC X'026DA40000000000026D970000000000026D990000000000026DC30000000000'
 DC X'026D860000000000046DA28599000000026D840000000000046D8785F0000000'
 DC X'046DA3966D000000036D948700000000036D899500000000066D8995986D9500'
 DC X'056D8593A36D0000056D8183936D0000056D839396830000056D9585A7A30000'
 DC X'036DD6D500000000056DA4A389930000026E400000000000026E410000000000'
 DC X'036E150000000000036E404000000000046E404000000000B1CA384040000104'
 DC X'026FD2000000000002700000000000000270D000000000000270D10000000000'
 DC X'0270F0000000000002708000000000003250080C34703E300270330000000000'
 DC X'02703F0000000000027004000000000002703600000000000270D20000000000'
 DC X'0270400000000000027032000000000002705000000000000270080000000000'
 DC X'02700C00000000000270340000000000027070000000000002703E0000000000'
 DC X'0270300000000000184737903A60D6D302704100000000000270310000000000'
 DC X'0270D5000000000002703B000000000002703500000000000270420000000000'
 DC X'0270180000000000027047000000000002703700000000000270900000000000'
 DC X'02703A000000000002706000000000000270D600000000000270D30000000000'
 DC X'3DB2C7DF140000000270580000000000027039000000000004700D0022000000'
 DC X'02703C00000000000270430000000000027005000000000002703D0000000000'
 DC X'0270B200000000000370C746000000000370DFAC000000000370148800000000'
 DC X'0370005000000000037000000000000003700012000000000370004100000000'
 DC X'037000D2000000001D0270950000000003700058000000000370008000000000'
 DC X'0370000100000000067000075570800003700008000000000370004700000000'
 DC X'0370001D00000000037000020000000004700070000000000470009500000000'
 DC X'04700050700000000670005010D088000570005070D100000570005070D00000'
 DC X'047000005000000004700000000000000570000050700000077000005070D0B0'
 DC X'0470001277000000057000127747000006700012774780000770001277478031'
 DC X'B1FE77478030A803B1FE77478033C4030470004110000000047000D203000000'
 DC X'057000D203D000000670005880D0880005700058707000000670008000587000'
 DC X'0670000147D03C0005700008589000000370D088000000000370D09000000000'
 DC X'0370D098000000000370D094000000000370D0A4000000000000000000000000'
 DC X'0370D0E8000000000370D09C000000000370D0B8000000000470D0BC47000000'
 DC X'0470D088580000000670D088D203D2000570D088587000000670D08858707000'
 DC X'B22C70700C5870040470D090580000000570D098507000000370D10800000000'
 DC X'0370D134000000000470D104410000000370F0F0000000000470F0F0F0000000'
 DC X'0470F0F0F10000000570F0F0F0F000000770F0F0F0F2F2F10670F0F0F0F0F000'
 DC X'0570F0F0F1F400000370800C0000000005708000589000000470800C41000000'
 DC X'0570800C41700000037004410000000003700447000000000470044110000000'
 DC X'0470367C580000000370D203000000000570D270417000000570D203D1740000'
 DC X'037040400000000004704040000000000570404000380000B24A404000010005'
 DC X'0670085870D0880004700C587000000003707000000000000570315450200000'
 DC X'037035FE00000000057247F03E72000005724040003800000274400000000000'
 DC X'0274070000000000027447000000000002745800000000000274410000000000'
 DC X'0000000000000000027450000000000003744040000000000474404000000000'
 DC X'037407FF00000000047407FF90000000037447F0000000000275700000000000'
 DC X'0275800000000000037570000000000004757000500000000675700012774700'
 DC X'05757000F0F0000005757000507000000575800047800000037641F000000000'
 DC X'0277BF000000000002775000000000000677067047D033000277430000000000'
 DC X'02774700000000000377BF73000000000477BF73800000000577BF73D0920000'
 DC X'0377507000000000037743700000000003774780000000000278000000000000'
 DC X'027840000000000002785800000000000278D200000000000278470000000000'
 DC X'000000000000000002785000000000000278180000000000057805EF12FF0000'
 DC X'04781A85F0000000047844703B00000003780000000000000478000000000000'
 DC X'0378404000000000047840400000000006784040404040000578404000380000'
 DC X'06784040003840000778404000384040B280003840400003B281384040000104'
 DC X'0378588000000000037858F00000000003785870000000000378D20300000000'
 DC X'027A400000000000027A000000000000027AF00000000000027A580000000000'
 DC X'047AF5F57A000000037A404000000000B291003840400003037AF0F100000000'
 DC X'027C400000000000027C000000000000027C410000000000027CE20000000000'
 DC X'027C580000000000037C404000000000047C404000000000B299003840400003'
 DC X'027E400000000000027EF00000000000047E4C6C84000000047E5850D0000000'
 DC X'047EF15D400000000000000000000000037E00F000000000037E406C00000000'
 DC X'057E404000380000037EF0A700000000047EF0A76C000000027F700000000000'
 DC X'027FD00000000000057F70004770000002800000000000000280D00000000000'
 DC X'028040000000000002803400000000000280300000000000040C393836584137'
 DC X'028031000000000002808000000000000280F000000000000280350000000000'
 DC X'02803300000000000280320000000000028004000000000002800C0000000000'
 DC X'0280390000000000028038000000000002803600000000000280580000000000'
 DC X'02804100000000000280370000000000103BD4C29018D2050280D10000000000'
 DC X'02803F00000000000280B0000000000002807000000000000280500000000000'
 DC X'0280140000000000028010000000000002803B00000000000280D40000000000'
 DC X'0280C20000000000028090000000000002801800000000000580D203D1D00000'
 DC X'02800500000000000A20910000000000028008000000000002803C0000000000'
 DC X'028047000000000002803E00000000000280D300000000000280600000000000'
 DC X'03800A8800000000038020DE00000000038091F6000000000380000000000000'
 DC X'0380005800000000038000200000000003800002000000000380004100000000'
 DC X'00000000000000000580005070D0000005800040404000000480000001000000'
 DC X'B2D700000000000307800000D26F700005800000587000000580000001000000'
 DC X'04800058800000000480005870000000B2E48014417000040480002000000000'
 DC X'0580002000000000078000200000245004800002580000000380D08800000000'
 DC X'0380D0A8000000000480D088580000000580D088417000000580D08858800000'
 DC X'0680D08858808000038040400000000004804000000000000480404000000000'
 DC X'058040400038000006804040003840000780404000384040B2F1003840400003'
 DC X'B2F33840400001040380342E000000000380346C000000000380800000000000'
 DC X'04808014410000000380F0F0000000000480F0F0F00000000580F0F0F1F00000'
 DC X'0580F0F0F0F10000038004580000000006800458903FDE0005800C4170000000'
 DC X'03803648000000000580371A586000000281A300000000000281930000000000'
 DC X'0281950000000000028183000000000002819900000000000000000000000000'
 DC X'028182000000000002819400000000000281A20000000000048184846D000000'
 DC X'0381A385000000000381A381000000000381A389000000000681A38599898100'
 DC X'0481A389960000000581A389969500000681A389969540000381939300000000'
 DC X'0381934000000000058193A4857E000006819393404040000681939396838100'
 DC X'0581959596A30000038195400000000004819995890000000581829385400000'
 DC X'0481820040000000038194850000000002829300000000000282850000000000'
 DC X'0282410000000000048200000000000002825800000000000000000000000000'
 DC X'028296000000000003829385000000000682938540A3960002836D0000000000'
 DC X'0283A30000000000028385000000000002838100000000000283960000000000'
 DC X'6184400000000000028393000000000002839900000000000283920000000000'
 DC X'028300000000000002838800000000000283A400000000000283610000000000'
 DC X'048384A2C3000000048340404000000005836D948794000004836DF0F0000000'
 DC X'0683A389969540000683A3858440D9000483A340A6000000048385F0F0000000'
 DC X'04838595A2000000038381A30000000005839684854B00000483936DA2000000'
 DC X'0383998500000000048300404000000002844000000000000284890000000000'
 DC X'028485000000000002840000000000000284A20000000000A493059700000000'
 DC X'0284990000000000028441000000000002846D00000000000284840000000000'
 DC X'028458000000000002840700000000000284A400000000000484938540000000'
 DC X'038405EF00000000038497850000000003844040000000000484404000000000'
 DC X'07844040404040F0068440400038400005848999858300000584858396840000'
 DC X'03840000000000000484996D8600000005844110F0F000000285990000000000'
 DC X'028540000000000002858400000000000285A200000000000285950000000000'
 DC X'8180A785F0C3D5000285A3000000000002858300000000000285930000000000'
 DC X'028594000000000002856D000000000002859700000000000285810000000000'
 DC X'05858000588000000285A7000000000002858500000000000485F0F0F0000000'
 DC X'0285C300000000000385D581000000000385994000000000038599A200000000'
 DC X'0685999996994000038599A5000000000385996D00000000068599A240D98500'
 DC X'048540958100000003858440000000000585848595A3000004858440D1000000'
 DC X'068584404040400005858440D48100000385A285000000000385A2A300000000'
 DC X'0385A2A2000000000485A240810000000685A28599A585000485A2A399000000'
 DC X'038595A3000000000385958300000000048595A340000000B38440E4A2859903'
 DC X'048595839600000005859583968400000385A385000000000785A3A499954D84'
 DC X'0385A34000000000038583A300000000068583A49989A3000385836D00000000'
 DC X'058593A36D89000005859385A385000003859496000000000385818400000000'
 DC X'0286400000000000028600000000000002864700000000000286810000000000'
 DC X'0286860000000000000000000000000002869900000000000486202212000000'
 DC X'0286580000000000048685994000000002868900000000000386938100000000'
 DC X'03864040000000000486404000000000B3A13840400001040386000000000000'
 DC X'04860000000000000486000001000000038647F000000000048647F0F0000000'
 DC X'078647F0F02840400586818993A4000005868685994000000287880000000000'
 DC X'02878500000000000487A86D9700000002874000000000000287990000000000'
 DC X'00000000000000000487966D870000000387958900000000038788A300000000'
 DC X'048788A3A2000000058788A3A2400000038785A300000000048785A36D000000'
 DC X'02885800000000000288D2000000000002884000000000000288000000000000'
 DC X'0288410000000000854389BF18D06D0002885000000000000288470000000000'
 DC X'0288A30000000000028881000000000005884400C1B000000288F00000000000'
 DC X'0288850000000000058843807000000002888900000000000488BF7F70000000'
 DC X'02881800000000000388D0A80000000003886DA3000000000388585000000000'
 DC X'03885870000000000388586000000000058858F0F0F000000488588080000000'
 DC X'0488585050000000058858505000000006885850500058000488587070000000'
 DC X'04885860600000000388D203000000000488D203D00000000488D203D1000000'
 DC X'0688D203D0904000038840400000000004884040000000000788404000384040'
 DC X'038800000000000004880000000000000588414002BD00000588A3A240D90000'
 DC X'03888195000000000388F0F00000000002899500000000000289930000000000'
 DC X'02898700000000000289A2000000000002895000000000008460709910200000'
 DC X'02899600000000000289A3000000000002898300000000000289F00000000000'
 DC X'0289A90000000000028985000000000002898400000000000289600000000000'
 DC X'0289700000000000048999857A00000004891000020000000489200014000000'
 DC X'03890000000000000389958700000000038995850000000005899584D4850000'
 DC X'058995A38599000004899540A200000004899587400000000389938500000000'
 DC X'0489938540000000038987880000000004898788A3000000B3FEA2406040F004'
 DC X'06898788A340C9000389A2A3000000000689A2839396A2000389500000000000'
 DC X'0489500002000000038996950000000004899695400000000589A38840C90000'
 DC X'0389F000000000000589A9854096000005896000048900000389700000000000'
 DC X'028A500000000000038A5A6000000000028BE00000000000038BE00000000000'
 DC X'028C400000000000028CD20000000000028C000000000000028C580000000000'
 DC X'038C404000000000048C404000000000038CD20300000000028E400000000000'
 DC X'028E410000000000038ED20300000000038E404000000000048E404000000000'
 DC X'058E404000380000068E404000384000078E404000384040B41A003840400003'
 DC X'B41B384040000104048FF0004100000002900000000000000290580000000000'
 DC X'0290500000000000029040000000000002904700000000003FEC37EBB0188010'
 DC X'02904100000000000290F000000000000290D000000000000290D20000000000'
 DC X'0290200000000000029004000000000002903F00000000000290EC0000000000'
 DC X'02903700000000000490EBD00C0000000290B000000000000290180000000000'
 DC X'039080C4000000000390104C0000000000000000000000000390D10400000000'
 DC X'039000000000000003900001000000000490000000000000039058F000000000'
 DC X'039050700000000004905050D000000004905070D00000000390404000000000'
 DC X'0490404000000000059040400038000006904040003840000790404000384040'
 DC X'B43F003840400003B4403840400001040590478030960000059047D035200000'
 DC X'0390477000000000039041100000000004904170000000000790F02048921020'
 DC X'0390F0F0000000000690F0F0F0F4F1000390D203000000000291800000000000'
 DC X'0291010000000000029140000000000002910200000000000291180000000000'
 DC X'0000000000000000039104800000000002924000000000000292100000000000'
 DC X'0292020000000000029299000000000002920000000000000000000000000000'
 DC X'0292080000000000049291D0140000000492F0F0F00000000292010000000000'
 DC X'039205EF000000000792404000384040079210200050D020049202D5C0000000'
 DC X'049202D164000000039299820000000005929982F5610000049208D17C000000'
 DC X'0293850000000000029393000000000002934000000000000293890000000000'
 DC X'0293A20000000000000000000000000002939600000000000293810000000000'
 DC X'0393A485000000000393854000000000039385840000000006938540C361F300'
 DC X'03939340000000000593934089950000059340D9898700000493408995000000'
 DC X'03938985000000000393A240000000000593A240604000000294400000000000'
 DC X'0294580000000000029485000000000002944100000000000294500000000000'
 DC X'000000000000000005948285994000000294BF00000000000494D203D1000000'
 DC X'0494A36D850000000494A4A38500000002948100000000000494000000000000'
 DC X'03944040000000000494404000000000059458F0D08800000394586000000000'
 DC X'05948595A3400000049485404C00000004945070D10000000295A30000000000'
 DC X'0295400000000000029500000000000002959600000000000295870000000000'
 DC X'848583816D5D02A5029501000000000002958900000000000295920000000000'
 DC X'029586000000000002959500000000000295A200000000000295840000000000'
 DC X'029585000000000002958300000000000595818293F0000002956D0000000000'
 DC X'02955D000000000002950200000000000295A500000000000000000000000000'
 DC X'049503D090000000029541000000000003959396000000000395A38500000000'
 DC X'0395A389000000000595A399898500000495A385990000000395404000000000'
 DC X'039500D0000000000395007000000000039596A300000000049596A340000000'
 DC X'0395874000000000039501D100000000069589A3898193000795929596A69540'
 DC X'03958696000000000595958583A3000002969900000000000296950000000000'
 DC X'0296400000000000029680000000000002968400000000008694879683F04781'
 DC X'0296A400000000000296A30000000000029697000000000002966D0000000000'
 DC X'0296890000000000029608000000000005968640C9C200000296940000000000'
 DC X'0296870000000000029696000000000002968300000000000496F0F0F0000000'
 DC X'0396470000000000039681F00000000003969940000000000396999700000000'
 DC X'03969994000000000596994040400000049699974B000000069699974B000000'
 DC X'069699974B40F10004969994810000000596999481A300000396954000000000'
 DC X'05969540D181000005969540869300000396404000000000B4D6003840400003'
 DC X'0396801000000000039684850000000004966DA68900000005968995A3850000'
 DC X'02979900000000000297830000000000029785000000000002976D0000000000'
 DC X'0297960000000000000000000000000002979300000000000297A30000000000'
 DC X'0497818392000000049787966D00000003979996000000000497998583000000'
 DC X'0397836D000000000697836D948794000597836D6D83000006978599A3A84000'
 DC X'0497856D8100000004976D859300000002985800000000000298400000000000'
 DC X'0298F00000000000029841000000000002980000000000001BEC550000000000'
 DC X'02985000000000000598E0D0C8470000029818000000000002980C0000000000'
 DC X'0298290000000000029847000000000002981B00000000000498ECD00C000000'
 DC X'0398550000000000039858F0000000000398588000000000059858F03FB80000'
 DC X'0398404000000000049840400000000006984040404040000598404000380000'
 DC X'06984040003840000798404000384040B500003840400003B501384040000204'
 DC X'B5013840400001040398F0F0000000000498F0F0080000000598F0F0F0F00000'
 DC X'0598F0F0084D00000698F0F0084DE0000798F0F0084DE0F0B50E104700000407'
 DC X'0398411000000000039841700000000005984110D1B000000398000000000000'
 DC X'0498000002000000049800000100000002998500000000000299400000000000'
 DC X'029989000000000002999600000000000299830000000000A382A4A595477EF0'
 DC X'0299A200000000000299810000000000029997000000000002996D0000000000'
 DC X'02999900000000000299A800000000000299A300000000000299820000000000'
 DC X'0299A400000000000499A5858400000002999500000000000299470000000000'
 DC X'03997E4C000000000399F0F00000000003998581000000000399858300000000'
 DC X'039985400000000006994040404040000499406CA20000000399899500000000'
 DC X'049989A388000000069989958740840003998361000000000699836199978300'
 DC X'0399A26D000000000399819400000000059997836D6D00000599974B40F10000'
 DC X'029A580000000000049A404000000000029C410000000000029C580000000000'
 DC X'029C400000000000029C470000000000029C0000000000000000000000000000'
 DC X'049C4800B4000000049C5040D2000000039C411000000000049C41F0D1000000'
 DC X'059C5860335C0000039C404000000000B545003840400003039C477000000000'
 DC X'029E400000000000049E414000000000039E05EF00000000079E404000384040'
 DC X'02A000000000000002A0D0000000000002A041000000000002A0400000000000'
 DC X'02A0580000000000954700000000000002A050000000000002A0040000000000'
 DC X'02A0F0000000000002A0D2000000000002A005000000000002A0D10000000000'
 DC X'02A095000000000003A047200000000003A000000000000003A0000100000000'
 DC X'05A000000000000005A0D094F0F0000003A041100000000004A04110D2000000'
 DC X'03A040400000000003A040000000000004A040400000000005A0404000380000'
 DC X'B563404000011B0503A058F00000000005A05000D703000005A0F0F0F0F00000'
 DC X'03A0D2030000000002A240000000000002A285000000000002A2A30000000000'
 DC X'02A26D000000000002A2D70000000000000000000000000002A2890000000000'
 DC X'02A26B000000000002A200000000000003A24B830000000005A240D985A20000'
 DC X'05A240838193000003A240840000000004A240400000000003A2859900000000'
 DC X'03A285840000000005A285836D99000006A28599A585990004A2858440000000'
 DC X'03A2A3990000000003A2D76D0000000002A385000000000002A3890000000000'
 DC X'02A340000000000002A396000000000002A36D0000000000F0A3000000000000'
 DC X'02A381000000000002A3A4000000000002A388000000000002A3990000000000'
 DC X'02A3A8000000000002A3A2000000000004A3F0F0F000000003A3A38500000000'
 DC X'03A385990000000003A385840000000007A38599898193A204A3858440000000'
 DC X'03A389960000000004A389958700000004A389969500000005A3899695400000'
 DC X'03A340810000000003A3966D0000000005A36D899598000005A36D85976D0000'
 DC X'05A381A3A4A2000003A3A4A20000000004A3A4999500000005A3A4A27EF00000'
 DC X'05A3888595A3000003A3A2400000000002A4A2000000000002A4990000000000'
 DC X'02A440000000000002A4D2000000000002A4A3000000000047898600F0830493'
 DC X'02A450000000000002A495000000000002A441000000000002A4940000000000'
 DC X'02A458000000000002A485000000000002A447000000000005A48984A2000000'
 DC X'05A486868599000002A400000000000002A4F0000000000002A4830000000000'
 DC X'03A404030000000003A493850000000003A4A2850000000003A4A24000000000'
 DC X'03A499850000000004A499854000000003A440400000000004A4404000000000'
 DC X'03A4D2030000000004A4D203D100000005A4D203DFA8000004A4A38540000000'
 DC X'03A495A30000000005A494828599000003A447F00000000004A4000100000000'
 DC X'03A4F0F00000000002A585000000000003A5A3E20000000003A5859900000000'
 DC X'02A641000000000002A640000000000002A658000000000004A6477040000000'
 DC X'03A641100000000002A715000000000004A76CF84B00000002A7400000000000'
 DC X'03A715000000000002A840000000000002A858000000000002A8410000000000'
 DC X'02A800000000000002A8D00000000000F00000000000000002A8A20000000000'
 DC X'02A8D2000000000002A861000000000002A850000000000003A895F000000000'
 DC X'03A805EF0000000003A8F0F00000000003A840400000000004A8404000000000'
 DC X'03A858F00000000005A85850D088000003A841100000000005A84110D0B00000'
 DC X'03A800000000000004A8D0A04100000002AA40000000000002AA470000000000'
 DC X'02AA41000000000002AA58000000000003AA40400000000004AA404000000000'
 DC X'B5E738404000010402AC50000000000002AC40000000000006AC000000000000'
 DC X'02AC41000000000002AC300000000000000000000000000002ACD00000000000'
 DC X'02AC18000000000003AC50200000000003AC40400000000004AC404000000000'
 DC X'07AC40400038404002AE58000000000004AE40400000000002AE470000000000'
 DC X'02B000000000000002B050000000000002B0D0000000000002B0400000000000'
 DC X'02B05800000000003536983D0000000002B047000000000002B0410000000000'
 DC X'02B0F0000000000002B030000000000002B0D4000000000002B0D20000000000'
 DC X'02B035000000000002B036000000000004B098ECD000000002B03D0000000000'
 DC X'03B000000000000003B000410000000004B000000000000004B0000004000000'
 DC X'05B00000015A000005B000000000000004B05070D100000003B0404000000000'
 DC X'04B040400000000005B040400038000006B040400038400007B0404000384040'
 DC X'B60F00384040000305B05840D088000003B047F00000000004B0417034000000'
 DC X'03B0F0F00000000004B109FFFF00000006B240400038400002B2470000000000'
 DC X'04B219020000000002B241000000000002B440000000000002B4000000000000'
 DC X'02B441000000000002B447000000000002B45800000000000000000000000000'
 DC X'05B4D203D0B8000002B4F0000000000002B450000000000003B4404000000000'
 DC X'04B440400000000006B440400038400005B44110D2A8000004B44780C6000000'
 DC X'04B45870D000000003B4F0F00000000004B540400000000002B6400000000000'
 DC X'03B640400000000004B640400000000005B6404000380000B632404000015805'
 DC X'02B858000000000002B847000000000002B840000000000002B8410000000000'
 DC X'02B8500000000000000000000000000002B800000000000003B805EF00000000'
 DC X'03B848900000000007B858D0D00458E003B858F00000000005B858F034580000'
 DC X'03B847800000000005B847F03458000003B840400000000004B8404000000000'
 DC X'05B840400038000006B840400038400007B8404000384040B642003840400003'
 DC X'04B84110D200000002BA40000000000002BAB9000000000002BA5A0000000000'
 DC X'03BA40400000000004BA404000000000B64C00384040000302BC410000000000'
 DC X'02BC47000000000002BC50000000000003BD91800000000002BE400000000000'
 DC X'02BE00000000000002BE58000000000003BE40400000000004BE404000000000'
 DC X'B65738404000010402BF0F000000000002BF5F000000000002BF7F0000000000'
 DC X'02BFFF000000000002BF2F0000000000180000000000000002BF4F0000000000'
 DC X'02BFAF000000000004BF6FD09C00000002BFEF000000000002BF1F0000000000'
 DC X'03BF83900000000003BF18F80000000003BF0F400000000003BF0FD000000000'
 DC X'05BF0F600047000005BF0F500047000004BF0FF00000000004BF0F4000000000'
 DC X'05BF0F400047000003BF5F500000000004BF5F500000000005BF5F5000470000'
 DC X'03BF7FD00000000006BF7FD09447800003BF2FD10000000002C0400000000000'
 DC X'02C000000000000002C00C000000000002C074000000000002C0580000000000'
 DC X'000000000000000002C0D2000000000002C050000000000002C0410000000000'
 DC X'05C005EFD207000003C00D000000000003C0F0F00000000003C0404000000000'
 DC X'04C040400000000005C040400038000006C040400038400007C0404000384040'
 DC X'B67F003840400003B680384040000104B68038404000020403C0000000000000'
 DC X'04C000000000000003C00C470000000004C00C472000000005C00C4720F00000'
 DC X'03C074070000000004C07407FF00000005C07407FF90000004C0587570000000'
 DC X'04C058F03700000003C0D2030000000002C1E3000000000002C1D90000000000'
 DC X'02C1E2000000000002C1D3000000000002C1400000000000B0C7E6C4C2D50000'
 DC X'02C1F4000000000002C1D7000000000002C1D4000000000002C1F00000000000'
 DC X'02C1C3000000000005C1B858D0D0000002C1B0000000000004C1C7C508000000'
 DC X'04C1E6C2D500000002C1C4000000000002C1C2000000000002C1D50000000000'
 DC X'03C1E3C50000000005C1E3E3C1C2000003C1D9E30000000005C1D9C7C5E30000'
 DC X'03C1E2C30000000004C1F4414000000003C1D76D0000000003C1D4C500000000'
 DC X'04C1D4C54000000002C240000000000002C2D4000000000002C2F40000000000'
 DC X'04C2D3C54000000003C2000000000000000000000000000003C2AE9100000000'
 DC X'03C2F0F50000000003C240400000000004C2404000000000B6B6384040000104'
 DC X'03C2D4400000000007C2D4404040404005C2D440C396000002C3440000000000'
 DC X'02C3C5000000000002C3D6000000000002C3E2000000000002C3D30000000000'
 DC X'D4E3D2000000000002C396000000000002C3F0000000000005C35D40C3960000'
 DC X'04C361F3F700000002C3C1000000000002C340000000000002C3D40000000000'
 DC X'02C3E3000000000002C3D2000000000003C344580000000003C3445000000000'
 DC X'04C344586000000006C344586060000003C3C5C50000000007C3C5C5E2E3C1D9'
 DC X'06C3C5C50000000003C3D6D40000000004C3D6D4D700000005C3D3C5C1D90000'
 DC X'02C440000000000002C441000000000002C4C5000000000002C4C10000000000'
 DC X'02C4000000000000C4D700000000000002C458000000000002C4C90000000000'
 DC X'02C4F0000000000005C461C3A883000004C4D203D100000004C447F032000000'
 DC X'04C4C400D400000002C4D7000000000003C440400000000004C4404040000000'
 DC X'04C440400000000005C440404040000006C440404040400007C4404040404040'
 DC X'B6E2404040400003B6E2404040404003B6E3404040003004B6E5404000304005'
 DC X'B6E6400030404006B6E7003040400007B6E3404040404004B6E5404040404005'
 DC X'B6E6404040404006B6E7404040404007B6E9404040404008B6EE404040404009'
 DC X'B6F340404040400EB6E200384040000303C441100000000005C4C5C2E4C70000'
 DC X'03C4C1E30000000003C400000000000005C458757000000003C4C9E300000000'
 DC X'03C4F0F00000000002C5E2000000000002C5E4000000000002C5D50000000000'
 DC X'02C5C5000000000002C5400000000000C2F05DC6D4C7000002C5E30000000000'
 DC X'02C5D9000000000002C5C4000000000002C5C1000000000002C5E70000000000'
 DC X'02C54D000000000005C5C2E4C76D000002C5F0000000000004C55D40E3000000'
 DC X'02C5C6000000000002C5D4000000000004C5C7E20200000003C5E2C400000000'
 DC X'03C5E2E30000000006C5E2C7F0F0F80005C5E2E2C6E4000003C5E2C500000000'
 DC X'04C5E2C44000000005C5E2C44040000006C5E2C44040400007C5E2C440404040'
 DC X'B70F404040404003B71840003040400806C5E2E3C1D9E30003C5E4E500000000'
 DC X'04C5E4E5D900000004C5E4E5E200000004C5E4E5D700000005C5E4E5E3F10000'
 DC X'06C5E4E5D9C3D40005C5E4E5D7F0000006C5E4E5D7F1D20003C5D5C400000000'
 DC X'05C5D5E340E3000004C5D5C44000000005C5D5C44040000006C5D5C440404000'
 DC X'B72740404040400603C5C5E20000000005C5C5000001000007C5C5E2E3C1D9E3'
 DC X'07C5C5E2C7F0F0F803C5E3C50000000004C5D96DA600000006C5C46DD6D56D00'
 DC X'03C5C4400000000005C5C1406040000005C5E7C3C500000005C54DD7D6E20000'
 DC X'02C640000000000002C6F5000000000002C689000000000002C6D60000000000'
 DC X'02C6580000000000000000000000000002C647000000000003C6404000000000'
 DC X'04C640400000000005C640400038000006C640400038400007C6404000384040'
 DC X'B73B003840400003B73C38404000010402C7E6000000000002C7F00000000000'
 DC X'02C7C5000000000003C700000000000003C740000000000002C8400000000000'
 DC X'02C800000000000002C847000000000002C8D2000000000002C8580000000000'
 DC X'000000000000000002C841000000000005C85500C00C000002C8F00000000000'
 DC X'02C8C5000000000002C850000000000003C840400000000004C8404000000000'
 DC X'05C840400038000006C840400038400007C8404000384040B752003840400003'
 DC X'03C800000000000004C800000000000005C8477030F4000003C847F000000000'
 DC X'03C8D2030000000004C858303E00000003C841200000000004C8C5C3D2000000'
 DC X'02C9E3000000000002C940000000000002C9D3000000000002C9D50000000000'
 DC X'02C9C20000000000000000000000000002C9D4000000000002C9C70000000000'
 DC X'04C9F0F0F100000004C9D6D54000000002C9C3000000000004C9E3C5D4000000'
 DC X'03C9D3C50000000004C9D3C5C400000005C9D5C740D4000003C9C2D400000000'
 DC X'04C9C2D44000000002CA40000000000003CA40400000000004CA404000000000'
 DC X'05CA40400038000006CA40400038400007CA404000384040B772003840400003'
 DC X'B77338404000010402CC41000000000002CC58000000000002CCD20000000000'
 DC X'02CC0C000000000004CC000007000000000000000000000004CCCDCECF000000'
 DC X'04CCF0F0F100000003CC58700000000003CCD2030000000002CE400000000000'
 DC X'04CE21864700000004CEB109FF00000003CE40400000000004CE404000000000'
 DC X'B78738404000010402D088000000000002D00C000000000002D0900000000000'
 DC X'02D09C000000000002D0A80000000000D0BCAC1CC0B4780002D0980000000000'
 DC X'02D094000000000002D0A4000000000002D0B0000000000002D0A00000000000'
 DC X'02D0B8000000000002D0D0000000000002D0BC000000000002D0AC0000000000'
 DC X'02D01C000000000002D0C0000000000002D0B4000000000002D0780000000000'
 DC X'02D0000000000000CCD820DCEC48504C02D058000000000002D0040000000000'
 DC X'02D0E8000000000002D0C4000000000002D040000000000002D0E00000000000'
 DC X'02D0CC000000000002D0D8000000000002D020000000000002D0DC0000000000'
 DC X'02D0EC000000000002D048000000000002D050000000000002D04C0000000000'
 DC X'8CF814FC803332D102D0E4000000000002D0C8000000000002D0F00000000000'
 DC X'02D0F4000000000002D041000000000002D024000000000002D08C0000000000'
 DC X'02D0F8000000000002D014000000000002D0FC000000000002D0800000000000'
 DC X'02D033000000000002D032000000000002D0D100000000000000000000000000'
 DC X'02D0D4000000000003D00D000000000003D088580000000003D088D200000000'
 DC X'03D088410000000003D088910000000003D0881B0000000004D0885850000000'
 DC X'04D088587000000004D088586000000005D088582020000005D0885890900000'
 DC X'05D088585050000006D088585050000006D0885850500400B7C3500058505004'
 DC X'B7BE505004D2030305D088587070000006D088587070000007D08858707004BF'
 DC X'05D088586060000006D088586050000004D088D20300000005D088D203D00000'
 DC X'06D088D203D0F000B7D2D0A04000580404D088414000000003D00C5800000000'
 DC X'03D00C980000000005D00C47F0CE000004D00C582000000004D00C58E0000000'
 DC X'05D00C5820D0000006D00C5820D04C0007D00C5820D04C41B7D720D04C410003'
 DC X'B7DAD04C41002004B7DD410020A0550606D00C9826D01C0003D0905800000000'
 DC X'03D090500000000003D090470000000003D090410000000004D090D203000000'
 DC X'04D09058F000000004D090507000000005D0905070D0000004D0904780000000'
 DC X'05D090477032000003D09C470000000003D09C580000000003D09C4100000000'
 DC X'03D09C500000000003D09C1800000000000000000000000005D09CD203F00000'
 DC X'04D09CBF5F00000006D09C4110D1680003D0A8410000000003D0A85800000000'
 DC X'06D0A8D203D0AC0003D0A8500000000004D0A8897000000004D0A84110000000'
 DC X'04D0A858F000000003D098500000000003D0981B0000000003D0985800000000'
 DC X'03D098180000000005D09847F0380000000000000000000005D098F0F0F10000'
 DC X'05D09858F0F0000003D094580000000003D094410000000003D0944700000000'
 DC X'03D094180000000003D0945000000000000000000000000004D0941B88000000'
 DC X'05D0945870D0000003D0A4580000000003D0A4470000000003D0A45000000000'
 DC X'05D0A4D203D0000003D0A4410000000004D0A4478000000003D0B04100000000'
 DC X'03D0B0470000000005D0B058F034000005D0B05000D2000004D0B04110000000'
 DC X'05D0B047F035000003D0A0580000000005D0A0D203D0000005D0A05070D00000'
 DC X'05D0A04110D0000004D0A058F000000005D0A05870D0000005D0A058F0100000'
 DC X'03D0B8580000000003D0B8D20000000003D0B8410000000003D0B85000000000'
 DC X'04D0B8D20300000003D0D0040000000003D0D0500000000003D0D05800000000'
 DC X'06D0D00458E0D00003D0BC410000000006D0BC58F034EA0005D0BCD203D20000'
 DC X'04D0BC505000000004D0BC411000000005D0BC4110D2000006D0AC4110D42800'
 DC X'03D0ACD20000000003D0AC500000000004D0ACD20300000003D01C0500000000'
 DC X'04D01C051E00000005D01C051E07000006D01C051E07070007D01C051E070700'
 DC X'B834070716C9A004B8331E0707D20003B8331E070700000303D0C04100000000'
 DC X'04D0C0D0A000000004D0C0411000000003D0B4D20000000003D0B45000000000'
 DC X'03D078580000000005D078D203D0000003D000000000000004D0000005000000'
 DC X'04D000000000000003D058F00000000003D058500000000003D0045800000000'
 DC X'05D0041BFF58000007D00458E0D00CF003D0E8580000000005D0E8D203D00000'
 DC X'04D0E8D70300000004D0E858F000000003D040400000000004D0404000000000'
 DC X'05D040400038000006D040400038400007D0404000384040B84E003840400003'
 DC X'B85040400001990505D0E04110D2000007D0200418D2053004D0EC4110000000'
 DC X'04D0ECD0EC00000007D04890F020489203D050700000000005D04C4100200000'
 DC X'03D041100000000004D041300000000006D02447F0E0040002D11C0000000000'
 DC X'02D108000000000002D158000000000002D100000000000002D1CC0000000000'
 DC X'F09840AC9C38B88402D168000000000002D1A4000000000002D1040000000000'
 DC X'02D16C000000000002D178000000000002D13C000000000002D1F00000000000'
 DC X'02D198000000000002D140000000000002D1AC000000000002D19C0000000000'
 DC X'02D138000000000002D1B8000000000002D18400000000009490FC60E8D00C74'
 DC X'02D120000000000002D128000000000002D114000000000002D1880000000000'
 DC X'02D1A0000000000002D12C000000000002D194000000000002D1900000000000'
 DC X'02D1FC000000000002D160000000000002D1E8000000000002D1D00000000000'
 DC X'02D10C000000000002D17400000000003410B4F4E000000002D1700000000000'
 DC X'02D148000000000002D1EC000000000002D14C000000000003D164D200000000'
 DC X'03D17DD20000000003D134410000000003D110D20000000003D1B4D200000000'
 DC X'03D1F4410000000003D1E0580000000003D11C470000000003D1084100000000'
 DC X'03D158580000000005D15858F03E000003D100580000000004D1005870000000'
 DC X'03D168180000000003D16C580000000003D178580000000004D1B8D203000000'
 DC X'02D203000000000002D200000000000002D201000000000002D2180000000000'
 DC X'02D207000000000040A8380CFC285EC002D205000000000002D2F00000000000'
 DC X'02D2FF000000000002D220000000000002D250000000000002D2040000000000'
 DC X'02D240000000000002D2A8000000000002D238000000000002D20C0000000000'
 DC X'02D2FC000000000002D228000000000002D25E000000000002D2C00000000000'
 DC X'440000000000000002D2A4000000000004D2A0415000000004D2245070000000'
 DC X'04D234477000000002D270000000000002D274000000000003D244D200000000'
 DC X'03D203D00000000003D203D10000000003D203D20000000003D203D300000000'
 DC X'03D203D400000000DD10DB60DF00000003D203F00000000003D203D600000000'
 DC X'03D203D50000000003D203500000000003D203DA0000000003D2037000000000'
 DC X'03D203DD0000000003D203100000000003D203DB0000000003D2036000000000'
 DC X'03D203DF0000000004D203D09000000004D203D09800000004D203D09C000000'
 DC X'04D203D0B800000004D203D0B4000000F8B0FCCCA4D8C80004D203D0E0000000'
 DC X'04D203D0A800000004D203D09400000004D203D0F000000004D203D0DC000000'
 DC X'04D203D0A000000004D203D0F800000004D203D0B000000004D203D0FC000000'
 DC X'06D203D0CC387A0006D203D0A4D0880005D203D0D836000005D203D0C8370000'
 DC X'06D203D09830F40006D203D09C33B20006D203D0F038680004D203D1A0000000'
 DC X'04D203D1AC00000004D203D16000000004D203D19C00000006D203D10C38F400'
 DC X'000000000000000004D203D1F000000005D203D1843F000005D203D170700000'
 DC X'06D203D210D0A80004D203D20800000005D203D24036000005D203D2543F0000'
 DC X'05D203D3083F000005D203D32CD0000006D203D408366A0004D203F0F0000000'
 DC X'05D203F0F0F0000005D203F0F0F1000006D203F0F0F0F10005D203D540390000'
 DC X'04D203500000000004D203DA5000000004D203700000000004D2031000000000'
 DC X'05D203DB6040000004D203600800000005D200000000000004D2005007000000'
 DC X'03D218410000000005D21858F038000003D207D10000000003D2072000000000'
 DC X'04D207F06400000003D205300000000004D205305800000006D2F0F202000000'
 DC X'05D2FF100020000002D3C4000000000002D3C5000000000002D3D60000000000'
 DC X'02D310000000000002D3400000000000C914E4A42830F00C02D3B00000000000'
 DC X'02D3D3000000000002D300000000000002D3D4000000000002D3C00000000000'
 DC X'02D3C1000000000002D3C9000000000002D314000000000002D3E40000000000'
 DC X'02D3A4000000000002D328000000000002D330000000000002D3F00000000000'
 DC X'03D30CD00000000003D3C4400000000004D3C4404000000005D3C44040400000'
 DC X'06D3C4404040400007D3C44040404040B915404040404003B916404040400004'
 DC X'B917404040003805B917404040003405B919400030404007B918404000384006'
 DC X'B919400038404007B91A003840404008B91B384040404009B91C40404040000A'
 DC X'B91D40404040000A03D3C54D0000000005D3C5C46DD6000004D3C54DD7000000'
 DC X'05D3C54DD7D60000B928E2C9E75D400503D3D6C30000000004D3000000000000'
 DC X'02D440000000000002D410000000000002D441000000000002D4F00000000000'
 DC X'02D4080000000000E5D61CC124600C3C02D458000000000002D4C50000000000'
 DC X'02D4D7000000000002D450000000000002D400000000000002D4280000000000'
 DC X'05D4E5E24040000002D4D6000000000002D41C000000000002D4C10000000000'
 DC X'02D424000000000002D460000000000002D40C000000000002D43C0000000000'
 DC X'000000000000000002D4C9000000000002D418000000000003D4F1F900000000'
 DC X'03D430180000000003D440400000000006D440404040400006D4404000384000'
 DC X'04D44110F000000003D4F0F00000000005D40858F036000003D4583000000000'
 DC X'03D4C5D40000000003D400000000000003D4D6C40000000002D5C40000000000'
 DC X'02D503000000000002D5E3000000000002D5D6000000000002D5C10000000000'
 DC X'C70000000000000002D5C3000000000002D500000000000002D5E20000000000'
 DC X'05D56DD4E5E2000002D5C5000000000002D540000000000002D5C70000000000'
 DC X'03D5C4400000000005D5C4020000000004D5C4404000000005D5C44040400000'
 DC X'06D5C4404040400007D5C44040404040B95C404040404003B95E404040404004'
 DC X'B95F404040404005B960404040404006B96540404040400B04D503F000000000'
 DC X'03D5E3400000000005D5D6400200000006D5C1D4C540000002D6D50000000000'
 DC X'02D640000000000002D6D4000000000002D6E2000000000002D6580000000000'
 DC X'C40000000000000002D6D7000000000002D6D9000000000002D6C30000000000'
 DC X'05D6C9404040000002D6E3000000000004D64100BF00000004D6C4C540000000'
 DC X'03D6D5400000000005D6D56DD4E5000003D640400000000004D6404000000000'
 DC X'07D640400038404003D6D9400000000003D6E3400000000002D7030000000000'
 DC X'02D7E3000000000002D7C1000000000002D7C9000000000002D7C30000000000'
 DC X'000000000000000002D76D000000000002D7F0000000000002D7C50000000000'
 DC X'02D7C6000000000003D799960000000003D703D00000000003D703D100000000'
 DC X'03D703D30000000003D703D20000000005D70351445100000000000000000000'
 DC X'05D703700070000005D703D0D8D0000003D7E3C90000000007D7E3C9D4C9E9C5'
 DC X'05D7C1D9C1D4000005D7C9D3C5C4000002D840000000000002D8000000000000'
 DC X'02D858000000000002D847000000000002D85000000000000000000000000000'
 DC X'02D838000000000003D8D2030000000003D840400000000004D8404000000000'
 DC X'05D840400038000006D840400038400007D8404000384040B99E003840400003'
 DC X'B99F38404000010403D800000000000005D858F0344E000003D847F000000000'
 DC X'03D850700000000002D9C5000000000002D9E3000000000002D9D30000000000'
 DC X'02D9D6000000000002D9F0000000000028F2E4000000000002D9850000000000'
 DC X'02D9D5000000000002D9C9000000000002D9C7000000000004D9C3F0F4000000'
 DC X'04D9D4C1E300000003D928500000000003D9F2C30000000003D9E4C300000000'
 DC X'06D9C5C54040400003D9C5C10000000003D9D3C40000000004D9D3C440000000'
 DC X'05D9D3C44040000006D9D3C44040400007D9D3C440404040B9BA404040404003'
 DC X'B9BB404040404004B9BC40404040000503D9D6C70000000003D985A200000000'
 DC X'02DA58000000000002DA40000000000002DA47000000000004DA0850C0000000'
 DC X'02DA410000000000000000000000000002DA1C000000000004DAD203D1000000'
 DC X'04DAF0F0F000000004DA5880B500000007DA40400038404003DA47F000000000'
 DC X'02DC47000000000002DC40000000000002DCD2000000000004DCF0F0F0000000'
 DC X'02DC58000000000003DC40400000000004DC40400000000002DDFF0000000000'
 DC X'02DDA0000000000003DDFF100000000004DDFF100000000002DE410000000000'
 DC X'02DE49000000000002DE50000000000004DE40400000000002DFD20000000000'
 DC X'02E000000000000002E0D0000000000002E0F0000000000002E0400000000000'
 DC X'02E004000000000005CA18C090C608C202E050000000000002E0470000000000'
 DC X'02E020000000000002E041000000000002E058000000000005E0D203D2A80000'
 DC X'02E005000000000002E0CA000000000002E018000000000002E0C00000000000'
 DC X'02E090000000000003E0C6660000000003E008470000000003E0C2AA00000000'
 DC X'03E000000000000003E000580000000003E000500000000005E0000002940000'
 DC X'06E00058F0F0180003E0D00C0000000003E0D0A00000000004E0D00C98000000'
 DC X'03E0F0100000000003E0F0F00000000005E0F04E58F0000004E0F04C58000000'
 DC X'B9FC4700000C500303E040400000000004E040400000000005E0404000380000'
 DC X'06E040400038400007E0404000384040BA01003840400003BA0340400002C905'
 DC X'03E004070000000004E004070700000003E047D00000000003E0411000000000'
 DC X'04E058503B00000002E2C4000000000002E240000000000002E2E30000000000'
 DC X'02E2C5000000000002E2C9000000000041E2C3C7F700000002E2C10000000000'
 DC X'02E2D2000000000006E2A381A3A4A20005E25050D0E0000002E2000000000000'
 DC X'02E201000000000002E241000000000002E2E2000000000002E2C30000000000'
 DC X'02E2C7000000000003E2F7E70000000003E2C4400000000004E2C44040000000'
 DC X'05E2C4404040000006E2C4404040400007E2C44040404040BA1E404040404003'
 DC X'BA1F404040400004BA20404040003005BA21404000304006BA22400030404007'
 DC X'BA23003040400008BA2540400001C50A03E240C70000000003E2404000000000'
 DC X'05E240E2E4C2000004E240C796000000BA2DA5859995940407E2404040404040'
 DC X'06E2E3D9D5C3D70005E2E3F0F0F0000003E2E3C10000000003E2C5E300000000'
 DC X'06E2C5E36DC4C50005E2C9E75D40000004E20040F000000002E3E70000000000'
 DC X'02E340000000000002E3F0000000000002E3C9000000000002E3C10000000000'
 DC X'D9E200000000000002E3C5000000000002E3C3000000000002E3D60000000000'
 DC X'05E34DD3C55D000002E3E4000000000004E302000000000002E3D90000000000'
 DC X'02E3E2000000000004E300007300000003E3E7E30000000004E3E7E340000000'
 DC X'05E3E7E34000000005E3E7E34001000005E3E7E34002000005E3E7E340040000'
 DC X'06E3E7E34000000006E3E7E34000060006E3E7E34000010006E3E7E340000200'
 DC X'06E3E7E3400015001B0C0D131924500F06E3E7E34000050006E3E7E340000E00'
 DC X'06E3E7E34000030006E3E7E34000220006E3E7E34000080006E3E7E340001000'
 DC X'06E3E7E340001B0006E3E7E340000C0006E3E7E340000D0006E3E7E340001300'
 DC X'06E3E7E34000190006E3E7E34000240006E3E7E34000500006E3E7E340000F00'
 DC X'041E85176320391406E3E7E340001F0006E3E7E34000260006E3E7E340001800'
 DC X'06E3E7E34000090006E3E7E340001C0006E3E7E34000110006E3E7E340000400'
 DC X'06E3E7E340001E0006E3E7E34000850006E3E7E34000170006E3E7E340006300'
 DC X'06E3E7E34000200006E3E7E34000390006E3E7E3400014000000000000000000'
 DC X'06E3E7E34000070007E3E7E3400033DC07E3E7E3400027E807E3E7E340002AAE'
 DC X'07E3E7E3400053D8BA48000040400005BA46400006404003BA47000188404004'
 DC X'03E340000000000003E340D60000000005E340D9C5D5000003E3400100000000'
 DC X'04E340E3C100000004E340000200000004E340000500000004E3400000000000'
 DC X'04E340000700000004E3400003000000000000000000000004E340000A000000'
 DC X'04E340001B00000004E340000C00000004E340001200000004E3400001000000'
 DC X'05E340000FD0000003E3F0F00000000003E3C9D60000000003E3C9D400000000'
 DC X'04E3C9D6D500000003E3C1D90000000006E3C1D9C7C5E30006E3C1D9E340D900'
 DC X'02E4E5000000000002E450000000000002E440000000000002E4D30000000000'
 DC X'02E4000000000000000000000000000002E458000000000002E4D00000000000'
 DC X'04E4A2859900000002E4D5000000000003E4E5E20000000003E4E5D700000000'
 DC X'03E4E5D90000000005E4E5E3F1F2000003E4E5C10000000004E4E5D7F1000000'
 DC X'05E4E5D9F8D4000003E440400000000004E440400000000007E4404000384040'
 DC X'03E4D3D30000000003E400000000000002E5E2000000000002E5D90000000000'
 DC X'02E5C3000000000004E5E9F0F300000002E5F000000000000000000000000000'
 DC X'02E5C5000000000005E5E2404040000002E640000000000002E6580000000000'
 DC X'02E6E7000000000002E6F0000000000003E640400000000004E6404000000000'
 DC X'05E6404000380000BAB440400001410502E7E3000000000002E7C30000000000'
 DC X'02E76B000000000003E7E3400000000004E7E3400000000004E7E34002000000'
 DC X'04E7E3400100000005E7E3400000000005E7E3400022000005E7E34000040000'
 DC X'05E7E340001E000005E7E34000060000080A21421B2B000005E7E34000120000'
 DC X'05E7E340003B000005E7E340000B000005E7E3400007000005E7E34000050000'
 DC X'05E7E3400023000005E7E3400008000005E7E340000A000006E7E34000217000'
 DC X'06E7E3400042C40006E7E340001B180006E7E340002B7A0003E7C3C500000000'
 DC X'05E7C3C50000000002E840000000000002E800000000000002E8580000000000'
 DC X'02E847000000000002E8500000000000000000000000000005E81A7595000000'
 DC X'02E8D0000000000002E8D7000000000003E8F0F20000000003E8404000000000'
 DC X'04E840400000000005E840400038000006E840400038400007E8404000384040'
 DC X'BADB003840400003BADC38404000010403E800000000000006E8000005B4F000'
 DC X'05E800000000000003E858F00000000003E847F00000000002E9F00000000000'
 DC X'02E9C5000000000004E9E9000000000002EAD2000000000003EAD20300000000'
 DC X'02ECD0000000000002EC40000000000002EC41000000000002EC050000000000'
 DC X'02EC470000000000000000000000000002EC00000000000004ECD203D1000000'
 DC X'03EC50000000000003ECD00C0000000007ECD00C58E0F8E603EC404000000000'
 DC X'04EC404000000000BAF700384040000303EC05EF0000000004EC000000000000'
 DC X'02EE40000000000002EE47000000000002EE50000000000002EE000000000000'
 DC X'02EED2000000000003EE40400000000004EE40400000000005EE404000380000'
 DC X'BB0340400001D20503EE47800000000002EF58000000000002EF500000000000'
 DC X'02EF47000000000002EF12000000000002EF41000000000044D7DE0000000000'
 DC X'02EFBF000000000002EF18000000000002EFF0000000000002EF000000000000'
 DC X'02EFD2000000000002EF92000000000004EF4400C100000004EFD703F0000000'
 DC X'04EFDEADF000000003EF58500000000003EF58700000000003EF586000000000'
 DC X'03EF58400000000003EF58F00000000006EF5850D088410005EF585037460000'
 DC X'04EF58703F00000007EF5870F000507006EF5840D088500003EF50F000000000'
 DC X'04EF50F0D000000004EF50F0D100000005EF50F0F0F0000003EF47F000000000'
 DC X'04EF47F03F00000003EF12FF0000000004EF12FF4700000005EF12FF47700000'
 DC X'03EFBF0F0000000004EFBF5FD000000005EFBF0FF000000005EFF0F0F0F00000'
 DC X'03EF00000000000004EF00000000000003EFD2030000000002F0F00000000000'
 DC X'02F0F1000000000002F0D0000000000002F002000000000002F0F30000000000'
 DC X'F63F30C0F9F8503402F000000000000002F0F5000000000002F0F20000000000'
 DC X'02F0F7000000000002F0F4000000000002F040000000000002F0F60000000000'
 DC X'02F03F000000000002F030000000000002F0C0000000000002F0F90000000000'
 DC X'02F0F8000000000002F050000000000002F0340000000000473758383D043B3E'
 DC X'02F031000000000002F036000000000002F010000000000002F0350000000000'
 DC X'02F033000000000002F020000000000002F047000000000002F0370000000000'
 DC X'02F058000000000002F038000000000002F03D000000000002F0040000000000'
 DC X'02F03B000000000002F03E00000000003AE0A760C3010C3C02F0320000000000'
 DC X'02F039000000000002F008000000000002F0D1000000000002F0D20000000000'
 DC X'02F044000000000002F03A000000000002F0E0000000000002F0A70000000000'
 DC X'02F060000000000002F0C3000000000002F001000000000002F00C0000000000'
 DC X'02F03C000000000005264FCC4AD341C702F018000000000002F0270000000000'
 DC X'02F070000000000004F0A0440500000002F056000000000004F0543720000000'
 DC X'04F005EF5000000002F026000000000002F04F000000000002F0CC0000000000'
 DC X'02F04A000000000002F0D3000000000003F041100000000003F0C76200000000'
 DC X'03F0F0F00000000003F0F0F10000000003F0F0F20000000003F0F0F300000000'
 DC X'03F0F0F400000000024028000000000003F0F0F90000000003F0F0F500000000'
 DC X'03F0F0F70000000003F0F0F60000000003F0F0F80000000003F0F00800000000'
 DC X'03F0F0020000000003F0F0400000000006F0F0284040400004F0F0F0F0000000'
 DC X'04F0F0F0F100000004F0F0F0F200000004F0F0F0F300000004F0F0F0F4000000'
 DC X'000000000000000004F0F0F0F700000004F0F0F0F900000004F0F0F0F6000000'
 DC X'04F0F0F0F500000004F0F0F0F800000005F0F0F0F0F0000005F0F0F0F0F10000'
 DC X'05F0F0F0F0F2000005F0F0F0F0F3000005F0F0F0F0F800000000000000000000'
 DC X'05F0F0F0F0F4000005F0F0F0F0F5000005F0F0F0F0F6000005F0F0F0F0F70000'
 DC X'05F0F0F0F0F9000006F0F0F0F0F0F00006F0F0F0F0F0F10006F0F0F0F0F0F200'
 DC X'06F0F0F0F0F0F40006F0F0F0F0F0F800000000000000000006F0F0F0F0F0F300'
 DC X'06F0F0F0F0F0F60006F0F0F0F0F0F50006F0F0F0F0F0F90006F0F0F0F0F0F700'
 DC X'07F0F0F0F0F0F0F207F0F0F0F0F0F0F507F0F0F0F0F0F0F807F0F0F0F0F0F0F6'
 DC X'07F0F0F0F0F0F0F0000000000000000007F0F0F0F0F0F0F407F0F0F0F0F0F0F7'
 DC X'07F0F0F0F0F0F0F107F0F0F0F0F0F0F3BB7FF0F0F4F80204BB7FF0F0F7F90204'
 DC X'07F0F0F0F0F0F1F307F0F0F0F0F0F1F507F0F0F0F0F0F1F807F0F0F0F0F0F1F6'
 DC X'BB7FF0F1F902E3040000000000000000BB7FF0F1F002E30407F0F0F0F0F0F1F1'
 DC X'07F0F0F0F0F0F2F907F0F0F0F0F0F2F5BB7FF0F2F2F4020407F0F0F0F0F0F8F0'
 DC X'07F0F0F0F0F0F8F307F0F0F0F0F0F8F707F0F0F0F0F0F3F107F0F0F0F0F0F3F2'
 DC X'BB7FF0F6F8F5020407F0F0F0F0F0F6F2BB7FF0F5F5F3020406F0F0F0F0F1F000'
 DC X'06F0F0F0F0F1F80006F0F0F0F0F1F90006F0F0F0F0F1F50006F0F0F0F0F1F100'
 DC X'000000000000000006F0F0F0F0F1F30006F0F0F0F0F1F60006F0F0F0F0F1F200'
 DC X'06F0F0F0F0F1F700BB70F0F1F9F10203BB70F0F1F3F3F50306F0F0F0F0F2F200'
 DC X'06F0F0F0F0F2F10006F0F0F0F0F2F80006F0F0F0F0F2F30006F0F0F0F0F2F900'
 DC X'07F0F0F0F0F2F2F206F0F0F0F0F3F90006F0F0F0F0F3F200BB70F0F3F3F5F503'
 DC X'BB70F0F8F4F60203BB70F0F8F9F2020306F0F0F0F0F8F20006F0F0F0F0F4F600'
 DC X'06F0F0F0F0F4F30006F0F0F0F0F5F50006F0F0F0F0F7F00005F0F0F0F1F00000'
 DC X'05F0F0F0F1F3000005F0F0F0F1F1000005F0F0F0F1F5000005F0F0F0F1F90000'
 DC X'000000000000000005F0F0F0F1F2000005F0F0F0F1F8000005F0F0F0F1F40000'
 DC X'05F0F0F0F1F7000005F0F0F0F1F6000006F0F0F0F1F0F10006F0F0F0F1F3F100'
 DC X'06F0F0F0F1F5F200BB80F5F2F9F1F30406F0F0F0F1F9F60006F0F0F0F1F2F500'
 DC X'05F0F0F0F2F2000005F0F0F0F2F9000005F0F0F0F2F8000005F0F0F0F2F50000'
 DC X'05F0F0F0F2F10000000000000000000005F0F0F0F2F6000005F0F0F0F2F40000'
 DC X'05F0F0F0F2F3000005F0F0F0F2F0000006F0F0F0F2F2F60006F0F0F0F2F9F500'
 DC X'06F0F0F0F2F8F70005F0F0F0F3F3000005F0F0F0F3F2000005F0F0F0F3F10000'
 DC X'05F0F0F0F3F6000005F0F0F0F3F70000000000000000000005F0F0F0F3F40000'
 DC X'05F0F0F0F3F9000005F0F0F0F3F8000007F0F0F0F3F3F2F007F0F0F0F3F6F2F3'
 DC X'05F0F0F0F4F1000005F0F0F0F4F3000005F0F0F0F4F4000007F0F0F0F4F9F0F2'
 DC X'05F0F0F0F4F00000000000000000000005F0F0F0F4F2000006F0F0F0F4F5F300'
 DC X'05F0F0F0F7F4000005F0F0F0F7F3000005F0F0F0F7F6000005F0F0F0F7F20000'
 DC X'07F0F0F0F7F7F2F305F0F0F0F9F5000005F0F0F0F9F8000005F0F0F0F9F20000'
 DC X'05F0F0F0F9F9000006F0F0F0F9F4F50005F0F0F0F6F4000005F0F0F0F6F20000'
 DC X'06F0F0F0F6F8F30006F0F0F0F6F6F60005F0F0F0F5F8000005F0F0F0F5F10000'
 DC X'05F0F0F0F8F2000005F0F0F0F8F9000005F0F0F0F8F8000004F0F0F1F0000000'
 DC X'04F0F0F1F300000004F0F0F1F600000004F0F0F1F100000004F0F0F1F9000000'
 DC X'000000000000000004F0F0F1F500000004F0F0F1F400000004F0F0F1F2000000'
 DC X'04F0F0F1F700000004F0F0F1F800000005F0F0F1F0F1000005F0F0F1F0F40000'
 DC X'05F0F0F1F0F6000005F0F0F1F0F0000005F0F0F1F0F9000007F0F0F1F0F0F6F3'
 DC X'05F0F0F1F3F1000005F0F0F1F3F5000005F0F0F1F3F4000005F0F0F1F3F80000'
 DC X'07F0F0F1F3F1F0F105F0F0F1F6F5000005F0F0F1F6F8000005F0F0F1F6F20000'
 DC X'06F0F0F1F6F4F40006F0F0F1F6F6F80005F0F0F1F1F2000005F0F0F1F1F00000'
 DC X'06F0F0F1F1F8F20005F0F0F1F9F4000005F0F0F1F5F5000007F0F0F1F5F5F3F2'
 DC X'05F0F0F1F4F6000006F0F0F1F4F9F20006F0F0F1F4F6F20007F0F0F1F7F1F1F1'
 DC X'05F0F0F1F8F0000004F0F0F2F100000004F0F0F2F000000004F0F0F2F7000000'
 DC X'04F0F0F2F500000004F0F0F2F8000000000000000000000004F0F0F2F9000000'
 DC X'04F0F0F2F200000004F0F0F2F300000004F0F0F2F600000005F0F0F2F1F00000'
 DC X'06F0F0F2F0F4F30006F0F0F2F9F0020004F0F0F3F400000004F0F0F3F5000000'
 DC X'04F0F0F3F900000004F0F0F3F700000004F0F0F3F80000000000000000000000'
 DC X'04F0F0F3F600000006F0F0F3F3F8F30006F0F0F3F4F3F40005F0F0F3F5F00000'
 DC X'04F0F0F4F400000004F0F0F4F100000004F0F0F4F000000004F0F0F4F5000000'
 DC X'04F0F0F4F8000000000000000000000005F0F0F4F3F7000005F0F0F4F7F00000'
 DC X'04F0F0F9F800000004F0F0F9F500000004F0F0F9F700000006F0F0F9F4F5F700'
 DC X'04F0F0F9F1000000000000000000000006F0F0F9F902E30006F0F0F9F2F60200'
 DC X'04F0F0F5F800000004F0F0F5F000000006F0F0F5F6F1F50005F0F0F5F3F10000'
 DC X'04F0F0F7F300000004F0F0F7F000000004F0F0F7F600000005F0F0F7F1F30000'
 DC X'05F0F0F7F9F6000005F0F0F7F0F8000004F0F0F6F700000004F0F0F6F4000000'
 DC X'04F0F0F6F100000004F0F0F6F300000005F0F0F6F7F2000004F0F0F8F9000000'
 DC X'06F0F0F8F3F0F10004F0F0F8F500000005F0F0F8F6F50000BB7B4DE0F0104703'
 DC X'07F0F0020000004006F0F002E3E7E30003F0F1F00000000003F0F1F100000000'
 DC X'03F0F1F70000000003F0F1F20000000003F0F1F3000000004000000000000000'
 DC X'03F0F1F60000000003F0F1F50000000003F0F1F80000000003F0F1F900000000'
 DC X'03F0F1F40000000003F0F1020000000004F0F140F100000004F0F1F0F3000000'
 DC X'04F0F1F0F100000004F0F1F0F700000005F0F1F0F6F1000005F0F1F0F9F10000'
 DC X'04F0F1F1F600000004F0F1F1F800000006F0F1F1F1F0020005F0F1F1F6F40000'
 DC X'04F0F1F7F400000004F0F1F7F300000006F0F1F7F0F5F10004F0F1F7F7000000'
 DC X'04F0F1F2F500000006F0F1F2F702E30005F0F1F2F1F9000004F0F1F3F7000000'
 DC X'05F0F1F3F3F4000005F0F1F3F7F1000004F0F1F6F100000004F0F1F5F8000000'
 DC X'04F0F1F5F200000005F0F1F5F8F9000004F0F1F8F800000006F0F1F8F6F3F000'
 DC X'05F0F1F8F5F7000006F0F1F9F6F1F50005F0F1F9F1F7000004F0F1F4F0000000'
 DC X'06F0F1F4F7F2F90005F0F1F4F8F60000BC8DE3E7E340000305F0F10200000000'
 DC X'03F0D0480000000003F0D09C0000000003F0D0B40000000003F0D09800000000'
 DC X'03F0D0A000000000000000000000000005F0D0A44170000004F0D09041000000'
 DC X'04F0D0489000000005F0D04890F0000006F0D04890F0200007F0D04890F02048'
 DC X'BCB090F020489203BCB8F02048921004BCBD200050D0200905F0D09C47F00000'
 DC X'03F002E30000000006F002000000400005F002D9D3C4000004F002E3E7000000'
 DC X'05F002E3E7E3000006F002E3E7E3400007F002E3E7E34000BCC0E7E340000503'
 DC X'BCC0E7E340000003BCC3E3400008B20403F0F3020000000003F0F3F700000000'
 DC X'03F0F3F90000000003F0F3F00000000005F0F3F8F502000004F0F302E3000000'
 DC X'BCCA000000404003BCCFE7E34000020403F000000000000003F0005800000000'
 DC X'03F000500000000003F0F5020000000003F0F5F50000000003F0F5F400000000'
 DC X'05F0F5F0F802000004F0F5F1F400000004F0F502E300000006F0F50200000000'
 DC X'05F0F502E3E7000006F0F502E3E7E30007F0F502E3E7E340BCD5E3E7E3400003'
 DC X'03F0F2020000000003F0F2F40000000003F0F2F20000000003F0F2F000000000'
 DC X'03F0F2F700000000000000000000000003F0F2F800000000BCE0000000404003'
 DC X'06F0F202E3E7E30003F0F7020000000003F0F7F90000000003F0F7F400000000'
 DC X'03F0F7F30000000005F0F7F502E3000004F0F702E300000005F0F702E3E70000'
 DC X'06F0F702E3E7E30007F0F702E3E7E340BCE9E3E7E340000305F0F7F902E30000'
 DC X'04F0F7F40200000003F0F4F10000000003F0F4F50000000003F0F40200000000'
 DC X'03F0F4F90000000003F0F4F20000000006F0F402E3E7E30003F0404000000000'
 DC X'03F040000000000004F040400000000004F040404000000005F0404000380000'
 DC X'06F040400038400007F0404000384040BCFB003840400003BCFF404000025005'
 DC X'06F040404040400003F0F6F60000000005F0F602E3E7000003F0F6F400000000'
 DC X'05F0F6F902E3000004F0F6F2F200000005F03FBE05EF000004F03F7E05000000'
 DC X'03F0305C0000000003F0C0740000000004F0C0740700000005F0C07407FF0000'
 DC X'06F0C07407FF9000BD0F90E9D00C5805BD0EFF90E8D00C0403F0F90200000000'
 DC X'03F0F9F70000000003F0F9F600000000BD13E3E7E340000304F0F9F7C9000000'
 DC X'03F0F8F30000000003F0F8020000000003F0F8F50000000003F0F8F000000000'
 DC X'05F0F8020000000003F050000000000003F010470000000005F0101E02550000'
 DC X'04F010470000000003F020480000000006F020489210200003F0474000000000'
 DC X'03F047B00000000003F058F00000000005F05860D088000005F0044770310000'
 DC X'05F03E7247F0000006F0D2FF1000200003F044F00000000003F0E00400000000'
 DC X'03F0A76C0000000002F102000000000002F1F0000000000002F1F50000000000'
 DC X'02F1F1000000000002F1F8000000000040D2D1000000000002F1F70000000000'
 DC X'02F1F2000000000002F1F6000000000002F1F9000000000002F1F30000000000'
 DC X'02F1F4000000000002F140000000000002F1D2000000000004F1D1F0F2000000'
 DC X'02F100000000000003F102E30000000003F102C50000000005F1020000000000'
 DC X'04F102E3E700000005F102E3E7E3000006F102E3E7E3400007F102E3E7E34000'
 DC X'07F102E3E7E34001BD3DE7E340000003BD3DE7E340002503BD3DE7E340000403'
 DC X'BD40E3400008D00405F102C5E2C4000003F1F0F00000000003F1F0F300000000'
 DC X'03F1F0F70000000006F1F002E3E7E30006F1F0F002E3E70006F1F0F0F9F5F200'
 DC X'03F1F5020000000003F1F5F50000000003F1F5F80000000003F1F5F600000000'
 DC X'03F1F5F000000000000000000000000004F1F5F1F000000004F1F5F2F5000000'
 DC X'04F1F502E300000005F1F502E3E7000006F1F502E3E7E30007F1F502E3E7E340'
 DC X'BD50E3E7E340000303F1F1020000000003F1F1F70000000003F1F1F900000000'
 DC X'03F1F1F80000000003F1F1F300000000000000000000000003F1F1F500000000'
 DC X'03F1F1F000000000BD5DE3E7E340000306F1F1F702E3E70003F1F8F600000000'
 DC X'03F1F8F80000000003F1F8020000000003F1F8F00000000004F1F8F2F0000000'
 DC X'06F1F8F802E3E70006F1F802E3E7E30003F1F7020000000003F1F7F900000000'
 DC X'05F1F7F4F502000003F1F7F70000000004F1F7F6F40000000000000000000000'
 DC X'04F1F7F3F5000000BD6EE3E7E340040305F1F7F9F6F2000003F1F20200000000'
 DC X'03F1F2F00000000004F1F2F402000000BD77E3E7E340000305F1F602E3E70000'
 DC X'03F1F6F50000000003F1F6F10000000005F1F640E5F1000003F1F6F800000000'
 DC X'000000000000000005F1F6F302E3000003F1F9F90000000006F1F902E3E7E300'
 DC X'06F1F9F9F640400006F1F9F9F46B400005F1F9F9F540000003F1F30200000000'
 DC X'03F1F3F70000000003F1F3F900000000BD87E3E7E340000303F1F4F500000000'
 DC X'06F1F402E3E7E30005F1F4F502E3000003F140F00000000005F140D9F2400000'
 DC X'05F140404040000003F1D2F00000000002F202000000000002F2F00000000000'
 DC X'02F2F7000000000002F2F6000000000002F2F9000000000041405B0061000000'
 DC X'02F2F5000000000002F2F1000000000002F2F2000000000002F2F30000000000'
 DC X'02F2F4000000000002F2F8000000000002F241000000000002F2400000000000'
 DC X'04F25BA21500000004F200001B00000002F261000000000003F202E300000000'
 DC X'04F202E3E700000005F202E3E7E3000006F202E3E7E3400007F202E3E7E34000'
 DC X'BDA3E7E340000803BDA54000302E4005BDA54000009A4005BDA4E3400022DE04'
 DC X'03F2F0F00000000003F2F0F60000000006F2F002E3E7E30003F2F0F400000000'
 DC X'03F2F0F10000000005F2F0F0F0F2000003F2F7020000000003F2F7F300000000'
 DC X'04F2F7F9F100000004F2F740F100000007F2F702E3E7E34003F2F60200000000'
 DC X'03F2F6F50000000006F2F6F402E3E70004F2F6F802000000BDB7E3E7E3400003'
 DC X'03F2F9020000000003F2F9F40000000005F2F9F2F902000004F2F902E3000000'
 DC X'BDBFE7E340008F0406F2F502E3E7E30003F2F5F20000000003F2F1F600000000'
 DC X'03F2F1020000000004F2F2F00200000003F2F3020000000005F2F37EF1F90000'
 DC X'BDC6E3E7E340000304F2F4F9F400000006F2F802E3E7E30002F3020000000000'
 DC X'02F3F7000000000002F3F9000000000002F3F1000000000002F3F50000000000'
 DC X'5D0000000000000002F3F3000000000002F3F6000000000002F3F00000000000'
 DC X'02F3F4000000000002F3F2000000000002F3F8000000000004F35D7A40000000'
 DC X'03F302E30000000003F302C50000000005F302000000000005F302D9D3C40000'
 DC X'04F302E3E700000005F302E3E7E3000006F302E3E7E3400007F302E3E7E34000'
 DC X'BDD8E7E340000603BDD8E7E340000103BDD8E7E340002403BDD8E7E340001903'
 DC X'BDD8E7E340000D030000000000000000BDDD40000A544005BDD8E7E340000003'
 DC X'BDDCE3400004680404F302C5E200000005F302C5E2C40000BDEA404040404005'
 DC X'03F3F7020000000003F3F7F90000000006F3F7F04040400003F3F7F800000000'
 DC X'04F3F702E300000005F3F702E3E7000006F3F702E3E7E30007F3F702E3E7E340'
 DC X'BDECE3E7E340000303F3F9020000000005F3F9F902D9000004F3F902E3000000'
 DC X'05F3F902E3E7000006F3F902E3E7E30007F3F902E3E7E340BDF5E3E7E3400003'
 DC X'03F3F1020000000004F3F1F5F000000004F3F102E300000005F3F102C5D50000'
 DC X'BDFEE7E340000B0403F3F5020000000003F3F5F30000000004F3F502E3000000'
 DC X'05F3F502E3E7000006F3F502E3E7E30007F3F502E3E7E340BE01E3E7E3400003'
 DC X'03F3F3020000000005F3F3F079E1000004F3F302E300000005F3F302E3E70000'
 DC X'06F3F302E3E7E30007F3F302E3E7E340BE08E3E7E340000303F3F6F600000000'
 DC X'05F3F6F502E3000003F3F6020000000003F3F0F30000000003F3F00200000000'
 DC X'04F3F0F7F400000004F3F4F6F800000006F3F202E3E7E30003F3F2F200000000'
 DC X'03F3F8020000000005F3F802C5E2000002F402000000000002F4F00000000000'
 DC X'02F4F1000000000002F4F7000000000002F4F90000000000F541F8D24705D1C1'
 DC X'02F4F3000000000002F4F2000000000002F458000000000002F4F60000000000'
 DC X'02F440000000000002F4F4000000000002F4F5000000000002F4410000000000'
 DC X'02F4F8000000000002F4D2000000000002F447000000000005F405EF50F00000'
 DC X'04F4D1F0F400000004F4C140E4000000000000000000000002F4500000000000'
 DC X'03F41B1F0000000003F402E30000000003F402D90000000003F402C500000000'
 DC X'04F402E3E700000005F402E3E7E3000006F402E3E7E3400007F402E3E7E34000'
 DC X'07F402E3E7E34001BE31E7E34000100304F402D9D3000000BE3AC44040404004'
 DC X'06F402C5E2C4400005F402C5D5C4000003F4F0020000000003F4F0F800000000'
 DC X'04F4F0F5F7000000BE3EE3E7E340000303F4F1F70000000003F4F10200000000'
 DC X'05F4F1F602E3000005F4F1F2F1F4000003F4F7020000000005F4F7F502E30000'
 DC X'05F4F7F1F902000004F4F7F3F400000007F4F702E3E7E34007F4F902E3E7E340'
 DC X'03F4F9F20000000004F4F9F7F200000007F4F302E3E7E34005F4F3F7F9F90000'
 DC X'03F4F3F40000000003F4F2020000000004F4F2F202000000BE51E3E7E3400003'
 DC X'03F458500000000007F4F602E3E7E34006F4F6F702E3E70004F4F6F002000000'
 DC X'03F440400000000004F440400000000005F4404000380000BE5A40400001D105'
 DC X'03F4F40200000000BE5CE3E7E340000306F4F502E3E7E30003F4F8F100000000'
 DC X'04F4F8F0F200000003F4D2030000000002F502000000000002F5F60000000000'
 DC X'02F5F7000000000002F5F3000000000002F5F500000000009840607000000000'
 DC X'02F5F8000000000002F5F1000000000002F5F2000000000002F5F00000000000'
 DC X'02F5F9000000000002F5F4000000000002F598000000000002F5400000000000'
 DC X'04F560F76100000003F570000000000003F502E30000000005F502C5D5C40000'
 DC X'04F502E3E700000005F502E3E7E3000006F502E3E7E3400007F502E3E7E34000'
 DC X'07F502E3E7E34001BE72E7E340000103BE72E7E340003B03BE72E7E340000403'
 DC X'BE75400011384005BE74E34000021A0403F5F6F80000000003F5F60200000000'
 DC X'04F5F6F8F800000007F5F6F802E3E7E305F5F6F8F8F2000006F5F6F8F8F2F100'
 DC X'BE83F6404040F106BE7FE3E7E340000303F5F7020000000003F5F7F500000000'
 DC X'03F5F7F300000000BE86E3E7E340000303F5F3020000000005F5F3F1F7020000'
 DC X'03F5F3F00000000004F5F302E300000005F5F302E3E7000006F5F302E3E7E300'
 DC X'07F5F302E3E7E340BE8AE3E7E340000303F5F5020000000007F5F502E3E7E340'
 DC X'03F5F8020000000003F5F8F20000000003F5F8F100000000BE94E3E7E3400003'
 DC X'03F5F1020000000004F5F1F6F800000004F5F102E300000005F5F102E3E70000'
 DC X'06F5F102E3E7E30007F5F102E3E7E340BE98E3E7E340000305F5F2F102E30000'
 DC X'04F5F202E300000007F5F002E3E7E34003F5F0F50000000003F5F90200000000'
 DC X'03F5F9F40000000006F5F902E3E7E30003F5F4F70000000005F5F402E3E70000'
 DC X'03F598F00000000004F598F0F000000005F598F0F008000006F598F0F0084D00'
 DC X'BEABE0F01047000605F540404040000002F602000000000002F6F10000000000'
 DC X'02F6F0000000000002F6F5000000000002F6F80000000000F6E9D20500000000'
 DC X'02F6F7000000000002F6F9000000000002F6F3000000000002F6F20000000000'
 DC X'02F640000000000002F6F4000000000002F6F6000000000002F6E90000000000'
 DC X'04F6D203D100000004F605EF5800000003F602E30000000006F602C5D5C44000'
 DC X'04F602E3E700000005F602E3E7E3000006F602E3E7E3400007F602E3E7E34000'
 DC X'BEBEE7E340000203BEC0E34000170404BEC0E340000FB20403F6F10200000000'
 DC X'03F6F1F10000000003F6F1F90000000004F6F102E300000005F6F102E3E70000'
 DC X'06F6F102E3E7E30007F6F102E3E7E340BEC7E3E7E340000303F6F00200000000'
 DC X'03F6F0F40000000003F6F0F70000000003F6F0F00000000003F6F50200000000'
 DC X'03F6F5F50000000004F6F5F8F9000000BED3E3E7E340000303F6F8F800000000'
 DC X'BED7F2F1F640E50303F6F7020000000005F6F7F7F202000004F6F7F1F3000000'
 DC X'04F6F702E300000005F6F702E3E7000006F6F702E3E7E30007F6F702E3E7E340'
 DC X'03F6F9020000000004F6F902E300000005F6F902E3E7000006F6F902E3E7E300'
 DC X'07F6F902E3E7E340BEE0E3E7E340000303F6F30200000000BEE6E3E7E3400003'
 DC X'03F6F2020000000003F6F2F000000000BEE8E3E7E340000303F6404000000000'
 DC X'04F640400000000005F640400038000006F640400038400007F6404000384040'
 DC X'BEEB003840400003BEEC38404000010407F6F4F560F0F0F104F6F4F3F7000000'
 DC X'04F6F6F8F900000002F702000000000002F7F1000000000002F7F00000000000'
 DC X'02F7F6000000000002F7F70000000000405000000000000002F7F90000000000'
 DC X'02F7F2000000000002F7F3000000000002F7F5000000000002F7F40000000000'
 DC X'02F7F8000000000002F740000000000002F750000000000003F702E300000000'
 DC X'03F702D90000000003F702C50000000004F702E3E700000005F702E3E7E30000'
 DC X'06F702E3E7E3400007F702E3E7E3400007F702E3E7E34001BF03E7E340000603'
 DC X'BF03E7E340001903BF03E7E340000003BF03E7E340000403BF04D3C440404003'
 DC X'07F7F102E3E7E34003F7F1F50000000003F7F1F10000000005F7F1F502E30000'
 DC X'03F7F0020000000003F7F0400000000004F7F0F00200000004F7F002E3000000'
 DC X'BF17E7E34000110403F7F6020000000003F7F6F300000000BF19E3E7E3400003'
 DC X'03F7F7020000000004F7F7F7F200000007F7F702E3E7E34007F7F902E3E7E340'
 DC X'03F7F9F20000000004F7F9F8F100000004F7F202E300000003F7F30200000000'
 DC X'05F7F3F302E3000006F7F502E3E7E30007F7F402E3E7E34004F7F4F102000000'
 DC X'04F7F802E300000004F740404000000002F802000000000002F8F90000000000'
 DC X'02F8F4000000000002F8F7000000000002F8F80000000000004050415847054B'
 DC X'02F8F2000000000002F8F1000000000002F8F6000000000002F8F30000000000'
 DC X'02F8F0000000000002F8F5000000000002F800000000000002F8400000000000'
 DC X'02F850000000000002F841000000000002F858000000000002F8470000000000'
 DC X'04F805EF4400000004F84BF8A7000000000000000000000004F8C540C6000000'
 DC X'04F896805000000002F818000000000003F8D2030000000003F8A71500000000'
 DC X'03F802E30000000005F802C5D5C4000005F802D9D3C4000004F802E3E7000000'
 DC X'05F802E3E7E3000006F802E3E7E3400007F802E3E7E34000BF44E7E340000403'
 DC X'BF44E7E340000503BF47E3400016F40403F8F9020000000003F8F9F800000000'
 DC X'04F8F9F00200000004F8F902E300000005F8F902E3E7000006F8F902E3E7E300'
 DC X'07F8F902E3E7E340BF4EE3E7E340000307F8F402E3E7E34003F8F4F800000000'
 DC X'05F8F4F702E3000004F8F4F60200000003F8F7020000000003F8F7F500000000'
 DC X'05F8F7F202E3000005F8F7F7F102000004F8F702E300000005F8F702E3E70000'
 DC X'06F8F702E3E7E30007F8F702E3E7E340BF5AE3E7E340000303F8F8F500000000'
 DC X'03F8F8020000000006F8F8F402E3E70005F8F8F2F1F6000005F8F802E3E70000'
 DC X'03F8F2020000000005F8F2F102D9000003F8F2F200000000BF68E3E7E3400003'
 DC X'03F8F1020000000004F8F102E300000005F8F102E3E7000006F8F102E3E7E300'
 DC X'07F8F102E3E7E340BF6CE3E7E340000307F8F602E3E7E34003F8F6F000000000'
 DC X'03F8F3020000000004F8F3F40200000004F8F302E3000000BF76E7E340000004'
 DC X'06F8F002E3E7E30005F8F0F902E3000003F8F0F80000000006F8F502E3E7E300'
 DC X'03F8F5F10000000003F800000000000005F800000000000003F8404000000000'
 DC X'03F858F00000000002F902000000000002F9F9000000000002F9F50000000000'
 DC X'02F9F3000000000002F9F60000000000180000000000000002F9F70000000000'
 DC X'02F9F4000000000002F9F8000000000002F9F1000000000002F9F00000000000'
 DC X'02F9F2000000000003F918020000000003F902E30000000006F902D9D3C44000'
 DC X'03F902C50000000004F902E3E700000005F902E3E7E3000006F902E3E7E34000'
 DC X'07F902E3E7E34000BF8EE7E340000003BF8EE7E340005003BF91E3400015E804'
 DC X'03F9F9020000000003F9F9F60000000005F9F9F46B40000003F9F9F500000000'
 DC X'04F9F902E300000005F9F902E3E7000006F9F902E3E7E30007F9F902E3E7E340'
 DC X'03F9F5020000000004F9F502E300000005F9F502E3E7000006F9F502E3E7E300'
 DC X'07F9F502E3E7E340BFA0E3E7E340000303F9F3020000000003F9F3F500000000'
 DC X'05F9F3F8F502000007F9F302E3E7E34004F9F3F50200000003F9F6F000000000'
 DC X'06F9F602E3E7E30003F9F6F20000000004F9F6F60200000004F9F6F5F6000000'
 DC X'05F9F6F002C5000003F9F7020000000003F9F7F60000000004F9F7F3F8000000'
 DC X'BFB1E3E7E340000303F9F4F80000000003F9F4F00000000003F9F40200000000'
 DC X'05F9F4F802E3000003F9F80200000000BFB9E3E7E340000303F9F10200000000'
 DC X'04F9F1F00200000004F9F102E3000000BFBDE7E34000370405F9F002E3E70000'
 DC X'05F9F202E3E7000004F9F2F2F600000002FA41000000000005FA000000000000'
 DC X'02FC40000000000002FC00000000000002FC50000000000002FC410000000000'
 DC X'02FC580000000000000000000000000004FC0D001C00000004FC184040000000'
 DC X'04FCD203D200000003FC40400000000007FC40400038404003FC411000000000'
 DC X'02FE40000000000002FE41000000000002FEFF000000000002FED70000000000'
 DC X'02FE470000000000000000000000000002FE90000000000003FE404000000000'
 DC X'04FE404000000000BFD700384040000303FEFFFF0000000003FE90EC00000000'
 DC X'02FFFF000000000002FF10000000000002FF00000000000002FF470000000000'
 DC X'02FFF00000000000D00000000000000002FF58000000000002FFFE0000000000'
 DC X'05FF06F047D0000002FF90000000000004FF43850000000002FF040000000000'
 DC X'03FFD0A00000000003FFFFFF0000000003FFFFFC0000000005FFFFFE00010000'
 DC X'04FFFF000000000004FFFFFFFF00000004FFFFFF0000000005FFFFFFFFFF0000'
 DC X'BFED00000000000406FFFFFFFFFFFF00BFEDFFFFFFFFFF0405FFFFFF00000000'
 DC X'06FFFFFF00000000BFE9000000031C0303FF10000000000004FF100020000000'
 DC X'05FF100020000000BFF70047803AAE0403FF00000000000004FF000000000000'
 PRINT ON
 DC X'03FF47800000000003FF47700000000003FFF0F00000000004FFF0F0F0000000'
EDICTSIZ EQU   *-EXPDICT          Expansion dictionary size
                                                                EJECT
                                                                SPACE 3
R0       EQU   0
R1       EQU   1
R2       EQU   2
R3       EQU   3
R4       EQU   4
R5       EQU   5
R6       EQU   6
R7       EQU   7
R8       EQU   8
R9       EQU   9
R10      EQU   10
R11      EQU   11
R12      EQU   12
R13      EQU   13
R14      EQU   14
R15      EQU   15
                                                                SPACE 4
         END
