# *cattrs*: Flexible Object Serialization and Validation

*Because validation belongs to the edges.*

---

```{include} ../README.md
:start-after: "begin-teaser -->"
:end-before: "<!-- end-teaser"
```

```{include} ../README.md
:start-after: "begin-example -->"
:end-before: "<!-- end-example"
```

---

However, *cattrs* does **much** more with a focus on **functional composition** and **not coupling** your data model to its serialization and validation rules.

To learn more on why to use *cattrs*, have a look at {doc}`why`, and if you're convinced jump right into {doc}`basics`!


```{toctree}
---
maxdepth: 2
hidden: true
caption: Introduction
---

why
basics
defaulthooks
```

```{toctree}
---
maxdepth: 2
hidden: true
caption: User Guide
---

customizing
strategies
recipes
validation
preconf
unions
usage
migrations
indepth
```

```{toctree}
---
maxdepth: 2
hidden: true
caption: Reference
---

API <modules>
modindex
genindex
```

```{toctree}
---
maxdepth: 2
hidden: true
caption: Dev Guide
---

contributing
benchmarking
```

```{toctree}
---
caption: Meta
hidden: true
maxdepth: 1
---

history
PyPI <https://pypi.org/project/cattrs/>
GitHub <https://github.com/python-attrs/cattrs>
```
