/*
 * Copyright (c) 2018, 2025, Oracle and/or its affiliates. All rights reserved.
 * 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * The contents of this file are subject to the terms of either the Universal Permissive License
 * v 1.0 as shown at https://oss.oracle.com/licenses/upl
 *
 * or the following license:
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted
 * provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions
 * and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other materials provided with
 * the distribution.
 * 
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to
 * endorse or promote products derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 * WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.openjdk.jmc.flightrecorder.metadata;

import org.openjdk.jmc.common.IDescribable;
import org.openjdk.jmc.common.item.IAccessorKey;

public class MetadataNode {
	private final MetadataNode parent;
	private MetadataNode[] children = new MetadataNode[0];
	private final String name;
	private final String description;
	private final String id;
	private final String contentTypeId;
	private final String contentTypeName;

	public MetadataNode(MetadataNode parent, IAccessorKey<?> key, IDescribable desc) {
		this(parent, desc.getName(), desc.getDescription(), key.getIdentifier(), key.getContentType().getIdentifier(),
				key.getContentType().getName());
	}

	public MetadataNode(MetadataNode parent, String name, String description, String id, String contentTypeId,
			String contentTypeName) {
		this.parent = parent;
		this.name = name;
		this.description = description;
		this.id = id;
		this.contentTypeId = contentTypeId;
		this.contentTypeName = contentTypeName;
	}

	public void setChildren(MetadataNode[] children) {
		this.children = children;
	}

	public MetadataNode[] getChildren() {
		return children;
	}

	public String getName() {
		return name;
	}

	public String getDescription() {
		return description;
	}

	public String getId() {
		return id;
	}

	public String getContentTypeId() {
		return contentTypeId;
	}

	public String getContentTypeName() {
		return contentTypeName;
	}

	public boolean hasChildren() {
		return children.length > 0;
	}

	public MetadataNode getParent() {
		return parent;
	}

	@Override
	public String toString() {
		if (getParent() == null) {
			return ""; //$NON-NLS-1$
		}
		return getParent().toString() + "/" + getName(); //$NON-NLS-1$
	}
}
