[38;2;117;113;94m#[0m[38;2;117;113;94m CoffeeScript can be used both on the server, as a command-line compiler based[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m on Node.js/V8, or to run CoffeeScript directly in the browser. This module[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m contains the main entry functions for tokenizing, parsing, and compiling[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m source CoffeeScript into JavaScript.[0m

[38;2;249;38;114m{[0m[38;2;248;248;242mLexer[0m[38;2;249;38;114m}       =[0m[38;2;248;248;242m [0m[38;2;102;217;239mrequire[0m[38;2;248;248;242m [0m[38;2;230;219;116m'[0m[38;2;230;219;116m./lexer[0m[38;2;230;219;116m'[0m
[38;2;249;38;114m{[0m[38;2;248;248;242mparser[0m[38;2;249;38;114m}      =[0m[38;2;248;248;242m [0m[38;2;102;217;239mrequire[0m[38;2;248;248;242m [0m[38;2;230;219;116m'[0m[38;2;230;219;116m./parser[0m[38;2;230;219;116m'[0m
[38;2;248;248;242mhelpers       [0m[38;2;249;38;114m= [0m[38;2;102;217;239mrequire[0m[38;2;248;248;242m [0m[38;2;230;219;116m'[0m[38;2;230;219;116m./helpers[0m[38;2;230;219;116m'[0m
[38;2;248;248;242mSourceMap     [0m[38;2;249;38;114m= [0m[38;2;102;217;239mrequire[0m[38;2;248;248;242m [0m[38;2;230;219;116m'[0m[38;2;230;219;116m./sourcemap[0m[38;2;230;219;116m'[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m Require `package.json`, which is two levels above this file, as this file is[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m evaluated from `lib/coffeescript`.[0m
[38;2;248;248;242mpackageJson   [0m[38;2;249;38;114m= [0m[38;2;102;217;239mrequire[0m[38;2;248;248;242m [0m[38;2;230;219;116m'[0m[38;2;230;219;116m../../package.json[0m[38;2;230;219;116m'[0m

[38;2;117;113;94m#[0m[38;2;117;113;94m The current CoffeeScript version number.[0m
[38;2;248;248;242mexports.VERSION [0m[38;2;249;38;114m= [0m[38;2;248;248;242mpackageJson[0m[38;2;248;248;242m.[0m[38;2;248;248;242mversion[0m

[38;2;248;248;242mexports.FILE_EXTENSIONS [0m[38;2;249;38;114m= [0m[38;2;248;248;242mFILE_EXTENSIONS [0m[38;2;249;38;114m= [0m[38;2;248;248;242m[[0m[38;2;230;219;116m'[0m[38;2;230;219;116m.coffee[0m[38;2;230;219;116m'[0m[38;2;248;248;242m, [0m[38;2;230;219;116m'[0m[38;2;230;219;116m.litcoffee[0m[38;2;230;219;116m'[0m[38;2;248;248;242m, [0m[38;2;230;219;116m'[0m[38;2;230;219;116m.coffee.md[0m[38;2;230;219;116m'[0m[38;2;248;248;242m][0m

[38;2;117;113;94m#[0m[38;2;117;113;94m Expose helpers for testing.[0m
[38;2;248;248;242mexports.helpers [0m[38;2;249;38;114m= [0m[38;2;248;248;242mhelpers[0m

[38;2;117;113;94m#[0m[38;2;117;113;94m Function that allows for btoa in both nodejs and the browser.[0m
[38;2;166;226;46mbase64encod[0m[38;2;166;226;46me[0m[38;2;166;226;46m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[3;38;2;253;151;31m(src)[0m[38;2;248;248;242m [0m[3;38;2;102;217;239m->[0m[38;2;248;248;242m [0m[38;2;249;38;114mswitch[0m
[38;2;248;248;242m  [0m[38;2;249;38;114mwhen[0m[38;2;248;248;242m [0m[38;2;249;38;114mtypeof[0m[38;2;248;248;242m Buffer [0m[38;2;249;38;114mis[0m[38;2;248;248;242m [0m[38;2;230;219;116m'[0m[38;2;230;219;116mfunction[0m[38;2;230;219;116m'[0m
[38;2;248;248;242m    Buffer[0m[38;2;248;248;242m.[0m[38;2;102;217;239mfrom[0m[38;2;255;255;255m([0m[38;2;248;248;242msrc[0m[38;2;255;255;255m)[0m[38;2;248;248;242m.[0m[38;2;102;217;239mtoString[0m[38;2;255;255;255m([0m[38;2;230;219;116m'[0m[38;2;230;219;116mbase64[0m[38;2;230;219;116m'[0m[38;2;255;255;255m)[0m
[38;2;248;248;242m  [0m[38;2;249;38;114mwhen[0m[38;2;248;248;242m [0m[38;2;249;38;114mtypeof[0m[38;2;248;248;242m btoa [0m[38;2;249;38;114mis[0m[38;2;248;248;242m [0m[38;2;230;219;116m'[0m[38;2;230;219;116mfunction[0m[38;2;230;219;116m'[0m
[38;2;248;248;242m    [0m[38;2;117;113;94m#[0m[38;2;117;113;94m The contents of a `<script>` block are encoded via UTF-16, so if any extended[0m
[38;2;248;248;242m    [0m[38;2;117;113;94m#[0m[38;2;117;113;94m characters are used in the block, btoa will fail as it maxes out at UTF-8.[0m
[38;2;248;248;242m    [0m[38;2;117;113;94m#[0m[38;2;117;113;94m See https://developer.mozilla.org/en-US/docs/Web/API/WindowBase64/Base64_encoding_and_decoding#The_Unicode_Problem[0m
[38;2;248;248;242m    [0m[38;2;117;113;94m#[0m[38;2;117;113;94m for the gory details, and for the solution implemented here.[0m
[38;2;248;248;242m    btoa [0m[38;2;102;217;239mencodeURIComponent[0m[38;2;255;255;255m([0m[38;2;248;248;242msrc[0m[38;2;255;255;255m)[0m[38;2;248;248;242m.[0m[38;2;248;248;242mreplace [0m[38;2;246;170;17m/%([0-9A-F]{2})/g[0m[38;2;248;248;242m, [0m[3;38;2;253;151;31m(match, p1)[0m[38;2;248;248;242m [0m[3;38;2;102;217;239m->[0m
[38;2;248;248;242m      [0m[3;38;2;166;226;46mString[0m[38;2;248;248;242m.[0m[38;2;248;248;242mfromCharCode [0m[38;2;230;219;116m'[0m[38;2;230;219;116m0x[0m[38;2;230;219;116m'[0m[38;2;248;248;242m [0m[38;2;249;38;114m+[0m[38;2;248;248;242m p1[0m
[38;2;248;248;242m  [0m[38;2;249;38;114melse[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mthrow[0m[38;2;248;248;242m [0m[38;2;249;38;114mnew[0m[38;2;248;248;242m [0m[3;38;2;166;226;46mError[0m[38;2;255;255;255m([0m[38;2;230;219;116m'[0m[38;2;230;219;116mUnable to base64 encode inline sourcemap.[0m[38;2;230;219;116m'[0m[38;2;255;255;255m)[0m

[38;2;117;113;94m#[0m[38;2;117;113;94m Function wrapper to add source file information to SyntaxErrors thrown by the[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m lexer/parser/compiler.[0m
[38;2;166;226;46mwithPrettyError[0m[38;2;166;226;46ms[0m[38;2;166;226;46m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[3;38;2;253;151;31m(fn)[0m[38;2;248;248;242m [0m[3;38;2;102;217;239m->[0m
[38;2;248;248;242m  [0m[3;38;2;253;151;31m(code, options = {})[0m[38;2;248;248;242m [0m[3;38;2;102;217;239m->[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mtry[0m
[38;2;248;248;242m      fn[0m[38;2;248;248;242m.[0m[38;2;102;217;239mcall[0m[38;2;248;248;242m [0m[38;2;255;255;255m@[0m[38;2;248;248;242m, [0m[38;2;248;248;242mcode[0m[38;2;248;248;242m, [0m[38;2;248;248;242moptions[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mcatch[0m[38;2;248;248;242m err[0m
[38;2;248;248;242m      [0m[38;2;249;38;114mthrow[0m[38;2;248;248;242m err [0m[38;2;249;38;114mif[0m[38;2;248;248;242m [0m[38;2;249;38;114mtypeof[0m[38;2;248;248;242m code [0m[38;2;249;38;114misnt[0m[38;2;248;248;242m [0m[38;2;230;219;116m'[0m[38;2;230;219;116mstring[0m[38;2;230;219;116m'[0m[38;2;248;248;242m [0m[38;2;117;113;94m#[0m[38;2;117;113;94m Support `CoffeeScript.nodes(tokens)`.[0m
[38;2;248;248;242m      [0m[38;2;249;38;114mthrow[0m[38;2;248;248;242m helpers[0m[38;2;248;248;242m.[0m[38;2;248;248;242mupdateSyntaxError err[0m[38;2;248;248;242m, [0m[38;2;248;248;242mcode[0m[38;2;248;248;242m, [0m[38;2;248;248;242moptions[0m[38;2;248;248;242m.[0m[38;2;248;248;242mfilename[0m

[38;2;117;113;94m#[0m[38;2;117;113;94m For each compiled file, save its source in memory in case we need to[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m recompile it later. We might need to recompile if the first compilation[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m didn’t create a source map (faster) but something went wrong and we need[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m a stack trace. Assuming that most of the time, code isn’t throwing[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m exceptions, it’s probably more efficient to compile twice only when we[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m need a stack trace, rather than always generating a source map even when[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m it’s not likely to be used. Save in form of `filename`: [`(source)`][0m
[38;2;248;248;242msources [0m[38;2;249;38;114m= [0m[38;2;248;248;242m{[0m[38;2;248;248;242m}[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m Also save source maps if generated, in form of `(source)`: [`(source map)`].[0m
[38;2;248;248;242msourceMaps [0m[38;2;249;38;114m= [0m[38;2;248;248;242m{[0m[38;2;248;248;242m}[0m

[38;2;117;113;94m#[0m[38;2;117;113;94m This is exported to enable an external module to implement caching of[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m compilation results. When the compiled js source is loaded from cache, the[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m original coffee code should be added with this method in order to enable the[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m Error.prepareStackTrace below to correctly adjust the stack trace for the[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m corresponding file (the source map will be generated on demand).[0m
[38;2;248;248;242mexports.registerCompiled [0m[38;2;249;38;114m= [0m[38;2;166;226;46mregisterCompile[0m[38;2;166;226;46md[0m[38;2;166;226;46m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[3;38;2;253;151;31m(filename, source, sourcemap)[0m[38;2;248;248;242m [0m[3;38;2;102;217;239m->[0m

[38;2;248;248;242m  sources[0m[38;2;248;248;242m[[0m[38;2;248;248;242mfilename[0m[38;2;248;248;242m] [0m[38;2;249;38;114m?[0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;248;248;242m[[0m[38;2;248;248;242m][0m
[38;2;248;248;242m  sources[0m[38;2;248;248;242m[[0m[38;2;248;248;242mfilename[0m[38;2;248;248;242m][0m[38;2;248;248;242m.[0m[38;2;102;217;239mpush[0m[38;2;248;248;242m source[0m

[38;2;248;248;242m  [0m[38;2;249;38;114mif[0m[38;2;248;248;242m sourcemap[0m[38;2;249;38;114m?[0m
[38;2;248;248;242m    sourceMaps[0m[38;2;248;248;242m[[0m[38;2;248;248;242mfilename[0m[38;2;248;248;242m] [0m[38;2;249;38;114m?[0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;248;248;242m[[0m[38;2;248;248;242m][0m
[38;2;248;248;242m    sourceMaps[0m[38;2;248;248;242m[[0m[38;2;248;248;242mfilename[0m[38;2;248;248;242m][0m[38;2;248;248;242m.[0m[38;2;102;217;239mpush[0m[38;2;248;248;242m sourcemap[0m

[38;2;117;113;94m#[0m[38;2;117;113;94m Compile CoffeeScript code to JavaScript, using the Coffee/Jison compiler.[0m
[38;2;117;113;94m#[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m If `options.sourceMap` is specified, then `options.filename` must also be[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m specified. All options that can be passed to `SourceMap#generate` may also[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m be passed here.[0m
[38;2;117;113;94m#[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m This returns a javascript string, unless `options.sourceMap` is passed,[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m in which case this returns a `{js, v3SourceMap, sourceMap}`[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m object, where sourceMap is a sourcemap.coffee#SourceMap object, handy for[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m doing programmatic lookups.[0m
[38;2;248;248;242mexports.compile [0m[38;2;249;38;114m= [0m[38;2;248;248;242mcompile [0m[38;2;249;38;114m= [0m[38;2;248;248;242mwithPrettyErrors [0m[3;38;2;253;151;31m(code, options = {})[0m[38;2;248;248;242m [0m[3;38;2;102;217;239m->[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m Clone `options`, to avoid mutating the `options` object passed in.[0m
[38;2;248;248;242m  [0m[38;2;248;248;242moptions [0m[38;2;249;38;114m= [0m[3;38;2;166;226;46mObject[0m[38;2;248;248;242m.[0m[38;2;248;248;242massign [0m[38;2;248;248;242m{[0m[38;2;248;248;242m}[0m[38;2;248;248;242m, [0m[38;2;248;248;242moptions[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m Always generate a source map if no filename is passed in, since without a[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m a filename we have no way to retrieve this source later in the event that[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m we need to recompile it to get a source map for `prepareStackTrace`.[0m
[38;2;248;248;242m  [0m[38;2;248;248;242mgenerateSourceMap [0m[38;2;249;38;114m= [0m[38;2;248;248;242moptions[0m[38;2;248;248;242m.[0m[38;2;248;248;242msourceMap [0m[38;2;249;38;114mor[0m[38;2;248;248;242m options[0m[38;2;248;248;242m.[0m[38;2;248;248;242minlineMap [0m[38;2;249;38;114mor[0m[38;2;248;248;242m [0m[38;2;249;38;114mnot[0m[38;2;248;248;242m options[0m[38;2;248;248;242m.[0m[38;2;248;248;242mfilename[0m[38;2;249;38;114m?[0m
[38;2;248;248;242m  [0m[38;2;248;248;242mfilename [0m[38;2;249;38;114m= [0m[38;2;248;248;242moptions[0m[38;2;248;248;242m.[0m[38;2;248;248;242mfilename [0m[38;2;249;38;114mor[0m[38;2;248;248;242m [0m[38;2;230;219;116m'[0m[38;2;230;219;116m<anonymous>[0m[38;2;230;219;116m'[0m

[38;2;248;248;242m  checkShebangLine filename[0m[38;2;248;248;242m, [0m[38;2;248;248;242mcode[0m

[38;2;248;248;242m  [0m[38;2;248;248;242mmap [0m[38;2;249;38;114m= [0m[38;2;249;38;114mnew[0m[38;2;248;248;242m [0m[3;38;2;166;226;46mSourceMap[0m[38;2;248;248;242m [0m[38;2;249;38;114mif[0m[38;2;248;248;242m generateSourceMap[0m

[38;2;248;248;242m  [0m[38;2;248;248;242mtokens [0m[38;2;249;38;114m= [0m[38;2;248;248;242mlexer[0m[38;2;248;248;242m.[0m[38;2;248;248;242mtokenize code[0m[38;2;248;248;242m, [0m[38;2;248;248;242moptions[0m

[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m Pass a list of referenced variables, so that generated variables won’t get[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m the same name.[0m
[38;2;248;248;242m  [0m[38;2;248;248;242moptions.referencedVars [0m[38;2;249;38;114m= [0m[38;2;255;255;255m([0m
[38;2;248;248;242m    token[0m[38;2;248;248;242m[[0m[38;2;190;132;255m1[0m[38;2;248;248;242m] [0m[38;2;249;38;114mfor[0m[38;2;248;248;242m token [0m[38;2;249;38;114min[0m[38;2;248;248;242m tokens [0m[38;2;249;38;114mwhen[0m[38;2;248;248;242m token[0m[38;2;248;248;242m[[0m[38;2;190;132;255m0[0m[38;2;248;248;242m] [0m[38;2;249;38;114mis[0m[38;2;248;248;242m [0m[38;2;230;219;116m'[0m[38;2;230;219;116mIDENTIFIER[0m[38;2;230;219;116m'[0m
[38;2;248;248;242m  [0m[38;2;255;255;255m)[0m

[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m Check for import or export; if found, force bare mode.[0m
[38;2;248;248;242m  [0m[38;2;249;38;114munless[0m[38;2;248;248;242m options[0m[38;2;248;248;242m.[0m[38;2;248;248;242mbare[0m[38;2;249;38;114m?[0m[38;2;248;248;242m [0m[38;2;249;38;114mand[0m[38;2;248;248;242m options[0m[38;2;248;248;242m.[0m[38;2;248;248;242mbare [0m[38;2;249;38;114mis[0m[38;2;248;248;242m [0m[38;2;190;132;255myes[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mfor[0m[38;2;248;248;242m token [0m[38;2;249;38;114min[0m[38;2;248;248;242m tokens[0m
[38;2;248;248;242m      [0m[38;2;249;38;114mif[0m[38;2;248;248;242m token[0m[38;2;248;248;242m[[0m[38;2;190;132;255m0[0m[38;2;248;248;242m] [0m[38;2;249;38;114min[0m[38;2;248;248;242m [0m[38;2;248;248;242m[[0m[38;2;230;219;116m'[0m[38;2;230;219;116mIMPORT[0m[38;2;230;219;116m'[0m[38;2;248;248;242m, [0m[38;2;230;219;116m'[0m[38;2;230;219;116mEXPORT[0m[38;2;230;219;116m'[0m[38;2;248;248;242m][0m
[38;2;248;248;242m        [0m[38;2;248;248;242moptions.bare [0m[38;2;249;38;114m= [0m[38;2;190;132;255myes[0m
[38;2;248;248;242m        [0m[38;2;249;38;114mbreak[0m

[38;2;248;248;242m  [0m[38;2;248;248;242mnodes [0m[38;2;249;38;114m= [0m[38;2;248;248;242mparser[0m[38;2;248;248;242m.[0m[38;2;248;248;242mparse tokens[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m If all that was requested was a POJO representation of the nodes, e.g.[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m the abstract syntax tree (AST), we can stop now and just return that[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m (after fixing the location data for the root/`File`»`Program` node,[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m which might’ve gotten misaligned from the original source due to the[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m `clean` function in the lexer).[0m
[38;2;248;248;242m  [0m[38;2;249;38;114mif[0m[38;2;248;248;242m options[0m[38;2;248;248;242m.[0m[38;2;248;248;242mast[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mnodes.allCommentTokens [0m[38;2;249;38;114m= [0m[38;2;248;248;242mhelpers[0m[38;2;248;248;242m.[0m[38;2;248;248;242mextractAllCommentTokens tokens[0m
[38;2;248;248;242m    [0m[38;2;248;248;242msourceCodeNumberOfLines [0m[38;2;249;38;114m= [0m[38;2;255;255;255m([0m[38;2;248;248;242mcode[0m[38;2;248;248;242m.[0m[38;2;248;248;242mmatch[0m[38;2;255;255;255m([0m[38;2;246;170;17m/\r?\n/g[0m[38;2;255;255;255m)[0m[38;2;248;248;242m [0m[38;2;249;38;114mor[0m[38;2;248;248;242m [0m[38;2;230;219;116m'[0m[38;2;230;219;116m'[0m[38;2;255;255;255m)[0m[38;2;248;248;242m.[0m[38;2;248;248;242mlength [0m[38;2;249;38;114m+[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m
[38;2;248;248;242m    [0m[38;2;248;248;242msourceCodeLastLine [0m[38;2;249;38;114m= [0m[38;2;246;170;17m/.*$/[0m[38;2;248;248;242m.[0m[38;2;248;248;242mexec[0m[38;2;255;255;255m([0m[38;2;248;248;242mcode[0m[38;2;255;255;255m)[0m[38;2;248;248;242m[[0m[38;2;190;132;255m0[0m[38;2;248;248;242m] [0m[38;2;117;113;94m#[0m[38;2;117;113;94m `.*` matches all but line break characters.[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mast [0m[38;2;249;38;114m= [0m[38;2;248;248;242mnodes[0m[38;2;248;248;242m.[0m[38;2;248;248;242mast options[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mrange [0m[38;2;249;38;114m= [0m[38;2;248;248;242m[[0m[38;2;190;132;255m0[0m[38;2;248;248;242m, [0m[38;2;248;248;242mcode[0m[38;2;248;248;242m.[0m[38;2;248;248;242mlength[0m[38;2;248;248;242m][0m
[38;2;248;248;242m    [0m[38;2;248;248;242mast.start [0m[38;2;249;38;114m= [0m[38;2;248;248;242mast.program.start [0m[38;2;249;38;114m= [0m[38;2;248;248;242mrange[0m[38;2;248;248;242m[[0m[38;2;190;132;255m0[0m[38;2;248;248;242m][0m
[38;2;248;248;242m    [0m[38;2;248;248;242mast.end [0m[38;2;249;38;114m= [0m[38;2;248;248;242mast.program.end [0m[38;2;249;38;114m= [0m[38;2;248;248;242mrange[0m[38;2;248;248;242m[[0m[38;2;190;132;255m1[0m[38;2;248;248;242m][0m
[38;2;248;248;242m    [0m[38;2;248;248;242mast.range [0m[38;2;249;38;114m= [0m[38;2;248;248;242mast.program.range [0m[38;2;249;38;114m= [0m[38;2;248;248;242mrange[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mast.loc.start [0m[38;2;249;38;114m= [0m[38;2;248;248;242mast.program.loc.start [0m[38;2;249;38;114m= [0m[38;2;248;248;242m{[0m[38;2;248;248;242mline[0m[38;2;248;248;242m:[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m, [0m[38;2;248;248;242mcolumn[0m[38;2;248;248;242m:[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m[38;2;248;248;242m}[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mast.loc.end.line [0m[38;2;249;38;114m= [0m[38;2;248;248;242mast.program.loc.end.line [0m[38;2;249;38;114m= [0m[38;2;248;248;242msourceCodeNumberOfLines[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mast.loc.end.column [0m[38;2;249;38;114m= [0m[38;2;248;248;242mast.program.loc.end.column [0m[38;2;249;38;114m= [0m[38;2;248;248;242msourceCodeLastLine[0m[38;2;248;248;242m.[0m[38;2;248;248;242mlength[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mast.tokens [0m[38;2;249;38;114m= [0m[38;2;248;248;242mtokens[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mreturn[0m[38;2;248;248;242m ast[0m

[38;2;248;248;242m  [0m[38;2;248;248;242mfragments [0m[38;2;249;38;114m= [0m[38;2;248;248;242mnodes[0m[38;2;248;248;242m.[0m[38;2;248;248;242mcompileToFragments options[0m

[38;2;248;248;242m  [0m[38;2;248;248;242mcurrentLine [0m[38;2;249;38;114m= [0m[38;2;190;132;255m0[0m
[38;2;248;248;242m  currentLine [0m[38;2;249;38;114m+[0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m [0m[38;2;249;38;114mif[0m[38;2;248;248;242m options[0m[38;2;248;248;242m.[0m[38;2;248;248;242mheader[0m
[38;2;248;248;242m  currentLine [0m[38;2;249;38;114m+[0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m [0m[38;2;249;38;114mif[0m[38;2;248;248;242m options[0m[38;2;248;248;242m.[0m[38;2;248;248;242mshiftLine[0m
[38;2;248;248;242m  [0m[38;2;248;248;242mcurrentColumn [0m[38;2;249;38;114m= [0m[38;2;190;132;255m0[0m
[38;2;248;248;242m  [0m[38;2;248;248;242mjs [0m[38;2;249;38;114m= [0m[38;2;230;219;116m"[0m[38;2;230;219;116m"[0m
[38;2;248;248;242m  [0m[38;2;249;38;114mfor[0m[38;2;248;248;242m fragment [0m[38;2;249;38;114min[0m[38;2;248;248;242m fragments[0m
[38;2;248;248;242m    [0m[38;2;117;113;94m#[0m[38;2;117;113;94m Update the sourcemap with data from each fragment.[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mif[0m[38;2;248;248;242m generateSourceMap[0m
[38;2;248;248;242m      [0m[38;2;117;113;94m#[0m[38;2;117;113;94m Do not include empty, whitespace, or semicolon-only fragments.[0m
[38;2;248;248;242m      [0m[38;2;249;38;114mif[0m[38;2;248;248;242m fragment[0m[38;2;248;248;242m.[0m[38;2;248;248;242mlocationData [0m[38;2;249;38;114mand[0m[38;2;248;248;242m [0m[38;2;249;38;114mnot[0m[38;2;248;248;242m [0m[38;2;246;170;17m/^[;\s]*$/[0m[38;2;248;248;242m.[0m[38;2;248;248;242mtest fragment[0m[38;2;248;248;242m.[0m[38;2;248;248;242mcode[0m
[38;2;248;248;242m        map[0m[38;2;248;248;242m.[0m[38;2;248;248;242madd[0m[38;2;255;255;255m([0m
[38;2;248;248;242m          [0m[38;2;248;248;242m[[0m[38;2;248;248;242mfragment[0m[38;2;248;248;242m.[0m[38;2;248;248;242mlocationData[0m[38;2;248;248;242m.[0m[38;2;248;248;242mfirst_line[0m[38;2;248;248;242m, [0m[38;2;248;248;242mfragment[0m[38;2;248;248;242m.[0m[38;2;248;248;242mlocationData[0m[38;2;248;248;242m.[0m[38;2;248;248;242mfirst_column[0m[38;2;248;248;242m][0m
[38;2;248;248;242m          [0m[38;2;248;248;242m[[0m[38;2;248;248;242mcurrentLine[0m[38;2;248;248;242m, [0m[38;2;248;248;242mcurrentColumn[0m[38;2;248;248;242m][0m
[38;2;248;248;242m          [0m[38;2;248;248;242m{[0m[38;2;248;248;242mnoReplace[0m[38;2;248;248;242m:[0m[38;2;248;248;242m [0m[38;2;190;132;255mtrue[0m[38;2;248;248;242m}[0m[38;2;255;255;255m)[0m
[38;2;248;248;242m      [0m[38;2;248;248;242mnewLines [0m[38;2;249;38;114m= [0m[38;2;248;248;242mhelpers[0m[38;2;248;248;242m.[0m[38;2;248;248;242mcount fragment[0m[38;2;248;248;242m.[0m[38;2;248;248;242mcode[0m[38;2;248;248;242m, [0m[38;2;230;219;116m"[0m[38;2;190;132;255m\n[0m[38;2;230;219;116m"[0m
[38;2;248;248;242m      currentLine [0m[38;2;249;38;114m+[0m[38;2;249;38;114m=[0m[38;2;248;248;242m newLines[0m
[38;2;248;248;242m      [0m[38;2;249;38;114mif[0m[38;2;248;248;242m newLines[0m
[38;2;248;248;242m        [0m[38;2;248;248;242mcurrentColumn [0m[38;2;249;38;114m= [0m[38;2;248;248;242mfragment[0m[38;2;248;248;242m.[0m[38;2;248;248;242mcode[0m[38;2;248;248;242m.[0m[38;2;248;248;242mlength [0m[38;2;249;38;114m-[0m[38;2;248;248;242m [0m[38;2;255;255;255m([0m[38;2;248;248;242mfragment[0m[38;2;248;248;242m.[0m[38;2;248;248;242mcode[0m[38;2;248;248;242m.[0m[38;2;102;217;239mlastIndexOf[0m[38;2;255;255;255m([0m[38;2;230;219;116m"[0m[38;2;190;132;255m\n[0m[38;2;230;219;116m"[0m[38;2;255;255;255m)[0m[38;2;248;248;242m [0m[38;2;249;38;114m+[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;255;255;255m)[0m
[38;2;248;248;242m      [0m[38;2;249;38;114melse[0m
[38;2;248;248;242m        currentColumn [0m[38;2;249;38;114m+[0m[38;2;249;38;114m=[0m[38;2;248;248;242m fragment[0m[38;2;248;248;242m.[0m[38;2;248;248;242mcode[0m[38;2;248;248;242m.[0m[38;2;248;248;242mlength[0m

[38;2;248;248;242m    [0m[38;2;117;113;94m#[0m[38;2;117;113;94m Copy the code from each fragment into the final JavaScript.[0m
[38;2;248;248;242m    js [0m[38;2;249;38;114m+[0m[38;2;249;38;114m=[0m[38;2;248;248;242m fragment[0m[38;2;248;248;242m.[0m[38;2;248;248;242mcode[0m

[38;2;248;248;242m  [0m[38;2;249;38;114mif[0m[38;2;248;248;242m options[0m[38;2;248;248;242m.[0m[38;2;248;248;242mheader[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mheader [0m[38;2;249;38;114m= [0m[38;2;230;219;116m"[0m[38;2;230;219;116mGenerated by CoffeeScript [0m[38;2;230;159;102m#{[0m[38;2;255;255;255m@VERSION[0m[38;2;230;159;102m}[0m[38;2;230;219;116m"[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mjs [0m[38;2;249;38;114m= [0m[38;2;230;219;116m"[0m[38;2;230;219;116m// [0m[38;2;230;159;102m#{[0m[38;2;230;219;116mheader[0m[38;2;230;159;102m}[0m[38;2;190;132;255m\n[0m[38;2;230;159;102m#{[0m[38;2;230;219;116mjs[0m[38;2;230;159;102m}[0m[38;2;230;219;116m"[0m

[38;2;248;248;242m  [0m[38;2;249;38;114mif[0m[38;2;248;248;242m generateSourceMap[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mv3SourceMap [0m[38;2;249;38;114m= [0m[38;2;248;248;242mmap[0m[38;2;248;248;242m.[0m[38;2;248;248;242mgenerate options[0m[38;2;248;248;242m, [0m[38;2;248;248;242mcode[0m

[38;2;248;248;242m  [0m[38;2;249;38;114mif[0m[38;2;248;248;242m options[0m[38;2;248;248;242m.[0m[38;2;248;248;242mtranspile[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mif[0m[38;2;248;248;242m [0m[38;2;249;38;114mtypeof[0m[38;2;248;248;242m options[0m[38;2;248;248;242m.[0m[38;2;248;248;242mtranspile [0m[38;2;249;38;114misnt[0m[38;2;248;248;242m [0m[38;2;230;219;116m'[0m[38;2;230;219;116mobject[0m[38;2;230;219;116m'[0m
[38;2;248;248;242m      [0m[38;2;117;113;94m#[0m[38;2;117;113;94m This only happens if run via the Node API and `transpile` is set to[0m
[38;2;248;248;242m      [0m[38;2;117;113;94m#[0m[38;2;117;113;94m something other than an object.[0m
[38;2;248;248;242m      [0m[38;2;249;38;114mthrow[0m[38;2;248;248;242m [0m[38;2;249;38;114mnew[0m[38;2;248;248;242m [0m[3;38;2;166;226;46mError[0m[38;2;248;248;242m [0m[38;2;230;219;116m'[0m[38;2;230;219;116mThe transpile option must be given an object with options to pass to Babel[0m[38;2;230;219;116m'[0m

[38;2;248;248;242m    [0m[38;2;117;113;94m#[0m[38;2;117;113;94m Get the reference to Babel that we have been passed if this compiler[0m
[38;2;248;248;242m    [0m[38;2;117;113;94m#[0m[38;2;117;113;94m is run via the CLI or Node API.[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mtranspiler [0m[38;2;249;38;114m= [0m[38;2;248;248;242moptions[0m[38;2;248;248;242m.[0m[38;2;248;248;242mtranspile[0m[38;2;248;248;242m.[0m[38;2;248;248;242mtranspile[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mdelete[0m[38;2;248;248;242m options[0m[38;2;248;248;242m.[0m[38;2;248;248;242mtranspile[0m[38;2;248;248;242m.[0m[38;2;248;248;242mtranspile[0m

[38;2;248;248;242m    [0m[38;2;248;248;242mtranspilerOptions [0m[38;2;249;38;114m= [0m[3;38;2;166;226;46mObject[0m[38;2;248;248;242m.[0m[38;2;248;248;242massign [0m[38;2;248;248;242m{[0m[38;2;248;248;242m}[0m[38;2;248;248;242m, [0m[38;2;248;248;242moptions[0m[38;2;248;248;242m.[0m[38;2;248;248;242mtranspile[0m

[38;2;248;248;242m    [0m[38;2;117;113;94m#[0m[38;2;117;113;94m See https://github.com/babel/babel/issues/827#issuecomment-77573107:[0m
[38;2;248;248;242m    [0m[38;2;117;113;94m#[0m[38;2;117;113;94m Babel can take a v3 source map object as input in `inputSourceMap`[0m
[38;2;248;248;242m    [0m[38;2;117;113;94m#[0m[38;2;117;113;94m and it will return an *updated* v3 source map object in its output.[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mif[0m[38;2;248;248;242m v3SourceMap [0m[38;2;249;38;114mand[0m[38;2;248;248;242m [0m[38;2;249;38;114mnot[0m[38;2;248;248;242m transpilerOptions[0m[38;2;248;248;242m.[0m[38;2;248;248;242minputSourceMap[0m[38;2;249;38;114m?[0m
[38;2;248;248;242m      [0m[38;2;248;248;242mtranspilerOptions.inputSourceMap [0m[38;2;249;38;114m= [0m[38;2;248;248;242mv3SourceMap[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mtranspilerOutput [0m[38;2;249;38;114m= [0m[38;2;248;248;242mtranspiler js[0m[38;2;248;248;242m, [0m[38;2;248;248;242mtranspilerOptions[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mjs [0m[38;2;249;38;114m= [0m[38;2;248;248;242mtranspilerOutput[0m[38;2;248;248;242m.[0m[38;2;248;248;242mcode[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mif[0m[38;2;248;248;242m v3SourceMap [0m[38;2;249;38;114mand[0m[38;2;248;248;242m transpilerOutput[0m[38;2;248;248;242m.[0m[38;2;102;217;239mmap[0m
[38;2;248;248;242m      [0m[38;2;248;248;242mv3SourceMap [0m[38;2;249;38;114m= [0m[38;2;248;248;242mtranspilerOutput[0m[38;2;248;248;242m.[0m[38;2;102;217;239mmap[0m

[38;2;248;248;242m  [0m[38;2;249;38;114mif[0m[38;2;248;248;242m options[0m[38;2;248;248;242m.[0m[38;2;248;248;242minlineMap[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mencoded [0m[38;2;249;38;114m= [0m[38;2;248;248;242mbase64encode JSON[0m[38;2;248;248;242m.[0m[38;2;248;248;242mstringify v3SourceMap[0m
[38;2;248;248;242m    [0m[38;2;248;248;242msourceMapDataURI [0m[38;2;249;38;114m= [0m[38;2;230;219;116m"[0m[38;2;230;219;116m//# sourceMappingURL=data:application/json;base64,[0m[38;2;230;159;102m#{[0m[38;2;230;219;116mencoded[0m[38;2;230;159;102m}[0m[38;2;230;219;116m"[0m
[38;2;248;248;242m    [0m[38;2;248;248;242msourceURL [0m[38;2;249;38;114m= [0m[38;2;230;219;116m"[0m[38;2;230;219;116m//# sourceURL=[0m[38;2;230;159;102m#{[0m[38;2;230;219;116moptions[0m[38;2;230;219;116m.[0m[38;2;230;219;116mfilename [0m[38;2;249;38;114m?[0m[38;2;230;219;116m [0m[38;2;230;219;116m'[0m[38;2;230;219;116mcoffeescript[0m[38;2;230;219;116m'[0m[38;2;230;159;102m}[0m[38;2;230;219;116m"[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mjs [0m[38;2;249;38;114m= [0m[38;2;230;219;116m"[0m[38;2;230;159;102m#{[0m[38;2;230;219;116mjs[0m[38;2;230;159;102m}[0m[38;2;190;132;255m\n[0m[38;2;230;159;102m#{[0m[38;2;230;219;116msourceMapDataURI[0m[38;2;230;159;102m}[0m[38;2;190;132;255m\n[0m[38;2;230;159;102m#{[0m[38;2;230;219;116msourceURL[0m[38;2;230;159;102m}[0m[38;2;230;219;116m"[0m

[38;2;248;248;242m  registerCompiled filename[0m[38;2;248;248;242m, [0m[38;2;248;248;242mcode[0m[38;2;248;248;242m, [0m[38;2;248;248;242mmap[0m

[38;2;248;248;242m  [0m[38;2;249;38;114mif[0m[38;2;248;248;242m options[0m[38;2;248;248;242m.[0m[38;2;248;248;242msourceMap[0m
[38;2;248;248;242m    [0m[38;2;248;248;242m{[0m
[38;2;248;248;242m      js[0m
[38;2;248;248;242m      [0m[38;2;248;248;242msourceMap[0m[38;2;248;248;242m:[0m[38;2;248;248;242m map[0m
[38;2;248;248;242m      [0m[38;2;248;248;242mv3SourceMap[0m[38;2;248;248;242m:[0m[38;2;248;248;242m JSON[0m[38;2;248;248;242m.[0m[38;2;248;248;242mstringify v3SourceMap[0m[38;2;248;248;242m, [0m[38;2;190;132;255mnull[0m[38;2;248;248;242m, [0m[38;2;190;132;255m2[0m
[38;2;248;248;242m    [0m[38;2;248;248;242m}[0m
[38;2;248;248;242m  [0m[38;2;249;38;114melse[0m
[38;2;248;248;242m    js[0m

[38;2;117;113;94m#[0m[38;2;117;113;94m Tokenize a string of CoffeeScript code, and return the array of tokens.[0m
[38;2;248;248;242mexports.tokens [0m[38;2;249;38;114m= [0m[38;2;248;248;242mwithPrettyErrors [0m[3;38;2;253;151;31m(code, options)[0m[38;2;248;248;242m [0m[3;38;2;102;217;239m->[0m
[38;2;248;248;242m  lexer[0m[38;2;248;248;242m.[0m[38;2;248;248;242mtokenize code[0m[38;2;248;248;242m, [0m[38;2;248;248;242moptions[0m

[38;2;117;113;94m#[0m[38;2;117;113;94m Parse a string of CoffeeScript code or an array of lexed tokens, and[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m return the AST. You can then compile it by calling `.compile()` on the root,[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m or traverse it by using `.traverseChildren()` with a callback.[0m
[38;2;248;248;242mexports.nodes [0m[38;2;249;38;114m= [0m[38;2;248;248;242mwithPrettyErrors [0m[3;38;2;253;151;31m(source, options)[0m[38;2;248;248;242m [0m[3;38;2;102;217;239m->[0m
[38;2;248;248;242m  [0m[38;2;248;248;242msource [0m[38;2;249;38;114m= [0m[38;2;248;248;242mlexer[0m[38;2;248;248;242m.[0m[38;2;248;248;242mtokenize source[0m[38;2;248;248;242m, [0m[38;2;248;248;242moptions [0m[38;2;249;38;114mif[0m[38;2;248;248;242m [0m[38;2;249;38;114mtypeof[0m[38;2;248;248;242m source [0m[38;2;249;38;114mis[0m[38;2;248;248;242m [0m[38;2;230;219;116m'[0m[38;2;230;219;116mstring[0m[38;2;230;219;116m'[0m
[38;2;248;248;242m  parser[0m[38;2;248;248;242m.[0m[38;2;248;248;242mparse source[0m

[38;2;117;113;94m#[0m[38;2;117;113;94m This file used to export these methods; leave stubs that throw warnings[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m instead. These methods have been moved into `index.coffee` to provide[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m separate entrypoints for Node and non-Node environments, so that static[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m analysis tools don’t choke on Node packages when compiling for a non-Node[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m environment.[0m
[38;2;248;248;242mexports.run [0m[38;2;249;38;114m= [0m[38;2;248;248;242mexports.eval [0m[38;2;249;38;114m= [0m[38;2;166;226;46mexports.registe[0m[38;2;166;226;46mr[0m[38;2;166;226;46m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[3;38;2;102;217;239m->[0m
[38;2;248;248;242m  [0m[38;2;249;38;114mthrow[0m[38;2;248;248;242m [0m[38;2;249;38;114mnew[0m[38;2;248;248;242m [0m[3;38;2;166;226;46mError[0m[38;2;248;248;242m [0m[38;2;230;219;116m'[0m[38;2;230;219;116mrequire index.coffee, not this file[0m[38;2;230;219;116m'[0m

[38;2;117;113;94m#[0m[38;2;117;113;94m Instantiate a Lexer for our use here.[0m
[38;2;248;248;242mlexer [0m[38;2;249;38;114m= [0m[38;2;249;38;114mnew[0m[38;2;248;248;242m [0m[3;38;2;166;226;46mLexer[0m

[38;2;117;113;94m#[0m[38;2;117;113;94m The real Lexer produces a generic stream of tokens. This object provides a[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m thin wrapper around it, compatible with the Jison API. We can then pass it[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m directly as a “Jison lexer.”[0m
[38;2;248;248;242mparser.lexer [0m[38;2;249;38;114m=[0m
[38;2;248;248;242m  [0m[38;2;248;248;242myylloc[0m[38;2;248;248;242m:[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mrange[0m[38;2;248;248;242m:[0m[38;2;248;248;242m [0m[38;2;248;248;242m[[0m[38;2;248;248;242m][0m
[38;2;248;248;242m  [0m[38;2;248;248;242moptions[0m[38;2;248;248;242m:[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mranges[0m[38;2;248;248;242m:[0m[38;2;248;248;242m [0m[38;2;190;132;255myes[0m
[38;2;248;248;242m  [0m[38;2;166;226;46mle[0m[38;2;166;226;46mx[0m[38;2;249;38;114m:[0m[38;2;248;248;242m [0m[3;38;2;102;217;239m->[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mtoken [0m[38;2;249;38;114m= [0m[38;2;248;248;242mparser[0m[38;2;248;248;242m.[0m[38;2;248;248;242mtokens[0m[38;2;248;248;242m[[0m[38;2;255;255;255m@pos[0m[38;2;249;38;114m++[0m[38;2;248;248;242m][0m
[38;2;248;248;242m    [0m[38;2;249;38;114mif[0m[38;2;248;248;242m token[0m
[38;2;248;248;242m      [0m[38;2;249;38;114m[[0m[38;2;248;248;242mtag[0m[38;2;248;248;242m, [0m[38;2;255;255;255m@yytext[0m[38;2;248;248;242m, [0m[38;2;255;255;255m@yylloc[0m[38;2;249;38;114m] =[0m[38;2;248;248;242m token[0m
[38;2;248;248;242m      [0m[38;2;248;248;242mparser.errorToken [0m[38;2;249;38;114m= [0m[38;2;248;248;242mtoken[0m[38;2;248;248;242m.[0m[38;2;248;248;242morigin [0m[38;2;249;38;114mor[0m[38;2;248;248;242m token[0m
[38;2;248;248;242m      [0m[38;2;255;255;255m@yylineno[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;255;255;255m@yylloc[0m[38;2;248;248;242m.[0m[38;2;248;248;242mfirst_line[0m
[38;2;248;248;242m    [0m[38;2;249;38;114melse[0m
[38;2;248;248;242m      [0m[38;2;248;248;242mtag [0m[38;2;249;38;114m= [0m[38;2;230;219;116m'[0m[38;2;230;219;116m'[0m
[38;2;248;248;242m    tag[0m
[38;2;248;248;242m  [0m[38;2;166;226;46msetInpu[0m[38;2;166;226;46mt[0m[38;2;249;38;114m:[0m[38;2;248;248;242m [0m[3;38;2;253;151;31m(tokens)[0m[38;2;248;248;242m [0m[3;38;2;102;217;239m->[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mparser.tokens [0m[38;2;249;38;114m= [0m[38;2;248;248;242mtokens[0m
[38;2;248;248;242m    [0m[38;2;255;255;255m@pos[0m[38;2;248;248;242m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[38;2;190;132;255m0[0m
[38;2;248;248;242m  [0m[38;2;166;226;46mupcomingInpu[0m[38;2;166;226;46mt[0m[38;2;249;38;114m:[0m[38;2;248;248;242m [0m[3;38;2;102;217;239m->[0m[38;2;248;248;242m [0m[38;2;230;219;116m'[0m[38;2;230;219;116m'[0m

[38;2;117;113;94m#[0m[38;2;117;113;94m Make all the AST nodes visible to the parser.[0m
[38;2;248;248;242mparser.yy [0m[38;2;249;38;114m= [0m[38;2;102;217;239mrequire[0m[38;2;248;248;242m [0m[38;2;230;219;116m'[0m[38;2;230;219;116m./nodes[0m[38;2;230;219;116m'[0m

[38;2;117;113;94m#[0m[38;2;117;113;94m Override Jison's default error handling function.[0m
[38;2;166;226;46mparser.yy.parseErro[0m[38;2;166;226;46mr[0m[38;2;166;226;46m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[3;38;2;253;151;31m(message, {token})[0m[38;2;248;248;242m [0m[3;38;2;102;217;239m->[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m Disregard Jison's message, it contains redundant line number information.[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m Disregard the token, we take its value directly from the lexer in case[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m the error is caused by a generated token which might refer to its origin.[0m
[38;2;248;248;242m  [0m[38;2;249;38;114m{[0m[38;2;248;248;242merrorToken[0m[38;2;248;248;242m, [0m[38;2;248;248;242mtokens[0m[38;2;249;38;114m} =[0m[38;2;248;248;242m parser[0m
[38;2;248;248;242m  [0m[38;2;249;38;114m[[0m[38;2;248;248;242merrorTag[0m[38;2;248;248;242m, [0m[38;2;248;248;242merrorText[0m[38;2;248;248;242m, [0m[38;2;248;248;242merrorLoc[0m[38;2;249;38;114m] =[0m[38;2;248;248;242m errorToken[0m

[38;2;248;248;242m  [0m[38;2;248;248;242merrorText [0m[38;2;249;38;114m= [0m[38;2;249;38;114mswitch[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mwhen[0m[38;2;248;248;242m errorToken [0m[38;2;249;38;114mis[0m[38;2;248;248;242m tokens[0m[38;2;248;248;242m[[0m[38;2;248;248;242mtokens[0m[38;2;248;248;242m.[0m[38;2;248;248;242mlength [0m[38;2;249;38;114m-[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m][0m
[38;2;248;248;242m      [0m[38;2;230;219;116m'[0m[38;2;230;219;116mend of input[0m[38;2;230;219;116m'[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mwhen[0m[38;2;248;248;242m errorTag [0m[38;2;249;38;114min[0m[38;2;248;248;242m [0m[38;2;248;248;242m[[0m[38;2;230;219;116m'[0m[38;2;230;219;116mINDENT[0m[38;2;230;219;116m'[0m[38;2;248;248;242m, [0m[38;2;230;219;116m'[0m[38;2;230;219;116mOUTDENT[0m[38;2;230;219;116m'[0m[38;2;248;248;242m][0m
[38;2;248;248;242m      [0m[38;2;230;219;116m'[0m[38;2;230;219;116mindentation[0m[38;2;230;219;116m'[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mwhen[0m[38;2;248;248;242m errorTag [0m[38;2;249;38;114min[0m[38;2;248;248;242m [0m[38;2;248;248;242m[[0m[38;2;230;219;116m'[0m[38;2;230;219;116mIDENTIFIER[0m[38;2;230;219;116m'[0m[38;2;248;248;242m, [0m[38;2;230;219;116m'[0m[38;2;230;219;116mNUMBER[0m[38;2;230;219;116m'[0m[38;2;248;248;242m, [0m[38;2;230;219;116m'[0m[38;2;230;219;116mINFINITY[0m[38;2;230;219;116m'[0m[38;2;248;248;242m, [0m[38;2;230;219;116m'[0m[38;2;230;219;116mSTRING[0m[38;2;230;219;116m'[0m[38;2;248;248;242m, [0m[38;2;230;219;116m'[0m[38;2;230;219;116mSTRING_START[0m[38;2;230;219;116m'[0m[38;2;248;248;242m, [0m[38;2;230;219;116m'[0m[38;2;230;219;116mREGEX[0m[38;2;230;219;116m'[0m[38;2;248;248;242m, [0m[38;2;230;219;116m'[0m[38;2;230;219;116mREGEX_START[0m[38;2;230;219;116m'[0m[38;2;248;248;242m][0m
[38;2;248;248;242m      errorTag[0m[38;2;248;248;242m.[0m[38;2;248;248;242mreplace[0m[38;2;255;255;255m([0m[38;2;246;170;17m/_START$/[0m[38;2;248;248;242m, [0m[38;2;230;219;116m'[0m[38;2;230;219;116m'[0m[38;2;255;255;255m)[0m[38;2;248;248;242m.[0m[38;2;248;248;242mtoLowerCase[0m[38;2;255;255;255m([0m[38;2;255;255;255m)[0m
[38;2;248;248;242m    [0m[38;2;249;38;114melse[0m
[38;2;248;248;242m      helpers[0m[38;2;248;248;242m.[0m[38;2;248;248;242mnameWhitespaceCharacter errorText[0m

[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m The second argument has a `loc` property, which should have the location[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m data for this token. Unfortunately, Jison seems to send an outdated `loc`[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m (from the previous token), so we take the location information directly[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m from the lexer.[0m
[38;2;248;248;242m  helpers[0m[38;2;248;248;242m.[0m[38;2;248;248;242mthrowSyntaxError [0m[38;2;230;219;116m"[0m[38;2;230;219;116munexpected [0m[38;2;230;159;102m#{[0m[38;2;230;219;116merrorText[0m[38;2;230;159;102m}[0m[38;2;230;219;116m"[0m[38;2;248;248;242m, [0m[38;2;248;248;242merrorLoc[0m

[38;2;117;113;94m#[0m[38;2;117;113;94m Based on http://v8.googlecode.com/svn/branches/bleeding_edge/src/messages.js[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m Modified to handle sourceMap[0m
[38;2;166;226;46mformatSourcePositio[0m[38;2;166;226;46mn[0m[38;2;166;226;46m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[3;38;2;253;151;31m(frame, getSourceMapping)[0m[38;2;248;248;242m [0m[3;38;2;102;217;239m->[0m
[38;2;248;248;242m  [0m[38;2;248;248;242mfilename [0m[38;2;249;38;114m= [0m[38;2;190;132;255mundefined[0m
[38;2;248;248;242m  [0m[38;2;248;248;242mfileLocation [0m[38;2;249;38;114m= [0m[38;2;230;219;116m'[0m[38;2;230;219;116m'[0m

[38;2;248;248;242m  [0m[38;2;249;38;114mif[0m[38;2;248;248;242m frame[0m[38;2;248;248;242m.[0m[38;2;248;248;242misNative[0m[38;2;255;255;255m([0m[38;2;255;255;255m)[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mfileLocation [0m[38;2;249;38;114m= [0m[38;2;230;219;116m"[0m[38;2;230;219;116mnative[0m[38;2;230;219;116m"[0m
[38;2;248;248;242m  [0m[38;2;249;38;114melse[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mif[0m[38;2;248;248;242m frame[0m[38;2;248;248;242m.[0m[38;2;248;248;242misEval[0m[38;2;255;255;255m([0m[38;2;255;255;255m)[0m
[38;2;248;248;242m      [0m[38;2;248;248;242mfilename [0m[38;2;249;38;114m= [0m[38;2;248;248;242mframe[0m[38;2;248;248;242m.[0m[38;2;248;248;242mgetScriptNameOrSourceURL[0m[38;2;255;255;255m([0m[38;2;255;255;255m)[0m
[38;2;248;248;242m      [0m[38;2;248;248;242mfileLocation [0m[38;2;249;38;114m= [0m[38;2;230;219;116m"[0m[38;2;230;159;102m#{[0m[38;2;230;219;116mframe[0m[38;2;230;219;116m.[0m[38;2;230;219;116mgetEvalOrigin[0m[38;2;255;255;255m([0m[38;2;255;255;255m)[0m[38;2;230;159;102m}[0m[38;2;230;219;116m, [0m[38;2;230;219;116m"[0m[38;2;248;248;242m [0m[38;2;249;38;114munless[0m[38;2;248;248;242m filename[0m
[38;2;248;248;242m    [0m[38;2;249;38;114melse[0m
[38;2;248;248;242m      [0m[38;2;248;248;242mfilename [0m[38;2;249;38;114m= [0m[38;2;248;248;242mframe[0m[38;2;248;248;242m.[0m[38;2;248;248;242mgetFileName[0m[38;2;255;255;255m([0m[38;2;255;255;255m)[0m

[38;2;248;248;242m    filename [0m[38;2;249;38;114mor=[0m[38;2;248;248;242m [0m[38;2;230;219;116m"[0m[38;2;230;219;116m<anonymous>[0m[38;2;230;219;116m"[0m

[38;2;248;248;242m    [0m[38;2;248;248;242mline [0m[38;2;249;38;114m= [0m[38;2;248;248;242mframe[0m[38;2;248;248;242m.[0m[38;2;248;248;242mgetLineNumber[0m[38;2;255;255;255m([0m[38;2;255;255;255m)[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mcolumn [0m[38;2;249;38;114m= [0m[38;2;248;248;242mframe[0m[38;2;248;248;242m.[0m[38;2;248;248;242mgetColumnNumber[0m[38;2;255;255;255m([0m[38;2;255;255;255m)[0m

[38;2;248;248;242m    [0m[38;2;117;113;94m#[0m[38;2;117;113;94m Check for a sourceMap position[0m
[38;2;248;248;242m    [0m[38;2;248;248;242msource [0m[38;2;249;38;114m= [0m[38;2;248;248;242mgetSourceMapping filename[0m[38;2;248;248;242m, [0m[38;2;248;248;242mline[0m[38;2;248;248;242m, [0m[38;2;248;248;242mcolumn[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mfileLocation [0m[38;2;249;38;114m=[0m
[38;2;248;248;242m      [0m[38;2;249;38;114mif[0m[38;2;248;248;242m source[0m
[38;2;248;248;242m        [0m[38;2;230;219;116m"[0m[38;2;230;159;102m#{[0m[38;2;230;219;116mfilename[0m[38;2;230;159;102m}[0m[38;2;230;219;116m:[0m[38;2;230;159;102m#{[0m[38;2;230;219;116msource[0m[38;2;230;219;116m[[0m[38;2;190;132;255m0[0m[38;2;230;219;116m][0m[38;2;230;159;102m}[0m[38;2;230;219;116m:[0m[38;2;230;159;102m#{[0m[38;2;230;219;116msource[0m[38;2;230;219;116m[[0m[38;2;190;132;255m1[0m[38;2;230;219;116m][0m[38;2;230;159;102m}[0m[38;2;230;219;116m"[0m
[38;2;248;248;242m      [0m[38;2;249;38;114melse[0m
[38;2;248;248;242m        [0m[38;2;230;219;116m"[0m[38;2;230;159;102m#{[0m[38;2;230;219;116mfilename[0m[38;2;230;159;102m}[0m[38;2;230;219;116m:[0m[38;2;230;159;102m#{[0m[38;2;230;219;116mline[0m[38;2;230;159;102m}[0m[38;2;230;219;116m:[0m[38;2;230;159;102m#{[0m[38;2;230;219;116mcolumn[0m[38;2;230;159;102m}[0m[38;2;230;219;116m"[0m

[38;2;248;248;242m  [0m[38;2;248;248;242mfunctionName [0m[38;2;249;38;114m= [0m[38;2;248;248;242mframe[0m[38;2;248;248;242m.[0m[38;2;248;248;242mgetFunctionName[0m[38;2;255;255;255m([0m[38;2;255;255;255m)[0m
[38;2;248;248;242m  [0m[38;2;248;248;242misConstructor [0m[38;2;249;38;114m= [0m[38;2;248;248;242mframe[0m[38;2;248;248;242m.[0m[38;2;248;248;242misConstructor[0m[38;2;255;255;255m([0m[38;2;255;255;255m)[0m
[38;2;248;248;242m  [0m[38;2;248;248;242misMethodCall [0m[38;2;249;38;114m= [0m[38;2;249;38;114mnot[0m[38;2;248;248;242m [0m[38;2;255;255;255m([0m[38;2;248;248;242mframe[0m[38;2;248;248;242m.[0m[38;2;248;248;242misToplevel[0m[38;2;255;255;255m([0m[38;2;255;255;255m)[0m[38;2;248;248;242m [0m[38;2;249;38;114mor[0m[38;2;248;248;242m isConstructor[0m[38;2;255;255;255m)[0m

[38;2;248;248;242m  [0m[38;2;249;38;114mif[0m[38;2;248;248;242m isMethodCall[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mmethodName [0m[38;2;249;38;114m= [0m[38;2;248;248;242mframe[0m[38;2;248;248;242m.[0m[38;2;248;248;242mgetMethodName[0m[38;2;255;255;255m([0m[38;2;255;255;255m)[0m
[38;2;248;248;242m    [0m[38;2;248;248;242mtypeName [0m[38;2;249;38;114m= [0m[38;2;248;248;242mframe[0m[38;2;248;248;242m.[0m[38;2;248;248;242mgetTypeName[0m[38;2;255;255;255m([0m[38;2;255;255;255m)[0m

[38;2;248;248;242m    [0m[38;2;249;38;114mif[0m[38;2;248;248;242m functionName[0m
[38;2;248;248;242m      [0m[38;2;248;248;242mtp [0m[38;2;249;38;114m= [0m[38;2;248;248;242mas [0m[38;2;249;38;114m= [0m[38;2;230;219;116m'[0m[38;2;230;219;116m'[0m
[38;2;248;248;242m      [0m[38;2;249;38;114mif[0m[38;2;248;248;242m typeName [0m[38;2;249;38;114mand[0m[38;2;248;248;242m functionName[0m[38;2;248;248;242m.[0m[38;2;102;217;239mindexOf[0m[38;2;248;248;242m typeName[0m
[38;2;248;248;242m        [0m[38;2;248;248;242mtp [0m[38;2;249;38;114m= [0m[38;2;230;219;116m"[0m[38;2;230;159;102m#{[0m[38;2;230;219;116mtypeName[0m[38;2;230;159;102m}[0m[38;2;230;219;116m.[0m[38;2;230;219;116m"[0m
[38;2;248;248;242m      [0m[38;2;249;38;114mif[0m[38;2;248;248;242m methodName [0m[38;2;249;38;114mand[0m[38;2;248;248;242m functionName[0m[38;2;248;248;242m.[0m[38;2;102;217;239mindexOf[0m[38;2;255;255;255m([0m[38;2;230;219;116m"[0m[38;2;230;219;116m.[0m[38;2;230;159;102m#{[0m[38;2;230;219;116mmethodName[0m[38;2;230;159;102m}[0m[38;2;230;219;116m"[0m[38;2;255;255;255m)[0m[38;2;248;248;242m [0m[38;2;249;38;114misnt[0m[38;2;248;248;242m functionName[0m[38;2;248;248;242m.[0m[38;2;248;248;242mlength [0m[38;2;249;38;114m-[0m[38;2;248;248;242m methodName[0m[38;2;248;248;242m.[0m[38;2;248;248;242mlength [0m[38;2;249;38;114m-[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m
[38;2;248;248;242m        [0m[38;2;248;248;242mas [0m[38;2;249;38;114m= [0m[38;2;230;219;116m"[0m[38;2;230;219;116m [as [0m[38;2;230;159;102m#{[0m[38;2;230;219;116mmethodName[0m[38;2;230;159;102m}[0m[38;2;230;219;116m][0m[38;2;230;219;116m"[0m

[38;2;248;248;242m      [0m[38;2;230;219;116m"[0m[38;2;230;159;102m#{[0m[38;2;230;219;116mtp[0m[38;2;230;159;102m}[0m[38;2;230;159;102m#{[0m[38;2;230;219;116mfunctionName[0m[38;2;230;159;102m}[0m[38;2;230;159;102m#{[0m[38;2;230;219;116mas[0m[38;2;230;159;102m}[0m[38;2;230;219;116m ([0m[38;2;230;159;102m#{[0m[38;2;230;219;116mfileLocation[0m[38;2;230;159;102m}[0m[38;2;230;219;116m)[0m[38;2;230;219;116m"[0m
[38;2;248;248;242m    [0m[38;2;249;38;114melse[0m
[38;2;248;248;242m      [0m[38;2;230;219;116m"[0m[38;2;230;159;102m#{[0m[38;2;230;219;116mtypeName[0m[38;2;230;159;102m}[0m[38;2;230;219;116m.[0m[38;2;230;159;102m#{[0m[38;2;230;219;116mmethodName [0m[38;2;249;38;114mor[0m[38;2;230;219;116m [0m[38;2;230;219;116m'[0m[38;2;230;219;116m<anonymous>[0m[38;2;230;219;116m'[0m[38;2;230;159;102m}[0m[38;2;230;219;116m ([0m[38;2;230;159;102m#{[0m[38;2;230;219;116mfileLocation[0m[38;2;230;159;102m}[0m[38;2;230;219;116m)[0m[38;2;230;219;116m"[0m
[38;2;248;248;242m  [0m[38;2;249;38;114melse[0m[38;2;248;248;242m [0m[38;2;249;38;114mif[0m[38;2;248;248;242m isConstructor[0m
[38;2;248;248;242m    [0m[38;2;230;219;116m"[0m[38;2;230;219;116mnew [0m[38;2;230;159;102m#{[0m[38;2;230;219;116mfunctionName [0m[38;2;249;38;114mor[0m[38;2;230;219;116m [0m[38;2;230;219;116m'[0m[38;2;230;219;116m<anonymous>[0m[38;2;230;219;116m'[0m[38;2;230;159;102m}[0m[38;2;230;219;116m ([0m[38;2;230;159;102m#{[0m[38;2;230;219;116mfileLocation[0m[38;2;230;159;102m}[0m[38;2;230;219;116m)[0m[38;2;230;219;116m"[0m
[38;2;248;248;242m  [0m[38;2;249;38;114melse[0m[38;2;248;248;242m [0m[38;2;249;38;114mif[0m[38;2;248;248;242m functionName[0m
[38;2;248;248;242m    [0m[38;2;230;219;116m"[0m[38;2;230;159;102m#{[0m[38;2;230;219;116mfunctionName[0m[38;2;230;159;102m}[0m[38;2;230;219;116m ([0m[38;2;230;159;102m#{[0m[38;2;230;219;116mfileLocation[0m[38;2;230;159;102m}[0m[38;2;230;219;116m)[0m[38;2;230;219;116m"[0m
[38;2;248;248;242m  [0m[38;2;249;38;114melse[0m
[38;2;248;248;242m    fileLocation[0m

[38;2;166;226;46mgetSourceMa[0m[38;2;166;226;46mp[0m[38;2;166;226;46m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[3;38;2;253;151;31m(filename, line, column)[0m[38;2;248;248;242m [0m[3;38;2;102;217;239m->[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m Skip files that we didn’t compile, like Node system files that appear in[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m the stack trace, as they never have source maps.[0m
[38;2;248;248;242m  [0m[38;2;249;38;114mreturn[0m[38;2;248;248;242m [0m[38;2;190;132;255mnull[0m[38;2;248;248;242m [0m[38;2;249;38;114munless[0m[38;2;248;248;242m filename [0m[38;2;249;38;114mis[0m[38;2;248;248;242m [0m[38;2;230;219;116m'[0m[38;2;230;219;116m<anonymous>[0m[38;2;230;219;116m'[0m[38;2;248;248;242m [0m[38;2;249;38;114mor[0m[38;2;248;248;242m filename[0m[38;2;248;248;242m.[0m[38;2;102;217;239mslice[0m[38;2;255;255;255m([0m[38;2;248;248;242mfilename[0m[38;2;248;248;242m.[0m[38;2;102;217;239mlastIndexOf[0m[38;2;255;255;255m([0m[38;2;230;219;116m'[0m[38;2;230;219;116m.[0m[38;2;230;219;116m'[0m[38;2;255;255;255m)[0m[38;2;255;255;255m)[0m[38;2;248;248;242m [0m[38;2;249;38;114min[0m[38;2;248;248;242m FILE_EXTENSIONS[0m

[38;2;248;248;242m  [0m[38;2;249;38;114mif[0m[38;2;248;248;242m filename [0m[38;2;249;38;114misnt[0m[38;2;248;248;242m [0m[38;2;230;219;116m'[0m[38;2;230;219;116m<anonymous>[0m[38;2;230;219;116m'[0m[38;2;248;248;242m [0m[38;2;249;38;114mand[0m[38;2;248;248;242m sourceMaps[0m[38;2;248;248;242m[[0m[38;2;248;248;242mfilename[0m[38;2;248;248;242m][0m[38;2;249;38;114m?[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mreturn[0m[38;2;248;248;242m sourceMaps[0m[38;2;248;248;242m[[0m[38;2;248;248;242mfilename[0m[38;2;248;248;242m][0m[38;2;248;248;242m[[0m[38;2;248;248;242msourceMaps[0m[38;2;248;248;242m[[0m[38;2;248;248;242mfilename[0m[38;2;248;248;242m][0m[38;2;248;248;242m.[0m[38;2;248;248;242mlength [0m[38;2;249;38;114m-[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m][0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m CoffeeScript compiled in a browser or via `CoffeeScript.compile` or `.run`[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m may get compiled with `options.filename` that’s missing, which becomes[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m `<anonymous>`; but the runtime might request the stack trace with the[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m filename of the script file. See if we have a source map cached under[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m `<anonymous>` that matches the error.[0m
[38;2;248;248;242m  [0m[38;2;249;38;114melse[0m[38;2;248;248;242m [0m[38;2;249;38;114mif[0m[38;2;248;248;242m sourceMaps[0m[38;2;248;248;242m[[0m[38;2;230;219;116m'[0m[38;2;230;219;116m<anonymous>[0m[38;2;230;219;116m'[0m[38;2;248;248;242m][0m[38;2;249;38;114m?[0m
[38;2;248;248;242m    [0m[38;2;117;113;94m#[0m[38;2;117;113;94m Work backwards from the most recent anonymous source maps, until we find[0m
[38;2;248;248;242m    [0m[38;2;117;113;94m#[0m[38;2;117;113;94m one that works. This isn’t foolproof; there is a chance that multiple[0m
[38;2;248;248;242m    [0m[38;2;117;113;94m#[0m[38;2;117;113;94m source maps will have line/column pairs that match. But we have no other[0m
[38;2;248;248;242m    [0m[38;2;117;113;94m#[0m[38;2;117;113;94m way to match them. `frame.getFunction().toString()` doesn’t always work,[0m
[38;2;248;248;242m    [0m[38;2;117;113;94m#[0m[38;2;117;113;94m and it’s not foolproof either.[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mfor[0m[38;2;248;248;242m map [0m[38;2;249;38;114min[0m[38;2;248;248;242m sourceMaps[0m[38;2;248;248;242m[[0m[38;2;230;219;116m'[0m[38;2;230;219;116m<anonymous>[0m[38;2;230;219;116m'[0m[38;2;248;248;242m] [0m[38;2;249;38;114mby[0m[38;2;248;248;242m [0m[38;2;249;38;114m-[0m[38;2;190;132;255m1[0m
[38;2;248;248;242m      [0m[38;2;248;248;242msourceLocation [0m[38;2;249;38;114m= [0m[38;2;248;248;242mmap[0m[38;2;248;248;242m.[0m[38;2;248;248;242msourceLocation [0m[38;2;248;248;242m[[0m[38;2;248;248;242mline [0m[38;2;249;38;114m-[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m, [0m[38;2;248;248;242mcolumn [0m[38;2;249;38;114m-[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m][0m
[38;2;248;248;242m      [0m[38;2;249;38;114mreturn[0m[38;2;248;248;242m map [0m[38;2;249;38;114mif[0m[38;2;248;248;242m sourceLocation[0m[38;2;249;38;114m?[0m[38;2;248;248;242m[[0m[38;2;190;132;255m0[0m[38;2;248;248;242m][0m[38;2;249;38;114m?[0m[38;2;248;248;242m [0m[38;2;249;38;114mand[0m[38;2;248;248;242m sourceLocation[0m[38;2;248;248;242m[[0m[38;2;190;132;255m1[0m[38;2;248;248;242m][0m[38;2;249;38;114m?[0m

[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m If all else fails, recompile this source to get a source map. We need the[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m previous section (for `<anonymous>`) despite this option, because after it[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m gets compiled we will still need to look it up from[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m `sourceMaps['<anonymous>']` in order to find and return it. That’s why we[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m start searching from the end in the previous block, because most of the[0m
[38;2;248;248;242m  [0m[38;2;117;113;94m#[0m[38;2;117;113;94m time the source map we want is the last one.[0m
[38;2;248;248;242m  [0m[38;2;249;38;114mif[0m[38;2;248;248;242m sources[0m[38;2;248;248;242m[[0m[38;2;248;248;242mfilename[0m[38;2;248;248;242m][0m[38;2;249;38;114m?[0m
[38;2;248;248;242m    [0m[38;2;248;248;242manswer [0m[38;2;249;38;114m= [0m[38;2;248;248;242mcompile sources[0m[38;2;248;248;242m[[0m[38;2;248;248;242mfilename[0m[38;2;248;248;242m][0m[38;2;248;248;242m[[0m[38;2;248;248;242msources[0m[38;2;248;248;242m[[0m[38;2;248;248;242mfilename[0m[38;2;248;248;242m][0m[38;2;248;248;242m.[0m[38;2;248;248;242mlength [0m[38;2;249;38;114m-[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m][0m[38;2;248;248;242m,[0m
[38;2;248;248;242m      [0m[38;2;248;248;242mfilename[0m[38;2;248;248;242m:[0m[38;2;248;248;242m filename[0m
[38;2;248;248;242m      [0m[38;2;248;248;242msourceMap[0m[38;2;248;248;242m:[0m[38;2;248;248;242m [0m[38;2;190;132;255myes[0m
[38;2;248;248;242m      [0m[38;2;248;248;242mliterate[0m[38;2;248;248;242m:[0m[38;2;248;248;242m helpers[0m[38;2;248;248;242m.[0m[38;2;248;248;242misLiterate filename[0m
[38;2;248;248;242m    answer[0m[38;2;248;248;242m.[0m[38;2;248;248;242msourceMap[0m
[38;2;248;248;242m  [0m[38;2;249;38;114melse[0m
[38;2;248;248;242m    [0m[38;2;190;132;255mnull[0m

[38;2;117;113;94m#[0m[38;2;117;113;94m Based on [michaelficarra/CoffeeScriptRedux](http://goo.gl/ZTx1p)[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m NodeJS / V8 have no support for transforming positions in stack traces using[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m sourceMap, so we must monkey-patch Error to display CoffeeScript source[0m
[38;2;117;113;94m#[0m[38;2;117;113;94m positions.[0m
[38;2;166;226;46mError.prepareStackTrac[0m[38;2;166;226;46me[0m[38;2;166;226;46m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[3;38;2;253;151;31m(err, stack)[0m[38;2;248;248;242m [0m[3;38;2;102;217;239m->[0m
[38;2;248;248;242m  [0m[38;2;166;226;46mgetSourceMappin[0m[38;2;166;226;46mg[0m[38;2;166;226;46m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[3;38;2;253;151;31m(filename, line, column)[0m[38;2;248;248;242m [0m[3;38;2;102;217;239m->[0m
[38;2;248;248;242m    [0m[38;2;248;248;242msourceMap [0m[38;2;249;38;114m= [0m[38;2;248;248;242mgetSourceMap filename[0m[38;2;248;248;242m, [0m[38;2;248;248;242mline[0m[38;2;248;248;242m, [0m[38;2;248;248;242mcolumn[0m
[38;2;248;248;242m    [0m[38;2;248;248;242manswer [0m[38;2;249;38;114m= [0m[38;2;248;248;242msourceMap[0m[38;2;248;248;242m.[0m[38;2;248;248;242msourceLocation [0m[38;2;248;248;242m[[0m[38;2;248;248;242mline [0m[38;2;249;38;114m-[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m, [0m[38;2;248;248;242mcolumn [0m[38;2;249;38;114m-[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m] [0m[38;2;249;38;114mif[0m[38;2;248;248;242m sourceMap[0m[38;2;249;38;114m?[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mif[0m[38;2;248;248;242m answer[0m[38;2;249;38;114m?[0m[38;2;248;248;242m [0m[38;2;249;38;114mthen[0m[38;2;248;248;242m [0m[38;2;248;248;242m[[0m[38;2;248;248;242manswer[0m[38;2;248;248;242m[[0m[38;2;190;132;255m0[0m[38;2;248;248;242m] [0m[38;2;249;38;114m+[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m, [0m[38;2;248;248;242manswer[0m[38;2;248;248;242m[[0m[38;2;190;132;255m1[0m[38;2;248;248;242m] [0m[38;2;249;38;114m+[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m[38;2;248;248;242m] [0m[38;2;249;38;114melse[0m[38;2;248;248;242m [0m[38;2;190;132;255mnull[0m

[38;2;248;248;242m  [0m[38;2;248;248;242mframes [0m[38;2;249;38;114m= [0m[38;2;249;38;114mfor[0m[38;2;248;248;242m frame [0m[38;2;249;38;114min[0m[38;2;248;248;242m stack[0m
[38;2;248;248;242m    [0m[38;2;249;38;114mbreak[0m[38;2;248;248;242m [0m[38;2;249;38;114mif[0m[38;2;248;248;242m frame[0m[38;2;248;248;242m.[0m[38;2;248;248;242mgetFunction[0m[38;2;255;255;255m([0m[38;2;255;255;255m)[0m[38;2;248;248;242m [0m[38;2;249;38;114mis[0m[38;2;248;248;242m exports[0m[38;2;248;248;242m.[0m[38;2;248;248;242mrun[0m
[38;2;248;248;242m    [0m[38;2;230;219;116m"[0m[38;2;230;219;116m    at [0m[38;2;230;159;102m#{[0m[38;2;230;219;116mformatSourcePosition frame[0m[38;2;230;219;116m, [0m[38;2;230;219;116mgetSourceMapping[0m[38;2;230;159;102m}[0m[38;2;230;219;116m"[0m

[38;2;248;248;242m  [0m[38;2;230;219;116m"[0m[38;2;230;159;102m#{[0m[38;2;230;219;116merr[0m[38;2;230;219;116m.[0m[38;2;102;217;239mtoString[0m[38;2;255;255;255m([0m[38;2;255;255;255m)[0m[38;2;230;159;102m}[0m[38;2;190;132;255m\n[0m[38;2;230;159;102m#{[0m[38;2;230;219;116mframes[0m[38;2;230;219;116m.[0m[38;2;102;217;239mjoin[0m[38;2;230;219;116m [0m[38;2;230;219;116m'[0m[38;2;190;132;255m\n[0m[38;2;230;219;116m'[0m[38;2;230;159;102m}[0m[38;2;190;132;255m\n[0m[38;2;230;219;116m"[0m

[38;2;166;226;46mcheckShebangLin[0m[38;2;166;226;46me[0m[38;2;166;226;46m [0m[38;2;249;38;114m=[0m[38;2;248;248;242m [0m[3;38;2;253;151;31m(file, input)[0m[38;2;248;248;242m [0m[3;38;2;102;217;239m->[0m
[38;2;248;248;242m  [0m[38;2;248;248;242mfirstLine [0m[38;2;249;38;114m= [0m[38;2;248;248;242minput[0m[38;2;248;248;242m.[0m[38;2;248;248;242msplit[0m[38;2;255;255;255m([0m[38;2;246;170;17m/$/m[0m[38;2;255;255;255m)[0m[38;2;248;248;242m[[0m[38;2;190;132;255m0[0m[38;2;248;248;242m][0m
[38;2;248;248;242m  [0m[38;2;248;248;242mrest [0m[38;2;249;38;114m= [0m[38;2;248;248;242mfirstLine[0m[38;2;249;38;114m?[0m[38;2;248;248;242m.[0m[38;2;248;248;242mmatch[0m[38;2;255;255;255m([0m[38;2;246;170;17m/^#!\s*([^\s]+\s*)(.*)/[0m[38;2;255;255;255m)[0m
[38;2;248;248;242m  [0m[38;2;248;248;242margs [0m[38;2;249;38;114m= [0m[38;2;248;248;242mrest[0m[38;2;249;38;114m?[0m[38;2;248;248;242m[[0m[38;2;190;132;255m2[0m[38;2;248;248;242m][0m[38;2;249;38;114m?[0m[38;2;248;248;242m.[0m[38;2;248;248;242msplit[0m[38;2;255;255;255m([0m[38;2;246;170;17m/\s/[0m[38;2;255;255;255m)[0m[38;2;248;248;242m.[0m[38;2;102;217;239mfilter[0m[38;2;248;248;242m [0m[3;38;2;253;151;31m(s)[0m[38;2;248;248;242m [0m[3;38;2;102;217;239m->[0m[38;2;248;248;242m s [0m[38;2;249;38;114misnt[0m[38;2;248;248;242m [0m[38;2;230;219;116m'[0m[38;2;230;219;116m'[0m
[38;2;248;248;242m  [0m[38;2;249;38;114mif[0m[38;2;248;248;242m args[0m[38;2;249;38;114m?[0m[38;2;248;248;242m.[0m[38;2;248;248;242mlength [0m[38;2;249;38;114m>[0m[38;2;248;248;242m [0m[38;2;190;132;255m1[0m
[38;2;248;248;242m    console[0m[38;2;248;248;242m.[0m[38;2;102;217;239merror[0m[38;2;248;248;242m [0m[38;2;230;219;116m'''[0m
[38;2;230;219;116m      The script to be run begins with a shebang line with more than one[0m
[38;2;230;219;116m      argument. This script will fail on platforms such as Linux which only[0m
[38;2;230;219;116m      allow a single argument.[0m
[38;2;230;219;116m    [0m[38;2;230;219;116m'''[0m
[38;2;248;248;242m    console[0m[38;2;248;248;242m.[0m[38;2;102;217;239merror[0m[38;2;248;248;242m [0m[38;2;230;219;116m"[0m[38;2;230;219;116mThe shebang line was: '[0m[38;2;230;159;102m#{[0m[38;2;230;219;116mfirstLine[0m[38;2;230;159;102m}[0m[38;2;230;219;116m' in file '[0m[38;2;230;159;102m#{[0m[38;2;230;219;116mfile[0m[38;2;230;159;102m}[0m[38;2;230;219;116m'[0m[38;2;230;219;116m"[0m
[38;2;248;248;242m    console[0m[38;2;248;248;242m.[0m[38;2;102;217;239merror[0m[38;2;248;248;242m [0m[38;2;230;219;116m"[0m[38;2;230;219;116mThe arguments were: [0m[38;2;230;159;102m#{[0m[38;2;230;219;116mJSON[0m[38;2;230;219;116m.[0m[38;2;230;219;116mstringify args[0m[38;2;230;159;102m}[0m[38;2;230;219;116m"[0m
