package v5

import (
	"fmt"

	"github.com/anchore/grype/grype/vulnerability"
)

var _ VulnerabilityMetadataProvider = (*vulnerabilityMetadataProvider)(nil)

type vulnerabilityMetadataProvider struct {
	reader VulnerabilityMetadataStoreReader
}

func NewVulnerabilityMetadataProvider(reader VulnerabilityMetadataStoreReader) VulnerabilityMetadataProvider {
	return &vulnerabilityMetadataProvider{
		reader: reader,
	}
}

func (pr *vulnerabilityMetadataProvider) VulnerabilityMetadata(ref vulnerability.Reference) (*vulnerability.Metadata, error) {
	return pr.GetMetadata(ref.ID, ref.Namespace)
}

func (pr *vulnerabilityMetadataProvider) GetMetadata(id, namespace string) (*vulnerability.Metadata, error) {
	metadata, err := pr.reader.GetVulnerabilityMetadata(id, namespace)
	if err != nil {
		return nil, fmt.Errorf("metadata provider failed to fetch id='%s' recordsource='%s': %w", id, namespace, err)
	}

	return NewMetadata(metadata)
}
