/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBox;
import net.sourceforge.plantuml.skin.Context2D;

class ArrowAndParticipant
extends Arrow
implements InGroupable {
    private final Arrow arrow;
    private final ParticipantBox participantBox;
    private final double paddingParticipant;

    public ArrowAndParticipant(StringBounder stringBounder, Arrow arrow, ParticipantBox participantBox, double paddingParticipant) {
        super(arrow.getStartingY(), arrow.getSkin(), arrow.getArrowComponent(), arrow.getUrl());
        this.arrow = arrow;
        this.participantBox = participantBox;
        this.paddingParticipant = paddingParticipant;
        arrow.setPaddingArrowHead(participantBox.getPreferredWidth(stringBounder) / 2.0 - paddingParticipant);
    }

    @Override
    public void setMaxX(double m) {
        super.setMaxX(m);
        this.arrow.setMaxX(m);
    }

    @Override
    public final double getArrowOnlyWidth(StringBounder stringBounder) {
        return this.arrow.getPreferredWidth(stringBounder) + this.participantBox.getPreferredWidth(stringBounder) / 2.0;
    }

    @Override
    public double getArrowYEndLevel(StringBounder stringBounder) {
        return this.arrow.getArrowYEndLevel(stringBounder);
    }

    @Override
    public double getArrowYStartLevel(StringBounder stringBounder) {
        return this.arrow.getArrowYStartLevel(stringBounder);
    }

    @Override
    public int getDirection(StringBounder stringBounder) {
        return this.arrow.getDirection(stringBounder);
    }

    @Override
    public LivingParticipantBox getParticipantAt(StringBounder stringBounder, NotePosition position) {
        return this.arrow.getParticipantAt(stringBounder, position);
    }

    @Override
    protected String getParticipant1Code() {
        return this.arrow.getParticipant1Code();
    }

    @Override
    protected String getParticipant2Code() {
        return this.arrow.getParticipant2Code();
    }

    @Override
    protected void drawInternalU(UGraphic ug, double maxX, Context2D context) {
        double participantBoxStartingX = this.participantBox.getStartingX();
        double arrowStartingX = this.arrow.getStartingX(ug.getStringBounder());
        if (arrowStartingX < participantBoxStartingX) {
            this.arrow.drawInternalU(ug, maxX, context);
        } else {
            double boxWidth = this.participantBox.getPreferredWidth(ug.getStringBounder());
            this.arrow.drawInternalU(ug.apply(UTranslate.dx(boxWidth / 2.0 - this.paddingParticipant)), maxX, context);
        }
        double arrowHeight = this.arrow.getPreferredHeight(ug.getStringBounder());
        double boxHeight = this.participantBox.getHeadHeight(ug.getStringBounder());
        double diff = 0.0;
        if (arrowHeight > boxHeight) {
            diff = arrowHeight - boxHeight;
        }
        if (!context.isBackground()) {
            this.participantBox.drawParticipantHead(ug.apply(new UTranslate(participantBoxStartingX, this.getStartingY() + diff)));
        }
    }

    private double getDiff(UGraphic ug) {
        double y1 = this.arrow.getPreferredHeight(ug.getStringBounder());
        double y2 = this.participantBox.getHeadHeight(ug.getStringBounder());
        double diff = y1 - y2;
        return diff;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return Math.max(this.arrow.getPreferredHeight(stringBounder), this.participantBox.getHeadHeight(stringBounder));
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.arrow.getPreferredWidth(stringBounder) + this.participantBox.getPreferredWidth(stringBounder) / 2.0;
    }

    @Override
    public double getActualWidth(StringBounder stringBounder) {
        return this.arrow.getActualWidth(stringBounder) + this.participantBox.getPreferredWidth(stringBounder) / 2.0;
    }

    @Override
    public double getStartingX(StringBounder stringBounder) {
        return this.arrow.getStartingX(stringBounder);
    }

    @Override
    public double getMaxX(StringBounder stringBounder) {
        return this.arrow.getMaxX(stringBounder);
    }

    @Override
    public double getMinX(StringBounder stringBounder) {
        return this.arrow.getMinX(stringBounder);
    }

    @Override
    public String toString(StringBounder stringBounder) {
        return this.arrow.toString(stringBounder);
    }
}

