/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.completion;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.model.DjangoMeta;
import com.jetbrains.django.model.DjangoModel;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class DjangoMetaAttributesCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final List<String> DEFAULT_NAMES = Lists.newArrayList((Object[])new String[]{"verbose_name", "verbose_name_plural", "db_table", "ordering", "unique_together", "permissions", "get_latest_by", "order_with_respect_to", "app_label", "db_tablespace", "abstract", "managed", "proxy", "auto_created"});

    public DjangoMetaAttributesCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParents(new Class[]{PyReferenceExpression.class, PyExpressionStatement.class, PyStatementList.class, PyClass.class}), (CompletionProvider)new CompletionProvider<CompletionParameters>(this){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                PyClass modelClass;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!DjangoFacet.isPresent((PsiElement)parameters.getPosition())) {
                    return;
                }
                PyClass cls = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), PyClass.class);
                if (DjangoMeta.isMetaClass((PyClass)cls) && DjangoModel.isDjangoModelDescendant((PyClass)(modelClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)cls, PyClass.class)), null)) {
                    for (String attrName : DjangoMetaAttributesCompletionContributor.getMetaAttributeNames(parameters.getPosition())) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)attrName));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/python/django/completion/DjangoMetaAttributesCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static List<String> getMetaAttributeNames(PsiElement position) {
        List attrValues;
        PsiFile file = DjangoPsiUtil.findFileInRoots((String)"django.db.models.options", (PsiElement)position);
        if (file instanceof PyFile && !(attrValues = PyPsiUtils.getAttributeValuesFromFile((PyFile)((PyFile)file), (String)"DEFAULT_NAMES")).isEmpty()) {
            return PyPsiUtils.getStringValues((PyExpression[])attrValues.toArray(PyExpression.EMPTY_ARRAY));
        }
        return DEFAULT_NAMES;
    }
}

