/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.jinja.tags.Jinja2Tag;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.python.django.lang.template.inspection.DjangoInspectionVisitorAdapter;
import com.intellij.python.django.lang.template.inspection.DjangoTemplateLocalInspectionTool;
import com.jetbrains.django.lang.template.psi.impl.Jinja2UrlViewImpl;
import com.jetbrains.django.lang.template.tags.Jinja2UrlTag;
import com.jetbrains.django.ui.DjangoBundle;
import org.jetbrains.annotations.NotNull;

public final class DjangoUnresolvedUrlInspection
extends DjangoTemplateLocalInspectionTool {
    @Override
    protected PsiElementVisitor createInspectionVisitor(InspectionManager manager) {
        return new MyUnresolvedUrlVisitor(manager);
    }

    private static class MyUnresolvedUrlVisitor
    extends DjangoInspectionVisitorAdapter {
        MyUnresolvedUrlVisitor(@NotNull InspectionManager manager) {
            if (manager == null) {
                MyUnresolvedUrlVisitor.$$$reportNull$$$0(0);
            }
            super(manager);
        }

        public void visitTag(@NotNull Jinja2Tag tag) {
            if (tag == null) {
                MyUnresolvedUrlVisitor.$$$reportNull$$$0(1);
            }
            if (tag instanceof Jinja2UrlTag) {
                Jinja2UrlTag urlTag = (Jinja2UrlTag)tag;
                Jinja2UrlViewImpl view = urlTag.getUrlView();
                if (view == null) {
                    return;
                }
                String urlName = view.getUrlName();
                if (urlName != null && urlTag.findAssociatedUrl() == null) {
                    String message = DjangoBundle.message((String)"inspection.unresolved_url.error", (Object[])new Object[]{urlName});
                    this.myProblems.add(this.myManager.createProblemDescriptor((PsiElement)urlTag, message, true, ProblemHighlightType.WEAK_WARNING, true, new LocalQuickFix[0]));
                }
            }
            super.visitTag(tag);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/python/django/lang/template/inspection/DjangoUnresolvedUrlInspection$MyUnresolvedUrlVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTag";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

