/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.jinja.model.TagLibrary;
import com.intellij.jinja.template.psi.DjangoTagName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.python.django.lang.template.DjangoTagUtils;
import com.intellij.python.django.lang.template.inspection.DjangoAddLoadTagQuickFix;
import com.intellij.python.django.lang.template.inspection.DjangoInspectionVisitor;
import com.intellij.python.django.lang.template.inspection.DjangoTemplateLocalInspectionTool;
import com.jetbrains.django.ui.DjangoBundle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class UnresolvedTagInspection
extends DjangoTemplateLocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "DjangoUnresolvedTagInspection";
    }

    @Override
    protected PsiElementVisitor createInspectionVisitor(InspectionManager manager) {
        return new DjangoTagVisitor(manager);
    }

    private static final class DjangoTagVisitor
    extends PsiRecursiveElementVisitor
    implements DjangoInspectionVisitor {
        private final List<ProblemDescriptor> myProblems = new ArrayList<ProblemDescriptor>();
        private final InspectionManager myManager;

        private DjangoTagVisitor(InspectionManager manager) {
            this.myManager = manager;
        }

        public void visitElement(@NotNull PsiElement element) {
            DjangoTagName tag;
            if (element == null) {
                DjangoTagVisitor.$$$reportNull$$$0(0);
            }
            if (element instanceof DjangoTagName && TagLibrary.isUnresolvedTag((DjangoTagName)(tag = (DjangoTagName)element))) {
                this.reportProblem(tag, DjangoBundle.message((String)"inspection.unresolved-tag.error-msg", (Object[])new Object[]{tag.getTagName()}));
            }
            super.visitElement(element);
        }

        private void reportProblem(DjangoTagName tag, @InspectionMessage String msg) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)tag);
            DjangoAddLoadTagQuickFix fix = null;
            if (module != null) {
                fix = DjangoTagUtils.proposeLoadFixForTag(tag, module);
            }
            ProblemDescriptor d = this.myManager.createProblemDescriptor((PsiElement)tag, new TextRange(0, tag.getTextLength()), msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[]{fix});
            this.myProblems.add(d);
        }

        @Override
        public void postprocess() {
        }

        @Override
        public List<ProblemDescriptor> getProblems() {
            return this.myProblems;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/python/django/lang/template/inspection/UnresolvedTagInspection$DjangoTagVisitor", "visitElement"));
        }
    }
}

