/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.ref;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.jetbrains.django.ref.ViewParameters;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.BaseReference;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.psi.PsiReferenceEx;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewMethodReference
extends BaseReference
implements PsiReferenceEx {
    public ViewMethodReference(@NotNull PsiElement element) {
        if (element == null) {
            ViewMethodReference.$$$reportNull$$$0(0);
        }
        super(element);
    }

    public PsiElement resolve() {
        ViewParameters params = ViewParameters.fromElement((PsiElement)this.myElement);
        return ViewMethodReference.findFunction(params);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            ViewMethodReference.$$$reportNull$$$0(1);
        }
        if (element instanceof PyFunction || element instanceof PyTargetExpression) {
            if (!this.getFunctionName().equals(((PsiNamedElement)element).getName())) {
                return false;
            }
            return this.resolve() == element;
        }
        return false;
    }

    public HighlightSeverity getUnresolvedHighlightSeverity(TypeEvalContext context) {
        return HighlightSeverity.WEAK_WARNING;
    }

    public String getUnresolvedDescription() {
        ViewParameters params = ViewParameters.fromElement((PsiElement)this.myElement);
        return DjangoBundle.message((String)"django.cant.resolve.view.method", (Object[])new Object[]{params.getFullPath()});
    }

    @Nullable
    private static PsiElement findFunction(ViewParameters parameters) {
        PyFile viewsFile = parameters.getViewsFile();
        if (viewsFile != null) {
            String name = parameters.getMethodName();
            PyFunction viewMethod = viewsFile.findTopLevelFunction(name);
            if (viewMethod != null) {
                return viewMethod;
            }
            return viewsFile.findTopLevelAttribute(name);
        }
        return null;
    }

    private String getFunctionName() {
        String text = this.myElement.getText();
        if (text.contains(".")) {
            return text.substring(text.lastIndexOf(".") + 1);
        }
        return text;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = PyPsiUtils.getStringValueTextRange((PsiElement)this.myElement);
        if (textRange == null) {
            ViewMethodReference.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        if (this.myElement instanceof PyStringLiteralExpression) {
            String string = ((PyStringLiteralExpression)this.myElement).getStringValue();
            if (string == null) {
                ViewMethodReference.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = this.myElement.getText();
        if (string == null) {
            ViewMethodReference.$$$reportNull$$$0(4);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) {
        if (newElementName == null) {
            ViewMethodReference.$$$reportNull$$$0(5);
        }
        String fullName = PythonStringUtil.replaceLastSuffix((String)this.myElement.getText(), (String)".", (String)newElementName);
        return this.myElement.replace((PsiElement)PyElementGenerator.getInstance((Project)this.myElement.getProject()).createStringLiteralAlreadyEscaped(fullName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/ref/ViewMethodReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/ref/ViewMethodReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

