/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.completion.cloud.settings;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.completion.cloud.settings.CloudCompletionPolicy;
import com.intellij.ml.llm.completion.impl.CloudCompletionSettingsImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.MutableBooleanProperty;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="CloudCompletionState", storages={@Storage(value="llm.cloud.completion.xml", roamingType=RoamingType.DISABLED, exportable=true)})
@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\f\rB\t\b\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/completion/cloud/settings/CloudCompletionSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/ml/llm/completion/cloud/settings/CloudCompletionSettings$State;", "<init>", "()V", "state", "getState", "loadState", "", "isEnabled", "Lcom/intellij/openapi/observable/properties/MutableBooleanProperty;", "()Lcom/intellij/openapi/observable/properties/MutableBooleanProperty;", "State", "Companion", "intellij.ml.llm.completion"})
public final class CloudCompletionSettings
implements PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private State state = new State(null, false, false, false, null, false, 63, null);

    @ApiStatus.Internal
    public CloudCompletionSettings() {
    }

    @NotNull
    public State getState() {
        return this.state;
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = State.copy$default(state, null, false, false, false, MapsKt.toMutableMap(this.state.getLanguageToEnabled()), false, 47, null);
        for (Map.Entry<String, Boolean> entry : state.getLanguageToEnabled().entrySet()) {
            String language = entry.getKey();
            boolean enabled = entry.getValue();
            this.state.getLanguageToEnabled().put(language, enabled);
        }
    }

    @NotNull
    public final MutableBooleanProperty isEnabled() {
        MutableBooleanProperty mutableBooleanProperty;
        try {
            mutableBooleanProperty = CloudCompletionSettingsImpl.INSTANCE.isInlineCompletionEnabledState();
        }
        catch (Throwable throwable) {
            mutableBooleanProperty = (MutableBooleanProperty)new AtomicBooleanProperty(false);
        }
        return mutableBooleanProperty;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/completion/cloud/settings/CloudCompletionSettings$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/completion/cloud/settings/CloudCompletionSettings;", "defaultCompletionPolicy", "Lcom/intellij/ml/llm/completion/cloud/settings/CloudCompletionPolicy;", "getDefaultCompletionPolicy", "()Lcom/intellij/ml/llm/completion/cloud/settings/CloudCompletionPolicy;", "intellij.ml.llm.completion"})
    @SourceDebugExtension(value={"SMAP\nCloudCompletionSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudCompletionSettings.kt\ncom/intellij/ml/llm/completion/cloud/settings/CloudCompletionSettings$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,71:1\n42#2,3:72\n*S KotlinDebug\n*F\n+ 1 CloudCompletionSettings.kt\ncom/intellij/ml/llm/completion/cloud/settings/CloudCompletionSettings$Companion\n*L\n62#1:72,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CloudCompletionSettings getInstance() {
            boolean $i$f$service = false;
            Class<CloudCompletionSettings> serviceClass$iv = CloudCompletionSettings.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (CloudCompletionSettings)object;
        }

        private final CloudCompletionPolicy getDefaultCompletionPolicy() {
            return PlatformUtils.isRubyMine() ? CloudCompletionPolicy.Creative : CloudCompletionPolicy.Focused;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u001f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BQ\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003JQ\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t2\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010'\u001a\u00020\u00052\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J\t\u0010+\u001a\u00020\nH\u00d6\u0001R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u0015R\u001e\u0010\u0007\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R\"\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001e\u0010\u000b\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0013\"\u0004\b\u001f\u0010\u0015\u00a8\u0006,"}, d2={"Lcom/intellij/ml/llm/completion/cloud/settings/CloudCompletionSettings$State;", "", "policy", "Lcom/intellij/ml/llm/completion/cloud/settings/CloudCompletionPolicy;", "bypassFiltersOnDirectCall", "", "textCompletion", "completionIndicator", "languageToEnabled", "", "", "allowCompletionInComments", "<init>", "(Lcom/intellij/ml/llm/completion/cloud/settings/CloudCompletionPolicy;ZZZLjava/util/Map;Z)V", "getPolicy", "()Lcom/intellij/ml/llm/completion/cloud/settings/CloudCompletionPolicy;", "setPolicy", "(Lcom/intellij/ml/llm/completion/cloud/settings/CloudCompletionPolicy;)V", "getBypassFiltersOnDirectCall", "()Z", "setBypassFiltersOnDirectCall", "(Z)V", "getTextCompletion$annotations", "()V", "getTextCompletion", "setTextCompletion", "getCompletionIndicator", "setCompletionIndicator", "getLanguageToEnabled", "()Ljava/util/Map;", "getAllowCompletionInComments", "setAllowCompletionInComments", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "intellij.ml.llm.completion"})
    public static final class State {
        @Property
        @NotNull
        private CloudCompletionPolicy policy;
        @Property
        private boolean bypassFiltersOnDirectCall;
        @Property
        private boolean textCompletion;
        @Property
        private boolean completionIndicator;
        @Property
        @XMap(keyAttributeName="language", valueAttributeName="enabled")
        @NotNull
        private final Map<String, Boolean> languageToEnabled;
        @Property
        private boolean allowCompletionInComments;

        @ApiStatus.Internal
        public State(@NotNull CloudCompletionPolicy policy, boolean bypassFiltersOnDirectCall, boolean textCompletion, boolean completionIndicator, @NotNull Map<String, Boolean> languageToEnabled, boolean allowCompletionInComments) {
            Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
            Intrinsics.checkNotNullParameter(languageToEnabled, (String)"languageToEnabled");
            this.policy = policy;
            this.bypassFiltersOnDirectCall = bypassFiltersOnDirectCall;
            this.textCompletion = textCompletion;
            this.completionIndicator = completionIndicator;
            this.languageToEnabled = languageToEnabled;
            this.allowCompletionInComments = allowCompletionInComments;
        }

        public /* synthetic */ State(CloudCompletionPolicy cloudCompletionPolicy, boolean bl, boolean bl2, boolean bl3, Map map2, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                cloudCompletionPolicy = Companion.getDefaultCompletionPolicy();
            }
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = true;
            }
            if ((n & 8) != 0) {
                bl3 = true;
            }
            if ((n & 0x10) != 0) {
                map2 = new LinkedHashMap();
            }
            if ((n & 0x20) != 0) {
                bl4 = bl2;
            }
            this(cloudCompletionPolicy, bl, bl2, bl3, map2, bl4);
        }

        @NotNull
        public final CloudCompletionPolicy getPolicy() {
            return this.policy;
        }

        public final void setPolicy(@NotNull CloudCompletionPolicy cloudCompletionPolicy) {
            Intrinsics.checkNotNullParameter((Object)((Object)cloudCompletionPolicy), (String)"<set-?>");
            this.policy = cloudCompletionPolicy;
        }

        public final boolean getBypassFiltersOnDirectCall() {
            return this.bypassFiltersOnDirectCall;
        }

        public final void setBypassFiltersOnDirectCall(boolean bl) {
            this.bypassFiltersOnDirectCall = bl;
        }

        public final boolean getTextCompletion() {
            return this.textCompletion;
        }

        public final void setTextCompletion(boolean bl) {
            this.textCompletion = bl;
        }

        @Deprecated(message="Use 'allowCompletionInComments' instead")
        public static /* synthetic */ void getTextCompletion$annotations() {
        }

        public final boolean getCompletionIndicator() {
            return this.completionIndicator;
        }

        public final void setCompletionIndicator(boolean bl) {
            this.completionIndicator = bl;
        }

        @NotNull
        public final Map<String, Boolean> getLanguageToEnabled() {
            return this.languageToEnabled;
        }

        public final boolean getAllowCompletionInComments() {
            return this.allowCompletionInComments;
        }

        public final void setAllowCompletionInComments(boolean bl) {
            this.allowCompletionInComments = bl;
        }

        @NotNull
        public final CloudCompletionPolicy component1() {
            return this.policy;
        }

        public final boolean component2() {
            return this.bypassFiltersOnDirectCall;
        }

        public final boolean component3() {
            return this.textCompletion;
        }

        public final boolean component4() {
            return this.completionIndicator;
        }

        @NotNull
        public final Map<String, Boolean> component5() {
            return this.languageToEnabled;
        }

        public final boolean component6() {
            return this.allowCompletionInComments;
        }

        @NotNull
        public final State copy(@NotNull CloudCompletionPolicy policy, boolean bypassFiltersOnDirectCall, boolean textCompletion, boolean completionIndicator, @NotNull Map<String, Boolean> languageToEnabled, boolean allowCompletionInComments) {
            Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
            Intrinsics.checkNotNullParameter(languageToEnabled, (String)"languageToEnabled");
            return new State(policy, bypassFiltersOnDirectCall, textCompletion, completionIndicator, languageToEnabled, allowCompletionInComments);
        }

        public static /* synthetic */ State copy$default(State state, CloudCompletionPolicy cloudCompletionPolicy, boolean bl, boolean bl2, boolean bl3, Map map2, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                cloudCompletionPolicy = state.policy;
            }
            if ((n & 2) != 0) {
                bl = state.bypassFiltersOnDirectCall;
            }
            if ((n & 4) != 0) {
                bl2 = state.textCompletion;
            }
            if ((n & 8) != 0) {
                bl3 = state.completionIndicator;
            }
            if ((n & 0x10) != 0) {
                map2 = state.languageToEnabled;
            }
            if ((n & 0x20) != 0) {
                bl4 = state.allowCompletionInComments;
            }
            return state.copy(cloudCompletionPolicy, bl, bl2, bl3, map2, bl4);
        }

        @NotNull
        public String toString() {
            return "State(policy=" + this.policy + ", bypassFiltersOnDirectCall=" + this.bypassFiltersOnDirectCall + ", textCompletion=" + this.textCompletion + ", completionIndicator=" + this.completionIndicator + ", languageToEnabled=" + this.languageToEnabled + ", allowCompletionInComments=" + this.allowCompletionInComments + ")";
        }

        public int hashCode() {
            int result2 = this.policy.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.bypassFiltersOnDirectCall);
            result2 = result2 * 31 + Boolean.hashCode(this.textCompletion);
            result2 = result2 * 31 + Boolean.hashCode(this.completionIndicator);
            result2 = result2 * 31 + ((Object)this.languageToEnabled).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.allowCompletionInComments);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (this.policy != state.policy) {
                return false;
            }
            if (this.bypassFiltersOnDirectCall != state.bypassFiltersOnDirectCall) {
                return false;
            }
            if (this.textCompletion != state.textCompletion) {
                return false;
            }
            if (this.completionIndicator != state.completionIndicator) {
                return false;
            }
            if (!Intrinsics.areEqual(this.languageToEnabled, state.languageToEnabled)) {
                return false;
            }
            return this.allowCompletionInComments == state.allowCompletionInComments;
        }

        @ApiStatus.Internal
        public State() {
            this(null, false, false, false, null, false, 63, null);
        }
    }
}

