/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.notification;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.execution.NodeProgressUtil;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.execution.ProcessWithCmdLine;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.packageJson.notification.PackageVersionRangeMatchRequest;
import com.intellij.javascript.nodejs.packageJson.notification.PackageVersionRangeMatchResponse;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import com.vdurmont.semver4j.Requirement;
import com.vdurmont.semver4j.Semver;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

public final class PackageVersionRangeMatcher {
    private static final Logger LOG = Logger.getInstance(PackageVersionRangeMatcher.class);
    private static final long TOTAL_WAIT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    private static final Map<Key, Value> CACHE = CollectionFactory.createConcurrentSoftMap();

    private PackageVersionRangeMatcher() {
    }

    @NotNull
    public static List<PackageVersionRangeMatchResponse> findMismatches(@NotNull Project project, @NotNull List<PackageVersionRangeMatchRequest> requests) throws ExecutionException {
        if (project == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(0);
        }
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(1);
        }
        return PackageVersionRangeMatcher.findMismatches(project, requests, (ThrowableComputable<NodeJsInterpreter, ExecutionException>)((ThrowableComputable)() -> {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return null;
            }
            NodeJsInterpreter interpreter2 = NodeJsInterpreterManager.getInstance(project).getInterpreter();
            return NodeInterpreterUtil.getValidInterpreterOrThrow(interpreter2);
        }));
    }

    @NotNull
    private static @Unmodifiable List<PackageVersionRangeMatchResponse> findMismatches(@NotNull Project project, @NotNull List<PackageVersionRangeMatchRequest> requests, @NotNull ThrowableComputable<NodeJsInterpreter, ExecutionException> interpreterComputable) throws ExecutionException {
        if (project == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(2);
        }
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(3);
        }
        if (interpreterComputable == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(4);
        }
        RequestsAndResponses requestsAndResponses = PackageVersionRangeMatcher.getCached(requests);
        ArrayList<PackageVersionRangeMatchResponse> responses = new ArrayList<PackageVersionRangeMatchResponse>(requestsAndResponses.myCachedResponses);
        if (!requestsAndResponses.myRequestsToRun.isEmpty()) {
            responses.addAll(PackageVersionRangeMatcher.match(project, requestsAndResponses.myRequestsToRun, interpreterComputable));
        }
        PackageVersionRangeMatcher.validateResponses(requests, responses);
        List list = ContainerUtil.filter(responses, response2 -> !response2.isMatched() && !response2.hasErrors());
        if (list == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static RequestsAndResponses getCached(@NotNull List<PackageVersionRangeMatchRequest> requests) {
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(6);
        }
        ArrayList<PackageVersionRangeMatchResponse> responses = new ArrayList<PackageVersionRangeMatchResponse>();
        ArrayList<PackageVersionRangeMatchRequest> requestsToRun = new ArrayList<PackageVersionRangeMatchRequest>();
        for (PackageVersionRangeMatchRequest request2 : requests) {
            Key key = new Key(request2.getVersionRange(), request2.getVersion());
            Value value = CACHE.get(key);
            if (value != null) {
                responses.add(new PackageVersionRangeMatchResponse(request2, value.myMatched, value.myValidVersion, value.myValidVersionRange));
                continue;
            }
            requestsToRun.add(request2);
        }
        return new RequestsAndResponses(requestsToRun, responses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    @NotNull
    public static List<PackageVersionRangeMatchResponse> match(@NotNull Project project, @NotNull List<PackageVersionRangeMatchRequest> requests, @NotNull ThrowableComputable<? extends NodeJsInterpreter, ? extends ExecutionException> interpreterComputable) {
        if (project == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(7);
        }
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(8);
        }
        if (interpreterComputable == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(9);
        }
        Map<Key, Value> map2 = CACHE;
        // MONITORENTER : map2
        RequestsAndResponses requestsAndResponses = PackageVersionRangeMatcher.getCached(requests);
        ArrayList<PackageVersionRangeMatchResponse> responses = new ArrayList<PackageVersionRangeMatchResponse>(requestsAndResponses.myCachedResponses);
        if (!requestsAndResponses.myRequestsToRun.isEmpty()) {
            NodeJsInterpreter interpreter2 = null;
            try {
                interpreter2 = (NodeJsInterpreter)interpreterComputable.compute();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            responses.addAll(PackageVersionRangeMatcher.handle(project, requestsAndResponses.myRequestsToRun, interpreter2));
        }
        ArrayList<PackageVersionRangeMatchResponse> arrayList = responses;
        // MONITOREXIT : map2
        if (arrayList != null) return arrayList;
        PackageVersionRangeMatcher.$$$reportNull$$$0(10);
        return arrayList;
    }

    @NotNull
    private static List<PackageVersionRangeMatchResponse> handle(@NotNull Project project, @NotNull List<PackageVersionRangeMatchRequest> requests, @Nullable NodeJsInterpreter interpreter2) {
        if (project == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(11);
        }
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(12);
        }
        List<PackageVersionRangeMatchResponse> semver4jResult = PackageVersionRangeMatcher.runWithSemver4j(requests);
        PackageVersionRangeMatcher.storeResponses(semver4jResult);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> PackageVersionRangeMatcher.verifySemver4jResult(project, semver4jResult, requests, interpreter2, true));
            List<PackageVersionRangeMatchResponse> list = semver4jResult;
            if (list == null) {
                PackageVersionRangeMatcher.$$$reportNull$$$0(13);
            }
            return list;
        }
        return PackageVersionRangeMatcher.verifySemver4jResult(project, semver4jResult, requests, interpreter2, false);
    }

    @NotNull
    private static List<PackageVersionRangeMatchResponse> verifySemver4jResult(@NotNull Project project, @NotNull List<PackageVersionRangeMatchResponse> semver4jResult, @NotNull List<PackageVersionRangeMatchRequest> requests, @Nullable NodeJsInterpreter interpreter2, boolean restartCodeAnalysisIfMismatched) {
        List nodeResult;
        if (project == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(14);
        }
        if (semver4jResult == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(15);
        }
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(16);
        }
        if (interpreter2 == null) {
            List<PackageVersionRangeMatchResponse> list = semver4jResult;
            if (list == null) {
                PackageVersionRangeMatcher.$$$reportNull$$$0(17);
            }
            return list;
        }
        if (!TrustedProjects.isProjectTrusted((Project)project)) {
            LOG.info("Cannot verify semver4j result with node in the untrusted project");
            List<PackageVersionRangeMatchResponse> list = semver4jResult;
            if (list == null) {
                PackageVersionRangeMatcher.$$$reportNull$$$0(18);
            }
            return list;
        }
        try {
            nodeResult = (List)NodeProgressUtil.withInvisibleProgress(() -> PackageVersionRangeMatcher.runWithNode(project, requests, interpreter2));
        }
        catch (ExecutionException e) {
            LOG.info("Cannot check requests", (Throwable)e);
            List<PackageVersionRangeMatchResponse> list = semver4jResult;
            if (list == null) {
                PackageVersionRangeMatcher.$$$reportNull$$$0(19);
            }
            return list;
        }
        Object errorMessage = PackageVersionRangeMatcher.getErrorMessageIfUnequal(nodeResult, semver4jResult);
        if (errorMessage != null) {
            if (restartCodeAnalysisIfMismatched) {
                PackageVersionRangeMatcher.restartCodeAnalysis("PackageVersionRangeMatcher: " + (String)errorMessage);
            }
            errorMessage = "Different node and semver4j results: " + (String)errorMessage;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error((String)errorMessage);
            } else {
                LOG.info((String)errorMessage);
            }
        }
        PackageVersionRangeMatcher.storeResponses(nodeResult);
        List list = nodeResult;
        if (list == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(20);
        }
        return list;
    }

    private static void restartCodeAnalysis(Object reason) {
        ReadAction.run(() -> {
            Project[] projects;
            for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
                if (project.isDisposed()) continue;
                DaemonCodeAnalyzer.getInstance((Project)project).restart(reason);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeResponses(@NotNull List<PackageVersionRangeMatchResponse> result2) {
        if (result2 == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(21);
        }
        Map<Key, Value> map2 = CACHE;
        synchronized (map2) {
            for (PackageVersionRangeMatchResponse response2 : result2) {
                CACHE.put(new Key(response2.getRequest().getVersionRange(), response2.getRequest().getVersion()), new Value(response2.isMatched(), response2.isValidVersion(), response2.isValidVersionRange()));
            }
        }
    }

    @Nullable
    private static String getErrorMessageIfUnequal(@NotNull List<PackageVersionRangeMatchResponse> nodeResponses, @NotNull List<PackageVersionRangeMatchResponse> semver4jResponses) {
        if (nodeResponses == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(22);
        }
        if (semver4jResponses == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(23);
        }
        if (nodeResponses.size() != semver4jResponses.size()) {
            return "node size: " + nodeResponses.size() + ", semver4j size: " + semver4jResponses.size();
        }
        for (int i = 0; i < nodeResponses.size(); ++i) {
            PackageVersionRangeMatchResponse node = nodeResponses.get(i);
            PackageVersionRangeMatchResponse semver4j = semver4jResponses.get(i);
            if (!node.getRequest().equals(semver4j.getRequest())) {
                return "(request) node: " + String.valueOf(node.getRequest()) + ", semver4j: " + String.valueOf(semver4j.getRequest());
            }
            if (node.hasErrors() == semver4j.hasErrors() && node.isMatched() == semver4j.isMatched()) continue;
            return "\n    node: " + String.valueOf(node) + ",\nsemver4j: " + String.valueOf(semver4j);
        }
        return null;
    }

    @NotNull
    private static List<PackageVersionRangeMatchResponse> runWithSemver4j(@NotNull List<PackageVersionRangeMatchRequest> requestsToRun) {
        if (requestsToRun == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(24);
        }
        List list = ContainerUtil.map(requestsToRun, request2 -> {
            Semver version2 = null;
            try {
                version2 = new Semver(request2.getVersion(), Semver.SemverType.NPM);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Requirement range = null;
            try {
                if (!request2.getVersionRange().contains("latest")) {
                    range = Requirement.buildNPM((String)request2.getVersionRange());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean matched = false;
            if (version2 != null && range != null) {
                try {
                    matched = request2.getVersionRange().equals(request2.getVersion()) || range.isSatisfiedBy(version2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new PackageVersionRangeMatchResponse((PackageVersionRangeMatchRequest)request2, matched, version2 != null, range != null);
        });
        if (list == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    private static List<PackageVersionRangeMatchResponse> runWithNode(@NotNull Project project, @NotNull List<PackageVersionRangeMatchRequest> requests, @NotNull NodeJsInterpreter interpreter2) throws ExecutionException {
        if (project == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(26);
        }
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(27);
        }
        if (interpreter2 == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(28);
        }
        if (requests.isEmpty()) {
            List<PackageVersionRangeMatchResponse> list = List.of();
            if (list == null) {
                PackageVersionRangeMatcher.$$$reportNull$$$0(29);
            }
            return list;
        }
        VirtualFile packageJson = requests.stream().map(req -> req.getPackageJson()).findFirst().orElseThrow();
        ProcessWithCmdLine processEx = PackageVersionRangeMatcher.startProcess(project, interpreter2, requests, packageJson);
        long startNano = System.nanoTime();
        CapturingProcessRunner runner = new CapturingProcessRunner((BaseProcessHandler)processEx.getProcessHandler());
        ProcessOutput output = runner.runProcess((int)TOTAL_WAIT_TIMEOUT_MILLIS, true);
        if (output.isTimeout()) {
            throw new ExecutionException("'" + processEx.getCommandLinePresentation() + "' command run is timed out (>" + TOTAL_WAIT_TIMEOUT_MILLIS + " ms)");
        }
        if (output.getExitCode() != 0) {
            throw new ExecutionException("Cannot match dependencies in " + String.valueOf(packageJson) + ", failed command: " + NodeCommandLineUtil.formatErrorMessage(processEx.getCommandLinePresentation(), output));
        }
        List<PackageVersionRangeMatchResponse> result2 = PackageVersionRangeMatcher.parse(output.getStdout(), interpreter2, packageJson);
        PackageVersionRangeMatcher.validateResponses(requests, result2);
        LOG.info("Matching " + requests.size() + " done in " + TimeoutUtil.getDurationMillis((long)startNano) + " ms");
        List<PackageVersionRangeMatchResponse> list = result2;
        if (list == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(30);
        }
        return list;
    }

    private static void validateResponses(@NotNull List<PackageVersionRangeMatchRequest> requests, @NotNull List<PackageVersionRangeMatchResponse> responses) throws ExecutionException {
        List processed;
        HashSet processedSet;
        HashSet<PackageVersionRangeMatchRequest> original;
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(31);
        }
        if (responses == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(32);
        }
        if (!(original = new HashSet<PackageVersionRangeMatchRequest>(requests)).equals(processedSet = new HashSet(processed = ContainerUtil.map(responses, response2 -> response2.getRequest())))) {
            throw new ExecutionException("Responses do not match requests: requests: " + String.valueOf(requests) + ", responses: " + String.valueOf(processed));
        }
    }

    @NotNull
    private static ProcessWithCmdLine startProcess(@NotNull Project project, @NotNull NodeJsInterpreter interpreter2, @NotNull List<PackageVersionRangeMatchRequest> requests, @NotNull VirtualFile packageJson) throws ExecutionException {
        if (project == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(33);
        }
        if (interpreter2 == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(34);
        }
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(35);
        }
        if (packageJson == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(36);
        }
        NodeTargetRun targetRun = new NodeTargetRun(interpreter2, project, null, NodeTargetRunOptions.of(false));
        TargetedCommandLineBuilder commandLine = targetRun.getCommandLineBuilder();
        targetRun.setEnableWrappingWithYarnNode(false);
        commandLine.setWorkingDirectory(targetRun.path(PackageVersionRangeMatcher.getWorkingDirectory(packageJson)));
        Path packageRoot = HelperFilesLocator.resolvePathOrThrowExecutionExecution("package-version-range-matcher");
        targetRun.path(packageRoot);
        commandLine.addParameter(targetRun.path(packageRoot.resolve("bin/batch-matcher")));
        for (PackageVersionRangeMatchRequest request2 : requests) {
            commandLine.addParameter("--package");
            commandLine.addParameter(request2.getPackageName());
            commandLine.addParameter(request2.getVersionRange());
            commandLine.addParameter(request2.getVersion());
        }
        ProcessWithCmdLine processWithCmdLine = targetRun.startProcessEx();
        if (processWithCmdLine == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(37);
        }
        return processWithCmdLine;
    }

    @NotNull
    private static Path getWorkingDirectory(@NotNull VirtualFile packageJson) throws ExecutionException {
        VirtualFile parentDirectory;
        if (packageJson == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(38);
        }
        if ((parentDirectory = packageJson.getParent()) == null) {
            throw new ExecutionException("No parent directory for " + String.valueOf(packageJson));
        }
        Path nioParentDirectory = parentDirectory.toNioPath();
        if (!Files.isDirectory(nioParentDirectory, new LinkOption[0])) {
            throw new ExecutionException("Parent directory does not exist for " + String.valueOf(packageJson));
        }
        Path path2 = nioParentDirectory;
        if (path2 == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(39);
        }
        return path2;
    }

    @NotNull
    private static List<PackageVersionRangeMatchResponse> parse(@NotNull String content, @NotNull NodeJsInterpreter interpreter2, @NotNull VirtualFile packageJson) throws ExecutionException {
        JsonArray array;
        if (content == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(40);
        }
        if (interpreter2 == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(41);
        }
        if (packageJson == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(42);
        }
        ArrayList<PackageVersionRangeMatchResponse> result2 = new ArrayList<PackageVersionRangeMatchResponse>();
        try {
            array = JsonUtil.parseJsonArray((String)content);
        }
        catch (Exception e) {
            throw new ExecutionException("Cannot parse result from " + interpreter2.getPresentableName() + ": " + content, (Throwable)e);
        }
        for (JsonElement element2 : array) {
            JsonObject obj = element2.getAsJsonObject();
            String packageName = JsonUtil.getChildAsString((JsonObject)obj, (String)"packageName");
            String versionRange = JsonUtil.getChildAsString((JsonObject)obj, (String)"versionRange");
            String version2 = JsonUtil.getChildAsString((JsonObject)obj, (String)"version");
            Boolean matched = JsonUtil.getChildAsBooleanObj((JsonObject)obj, (String)"matched");
            boolean validVersion = JsonUtil.getChildAsBoolean((JsonObject)obj, (String)"validVersion", (boolean)false);
            boolean validVersionRange = JsonUtil.getChildAsBoolean((JsonObject)obj, (String)"validVersionRange", (boolean)false);
            if (!validVersion || !validVersionRange) {
                matched = false;
            }
            if (packageName == null || versionRange == null || version2 == null || matched == null) {
                throw new ExecutionException("packageName: " + packageName + ", versionRange: " + versionRange + ", version: " + version2 + ", matched: " + matched);
            }
            result2.add(new PackageVersionRangeMatchResponse(new PackageVersionRangeMatchRequest(packageName, versionRange, version2, packageJson), matched, validVersion, validVersionRange));
        }
        ArrayList<PackageVersionRangeMatchResponse> arrayList = result2;
        if (arrayList == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(43);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 10, 13, 17, 18, 19, 20, 25, 29, 30, 37, 39, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 12: 
            case 16: 
            case 27: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterComputable";
                break;
            }
            case 5: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 29: 
            case 30: 
            case 37: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/notification/PackageVersionRangeMatcher";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semver4jResult";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeResponses";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semver4jResponses";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestsToRun";
                break;
            }
            case 28: 
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responses";
                break;
            }
            case 36: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/notification/PackageVersionRangeMatcher";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findMismatches";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "match";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "handle";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "verifySemver4jResult";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "runWithSemver4j";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "runWithNode";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findMismatches";
                break;
            }
            case 5: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 29: 
            case 30: 
            case 37: 
            case 39: 
            case 43: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCached";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handle";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "verifySemver4jResult";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "storeResponses";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessageIfUnequal";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "runWithSemver4j";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "runWithNode";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "validateResponses";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDirectory";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 10, 13, 17, 18, 19, 20, 25, 29, 30, 37, 39, 43 -> new IllegalStateException(string);
        };
    }

    private static class RequestsAndResponses {
        public final List<PackageVersionRangeMatchRequest> myRequestsToRun;
        public final List<PackageVersionRangeMatchResponse> myCachedResponses;

        RequestsAndResponses(@NotNull List<PackageVersionRangeMatchRequest> requestsToRun, @NotNull List<PackageVersionRangeMatchResponse> cachedResponses) {
            if (requestsToRun == null) {
                RequestsAndResponses.$$$reportNull$$$0(0);
            }
            if (cachedResponses == null) {
                RequestsAndResponses.$$$reportNull$$$0(1);
            }
            this.myRequestsToRun = requestsToRun;
            this.myCachedResponses = cachedResponses;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "requestsToRun";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cachedResponses";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/packageJson/notification/PackageVersionRangeMatcher$RequestsAndResponses";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Key {
        private final String myVersionRange;
        private final String myVersion;

        Key(@NotNull String versionRange, @NotNull String version2) {
            if (versionRange == null) {
                Key.$$$reportNull$$$0(0);
            }
            if (version2 == null) {
                Key.$$$reportNull$$$0(1);
            }
            this.myVersionRange = versionRange;
            this.myVersion = version2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.myVersionRange.equals(key.myVersionRange) && this.myVersion.equals(key.myVersion);
        }

        public int hashCode() {
            int result2 = this.myVersionRange.hashCode();
            result2 = 31 * result2 + this.myVersion.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "versionRange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "version";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/packageJson/notification/PackageVersionRangeMatcher$Key";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Value {
        private final boolean myMatched;
        private final boolean myValidVersion;
        private final boolean myValidVersionRange;

        Value(boolean matched, boolean validVersion, boolean validVersionRange) {
            this.myMatched = matched;
            this.myValidVersion = validVersion;
            this.myValidVersionRange = validVersionRange;
        }
    }
}

