/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.intellij.lang.javascript.boilerplate.GithubDownloadUtil;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticTemplatesMemoryCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u0000 +2\u00020\u0001:\u0005'()*+B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\fH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\fH\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u00192\u0006\u0010\r\u001a\u00020\fH\u0002J\u001e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\fH\u0002J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\fH\u0007J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\fH\u0007J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\fH\u0007J\u0010\u0010%\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "myCache", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesMemoryCache;", "getTemplates", "", "", "version", "getCriteria", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesMemoryCache$GetCriteria;", "myDownloadedFile", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadedFile;", "getDownloadedPath", "Ljava/nio/file/Path;", "removeDownloadedFileAsFailed", "", "file", "myDownloadTasks", "", "Lkotlinx/coroutines/Deferred;", "getDownloadTask", "removeDownloadTask", "downloadTask", "myDataUrlPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "parseDataURL", "url", "cleanup", "assertDownloadFailed", "assertVersionNotFound", "assertFileNotExists", "assertDownloadedFileVersion", "DownloadedFile", "SuccessfullyDownloaded", "VersionNotFound", "DownloadFailed", "Companion", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nDiagnosticTemplatesEnProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagnosticTemplatesEnProvider.kt\ncom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,250:1\n1#2:251\n1869#3,2:252\n*S KotlinDebug\n*F\n+ 1 DiagnosticTemplatesEnProvider.kt\ncom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider\n*L\n170#1:252,2\n*E\n"})
public final class DiagnosticTemplatesEnProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final DiagnosticTemplatesMemoryCache myCache;
    @Nullable
    private DownloadedFile myDownloadedFile;
    @NotNull
    private final Map<String, Deferred<DownloadedFile>> myDownloadTasks;
    private final Pattern myDataUrlPattern;
    @NotNull
    private static final Logger myLogger;
    @NotNull
    private static final Function1<Exception, Unit> myDefaultErrorReporter;
    @NotNull
    private static volatile Function1<? super Exception, Unit> myErrorReporter;

    public DiagnosticTemplatesEnProvider(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        this.myCache = new DiagnosticTemplatesMemoryCache((Function1<? super Path, ? extends Sequence<Pair<Integer, String>>>)((Function1)DiagnosticTemplatesEnProvider::myCache$lambda$0));
        this.myDownloadTasks = new LinkedHashMap();
        this.myDataUrlPattern = Pattern.compile("data:application/json;charset=utf-8,(.+)", 2);
    }

    @NotNull
    public final CoroutineScope getCs() {
        return this.cs;
    }

    @RequiresBackgroundThread
    @NotNull
    public final List<String> getTemplates(@NotNull String version2, @NotNull DiagnosticTemplatesMemoryCache.GetCriteria getCriteria) {
        List list;
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)getCriteria, (String)"getCriteria");
        Path file = this.getDownloadedPath(version2);
        if (file != null) {
            List list2;
            try {
                list2 = this.myCache.getTemplates(file, getCriteria);
            }
            catch (JsonParseException e) {
                myErrorReporter.invoke((Object)e);
                this.removeDownloadedFileAsFailed(file, version2);
                list2 = CollectionsKt.emptyList();
            }
            list = list2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path getDownloadedPath(String version2) {
        Deferred<DownloadedFile> downloadTask;
        DownloadedFile newDownloadedFile2;
        Object object;
        DownloadedFile currentFile;
        Object $i$a$-synchronized-DiagnosticTemplatesEnProvider$getDownloadedPath$currentFile$22;
        Object object2 = this;
        synchronized (object2) {
            boolean $i$a$-synchronized-DiagnosticTemplatesEnProvider$getDownloadedPath$currentFile$22 = false;
            $i$a$-synchronized-DiagnosticTemplatesEnProvider$getDownloadedPath$currentFile$22 = this.myDownloadedFile;
        }
        DownloadedFile downloadedFile = currentFile = $i$a$-synchronized-DiagnosticTemplatesEnProvider$getDownloadedPath$currentFile$22;
        if (Intrinsics.areEqual((Object)(downloadedFile != null ? downloadedFile.getVersion() : null), (Object)version2)) {
            object2 = currentFile;
            if (object2 instanceof SuccessfullyDownloaded) {
                $i$a$-synchronized-DiagnosticTemplatesEnProvider$getDownloadedPath$currentFile$22 = ((SuccessfullyDownloaded)currentFile).getPath();
                if (Files.isRegularFile((Path)$i$a$-synchronized-DiagnosticTemplatesEnProvider$getDownloadedPath$currentFile$22, Arrays.copyOf(object = new LinkOption[0], ((LinkOption[])object).length))) {
                    return ((SuccessfullyDownloaded)currentFile).getPath();
                }
            } else {
                if (object2 instanceof VersionNotFound) {
                    return null;
                }
                if (object2 instanceof DownloadFailed) {
                    long retryAt = ((DownloadFailed)currentFile).getWhenMs() + (long)Registry.Companion.intValue("ts.highlightCodeInErrorTooltips.downloadRetryDelayMs");
                    if (retryAt > System.currentTimeMillis()) {
                        return null;
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        if ((newDownloadedFile2 = (DownloadedFile)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DownloadedFile>, Object>(downloadTask = this.getDownloadTask(version2), null){
            int label;
            final /* synthetic */ Deferred<DownloadedFile> $downloadTask;
            {
                this.$downloadTask = $downloadTask;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TimeoutKt.withTimeoutOrNull((long)Registry.Companion.intValue("ts.highlightCodeInErrorTooltips.downloadAwaitTimeoutMs"), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DownloadedFile>, Object>(this.$downloadTask, null){
                            int label;
                            final /* synthetic */ Deferred<DownloadedFile> $downloadTask;
                            {
                                this.$downloadTask = $downloadTask;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = this.$downloadTask.await((Continuation)this);
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super DownloadedFile> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super DownloadedFile> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }))) != null) {
            object = this;
            synchronized (object) {
                boolean bl = false;
                if (Intrinsics.areEqual((Object)currentFile, (Object)this.myDownloadedFile)) {
                    this.myDownloadedFile = newDownloadedFile2;
                }
                Unit unit = Unit.INSTANCE;
            }
            this.removeDownloadTask(version2, downloadTask);
        }
        return newDownloadedFile2 instanceof SuccessfullyDownloaded ? ((SuccessfullyDownloaded)newDownloadedFile2).getPath() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeDownloadedFileAsFailed(Path file, String version2) {
        LinkOption[] linkOptionArray;
        Object object = this;
        synchronized (object) {
            boolean bl = false;
            if (this.myDownloadedFile instanceof SuccessfullyDownloaded) {
                DownloadedFile downloadedFile = this.myDownloadedFile;
                Intrinsics.checkNotNull((Object)downloadedFile, (String)"null cannot be cast to non-null type com.intellij.lang.typescript.compiler.languageService.DiagnosticTemplatesEnProvider.SuccessfullyDownloaded");
                if (Intrinsics.areEqual((Object)((SuccessfullyDownloaded)downloadedFile).getPath(), (Object)file)) {
                    this.myDownloadedFile = new DownloadFailed(version2, System.currentTimeMillis());
                }
            }
            linkOptionArray = Unit.INSTANCE;
        }
        object = file;
        linkOptionArray = new LinkOption[]{};
        if (Files.isRegularFile((Path)object, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Files.delete(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Deferred<DownloadedFile> getDownloadTask(String version2) {
        Deferred deferred2;
        Map<String, Deferred<DownloadedFile>> map2 = this.myDownloadTasks;
        synchronized (map2) {
            boolean bl = false;
            Deferred deferred3 = this.myDownloadTasks.computeIfAbsent(version2, arg_0 -> DiagnosticTemplatesEnProvider.getDownloadTask$lambda$0$1(arg_0 -> DiagnosticTemplatesEnProvider.getDownloadTask$lambda$0$0(this, version2, arg_0), arg_0));
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
            deferred2 = deferred3;
        }
        Intrinsics.checkNotNullExpressionValue((Object)deferred2, (String)"synchronized(...)");
        return deferred2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeDownloadTask(String version2, Deferred<? extends DownloadedFile> downloadTask) {
        Map<String, Deferred<DownloadedFile>> map2 = this.myDownloadTasks;
        synchronized (map2) {
            boolean bl = false;
            boolean bl2 = this.myDownloadTasks.remove(version2, downloadTask);
        }
    }

    private final String parseDataURL(String url) {
        Matcher m = this.myDataUrlPattern.matcher(url);
        return m.matches() ? URLDecoder.decode(m.group(1), "utf-8") : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final void cleanup(@NotNull String version2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        DiagnosticTemplatesEnProvider diagnosticTemplatesEnProvider = this;
        synchronized (diagnosticTemplatesEnProvider) {
            boolean bl = false;
            DownloadedFile downloadedFile = this.myDownloadedFile;
            if (Intrinsics.areEqual((Object)(downloadedFile != null ? downloadedFile.getVersion() : null), (Object)version2)) {
                if (this.myDownloadedFile instanceof SuccessfullyDownloaded) {
                    DownloadedFile downloadedFile2 = this.myDownloadedFile;
                    Intrinsics.checkNotNull((Object)downloadedFile2, (String)"null cannot be cast to non-null type com.intellij.lang.typescript.compiler.languageService.DiagnosticTemplatesEnProvider.SuccessfullyDownloaded");
                    PathKt.delete$default((Path)((SuccessfullyDownloaded)downloadedFile2).getPath(), (boolean)false, (int)1, null);
                }
                this.myDownloadedFile = null;
            }
            object = Unit.INSTANCE;
        }
        this.myCache.cleanup$intellij_javascript_backend();
        object = this.myDownloadTasks;
        synchronized (object) {
            boolean bl = false;
            Iterable $this$forEach$iv = this.myDownloadTasks.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Deferred it = (Deferred)element$iv;
                boolean bl2 = false;
                Job.DefaultImpls.cancel$default((Job)((Job)it), null, (int)1, null);
            }
            this.myDownloadTasks.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final void assertDownloadFailed(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        this.assertFileNotExists(version2);
        this.assertDownloadedFileVersion(version2);
        DiagnosticTemplatesEnProvider diagnosticTemplatesEnProvider = this;
        synchronized (diagnosticTemplatesEnProvider) {
            boolean bl = false;
            if (!(this.myDownloadedFile instanceof DownloadFailed)) {
                throw new AssertionError((Object)("Not failed: " + this.myDownloadedFile));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final void assertVersionNotFound(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        this.assertFileNotExists(version2);
        this.assertDownloadedFileVersion(version2);
        DiagnosticTemplatesEnProvider diagnosticTemplatesEnProvider = this;
        synchronized (diagnosticTemplatesEnProvider) {
            boolean bl = false;
            if (!(this.myDownloadedFile instanceof VersionNotFound)) {
                throw new AssertionError((Object)("Not 'not found': " + this.myDownloadedFile));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void assertFileNotExists(String version2) {
        Path path2 = DiagnosticTemplatesEnProvider.Companion.getFileDownloadPath(version2);
        Intrinsics.checkNotNull((Object)path2);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new AssertionError((Object)("Exists " + path2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void assertDownloadedFileVersion(String version2) {
        DiagnosticTemplatesEnProvider diagnosticTemplatesEnProvider = this;
        synchronized (diagnosticTemplatesEnProvider) {
            boolean bl = false;
            DownloadedFile downloadedFile = this.myDownloadedFile;
            if (!Intrinsics.areEqual((Object)(downloadedFile != null ? downloadedFile.getVersion() : null), (Object)version2)) {
                DownloadedFile downloadedFile2 = this.myDownloadedFile;
                throw new AssertionError((Object)("Unexpected version " + (downloadedFile2 != null ? downloadedFile2.getVersion() : null)));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final Sequence myCache$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Companion.getCodeToTemplate(it);
    }

    private static final Deferred getDownloadTask$lambda$0$0(DiagnosticTemplatesEnProvider this$0, String $version, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return BuildersKt.async$default((CoroutineScope)this$0.cs, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DownloadedFile>, Object>($version, this$0, null){
            int label;
            final /* synthetic */ String $version;
            final /* synthetic */ DiagnosticTemplatesEnProvider this$0;
            {
                this.$version = $version;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        DownloadedFile downloadedFile;
                        ResultKt.throwOnFailure((Object)$result);
                        Path downloadPath = com.intellij.lang.typescript.compiler.languageService.DiagnosticTemplatesEnProvider$Companion.access$getFileDownloadPath(DiagnosticTemplatesEnProvider.Companion, this.$version);
                        Intrinsics.checkNotNull((Object)downloadPath);
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (Files.isRegularFile(downloadPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                            return new SuccessfullyDownloaded(this.$version, downloadPath);
                        }
                        String url = StringsKt.replace$default((String)Registry.Companion.stringValue("ts.highlightCodeInErrorTooltips.diagnosticMessages.url"), (String)"${version}", (String)this.$version, (boolean)false, (int)4, null);
                        String jsonFromDataUrl = DiagnosticTemplatesEnProvider.access$parseDataURL(this.this$0, url);
                        if (jsonFromDataUrl != null) {
                            FileUtil.writeToFile((File)downloadPath.toFile(), (String)jsonFromDataUrl);
                            return new SuccessfullyDownloaded(this.$version, downloadPath);
                        }
                        try {
                            GithubDownloadUtil.downloadAtomically(null, (String)url, (File)downloadPath.toFile(), (String)"microsoft", (String)"TypeScript");
                            downloadedFile = new SuccessfullyDownloaded(this.$version, downloadPath);
                        }
                        catch (IOException e) {
                            DiagnosticTemplatesEnProvider.access$getMyErrorReporter$cp().invoke((Object)e);
                            Throwable throwable = e.getCause();
                            HttpRequests.HttpStatusException httpStatusException = throwable instanceof HttpRequests.HttpStatusException ? (HttpRequests.HttpStatusException)throwable : null;
                            downloadedFile = (httpStatusException != null ? httpStatusException.getStatusCode() == 404 : false) ? (DownloadedFile)new VersionNotFound(this.$version) : (DownloadedFile)new DownloadFailed(this.$version, System.currentTimeMillis());
                        }
                        return downloadedFile;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super DownloadedFile> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private static final Deferred getDownloadTask$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Deferred)$tmp0.invoke(p0);
    }

    private static final Unit myDefaultErrorReporter$lambda$0(Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            myLogger.error((Throwable)e);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ String access$parseDataURL(DiagnosticTemplatesEnProvider $this, String url) {
        return $this.parseDataURL(url);
    }

    public static final /* synthetic */ Function1 access$getMyErrorReporter$cp() {
        return myErrorReporter;
    }

    static {
        Logger logger = Logger.getInstance(DiagnosticTemplatesEnProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        myLogger = logger;
        myDefaultErrorReporter = DiagnosticTemplatesEnProvider::myDefaultErrorReporter$lambda$0;
        myErrorReporter = myDefaultErrorReporter;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2%\u0010\u000f\u001a!\u0012\u0017\u0012\u00150\bj\u0002`\t\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\n0\u0007H\u0007J \u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00150\u00142\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\n \u001b*\u0004\u0018\u00010\u00190\u00192\u0006\u0010\u001c\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$Companion;", "", "<init>", "()V", "myLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "myDefaultErrorReporter", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "", "myErrorReporter", "setErrorReporter", "disposable", "Lcom/intellij/openapi/Disposable;", "reporter", "Lkotlin/ParameterName;", "name", "e", "getCodeToTemplate", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "", "", "file", "Ljava/nio/file/Path;", "getFileDownloadPath", "kotlin.jvm.PlatformType", "version", "intellij.javascript.backend"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        public final void setErrorReporter(@NotNull Disposable disposable, @NotNull Function1<? super Exception, Unit> reporter) {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            Intrinsics.checkNotNullParameter(reporter, (String)"reporter");
            myErrorReporter = reporter;
            Disposer.register((Disposable)disposable, Companion::setErrorReporter$lambda$0);
        }

        @NotNull
        public final Sequence<Pair<Integer, String>> getCodeToTemplate(@NotNull Path file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Pair<? extends Integer, ? extends String>>, Continuation<? super Unit>, Object>(file, null){
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Path $file;
                {
                    this.$file = $file;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    block11: {
                        var2_2 = (SequenceScope)this.L$0;
                        var12_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        block0 : switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                root = JsonParser.parseReader((Reader)Files.newBufferedReader(this.$file));
                                if (!root.isJsonObject()) {
                                    throw new JsonParseException("Not json object: " + this.$file);
                                }
                                var4_5 = root.getAsJsonObject().entrySet().iterator();
lbl10:
                                // 3 sources

                                while (var4_5.hasNext()) {
                                    var5_6 = (Map.Entry)var4_5.next();
                                    Intrinsics.checkNotNull((Object)var5_6);
                                    jsonKey = (String)var5_6.getKey();
                                    jsonVal = (JsonElement)var5_6.getValue();
                                    if (!jsonVal.isJsonObject() || !jsonVal.getAsJsonObject().has("code") || !jsonVal.getAsJsonObject().get("code").isJsonPrimitive()) break block0;
                                    if (jsonVal.getAsJsonObject().get("code").getAsJsonPrimitive() == null) ** GOTO lbl30
                                    $i$a$-let-DiagnosticTemplatesEnProvider$Companion$getCodeToTemplate$1$1 = false;
                                    if (it.isNumber()) ** GOTO lbl-1000
                                    if (it.isString()) {
                                        v0 = it.getAsString();
                                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getAsString(...)");
                                        ** if (StringsKt.toIntOrNull((String)v0) == null) goto lbl-1000
                                    }
                                    ** GOTO lbl-1000
lbl-1000:
                                    // 2 sources

                                    {
                                        v1 = true;
                                        ** GOTO lbl28
                                    }
lbl-1000:
                                    // 2 sources

                                    {
                                        v1 = false;
                                    }
lbl28:
                                    // 2 sources

                                    v2 = v1;
                                    ** GOTO lbl31
lbl30:
                                    // 1 sources

                                    v2 = false;
lbl31:
                                    // 2 sources

                                    if (!v2) break block0;
                                    var8_9 = jsonVal.getAsJsonObject().get("code").getAsJsonPrimitive();
                                    var11_13 = $this$sequence;
                                    $i$a$-let-DiagnosticTemplatesEnProvider$Companion$getCodeToTemplate$1$2 = false;
                                    if (it.isNumber()) {
                                        v3 = it.getAsInt();
                                    } else {
                                        v4 = it.getAsString();
                                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getAsString(...)");
                                        v3 = Integer.parseInt(v4);
                                    }
                                    this.L$0 = $this$sequence;
                                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)root);
                                    this.L$2 = var4_5;
                                    this.L$3 = SpillingKt.nullOutSpilledVariable((Object)jsonKey);
                                    this.L$4 = SpillingKt.nullOutSpilledVariable((Object)jsonVal);
                                    this.label = 1;
                                    v5 = var11_13.yield((Object)TuplesKt.to((Object)Boxing.boxInt((int)v3), (Object)jsonKey), (Continuation)this);
                                    if (v5 != var12_3) continue;
                                    return var12_3;
                                }
                                break block11;
                            }
                            case 1: {
                                jsonVal = (JsonElement)this.L$4;
                                jsonKey = (String)this.L$3;
                                var4_5 = (Iterator<E>)this.L$2;
                                root = (JsonElement)this.L$1;
                                ResultKt.throwOnFailure((Object)$result);
                                v5 = $result;
                                ** GOTO lbl10
                            }
                        }
                        throw new JsonParseException("In " + this.$file + " unexpected json value=" + jsonVal + " with key=" + jsonKey);
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(SequenceScope<? super Pair<Integer, String>> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        private final Path getFileDownloadPath(String version2) {
            String[] stringArray = new String[]{"typescript-diag-message-parser", "diagnosticMessages-en-" + version2 + ".json"};
            return Paths.get(PathManager.getSystemPath(), stringArray);
        }

        private static final void setErrorReporter$lambda$0() {
            myErrorReporter = myDefaultErrorReporter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadFailed;", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadedFile;", "version", "", "whenMs", "", "<init>", "(Ljava/lang/String;J)V", "getWhenMs", "()J", "intellij.javascript.backend"})
    private static final class DownloadFailed
    extends DownloadedFile {
        private final long whenMs;

        public DownloadFailed(@NotNull String version2, long whenMs) {
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            super(version2, null);
            this.whenMs = whenMs;
        }

        public final long getWhenMs() {
            return this.whenMs;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0003\b\t\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadedFile;", "", "version", "", "<init>", "(Ljava/lang/String;)V", "getVersion", "()Ljava/lang/String;", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadFailed;", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$SuccessfullyDownloaded;", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$VersionNotFound;", "intellij.javascript.backend"})
    private static abstract sealed class DownloadedFile
    permits DownloadFailed, SuccessfullyDownloaded, VersionNotFound {
        @NotNull
        private final String version;

        private DownloadedFile(String version2) {
            this.version = version2;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        public /* synthetic */ DownloadedFile(String version2, DefaultConstructorMarker $constructor_marker) {
            this(version2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$SuccessfullyDownloaded;", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadedFile;", "version", "", "path", "Ljava/nio/file/Path;", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "getPath", "()Ljava/nio/file/Path;", "intellij.javascript.backend"})
    private static final class SuccessfullyDownloaded
    extends DownloadedFile {
        @NotNull
        private final Path path;

        public SuccessfullyDownloaded(@NotNull String version2, @NotNull Path path2) {
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            super(version2, null);
            this.path = path2;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$VersionNotFound;", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadedFile;", "version", "", "<init>", "(Ljava/lang/String;)V", "intellij.javascript.backend"})
    private static final class VersionNotFound
    extends DownloadedFile {
        public VersionNotFound(@NotNull String version2) {
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            super(version2, null);
        }
    }
}

