/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.IClassVariable;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class ClassVarNode
extends Node
implements IClassVariable {
    private String name;

    public ClassVarNode(SourcePosition position, String name) {
        super(position);
        if (name.startsWith("@@")) {
            name = name.substring(2);
        }
        this.name = name;
    }

    public boolean isSame(Node other) {
        return super.isSame(other) && this.isNameMatch(((ClassVarNode)other).getName());
    }

    public NodeType getNodeType() {
        return NodeType.CLASSVARNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitClassVarNode(this);
    }

    public String getLexicalName() {
        return "@@" + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNameMatch(String name) {
        String thisName = this.getName();
        return thisName != null && thisName.equals(name);
    }

    public SourcePosition getNamePosition() {
        return this.getPosition().fromEnd(this.getName().length());
    }

    public SourcePosition getLexicalNamePosition() {
        return this.getPosition();
    }
}

