/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.vcs.VcsException;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.perforce.P4Command;

public abstract class P4Parser {
    @NotNull
    private final RevisionCollector myRevisionCollector;
    @NotNull
    private final P4Command myCommand;

    public P4Parser(@NotNull P4Command command, @NotNull Object2LongMap<String> revisions) {
        if (command == null) {
            P4Parser.$$$reportNull$$$0(0);
        }
        if (revisions == null) {
            P4Parser.$$$reportNull$$$0(1);
        }
        this.myRevisionCollector = new RevisionCollector(revisions);
        this.myCommand = command;
    }

    @NotNull
    public P4Command getCommand() {
        P4Command p4Command = this.myCommand;
        if (p4Command == null) {
            P4Parser.$$$reportNull$$$0(2);
        }
        return p4Command;
    }

    @Nullable
    protected abstract ParsedLine consumeLine(@NotNull String var1) throws VcsException;

    protected void consumeRevision(@NotNull String path, long revision) {
        if (path == null) {
            P4Parser.$$$reportNull$$$0(3);
        }
        this.myRevisionCollector.consumeRevision(path, revision);
    }

    void readOutput(@NotNull InputStream inputStream) throws IOException, VcsException {
        String line;
        if (inputStream == null) {
            P4Parser.$$$reportNull$$$0(4);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null && !line.isEmpty()) {
            ParsedLine parsedLine = this.consumeLine(line);
            if (parsedLine == null) continue;
            this.consumeRevision(parsedLine.path, parsedLine.revision);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/perforce/P4Parser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/perforce/P4Parser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "consumeRevision";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readOutput";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    static final class RevisionCollector {
        private final Object2LongMap<String> myRevisions;

        RevisionCollector(@NotNull Object2LongMap<String> revisions) {
            if (revisions == null) {
                RevisionCollector.$$$reportNull$$$0(0);
            }
            this.myRevisions = revisions;
        }

        void consumeRevision(@NotNull String path, long revision) {
            if (path == null) {
                RevisionCollector.$$$reportNull$$$0(1);
            }
            this.myRevisions.put((Object)path, revision);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revisions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/perforce/perforce/P4Parser$RevisionCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "consumeRevision";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected record ParsedLine(@NotNull String path, long revision) {
        @NotNull
        private final String path;

        protected ParsedLine(@NotNull String path, long revision) {
            if (path == null) {
                ParsedLine.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public String path() {
            String string = this.path;
            if (string == null) {
                ParsedLine.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/perforce/perforce/P4Parser$ParsedLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/perforce/perforce/P4Parser$ParsedLine";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "path";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

