/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic.internal.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCacheControl;
import dev.langchain4j.model.anthropic.internal.api.AnthropicToolSchema;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class AnthropicTool {
    public String name;
    public String description;
    public AnthropicToolSchema inputSchema;
    public AnthropicCacheControl cacheControl;

    public AnthropicTool() {
    }

    public AnthropicTool(String name, String description, AnthropicToolSchema inputSchema, AnthropicCacheControl cacheControl) {
        this.name = name;
        this.description = description;
        this.inputSchema = inputSchema;
        this.cacheControl = cacheControl;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnthropicTool that = (AnthropicTool)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.inputSchema, that.inputSchema) && Objects.equals(this.cacheControl, that.cacheControl);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.inputSchema, this.cacheControl);
    }

    public String toString() {
        return "AnthropicTool{name='" + this.name + "', description='" + this.description + "', inputSchema=" + String.valueOf(this.inputSchema) + ", cacheControl=" + String.valueOf(this.cacheControl) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String description;
        private AnthropicToolSchema inputSchema;
        private AnthropicCacheControl cacheControl;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder inputSchema(AnthropicToolSchema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public Builder cacheControl(AnthropicCacheControl cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public AnthropicTool build() {
            return new AnthropicTool(this.name, this.description, this.inputSchema, this.cacheControl);
        }
    }
}

