/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.DiscreteTransform;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.scale.AbstractScale;
import org.jetbrains.letsPlot.core.plot.base.scale.BreaksGenerator;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.Transforms;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0012\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0014J\b\u0010\u0018\u001a\u00020\u000eH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/ContinuousScale;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/AbstractScale;", "", "name", "", "continuousOutput", "", "(Ljava/lang/String;Z)V", "b", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ContinuousScale$MyBuilder;", "(Lorg/jetbrains/letsPlot/core/plot/base/scale/ContinuousScale$MyBuilder;)V", "continuousTransform", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "customBreaksGenerator", "Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "isContinuous", "()Z", "isContinuousDomain", "transform", "getTransform", "()Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "createScaleBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "shortenLabels", "getBreaksGenerator", "with", "Lorg/jetbrains/letsPlot/core/plot/base/Scale$Builder;", "MyBuilder", "plot-base"})
@SourceDebugExtension(value={"SMAP\nContinuousScale.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContinuousScale.kt\norg/jetbrains/letsPlot/core/plot/base/scale/ContinuousScale\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public final class ContinuousScale
extends AbstractScale<Double> {
    @NotNull
    private final ContinuousTransform continuousTransform;
    @Nullable
    private final BreaksGenerator customBreaksGenerator;
    private final boolean isContinuous;
    private final boolean isContinuousDomain;

    @Override
    public boolean isContinuous() {
        return this.isContinuous;
    }

    @Override
    public boolean isContinuousDomain() {
        return this.isContinuousDomain;
    }

    @Override
    @NotNull
    public ContinuousTransform getTransform() {
        return this.continuousTransform;
    }

    public ContinuousScale(@NotNull String name, boolean continuousOutput) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.isContinuousDomain = true;
        this.isContinuous = continuousOutput;
        this.continuousTransform = Transforms.INSTANCE.getIDENTITY();
        this.customBreaksGenerator = null;
        this.setMultiplicativeExpand(0.05);
        this.setAdditiveExpand(0.0);
    }

    private ContinuousScale(MyBuilder b2) {
        super(b2);
        this.isContinuousDomain = true;
        this.continuousTransform = b2.getMyContinuousTransform();
        this.customBreaksGenerator = b2.getMyCustomBreaksGenerator();
        this.isContinuous = b2.getMyContinuousOutput();
    }

    @Override
    @NotNull
    public BreaksGenerator getBreaksGenerator() {
        return this.customBreaksGenerator != null ? (BreaksGenerator)new Transforms.BreaksGeneratorForTransformedDomain(this.continuousTransform, this.customBreaksGenerator) : Transforms.INSTANCE.createBreaksGeneratorForTransformedDomain(this.continuousTransform, this.getProvidedFormatter(), this.getExpFormat());
    }

    @Override
    @NotNull
    protected ScaleBreaks createScaleBreaks(boolean shortenLabels) {
        ScaleBreaks scaleBreaksOrNull2;
        ScaleBreaks scaleBreaks;
        ScaleBreaks scaleBreaks2;
        boolean makeFixed;
        boolean bl = makeFixed = this.getProvidedBreaks() != null || this.getProvidedLabels() != null;
        if (makeFixed) {
            List<String> list2;
            List fixedDomainValues;
            List<Object> list3 = this.getProvidedBreaks();
            if (list3 == null) {
                ScaleBreaks scaleBreaks3 = this.getProvidedScaleBreaks();
                list3 = fixedDomainValues = scaleBreaks3 != null ? scaleBreaks3.getDomainValues() : null;
            }
            if ((list2 = this.getProvidedLabels()) == null) {
                ScaleBreaks scaleBreaks4 = this.getProvidedScaleBreaks();
                list2 = scaleBreaks4 != null ? scaleBreaks4.getLabels() : null;
            }
            List<String> fixedLabels = list2;
            List list4 = fixedDomainValues;
            if (list4 != null) {
                List<String> alignedLabels;
                List<String> list5;
                List domainValues = list4;
                boolean bl2 = false;
                List<String> list6 = fixedLabels;
                if (list6 != null) {
                    List<String> it = list6;
                    boolean bl3 = false;
                    list5 = AbstractScale.Companion.alignLablesAndBreaks(domainValues, it);
                } else {
                    list5 = alignedLabels = null;
                }
                if ((scaleBreaks2 = this.getProvidedScaleBreaks()) == null || (scaleBreaks2 = scaleBreaks2.withFixedBreaks(fixedDomainValues, alignedLabels)) == null) {
                    scaleBreaks2 = ScaleBreaks.Fixed.withTransform$default(ScaleBreaks.Fixed.INSTANCE, domainValues, this.getTransform(), (Function1)new Function1<Object, String>((Object)this){

                        @NotNull
                        public final String invoke(@NotNull Object p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return ((ContinuousScale)this.receiver).formatValue(p0);
                        }
                    }, fixedLabels, null, 16, null);
                }
            } else {
                scaleBreaks2 = null;
            }
        } else {
            scaleBreaks2 = this.getProvidedScaleBreaks();
        }
        if ((scaleBreaks = (scaleBreaksOrNull2 = scaleBreaks2)) == null) {
            scaleBreaks = ScaleBreaks.Companion.getEMPTY();
        }
        return scaleBreaks;
    }

    @Override
    @NotNull
    public Scale.Builder with() {
        return new MyBuilder(this);
    }

    public /* synthetic */ ContinuousScale(MyBuilder b2, DefaultConstructorMarker $constructor_marker) {
        this(b2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001dH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/ContinuousScale$MyBuilder;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/AbstractScale$AbstractBuilder;", "", "scale", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ContinuousScale;", "(Lorg/jetbrains/letsPlot/core/plot/base/scale/ContinuousScale;)V", "myContinuousOutput", "", "getMyContinuousOutput", "()Z", "myContinuousTransform", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "getMyContinuousTransform", "()Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "setMyContinuousTransform", "(Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;)V", "myCustomBreaksGenerator", "Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "getMyCustomBreaksGenerator", "()Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "setMyCustomBreaksGenerator", "(Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;)V", "breaksGenerator", "Lorg/jetbrains/letsPlot/core/plot/base/Scale$Builder;", "v", "build", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "continuousTransform", "discreteTransform", "Lorg/jetbrains/letsPlot/core/plot/base/DiscreteTransform;", "plot-base"})
    private static final class MyBuilder
    extends AbstractScale.AbstractBuilder<Double> {
        @NotNull
        private ContinuousTransform myContinuousTransform;
        @Nullable
        private BreaksGenerator myCustomBreaksGenerator;
        private final boolean myContinuousOutput;

        public MyBuilder(@NotNull ContinuousScale scale2) {
            Intrinsics.checkNotNullParameter((Object)scale2, (String)"scale");
            super(scale2);
            this.myContinuousTransform = scale2.continuousTransform;
            this.myCustomBreaksGenerator = scale2.customBreaksGenerator;
            this.myContinuousOutput = scale2.isContinuous();
        }

        @NotNull
        public final ContinuousTransform getMyContinuousTransform() {
            return this.myContinuousTransform;
        }

        public final void setMyContinuousTransform(@NotNull ContinuousTransform continuousTransform) {
            Intrinsics.checkNotNullParameter((Object)continuousTransform, (String)"<set-?>");
            this.myContinuousTransform = continuousTransform;
        }

        @Nullable
        public final BreaksGenerator getMyCustomBreaksGenerator() {
            return this.myCustomBreaksGenerator;
        }

        public final void setMyCustomBreaksGenerator(@Nullable BreaksGenerator breaksGenerator) {
            this.myCustomBreaksGenerator = breaksGenerator;
        }

        public final boolean getMyContinuousOutput() {
            return this.myContinuousOutput;
        }

        @Override
        @NotNull
        public Scale.Builder continuousTransform(@NotNull ContinuousTransform v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            this.myContinuousTransform = v;
            return this;
        }

        @Override
        @NotNull
        public Scale.Builder discreteTransform(@NotNull DiscreteTransform v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            return this;
        }

        @Override
        @NotNull
        public Scale.Builder breaksGenerator(@NotNull BreaksGenerator v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            this.myCustomBreaksGenerator = v;
            return this;
        }

        @Override
        @NotNull
        public Scale build() {
            return new ContinuousScale(this, null);
        }
    }
}

