/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.export;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.Figure;
import org.jetbrains.letsPlot.awt.plot.PlotSvgExport;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.export.PlotImageExport;
import org.jetbrains.letsPlot.core.util.PlotExportCommon;
import org.jetbrains.letsPlot.core.util.PlotHtmlExport;
import org.jetbrains.letsPlot.core.util.PlotHtmlHelper;
import org.jetbrains.letsPlot.export.VersionChecker;
import org.jetbrains.letsPlot.intern.ToSpecConvertersKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u001aT\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0002\u001a^\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0001\u001a\u001e\u0010\u0019\u001a\u0004\u0018\u00010\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"DEF_EXPORT_DIR", "", "exportRasterImage", "", "spec", "", "", "file", "Ljava/nio/file/Path;", "scalingFactor", "", "plotSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "unit", "Lorg/jetbrains/letsPlot/core/util/PlotExportCommon$SizeUnit;", "targetDPI", "ggsave", "plot", "Lorg/jetbrains/letsPlot/Figure;", "filename", "scale", "dpi", "path", "w", "h", "toDoubleVector", "x", "y", "plot-api"})
@SourceDebugExtension(value={"SMAP\nggsave.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ggsave.kt\norg/jetbrains/letsPlot/export/GgsaveKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,261:1\n1#2:262\n*E\n"})
public final class GgsaveKt {
    @NotNull
    private static final String DEF_EXPORT_DIR = "lets-plot-images";

    @NotNull
    public static final String ggsave(@NotNull Figure plot, @NotNull String filename, @Nullable Number scale2, @Nullable Number dpi, @Nullable String path2, @Nullable Number w, @Nullable Number h, @Nullable String unit) {
        Object object;
        String ext;
        String filename2;
        block35: {
            String[] it;
            block34: {
                Intrinsics.checkNotNullParameter((Object)plot, (String)"plot");
                Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
                filename2 = ((Object)StringsKt.trim((CharSequence)filename)).toString();
                if (!(StringsKt.indexOf$default((CharSequence)filename2, (char)'.', (int)0, (boolean)false, (int)6, null) >= 0)) {
                    boolean $i$a$-require-GgsaveKt$ggsave$42 = false;
                    String $i$a$-require-GgsaveKt$ggsave$42 = "File extension is missing: \"" + filename2 + "\".";
                    throw new IllegalArgumentException($i$a$-require-GgsaveKt$ggsave$42.toString());
                }
                if (!(((CharSequence)StringsKt.substringBeforeLast((String)filename2, (char)'.', (String)"")).length() > 0)) {
                    boolean $i$a$-require-GgsaveKt$ggsave$52 = false;
                    String $i$a$-require-GgsaveKt$ggsave$52 = "Malformed filename: \"" + filename2 + "\".";
                    throw new IllegalArgumentException($i$a$-require-GgsaveKt$ggsave$52.toString());
                }
                String $i$a$-require-GgsaveKt$ggsave$52 = StringsKt.substringAfterLast((String)filename2, (char)'.', (String)"");
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string = $i$a$-require-GgsaveKt$ggsave$52.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                ext = string;
                if (!(((CharSequence)ext).length() > 0)) {
                    boolean $i$a$-require-GgsaveKt$ggsave$62 = false;
                    String $i$a$-require-GgsaveKt$ggsave$62 = "Missing file extension: \"" + filename2 + "\".";
                    throw new IllegalArgumentException($i$a$-require-GgsaveKt$ggsave$62.toString());
                }
                object = path2;
                if (path2 == null) break block34;
                it = object;
                boolean bl = false;
                Path path3 = Paths.get((String)path2, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
                object = path3;
                if (path3 != null) break block35;
            }
            String string = System.getProperty("user.dir");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            String string2 = string;
            it = new String[]{DEF_EXPORT_DIR};
            Path path4 = Paths.get(string2, Arrays.copyOf(it, it.length));
            object = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
        }
        String[] dir = object;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)dir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Path file = dir.resolve(filename2);
        Map<String, Object> spec = ToSpecConvertersKt.toSpec(plot);
        String string = unit;
        if (string == null) {
            string = "";
        }
        PlotExportCommon.SizeUnit sizeUnit = PlotExportCommon.SizeUnit.Companion.fromName(string);
        DoubleVector plotSize2 = GgsaveKt.toDoubleVector(w, h);
        switch (ext) {
            case "svg": {
                PlotExportCommon.SizeUnit sizeUnit2 = sizeUnit;
                if (sizeUnit2 == null) {
                    sizeUnit2 = PlotExportCommon.SizeUnit.PX;
                }
                String svg = PlotSvgExport.buildSvgImageFromRawSpecs$default(PlotSvgExport.INSTANCE, spec, plotSize2, false, sizeUnit2, 4, null);
                Intrinsics.checkNotNull((Object)file);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(file, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length)), (String)"createFile(...)");
                }
                PathsKt.writeText$default((Path)file, (CharSequence)svg, null, (OpenOption[])new OpenOption[0], (int)2, null);
                break;
            }
            case "htm": 
            case "html": {
                String html = PlotHtmlExport.INSTANCE.buildHtmlFromRawSpecs(spec, PlotHtmlHelper.INSTANCE.scriptUrl(VersionChecker.INSTANCE.getLetsPlotJsVersion()), true, plotSize2);
                Intrinsics.checkNotNull((Object)file);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    FileAttribute[] fileAttributeArray3 = new FileAttribute[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(file, Arrays.copyOf(fileAttributeArray3, fileAttributeArray3.length)), (String)"createFile(...)");
                }
                PathsKt.writeText$default((Path)file, (CharSequence)html, null, (OpenOption[])new OpenOption[0], (int)2, null);
                break;
            }
            case "jpg": 
            case "tif": 
            case "tiff": 
            case "png": 
            case "jpeg": {
                Intrinsics.checkNotNull((Object)file);
                GgsaveKt.exportRasterImage(spec, file, scale2, plotSize2, sizeUnit, dpi);
                break;
            }
            default: {
                throw new IllegalArgumentException(StringsKt.trimIndent((String)("\n            Unsupported file extension: \"" + ext + "\".\n            Please use one of: \"svg\", \"html\", \"htm\", \"png\", \"jpeg\", \"jpg\", \"tiff\", \"tif\". \n        ")));
            }
        }
        return ((Object)file.toRealPath(new LinkOption[0])).toString();
    }

    public static /* synthetic */ String ggsave$default(Figure figure, String string, Number number, Number number2, String string2, Number number3, Number number4, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            number = null;
        }
        if ((n & 8) != 0) {
            number2 = null;
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        if ((n & 0x20) != 0) {
            number3 = null;
        }
        if ((n & 0x40) != 0) {
            number4 = null;
        }
        if ((n & 0x80) != 0) {
            string3 = null;
        }
        return GgsaveKt.ggsave(figure, string, number, number2, string2, number3, number4, string3);
    }

    private static final DoubleVector toDoubleVector(Number x2, Number y2) {
        return x2 != null && y2 != null ? new DoubleVector(x2.doubleValue(), y2.doubleValue()) : null;
    }

    private static final void exportRasterImage(Map<String, Object> spec, Path file, Number scalingFactor, DoubleVector plotSize2, PlotExportCommon.SizeUnit unit, Number targetDPI) {
        byte[] byArray;
        try {
            Class.forName("java.awt.image.BufferedImage");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("\nCan't export plot to raster formats: 'java.awt.image.BufferedImage' is not available in this environment.\nRaster image export requires 'java.awt.image.BufferedImage' which is not present in Android JRE or headless environments.");
        }
        try {
            PlotImageExport.Format format2;
            String string = PathsKt.getExtension((Path)file);
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            switch (string2) {
                case "png": {
                    format2 = (PlotImageExport.Format)PlotImageExport.Format.PNG.INSTANCE;
                    break;
                }
                case "jpg": 
                case "jpeg": {
                    format2 = (PlotImageExport.Format)new PlotImageExport.Format.JPEG(0.0, 1, null);
                    break;
                }
                case "tif": 
                case "tiff": {
                    format2 = (PlotImageExport.Format)PlotImageExport.Format.TIFF.INSTANCE;
                    break;
                }
                default: {
                    String ext;
                    throw new IllegalArgumentException("Unsupported format: " + ext);
                }
            }
            PlotImageExport.Format format3 = format2;
            PlotImageExport.ImageData image = PlotImageExport.INSTANCE.buildImageFromRawSpecs(spec, format3, scalingFactor, targetDPI, plotSize2, unit);
            byArray = image.getBytes();
        }
        catch (Throwable e) {
            Throwable throwable = e;
            if (throwable instanceof ClassNotFoundException ? true : throwable instanceof NoClassDefFoundError) {
                throw new IllegalStateException(StringsKt.trimIndent((String)("\n                    \n                    Can't export plot to raster formats: " + Reflection.getOrCreateKotlinClass(e.getClass()).getSimpleName() + " \"" + e.getMessage() + "\".\n                    Please add \"lets-plot-image-export-<version>.jar\" to your classpath.\n                    A Gradle dependency example:\n                    \n                        implementation(\"org.jetbrains.lets-plot:lets-plot-image-export:<version>\")\n                    \n                    where <version> is the version of the Lets-Plot Multiplatform artifact you are using.\n                ")));
            }
            throw e;
        }
        byte[] imageBytes = byArray;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(file, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
        }
        OpenOption[] openOptionArray = new OpenOption[]{};
        Files.write(file, imageBytes, Arrays.copyOf(openOptionArray, openOptionArray.length));
    }

    static /* synthetic */ void exportRasterImage$default(Map map2, Path path2, Number number, DoubleVector doubleVector, PlotExportCommon.SizeUnit sizeUnit, Number number2, int n, Object object) {
        if ((n & 4) != 0) {
            number = null;
        }
        if ((n & 8) != 0) {
            doubleVector = null;
        }
        if ((n & 0x10) != 0) {
            sizeUnit = null;
        }
        if ((n & 0x20) != 0) {
            number2 = null;
        }
        GgsaveKt.exportRasterImage(map2, path2, number, doubleVector, sizeUnit, number2);
    }
}

