/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Calendar;
import org.jetbrains.relocated.apache.batik.anim.AbstractAnimation;
import org.jetbrains.relocated.apache.batik.anim.dom.AnimatableElement;
import org.jetbrains.relocated.apache.batik.anim.dom.AnimatedLiveAttributeValue;
import org.jetbrains.relocated.apache.batik.anim.dom.AnimationTarget;
import org.jetbrains.relocated.apache.batik.anim.dom.AnimationTargetListener;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMElement;
import org.jetbrains.relocated.apache.batik.anim.timing.TimedElement;
import org.jetbrains.relocated.apache.batik.anim.values.AnimatableValue;
import org.jetbrains.relocated.apache.batik.bridge.AbstractSVGBridge;
import org.jetbrains.relocated.apache.batik.bridge.AnimationSupport;
import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.BridgeException;
import org.jetbrains.relocated.apache.batik.bridge.BridgeUpdateHandler;
import org.jetbrains.relocated.apache.batik.bridge.GenericBridge;
import org.jetbrains.relocated.apache.batik.bridge.SVGAnimationEngine;
import org.jetbrains.relocated.apache.batik.css.engine.CSSEngineEvent;
import org.jetbrains.relocated.apache.batik.dom.svg.SVGAnimationContext;
import org.jetbrains.relocated.apache.batik.dom.util.XLinkSupport;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGElement;

public abstract class SVGAnimationElementBridge
extends AbstractSVGBridge
implements GenericBridge,
BridgeUpdateHandler,
SVGAnimationContext,
AnimatableElement {
    protected SVGOMElement element;
    protected BridgeContext ctx;
    protected SVGAnimationEngine eng;
    protected TimedElement timedElement;
    protected AbstractAnimation animation;
    protected String attributeNamespaceURI;
    protected String attributeLocalName;
    protected short animationType;
    protected SVGOMElement targetElement;
    protected AnimationTarget animationTarget;

    public TimedElement getTimedElement() {
        return this.timedElement;
    }

    @Override
    public AnimatableValue getUnderlyingValue() {
        if (this.animationType == 0) {
            return this.animationTarget.getUnderlyingValue(this.attributeNamespaceURI, this.attributeLocalName);
        }
        return this.eng.getUnderlyingCSSValue(this.element, this.animationTarget, this.attributeLocalName);
    }

    @Override
    public void handleElement(BridgeContext ctx2, Element e) {
        if (ctx2.isDynamic() && BridgeContext.getSVGContext(e) == null) {
            SVGAnimationElementBridge b2 = (SVGAnimationElementBridge)this.getInstance();
            b2.element = (SVGOMElement)e;
            b2.ctx = ctx2;
            b2.eng = ctx2.getAnimationEngine();
            b2.element.setSVGContext(b2);
            if (b2.eng.hasStarted()) {
                b2.initializeAnimation();
                b2.initializeTimedElement();
            } else {
                b2.eng.addInitialBridge(b2);
            }
        }
    }

    protected void initializeAnimation() {
        Node t;
        String uri = XLinkSupport.getXLinkHref(this.element);
        if (uri.length() == 0) {
            t = this.element.getParentNode();
        } else {
            t = this.ctx.getReferencedElement(this.element, uri);
            if (t.getOwnerDocument() != this.element.getOwnerDocument()) {
                throw new BridgeException(this.ctx, this.element, "uri.badTarget", new Object[]{uri});
            }
        }
        this.animationTarget = null;
        if (t instanceof SVGOMElement) {
            this.targetElement = (SVGOMElement)t;
            this.animationTarget = this.targetElement;
        }
        if (this.animationTarget == null) {
            throw new BridgeException(this.ctx, this.element, "uri.badTarget", new Object[]{uri});
        }
        String an = this.element.getAttributeNS(null, "attributeName");
        int ci = an.indexOf(58);
        if (ci == -1) {
            if (this.element.hasProperty(an)) {
                this.animationType = 1;
                this.attributeLocalName = an;
            } else {
                this.animationType = 0;
                this.attributeLocalName = an;
            }
        } else {
            this.animationType = 0;
            String prefix = an.substring(0, ci);
            this.attributeNamespaceURI = this.element.lookupNamespaceURI(prefix);
            this.attributeLocalName = an.substring(ci + 1);
        }
        if (this.animationType == 1 && !this.targetElement.isPropertyAnimatable(this.attributeLocalName) || this.animationType == 0 && !this.targetElement.isAttributeAnimatable(this.attributeNamespaceURI, this.attributeLocalName)) {
            throw new BridgeException(this.ctx, this.element, "attribute.not.animatable", new Object[]{this.targetElement.getNodeName(), an});
        }
        int type = this.animationType == 1 ? this.targetElement.getPropertyType(this.attributeLocalName) : this.targetElement.getAttributeType(this.attributeNamespaceURI, this.attributeLocalName);
        if (!this.canAnimateType(type)) {
            throw new BridgeException(this.ctx, this.element, "type.not.animatable", new Object[]{this.targetElement.getNodeName(), an, this.element.getNodeName()});
        }
        this.timedElement = this.createTimedElement();
        this.animation = this.createAnimation(this.animationTarget);
        this.eng.addAnimation(this.animationTarget, this.animationType, this.attributeNamespaceURI, this.attributeLocalName, this.animation);
    }

    protected abstract boolean canAnimateType(int var1);

    protected boolean checkValueType(AnimatableValue v) {
        return true;
    }

    protected void initializeTimedElement() {
        this.initializeTimedElement(this.timedElement);
        this.timedElement.initialize();
    }

    protected TimedElement createTimedElement() {
        return new SVGTimedElement();
    }

    protected abstract AbstractAnimation createAnimation(AnimationTarget var1);

    protected AnimatableValue parseAnimatableValue(String an) {
        String s;
        if (!this.element.hasAttributeNS(null, an)) {
            return null;
        }
        AnimatableValue val = this.eng.parseAnimatableValue(this.element, this.animationTarget, this.attributeNamespaceURI, this.attributeLocalName, this.animationType == 1, s = this.element.getAttributeNS(null, an));
        if (!this.checkValueType(val)) {
            throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{an, s});
        }
        return val;
    }

    protected void initializeTimedElement(TimedElement timedElement) {
        timedElement.parseAttributes(this.element.getAttributeNS(null, "begin"), this.element.getAttributeNS(null, "dur"), this.element.getAttributeNS(null, "end"), this.element.getAttributeNS(null, "min"), this.element.getAttributeNS(null, "max"), this.element.getAttributeNS(null, "repeatCount"), this.element.getAttributeNS(null, "repeatDur"), this.element.getAttributeNS(null, "fill"), this.element.getAttributeNS(null, "restart"));
    }

    @Override
    public void handleDOMAttrModifiedEvent(MutationEvent evt) {
    }

    @Override
    public void handleDOMNodeInsertedEvent(MutationEvent evt) {
    }

    @Override
    public void handleDOMNodeRemovedEvent(MutationEvent evt) {
        this.element.setSVGContext(null);
        this.dispose();
    }

    @Override
    public void handleDOMCharacterDataModified(MutationEvent evt) {
    }

    @Override
    public void handleCSSEngineEvent(CSSEngineEvent evt) {
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue alav) {
    }

    @Override
    public void handleOtherAnimationChanged(String type) {
    }

    @Override
    public void dispose() {
        if (this.element.getSVGContext() == null) {
            this.eng.removeAnimation(this.animation);
            this.timedElement.deinitialize();
            this.timedElement = null;
            this.element = null;
        }
    }

    @Override
    public float getPixelUnitToMillimeter() {
        return this.ctx.getUserAgent().getPixelUnitToMillimeter();
    }

    @Override
    public float getPixelToMM() {
        return this.getPixelUnitToMillimeter();
    }

    @Override
    public Rectangle2D getBBox() {
        return null;
    }

    @Override
    public AffineTransform getScreenTransform() {
        return this.ctx.getUserAgent().getTransform();
    }

    @Override
    public void setScreenTransform(AffineTransform at) {
        this.ctx.getUserAgent().setTransform(at);
    }

    @Override
    public AffineTransform getCTM() {
        return null;
    }

    @Override
    public AffineTransform getGlobalTransform() {
        return null;
    }

    @Override
    public float getViewportWidth() {
        return this.ctx.getBlockWidth(this.element);
    }

    @Override
    public float getViewportHeight() {
        return this.ctx.getBlockHeight(this.element);
    }

    @Override
    public float getFontSize() {
        return 0.0f;
    }

    public float svgToUserSpace(float v, int type, int pcInterp) {
        return 0.0f;
    }

    public void addTargetListener(String pn, AnimationTargetListener l) {
    }

    public void removeTargetListener(String pn, AnimationTargetListener l) {
    }

    @Override
    public SVGElement getTargetElement() {
        return this.targetElement;
    }

    @Override
    public float getStartTime() {
        return this.timedElement.getCurrentBeginTime();
    }

    @Override
    public float getCurrentTime() {
        return this.timedElement.getLastSampleTime();
    }

    @Override
    public float getSimpleDuration() {
        return this.timedElement.getSimpleDur();
    }

    @Override
    public float getHyperlinkBeginTime() {
        return this.timedElement.getHyperlinkBeginTime();
    }

    public boolean beginElement() throws DOMException {
        this.timedElement.beginElement();
        return this.timedElement.canBegin();
    }

    public boolean beginElementAt(float offset) throws DOMException {
        this.timedElement.beginElement(offset);
        return true;
    }

    public boolean endElement() throws DOMException {
        this.timedElement.endElement();
        return this.timedElement.canEnd();
    }

    public boolean endElementAt(float offset) throws DOMException {
        this.timedElement.endElement(offset);
        return true;
    }

    protected boolean isConstantAnimation() {
        return false;
    }

    protected class SVGTimedElement
    extends TimedElement {
        protected SVGTimedElement() {
        }

        @Override
        public Element getElement() {
            return SVGAnimationElementBridge.this.element;
        }

        @Override
        protected void fireTimeEvent(String eventType, Calendar time, int detail) {
            AnimationSupport.fireTimeEvent(SVGAnimationElementBridge.this.element, eventType, time, detail);
        }

        @Override
        protected void toActive(float begin) {
            SVGAnimationElementBridge.this.eng.toActive(SVGAnimationElementBridge.this.animation, begin);
        }

        @Override
        protected void toInactive(boolean stillActive, boolean isFrozen) {
            SVGAnimationElementBridge.this.eng.toInactive(SVGAnimationElementBridge.this.animation, isFrozen);
        }

        @Override
        protected void removeFill() {
            SVGAnimationElementBridge.this.eng.removeFill(SVGAnimationElementBridge.this.animation);
        }

        @Override
        protected void sampledAt(float simpleTime, float simpleDur, int repeatIteration) {
            SVGAnimationElementBridge.this.eng.sampledAt(SVGAnimationElementBridge.this.animation, simpleTime, simpleDur, repeatIteration);
        }

        @Override
        protected void sampledLastValue(int repeatIteration) {
            SVGAnimationElementBridge.this.eng.sampledLastValue(SVGAnimationElementBridge.this.animation, repeatIteration);
        }

        @Override
        protected TimedElement getTimedElementById(String id) {
            return AnimationSupport.getTimedElementById(id, SVGAnimationElementBridge.this.element);
        }

        @Override
        protected EventTarget getEventTargetById(String id) {
            return AnimationSupport.getEventTargetById(id, SVGAnimationElementBridge.this.element);
        }

        @Override
        protected EventTarget getRootEventTarget() {
            return (EventTarget)((Object)SVGAnimationElementBridge.this.element.getOwnerDocument());
        }

        @Override
        protected EventTarget getAnimationEventTarget() {
            return SVGAnimationElementBridge.this.targetElement;
        }

        @Override
        public boolean isBefore(TimedElement other) {
            Element e = other.getElement();
            short pos = SVGAnimationElementBridge.this.element.compareDocumentPosition(e);
            return (pos & 2) != 0;
        }

        public String toString() {
            String id;
            if (SVGAnimationElementBridge.this.element != null && (id = SVGAnimationElementBridge.this.element.getAttributeNS(null, "id")).length() != 0) {
                return id;
            }
            return super.toString();
        }

        @Override
        protected boolean isConstantAnimation() {
            return SVGAnimationElementBridge.this.isConstantAnimation();
        }
    }
}

