/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.JSParsingContextUtil;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0014\b\u0016\u0018\u0000 \"*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\"B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0012\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\bH\u0004J\b\u0010\u0014\u001a\u00020\u000fH\u0014J\b\u0010\u0015\u001a\u00020\bH\u0014J\u0012\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\rH\u0014J\b\u0010\u001b\u001a\u00020\bH\u0014J\b\u0010\u001c\u001a\u00020\bH\u0002J\b\u0010\u001d\u001a\u00020\bH\u0014J\b\u0010\u001e\u001a\u00020\bH\u0016J\b\u0010\u001f\u001a\u00020\bH\u0014J\u0010\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bH\u0016R\u0014\u0010\u0016\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006#"}, d2={"Lcom/intellij/lang/ecmascript6/parsing/ES6ExpressionParser;", "T", "Lcom/intellij/lang/javascript/parsing/JavaScriptParser;", "Lcom/intellij/lang/javascript/parsing/ExpressionParser;", "parser", "<init>", "(Lcom/intellij/lang/javascript/parsing/JavaScriptParser;)V", "parsePropertyNoMarker", "", "property", "Lcom/intellij/lang/PsiBuilder$Marker;", "isPropertyStart", "elementType", "Lcom/intellij/psi/tree/IElementType;", "parseDestructuringProperty", "", "tryParseDestructuringRestElement", "type", "parseDestructuringRestElementNoMarker", "parseType", "parseDestructuringArrayElement", "parseArrayElement", "safeAccessOperator", "getSafeAccessOperator", "()Lcom/intellij/psi/tree/IElementType;", "isReferenceQualifierSeparator", "tokenType", "parseArgument", "parseSpreadExpression", "parseUnaryExpression", "parsePrimaryExpression", "parseNewExpression", "parseAssignmentExpression", "allowIn", "Companion", "intellij.javascript.parser"})
public class ES6ExpressionParser<T extends JavaScriptParser>
extends ExpressionParser<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ES6ExpressionParser(@NotNull T parser) {
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        super(parser);
    }

    @Override
    protected boolean parsePropertyNoMarker(@NotNull PsiBuilder.Marker property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (this.parser.getFunctionParser().tryParseES7Decorators() && this.builder.getTokenType() == JSTokenTypes.RBRACE) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.property.name", new Object[0]));
            property.done(JSElementTypes.PROPERTY);
            return true;
        }
        return super.parsePropertyNoMarker(property);
    }

    @Override
    protected boolean isPropertyStart(@Nullable IElementType elementType) {
        return super.isPropertyStart(elementType) || elementType == JSTokenTypes.MULT || elementType == JSTokenTypes.AT;
    }

    @Override
    protected void parseDestructuringProperty() {
        if (this.tryParseDestructuringRestElement(JSElementTypes.DESTRUCTURING_PROPERTY)) {
            return;
        }
        super.parseDestructuringProperty();
    }

    private final boolean tryParseDestructuringRestElement(IElementType type) {
        if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker property = marker;
            this.parseDestructuringRestElementNoMarker(false);
            property.done(type);
            return true;
        }
        return false;
    }

    protected final void parseDestructuringRestElementNoMarker(boolean parseType) {
        boolean bl;
        boolean bl2 = bl = this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.builder.advanceLexer();
        IElementType tokenType = this.builder.getTokenType();
        if (this.isIdentifierToken(tokenType)) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker variable = marker;
            this.builder.advanceLexer();
            Object object = this.builder.getUserData(ExpressionParser.DESTRUCTURING_VAR_TYPE);
            if (object == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            IElementType varType = (IElementType)object;
            if (parseType) {
                this.parser.getTypeParser().tryParseType();
            }
            variable.done(varType);
        } else if (tokenType == JSTokenTypes.LBRACE || tokenType == JSTokenTypes.LBRACKET) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker mark = marker;
            mark.done(this.parseDestructuringElementNoMarker(false, false));
        } else {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.identifier", new Object[0]));
        }
    }

    @Override
    protected void parseDestructuringArrayElement() {
        if (this.tryParseDestructuringRestElement(JSElementTypes.DESTRUCTURING_ARRAY_REST)) {
            return;
        }
        super.parseDestructuringArrayElement();
    }

    @Override
    protected boolean parseArrayElement() {
        boolean parseMoreElements = true;
        if (!this.parseSpreadExpression()) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            parseMoreElements = false;
        }
        return parseMoreElements;
    }

    @Override
    @NotNull
    protected IElementType getSafeAccessOperator() {
        return JSTokenTypes.ELVIS;
    }

    @Override
    protected boolean isReferenceQualifierSeparator(@Nullable IElementType tokenType) {
        return super.isReferenceQualifierSeparator(tokenType) || tokenType == this.getSafeAccessOperator();
    }

    @Override
    protected boolean parseArgument() {
        if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
            return this.parseSpreadExpression();
        }
        return super.parseArgument();
    }

    private final boolean parseSpreadExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker marker2 = marker;
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(true)) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
                marker2.drop();
                return false;
            }
            marker2.done(JSElementTypes.SPREAD_EXPRESSION);
        } else if (!this.parseAssignmentExpression(true)) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    protected boolean parseUnaryExpression() {
        IElementType type = this.builder.getTokenType();
        if (type == JSTokenTypes.AWAIT_KEYWORD) {
            if (JSParsingContextUtil.isAsyncContext(this.builder) || !JavaScriptParserBase.Companion.hasLineTerminatorAfter(this.builder) && this.parser.isIdentifierName(this.builder.lookAhead(1))) {
                PsiBuilder.Marker marker = this.builder.mark();
                Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
                PsiBuilder.Marker expr = marker;
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.MULT) {
                    this.builder.advanceLexer();
                }
                if (!this.parseUnaryExpression()) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
                }
                expr.done(JSElementTypes.PREFIX_EXPRESSION);
                return true;
            }
            return this.parsePostfixExpression();
        }
        if (type == JSTokenTypes.THROW_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker mark = marker;
            this.builder.advanceLexer();
            if (!this.parseUnaryExpression()) {
                mark.rollbackTo();
                return false;
            }
            mark.done(JSElementTypes.THROW_EXPRESSION);
            return true;
        }
        return super.parseUnaryExpression();
    }

    @Override
    public boolean parsePrimaryExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.ASYNC_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.FUNCTION_KEYWORD) {
            this.parser.getFunctionParser().parseFunctionExpression();
            return true;
        }
        if (this.builder.getTokenType() == JSTokenTypes.DO_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker doMarker = marker;
            this.builder.advanceLexer();
            this.parser.getStatementParser().parseBlock();
            doMarker.done(JSElementTypes.DO_EXPRESSION);
            return true;
        }
        return super.parsePrimaryExpression();
    }

    @Override
    protected boolean parseNewExpression() {
        ExpressionParser.LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.NEW_KEYWORD);
        if (this.builder.lookAhead(1) == JSTokenTypes.DOT) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker marker2 = marker;
            this.builder.advanceLexer();
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.IDENTIFIER) {
                if (!Intrinsics.areEqual((Object)"target", (Object)this.builder.getTokenText())) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.target", new Object[0]));
                }
                this.builder.advanceLexer();
            } else {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.identifier", new Object[0]));
            }
            marker2.done(JSElementTypes.META_PROPERTY);
            return false;
        }
        return super.parseNewExpression();
    }

    @Override
    public boolean parseAssignmentExpression(boolean allowIn) {
        if ((this.builder.getTokenType() == JSTokenTypes.LPAR || this.isIdentifierToken(this.builder.getTokenType())) && this.parser.getFunctionParser().parseArrowFunction()) {
            return true;
        }
        return super.parseAssignmentExpression(allowIn);
    }

    @JvmStatic
    public static final int collapseGtAndGetPriority(boolean advance, @NotNull PsiBuilder builder) {
        return Companion.collapseGtAndGetPriority(advance, builder);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/ecmascript6/parsing/ES6ExpressionParser$Companion;", "", "<init>", "()V", "collapseGtAndGetPriority", "", "advance", "", "builder", "Lcom/intellij/lang/PsiBuilder;", "intellij.javascript.parser"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int collapseGtAndGetPriority(boolean advance, @NotNull PsiBuilder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            IElementType tokenType = builder.getTokenType();
            if (tokenType == JSTokenTypes.GT && builder.rawLookup(1) == JSTokenTypes.EQ) {
                if (advance) {
                    PsiBuilder.Marker marker = builder.mark();
                    Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
                    PsiBuilder.Marker marker2 = marker;
                    builder.advanceLexer();
                    builder.advanceLexer();
                    marker2.collapse(JSTokenTypes.GE);
                }
                return 6;
            }
            if (tokenType == JSTokenTypes.GT && builder.rawLookup(1) == JSTokenTypes.GT) {
                if (advance) {
                    PsiBuilder.Marker marker = builder.mark();
                    Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
                    PsiBuilder.Marker marker3 = marker;
                    builder.advanceLexer();
                    builder.advanceLexer();
                    if (builder.getTokenType() == JSTokenTypes.GT) {
                        builder.advanceLexer();
                        marker3.collapse(JSTokenTypes.GTGTGT);
                    } else {
                        marker3.collapse(JSTokenTypes.GTGT);
                    }
                }
                return 7;
            }
            return -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

