/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.javascript.ecmascript6.InvalidEnumConstantValue;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.psi.PsiElement;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.StringCharacterIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnumTypeConstValue
implements EnumConstantValue {
    @Nullable
    private final JSType myType;

    public static EnumTypeConstValue createForNumber(double value, String stringValue, PsiElement context) {
        JSTypeSource source = JSTypeSourceFactory.createTypeSource(context, true);
        return new EnumTypeConstValue(new JSNumberLiteralTypeImpl(value, false, source, stringValue));
    }

    public static EnumTypeConstValue createForBigInt(BigInteger value, String stringValue, PsiElement context) {
        JSTypeSource source = JSTypeSourceFactory.createTypeSource(context, true);
        return new EnumTypeConstValue(new JSBigIntLiteralTypeImpl(value, false, source, stringValue));
    }

    @NotNull
    public static EnumConstantValue deserialize(@NotNull JSTypeSource source, @Nullable String value) {
        if (source == null) {
            EnumTypeConstValue.$$$reportNull$$$0(0);
        }
        if (value == null) {
            EnumConstantValue enumConstantValue = InvalidEnumConstantValue.INSTANCE;
            if (enumConstantValue == null) {
                EnumTypeConstValue.$$$reportNull$$$0(1);
            }
            return enumConstantValue;
        }
        return new EnumTypeConstValue(JSTypeSerializer.TYPE_SERIALIZER.read(source, new StringCharacterIterator(value)));
    }

    public EnumTypeConstValue(@Nullable JSType type) {
        this.myType = type;
    }

    @Override
    @Nullable
    public String getStringValue() {
        return this.myType instanceof JSStringLiteralTypeImpl ? ((JSStringLiteralTypeImpl)this.myType).getLiteral() : null;
    }

    @Override
    @Nullable
    public Double getNumericValue() {
        return this.myType instanceof JSNumberLiteralTypeImpl ? ((JSNumberLiteralTypeImpl)this.myType).getLiteral() : null;
    }

    @Override
    @Nullable
    public BigInteger getBigIntValue() {
        return this.myType instanceof JSBigIntLiteralTypeImpl ? ((JSBigIntLiteralTypeImpl)this.myType).getLiteral() : null;
    }

    @Override
    @NotNull
    public EnumConstantValue increaseNumericDelta(int delta) {
        int intValue;
        if (!(this.myType instanceof JSNumberLiteralTypeImpl)) {
            EnumConstantValue enumConstantValue = InvalidEnumConstantValue.INSTANCE;
            if (enumConstantValue == null) {
                EnumTypeConstValue.$$$reportNull$$$0(2);
            }
            return enumConstantValue;
        }
        double literal = ((JSNumberLiteralTypeImpl)this.myType).getLiteral();
        String newStringValue = literal == (double)(intValue = (int)literal) ? String.valueOf(intValue + delta) : String.valueOf(literal + (double)delta);
        return new EnumTypeConstValue(new JSNumberLiteralTypeImpl(literal + (double)delta, false, this.myType.getSource(), newStringValue));
    }

    @Override
    @Nullable
    public String getSerializedString() {
        return JSTypeUtils.serializeType(this.myType);
    }

    @Override
    @Nullable
    public String getAsString() {
        String value = this.getStringValue();
        if (value != null) {
            return value;
        }
        if (this.myType instanceof JSNumberLiteralTypeImpl) {
            return ((JSNumberLiteralTypeImpl)this.myType).getValueAsString();
        }
        if (this.myType instanceof JSBigIntLiteralTypeImpl) {
            return ((JSBigIntLiteralTypeImpl)this.myType).getValueAsString();
        }
        return null;
    }

    @Override
    public boolean isLiteral() {
        return this.myType instanceof JSLiteralType;
    }

    @Override
    public boolean isValid() {
        return this.myType != null;
    }

    @Override
    @Nullable
    public JSType getExpandedJSType(@Nullable PsiElement typeSource) {
        JSType type;
        JSType jSType = type = typeSource == null ? this.myType : JSTypeBaseImpl.replaceSourceRecursive(this.myType, JSTypeSourceFactory.createTypeSource(typeSource, true));
        if (type instanceof JSTypeofTypeImpl) {
            return JSNamedTypeFactory.createNumberPrimitiveType(JSTypeSourceFactory.createTypeSource(typeSource, true));
        }
        return type;
    }

    @Override
    @Nullable
    public String getDescription() {
        String stringValue = this.getStringValue();
        if (stringValue != null) {
            return stringValue;
        }
        Double doubleValue = this.getNumericValue();
        if (doubleValue != null) {
            return new DecimalFormat("#.######").format(doubleValue);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/EnumTypeConstValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/EnumTypeConstValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "increaseNumericDelta";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

