/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ui;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class NodeModuleNamesUtil {
    public static final String MODULES = "node_modules";
    private static final int MODULES_LENGTH = "node_modules".length();
    public static final String PACKAGE_JSON = "package.json";

    @NotNull
    public static String getModule(String file) {
        return NodeModuleNamesUtil.getModuleDirOrName(file, true);
    }

    @NotNull
    public static String getModulePackageFile(String file) {
        String moduleDir = NodeModuleNamesUtil.getModuleDirOrName(file, false);
        if (StringUtil.isEmpty((String)moduleDir)) {
            return "";
        }
        String string = String.format("%s%s%s", moduleDir, File.separator, PACKAGE_JSON);
        if (string == null) {
            NodeModuleNamesUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private static String getModuleDirOrName(String file, boolean getName) {
        if (StringUtil.isEmpty((String)file)) {
            return "";
        }
        int nodeModulesIndex = file.lastIndexOf(MODULES);
        if (nodeModulesIndex < 0) {
            return "";
        }
        int nodeModulesEndIndex = nodeModulesIndex + MODULES_LENGTH + 1;
        int nextFileSeparatorIndex = file.indexOf(File.separator, nodeModulesEndIndex);
        if (nextFileSeparatorIndex < 0) {
            return "";
        }
        String string = file.substring(getName ? nodeModulesEndIndex : 0, nextFileSeparatorIndex);
        if (string == null) {
            NodeModuleNamesUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/ui/NodeModuleNamesUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulePackageFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDirOrName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

