/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.Dbms;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelReader;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.psi.ModelNameIndex;
import com.intellij.database.types.DasType;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicModel
extends DasModel {
    @NotNull
    public BasicMetaModel<?> getMetaModel();

    @NotNull
    default public Dbms getDbms() {
        Dbms dbms = this.getRoot().getDbms();
        if (dbms == null) {
            BasicModel.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @NotNull
    public BasicRoot getRoot();

    @NotNull
    public ModelNameIndex getNameIndex();

    @NotNull
    public BasicResolveAssistant getResolveAssistant();

    @NotNull
    public DasType getCacheableDasType(@NotNull DasObject var1, @NotNull Supplier<? extends DasType> var2);

    default public <V> V read(@NotNull ModelReader<? super BasicModel, V> reader) {
        if (reader == null) {
            BasicModel.$$$reportNull$$$0(1);
        }
        return reader.perform(this);
    }

    default public boolean contains(@Nullable DasObject e) {
        return e instanceof BasicNode && ((BasicNode)e).getModel() == this;
    }

    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getModelRoots() {
        JBIterable<? extends BasicElement> jBIterable = this.getRoot().getDasChildren(null);
        if (jBIterable == null) {
            BasicModel.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @Nullable
    default public DasNamespace getCurrentRootNamespace() {
        Iterable namespaces = this.getRoot().getNamespaces();
        for (BasicMateNamespace namespace : namespaces) {
            if (!namespace.isCurrent()) continue;
            return namespace;
        }
        return null;
    }

    @NotNull
    default public JBTreeTraverser<DasObject> traverser() {
        JBTreeTraverser<BasicElement> jBTreeTraverser = this.basicTraverser();
        if (jBTreeTraverser == null) {
            BasicModel.$$$reportNull$$$0(3);
        }
        return jBTreeTraverser;
    }

    @NotNull
    default public JBTreeTraverser<BasicElement> basicTraverser() {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)JBTreeTraverser.from(BasicMixinElement::getChildren).withRoots(this.getRoot().getChildren());
        if (jBTreeTraverser == null) {
            BasicModel.$$$reportNull$$$0(4);
        }
        return jBTreeTraverser;
    }

    @NotNull
    default public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        DasObject tmp;
        if (kind == null) {
            BasicModel.$$$reportNull$$$0(5);
        }
        if (!((tmp = (DasObject)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(context), DasObject.class)) instanceof PsiElement)) {
            while (tmp != null) {
                if (tmp instanceof CasingProvider) {
                    Casing casing = ((CasingProvider)tmp).getCasing(kind, tmp);
                    if (casing == null) {
                        BasicModel.$$$reportNull$$$0(6);
                    }
                    return casing;
                }
                tmp = tmp.getDasParent();
            }
        }
        Casing casing = this.getRoot().getCasing(kind, context);
        if (casing == null) {
            BasicModel.$$$reportNull$$$0(7);
        }
        return casing;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/basic/BasicModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/basic/BasicModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "traverser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "basicTraverser";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 5 -> new IllegalArgumentException(string);
        };
    }
}

