/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.thoughtworks.xstream.core.util.FastStack;
import com.thoughtworks.xstream.io.xml.JDomReader;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;

public class InternedJDomReader
extends JDomReader {
    private final FastStack myParents = new FastStack(16);
    private final FastStack myChildren = new FastStack(16);

    public InternedJDomReader(Element root) {
        super(root);
        this.myChildren.push(null);
    }

    protected Object getParent() {
        return this.myParents.peek();
    }

    public void moveUp() {
        super.moveUp();
        Object p = this.myParents.pop();
        this.myChildren.pop();
        if (p != this.getCurrent()) {
            throw new IllegalStateException("Stack mismatch");
        }
    }

    public void moveDown() {
        this.myParents.push(this.getCurrent());
        super.moveDown();
        this.myChildren.push(null);
    }

    protected List<Element> getChildren() {
        if (this.myChildren.size() == 0) {
            return Collections.emptyList();
        }
        List res = (List)this.myChildren.peek();
        if (res != null) {
            return res;
        }
        res = ((Element)this.getCurrent()).getChildren();
        this.myChildren.replaceSilently((Object)res);
        return res;
    }

    protected Object getChild(int index) {
        return this.getChildren().get(index);
    }

    protected int getChildCount() {
        return this.getChildren().size();
    }
}

