/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.go;

import com.goide.psi.GoCallExpr;
import com.goide.psi.GoStringLiteral;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import ru.adelf.idea.dotenv.go.GoPsiHelper;
import ru.adelf.idea.dotenv.models.KeyUsagePsiElement;

class GoEnvironmentCallsVisitor
extends PsiRecursiveElementWalkingVisitor {
    private final Collection<KeyUsagePsiElement> collectedItems = new HashSet<KeyUsagePsiElement>();

    GoEnvironmentCallsVisitor() {
    }

    public void visitElement(PsiElement element) {
        if (element instanceof GoCallExpr) {
            this.visitCall((GoCallExpr)element);
        }
        super.visitElement(element);
    }

    private void visitCall(GoCallExpr expression) {
        GoStringLiteral stringLiteral = GoPsiHelper.getEnvironmentGoLiteral(expression);
        if (stringLiteral != null) {
            this.collectedItems.add(new KeyUsagePsiElement(stringLiteral.getDecodedText(), (PsiElement)stringLiteral));
        }
    }

    @NotNull
    Collection<KeyUsagePsiElement> getCollectedItems() {
        Collection<KeyUsagePsiElement> collection = this.collectedItems;
        if (collection == null) {
            GoEnvironmentCallsVisitor.$$$reportNull$$$0(0);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ru/adelf/idea/dotenv/go/GoEnvironmentCallsVisitor", "getCollectedItems"));
    }
}

