/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.CssRelatedToHtmlFilesContributor;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class CssGotoRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context) {
        PsiFile file;
        if (context == null) {
            CssGotoRelatedProvider.$$$reportNull$$$0(0);
        }
        if ((file = context.getContainingFile()) == null || !CssGotoRelatedProvider.isAvailable(file)) {
            List list = Collections.emptyList();
            if (list == null) {
                CssGotoRelatedProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        HashSet<PsiFile> resultSet = new HashSet<PsiFile>();
        CssGotoRelatedProvider.fillRelatedFiles(file, resultSet);
        ArrayList<GotoRelatedItem> items = new ArrayList<GotoRelatedItem>(resultSet.size());
        for (PsiFile relatedFile : resultSet) {
            @NlsSafe String group = "HTML";
            items.add(new GotoRelatedItem((PsiElement)relatedFile, group));
        }
        ArrayList<GotoRelatedItem> arrayList = items;
        if (arrayList == null) {
            CssGotoRelatedProvider.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void fillRelatedFiles(@NotNull PsiFile file, @NotNull Set<PsiFile> resultSet) {
        StylesheetFile stylesheetFile;
        CssStylesheet stylesheet;
        if (file == null) {
            CssGotoRelatedProvider.$$$reportNull$$$0(3);
        }
        if (resultSet == null) {
            CssGotoRelatedProvider.$$$reportNull$$$0(4);
        }
        if ((stylesheet = (stylesheetFile = (StylesheetFile)file).getStylesheet()) != null) {
            CssRelatedToHtmlFilesContributor.processImports(stylesheet, resultSet);
        }
    }

    private static boolean isAvailable(@NotNull PsiFile file) {
        if (file == null) {
            CssGotoRelatedProvider.$$$reportNull$$$0(5);
        }
        return file instanceof StylesheetFile && InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/navigation/CssGotoRelatedProvider";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/navigation/CssGotoRelatedProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fillRelatedFiles";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

