/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentialException;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.VagrantNotStartedException;
import com.intellij.remote.VagrantSupport;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VagrantCredentialsUtil {
    private VagrantCredentialsUtil() {
    }

    @NotNull
    public static RemoteCredentials getAndCheckVagrantRemoteCredentials(@NotNull VagrantBasedCredentialsHolder cred, boolean allowSynchronousInteraction) {
        RemoteCredentials remoteCredentials;
        if (cred == null) {
            VagrantCredentialsUtil.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmpty((String)cred.getVagrantFolder())) {
            throw new IllegalStateException("Vagrant instance folder is not specified");
        }
        try {
            RemoteCredentials credentials = VagrantCredentialsUtil.getVagrantRemoteCredentials(cred);
            if (credentials == null) {
                throw new RemoteCredentialException("Cant obtain ssh credentials for Vagrant at " + cred.getVagrantFolder());
            }
            if (!RemoteSdkUtil.testConnection(null, credentials) && !VagrantCredentialsUtil.checkVagrantStatus(cred.getVagrantFolder(), cred.getMachineName(), allowSynchronousInteraction)) {
                throw new VagrantNotStartedException("Vagrant VM" + (String)(cred.getMachineName() != null ? " '" + cred.getMachineName() + "'" : "") + " at " + cred.getVagrantFolder() + " is not launched", cred.getVagrantFolder(), cred.getMachineName());
            }
            remoteCredentials = credentials;
        }
        catch (IOException e) {
            throw new VagrantNotStartedException(e.getMessage(), cred.getVagrantFolder(), cred.getMachineName());
        }
        if (remoteCredentials == null) {
            VagrantCredentialsUtil.$$$reportNull$$$0(1);
        }
        return remoteCredentials;
    }

    @Nullable
    private static RemoteCredentials getVagrantRemoteCredentials(@NotNull VagrantBasedCredentialsHolder data) throws IOException {
        VagrantSupport vs;
        if (data == null) {
            VagrantCredentialsUtil.$$$reportNull$$$0(2);
        }
        if ((vs = VagrantSupport.getInstance()) != null) {
            return vs.getCredentials(data.getVagrantFolder(), data.getMachineName());
        }
        VagrantSupport.showMissingVagrantSupportMessage(null);
        return null;
    }

    private static boolean checkVagrantStatus(@NotNull String vagrantFolder, @Nullable String machineName, boolean askToRunIfDown) {
        VagrantSupport vs;
        if (vagrantFolder == null) {
            VagrantCredentialsUtil.$$$reportNull$$$0(3);
        }
        if ((vs = VagrantSupport.getInstance()) != null) {
            return vs.checkVagrantRunning(vagrantFolder, machineName, askToRunIfDown);
        }
        throw new IllegalStateException("Vagrant Support unavailable");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cred";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/VagrantCredentialsUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vagrantFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/VagrantCredentialsUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndCheckVagrantRemoteCredentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAndCheckVagrantRemoteCredentials";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVagrantRemoteCredentials";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkVagrantStatus";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

