/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.concurrencyVisualizer.tool.panels;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.python.concurrencyVisualizer.PyConcurrencyServiceImpl;
import com.intellij.python.concurrencyVisualizer.PythonConcurrencyVisualizerBundle;
import com.intellij.python.concurrencyVisualizer.model.ConcurrencyGraphModel;
import com.intellij.python.concurrencyVisualizer.tool.panels.ConcurrencyToolWindowPanel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.python.debugger.PyConcurrencyService;
import java.awt.Component;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.NotNull;

public class ConcurrencyTab
extends SimpleToolWindowPanel
implements Disposable {
    @NotNull
    private final ConcurrencyGraphModel myThreadingGraphModel;
    @NotNull
    private final Project myProject;
    @NotNull
    private final XDebugSession mySession;
    private final JTabbedPane myTabbedPane;
    private static final int THREADING_INDEX = 0;
    private static final int ASYNCIO_INDEX = 1;

    public ConcurrencyTab(@NotNull Project project, @NotNull XDebugSession session) {
        if (project == null) {
            ConcurrencyTab.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ConcurrencyTab.$$$reportNull$$$0(1);
        }
        super(false);
        this.myProject = project;
        this.mySession = session;
        this.myTabbedPane = new JBTabbedPane(1);
        this.myTabbedPane.setTabLayoutPolicy(0);
        this.myThreadingGraphModel = ((PyConcurrencyServiceImpl)PyConcurrencyService.getInstance((Project)this.myProject)).getThreadingInstance(session);
        ConcurrencyToolWindowPanel threadingPanel = new ConcurrencyToolWindowPanel(this.myProject, this.myThreadingGraphModel, "Threading");
        this.myTabbedPane.insertTab(PythonConcurrencyVisualizerBundle.message("threading.graph", new Object[0]), null, (Component)((Object)threadingPanel), "", 0);
        Disposer.register((Disposable)this, (Disposable)threadingPanel);
        ConcurrencyGraphModel asyncioGraphModel = ((PyConcurrencyServiceImpl)PyConcurrencyService.getInstance((Project)this.myProject)).getAsyncioInstance(session);
        ConcurrencyToolWindowPanel asyncioPanel = new ConcurrencyToolWindowPanel(this.myProject, asyncioGraphModel, "Asyncio");
        this.myTabbedPane.insertTab(PythonConcurrencyVisualizerBundle.message("asyncio.graph", new Object[0]), null, (Component)((Object)asyncioPanel), "", 1);
        Disposer.register((Disposable)this, (Disposable)asyncioPanel);
        this.add(this.myTabbedPane);
    }

    @NotNull
    public ConcurrencyGraphModel getThreadingGraphModel() {
        ConcurrencyGraphModel concurrencyGraphModel = this.myThreadingGraphModel;
        if (concurrencyGraphModel == null) {
            ConcurrencyTab.$$$reportNull$$$0(2);
        }
        return concurrencyGraphModel;
    }

    public void dispose() {
        PyConcurrencyService.getInstance((Project)this.myProject).removeSession(this.mySession);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/concurrencyVisualizer/tool/panels/ConcurrencyTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/concurrencyVisualizer/tool/panels/ConcurrencyTab";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadingGraphModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

