/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.docker.watcher;

import com.intellij.codeWithMe.ClientId;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.util.DockerComposeUtilsKt;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.python.docker.watcher.PyDockerComposeInterpreterInfo;
import com.intellij.python.docker.watcher.PyDockerInterpreterInfo;
import com.intellij.python.docker.watcher.PyInterpreterInfo;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.util.ConcurrencyUtil;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0004\u0012\u0013\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u0015\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\b\u0010\u0011\u001a\u00020\tH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/python/docker/watcher/PyDockerInterpretersUpdater;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "tasks", "", "", "Lcom/intellij/python/docker/watcher/PyDockerInterpretersUpdater$DockerAccountRecurrentCheckTask;", "registerInterpreter", "", "interpreterInfo", "Lcom/intellij/python/docker/watcher/PyInterpreterInfo;", "registerInterpreter$intellij_python_docker", "unregisterForModule", "module", "Lcom/intellij/openapi/module/Module;", "unregisterForModule$intellij_python_docker", "dispose", "DockerAccountRecurrentCheckTask", "ImageSearchResult", "CachedDockerRuntime", "Companion", "intellij.python.docker"})
@SourceDebugExtension(value={"SMAP\nPyDockerInterpretersUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDockerInterpretersUpdater.kt\ncom/intellij/python/docker/watcher/PyDockerInterpretersUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,262:1\n1869#2,2:263\n216#3,2:265\n13#4:267\n*S KotlinDebug\n*F\n+ 1 PyDockerInterpretersUpdater.kt\ncom/intellij/python/docker/watcher/PyDockerInterpretersUpdater\n*L\n42#1:263,2\n48#1:265,2\n207#1:267\n*E\n"})
public final class PyDockerInterpretersUpdater
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, DockerAccountRecurrentCheckTask> tasks = new LinkedHashMap();
    @NotNull
    private static final String THREAD_NAME = "Docker Account Recurrent Check Thread";
    private static final long DELAY_IN_SECONDS = 5L;
    @NotNull
    private static final String DEFAULT_DOCKER_COMPOSE_PROJECT_NAME = "default";
    @NotNull
    private static final String DOCKER_COMPOSE_PROJECT_LABEL = "com.docker.compose.project";
    @NotNull
    private static final String DOCKER_COMPOSE_SERVICE_LABEL = "com.docker.compose.service";
    @NotNull
    private static final String DOCKER_COMPOSE_ONE_OFF_LABEL = "com.docker.compose.oneoff";
    @NotNull
    private static final String FALSE_VALUE = "False";
    @NotNull
    private static final Logger LOG;

    public final void registerInterpreter$intellij_python_docker(@NotNull PyInterpreterInfo<?> interpreterInfo) {
        block0: {
            Intrinsics.checkNotNullParameter(interpreterInfo, (String)"interpreterInfo");
            String string = interpreterInfo.getDockerAccountName();
            if (string == null) break block0;
            String dockerAccountName = string;
            boolean bl = false;
            this.tasks.computeIfAbsent(dockerAccountName, arg_0 -> PyDockerInterpretersUpdater.registerInterpreter$lambda$0$1(arg_0 -> PyDockerInterpretersUpdater.registerInterpreter$lambda$0$0(dockerAccountName, arg_0), arg_0)).register(interpreterInfo);
        }
    }

    public final void unregisterForModule$intellij_python_docker(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Iterable $this$forEach$iv = this.tasks.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            DockerAccountRecurrentCheckTask task = (DockerAccountRecurrentCheckTask)entry.getValue();
            task.unregister(module);
        }
    }

    public void dispose() {
        Map<String, DockerAccountRecurrentCheckTask> $this$forEach$iv = this.tasks;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, DockerAccountRecurrentCheckTask>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DockerAccountRecurrentCheckTask> element$iv;
            Map.Entry<String, DockerAccountRecurrentCheckTask> entry = element$iv = iterator.next();
            boolean bl = false;
            DockerAccountRecurrentCheckTask task = entry.getValue();
            task.shutdown();
        }
    }

    private static final DockerAccountRecurrentCheckTask registerInterpreter$lambda$0$0(String $dockerAccountName, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new DockerAccountRecurrentCheckTask($dockerAccountName);
    }

    private static final DockerAccountRecurrentCheckTask registerInterpreter$lambda$0$1(Function1 $tmp0, Object p0) {
        return (DockerAccountRecurrentCheckTask)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final PyDockerInterpretersUpdater getInstance() {
        return Companion.getInstance();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PyDockerInterpretersUpdater.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/python/docker/watcher/PyDockerInterpretersUpdater$CachedDockerRuntime;", "", "dockerRuntime", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "<init>", "(Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;)V", "lock", "cachedImages", "", "Lcom/intellij/docker/agent/DockerAgentImage;", "cachedContainers", "Lcom/intellij/docker/agent/DockerAgentContainer;", "findImageByName", "imageName", "", "getContainers", "labels", "", "intellij.python.docker"})
    @SourceDebugExtension(value={"SMAP\nPyDockerInterpretersUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDockerInterpretersUpdater.kt\ncom/intellij/python/docker/watcher/PyDockerInterpretersUpdater$CachedDockerRuntime\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,262:1\n1#2:263\n774#3:264\n865#3:265\n1740#3,3:266\n866#3:269\n*S KotlinDebug\n*F\n+ 1 PyDockerInterpretersUpdater.kt\ncom/intellij/python/docker/watcher/PyDockerInterpretersUpdater$CachedDockerRuntime\n*L\n190#1:264\n190#1:265\n190#1:266,3\n190#1:269\n*E\n"})
    private static final class CachedDockerRuntime {
        @NotNull
        private final RemoteDockerRuntime dockerRuntime;
        @NotNull
        private final Object lock;
        @Nullable
        private List<? extends DockerAgentImage> cachedImages;
        @Nullable
        private List<? extends DockerAgentContainer> cachedContainers;

        public CachedDockerRuntime(@NotNull RemoteDockerRuntime dockerRuntime) {
            Intrinsics.checkNotNullParameter((Object)dockerRuntime, (String)"dockerRuntime");
            this.dockerRuntime = dockerRuntime;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final DockerAgentImage findImageByName(@NotNull String imageName) {
            List list;
            block5: {
                Object object;
                List it;
                List list2;
                Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl = false;
                    List list3 = this.cachedImages;
                    if (list3 == null) {
                        it = list2 = ArraysKt.toList((Object[])this.dockerRuntime.getImages());
                        boolean bl2 = false;
                        this.cachedImages = it;
                        list3 = list2;
                    }
                    object = list3;
                }
                List images = object;
                object2 = images;
                object = object2.iterator();
                while (object.hasNext()) {
                    list2 = object.next();
                    it = (DockerAgentImage)list2;
                    boolean bl = false;
                    if (!ArraysKt.contains((Object[])it.getImageRepoTags(), (Object)imageName)) continue;
                    list = list2;
                    break block5;
                }
                list = null;
            }
            return (DockerAgentImage)list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final List<DockerAgentContainer> getContainers(@NotNull Map<String, String> labels) {
            void $this$filterTo$iv$iv;
            Iterable $i$a$-synchronized-PyDockerInterpretersUpdater$CachedDockerRuntime$getContainers$containers$22;
            Intrinsics.checkNotNullParameter(labels, (String)"labels");
            Object object = this.lock;
            synchronized (object) {
                boolean $i$a$-synchronized-PyDockerInterpretersUpdater$CachedDockerRuntime$getContainers$containers$22 = false;
                List list = this.cachedContainers;
                if (list == null) {
                    List list2;
                    List it = list2 = ArraysKt.toList((Object[])this.dockerRuntime.getContainers());
                    boolean bl = false;
                    this.cachedContainers = it;
                    list = list2;
                }
                $i$a$-synchronized-PyDockerInterpretersUpdater$CachedDockerRuntime$getContainers$containers$22 = list;
            }
            List containers = $i$a$-synchronized-PyDockerInterpretersUpdater$CachedDockerRuntime$getContainers$containers$22;
            Iterable $this$filter$iv = containers;
            boolean $i$f$filter = false;
            $i$a$-synchronized-PyDockerInterpretersUpdater$CachedDockerRuntime$getContainers$containers$22 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block8: {
                    DockerAgentContainer container = (DockerAgentContainer)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$all$iv = labels.entrySet();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            Map.Entry entry = (Map.Entry)element$iv;
                            boolean bl3 = false;
                            String key = (String)entry.getKey();
                            String value2 = (String)entry.getValue();
                            if (Intrinsics.areEqual(container.getContainerLabels().get(key), (Object)value2)) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001bH\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\n\u0010!\u001a\u00060\"j\u0002`#H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/python/docker/watcher/PyDockerInterpretersUpdater$Companion;", "", "<init>", "()V", "THREAD_NAME", "", "DELAY_IN_SECONDS", "", "DEFAULT_DOCKER_COMPOSE_PROJECT_NAME", "DOCKER_COMPOSE_PROJECT_LABEL", "DOCKER_COMPOSE_SERVICE_LABEL", "DOCKER_COMPOSE_ONE_OFF_LABEL", "FALSE_VALUE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/python/docker/watcher/PyDockerInterpretersUpdater;", "findDockerServer", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "accountName", "findImageIdForInterpreter", "cachedDockerRuntime", "Lcom/intellij/python/docker/watcher/PyDockerInterpretersUpdater$CachedDockerRuntime;", "info", "Lcom/intellij/python/docker/watcher/PyInterpreterInfo;", "findImageIdForDockerInterpreter", "Lcom/intellij/python/docker/watcher/PyDockerInterpreterInfo;", "findImageIdForComposeInterpreter", "Lcom/intellij/python/docker/watcher/PyDockerComposeInterpreterInfo;", "logException", "", "message", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "intellij.python.docker"})
    @SourceDebugExtension(value={"SMAP\nPyDockerInterpretersUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDockerInterpretersUpdater.kt\ncom/intellij/python/docker/watcher/PyDockerInterpretersUpdater$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,262:1\n42#2,3:263\n60#3,5:266\n60#3,5:271\n60#3,5:280\n60#3,5:285\n60#3,5:290\n1563#4:276\n1634#4,3:277\n*S KotlinDebug\n*F\n+ 1 PyDockerInterpretersUpdater.kt\ncom/intellij/python/docker/watcher/PyDockerInterpretersUpdater$Companion\n*L\n210#1:263,3\n225#1:266,5\n230#1:271,5\n247#1:280,5\n251#1:285,5\n254#1:290,5\n237#1:276\n237#1:277,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PyDockerInterpretersUpdater getInstance() {
            boolean $i$f$service = false;
            Class<PyDockerInterpretersUpdater> serviceClass$iv = PyDockerInterpretersUpdater.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (PyDockerInterpretersUpdater)object;
        }

        private final RemoteServer<DockerCloudConfiguration> findDockerServer(String accountName) {
            return RemoteServersManager.getInstance().findByName(accountName, (ServerType)DockerCloudType.getInstance());
        }

        private final String findImageIdForInterpreter(CachedDockerRuntime cachedDockerRuntime, PyInterpreterInfo<?> info) {
            String string;
            PyInterpreterInfo<?> pyInterpreterInfo = info;
            if (pyInterpreterInfo instanceof PyDockerInterpreterInfo) {
                string = this.findImageIdForDockerInterpreter(cachedDockerRuntime, (PyDockerInterpreterInfo)info);
            } else if (pyInterpreterInfo instanceof PyDockerComposeInterpreterInfo) {
                string = this.findImageIdForComposeInterpreter((PyDockerComposeInterpreterInfo)info, cachedDockerRuntime);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        private final String findImageIdForDockerInterpreter(CachedDockerRuntime cachedDockerRuntime, PyDockerInterpreterInfo info) {
            String string;
            String string2 = info.getCredentials().getImageName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getImageName(...)");
            String imageName = string2;
            DockerAgentImage image = cachedDockerRuntime.findImageByName(imageName);
            if (image == null) {
                Logger $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Cannot find image by name '" + imageName + "'", e$iv);
                }
                string = null;
            } else {
                String imageId = image.getImageId();
                Logger $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Image found by its name: '" + imageName + "', image id: '" + imageId + "'", e$iv);
                }
                string = imageId;
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final String findImageIdForComposeInterpreter(PyDockerComposeInterpreterInfo info, CachedDockerRuntime cachedDockerRuntime) {
            String string;
            Logger logger;
            void $this$mapTo$iv$iv;
            List list = info.getCredentials().getComposeFilePaths();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getComposeFilePaths(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Logger destination$iv$iv = (Logger)new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                logger = destination$iv$iv;
                boolean bl = false;
                logger.add(Paths.get((String)it, new String[0]));
            }
            List composeFilePaths = (List)destination$iv$iv;
            String string3 = DockerComposeUtilsKt.getEffectiveDockerComposeProjectName(null, (List)composeFilePaths, (Map)info.getCredentials().getEnvs().getEnvs());
            if (string3 == null) {
                string3 = PyDockerInterpretersUpdater.DEFAULT_DOCKER_COMPOSE_PROJECT_NAME;
            }
            String projectName = string3;
            String serviceName = info.getCredentials().getComposeServiceName();
            destination$iv$iv = new Logger[]{TuplesKt.to((Object)PyDockerInterpretersUpdater.DOCKER_COMPOSE_PROJECT_LABEL, (Object)projectName), TuplesKt.to((Object)PyDockerInterpretersUpdater.DOCKER_COMPOSE_SERVICE_LABEL, (Object)serviceName), TuplesKt.to((Object)PyDockerInterpretersUpdater.DOCKER_COMPOSE_ONE_OFF_LABEL, (Object)PyDockerInterpretersUpdater.FALSE_VALUE)};
            List<DockerAgentContainer> containers = cachedDockerRuntime.getContainers(MapsKt.mapOf((Pair[])destination$iv$iv));
            if (containers.isEmpty()) {
                $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Cannot find container for Compose service '" + serviceName + "'", e$iv);
                }
                string = null;
            } else {
                if (containers.size() > 1) {
                    $this$debug_u24default$iv = LOG;
                    Throwable e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        logger = $this$debug_u24default$iv;
                        boolean bl = false;
                        logger.debug("Several containers found for Compose service '" + serviceName + "'", e$iv);
                    }
                }
                DockerAgentContainer container = containers.get(0);
                String imageId = container.getImageId();
                Logger $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Container '" + container.getContainerName() + "' found for Compose service '" + serviceName + "', image id: '" + imageId + "'", e$iv);
                }
                string = imageId;
            }
            return string;
        }

        private final void logException(String message, Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(message, (Throwable)e);
            } else {
                LOG.info(message + ": " + e.getLocalizedMessage());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0010J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0015H\u0016J$\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u0006\u0010\u001f\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/python/docker/watcher/PyDockerInterpretersUpdater$DockerAccountRecurrentCheckTask;", "Ljava/lang/Runnable;", "dockerAccountName", "", "<init>", "(Ljava/lang/String;)V", "getDockerAccountName", "()Ljava/lang/String;", "lock", "", "isScheduled", "", "service", "Ljava/util/concurrent/ScheduledExecutorService;", "infos", "", "Lcom/intellij/python/docker/watcher/PyInterpreterInfo;", "interpreterToLastImageSearchResult", "", "Lcom/intellij/python/docker/watcher/PyDockerInterpretersUpdater$ImageSearchResult;", "register", "", "interpreterInfo", "unregister", "module", "Lcom/intellij/openapi/module/Module;", "run", "updatePythonSdk", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "info", "shutdown", "intellij.python.docker"})
    @SourceDebugExtension(value={"SMAP\nPyDockerInterpretersUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDockerInterpretersUpdater.kt\ncom/intellij/python/docker/watcher/PyDockerInterpretersUpdater$DockerAccountRecurrentCheckTask\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,262:1\n60#2,5:263\n60#2,5:268\n60#2,5:273\n60#2,5:278\n60#2,5:288\n60#2,5:293\n774#3:283\n865#3,2:284\n1869#3,2:286\n*S KotlinDebug\n*F\n+ 1 PyDockerInterpretersUpdater.kt\ncom/intellij/python/docker/watcher/PyDockerInterpretersUpdater$DockerAccountRecurrentCheckTask\n*L\n76#1:263,5\n94#1:268,5\n102#1:273,5\n106#1:278,5\n143#1:288,5\n147#1:293,5\n112#1:283\n112#1:284,2\n128#1:286,2\n*E\n"})
    private static final class DockerAccountRecurrentCheckTask
    implements Runnable {
        @NotNull
        private final String dockerAccountName;
        @NotNull
        private final Object lock;
        private boolean isScheduled;
        @NotNull
        private final ScheduledExecutorService service;
        @NotNull
        private final List<PyInterpreterInfo<?>> infos;
        @NotNull
        private final Map<Object, ImageSearchResult> interpreterToLastImageSearchResult;

        public DockerAccountRecurrentCheckTask(@NotNull String dockerAccountName) {
            Intrinsics.checkNotNullParameter((Object)dockerAccountName, (String)"dockerAccountName");
            this.dockerAccountName = dockerAccountName;
            this.lock = new Object();
            ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, ConcurrencyUtil.newNamedThreadFactory((String)PyDockerInterpretersUpdater.THREAD_NAME));
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newScheduledThreadPool(...)");
            this.service = scheduledExecutorService;
            this.infos = new ArrayList();
            this.interpreterToLastImageSearchResult = new LinkedHashMap();
        }

        @NotNull
        public final String getDockerAccountName() {
            return this.dockerAccountName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void register(@NotNull PyInterpreterInfo<?> interpreterInfo) {
            Intrinsics.checkNotNullParameter(interpreterInfo, (String)"interpreterInfo");
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                this.infos.removeIf(arg_0 -> DockerAccountRecurrentCheckTask.register$lambda$0$1(arg_0 -> DockerAccountRecurrentCheckTask.register$lambda$0$0(interpreterInfo, arg_0), arg_0));
                this.infos.add(interpreterInfo);
                if (!this.isScheduled) {
                    Logger $this$debug_u24default$iv = LOG;
                    Throwable e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl2 = false;
                        logger.debug("Start watching images for updates within Docker account '" + this.dockerAccountName + "'", e$iv);
                    }
                    this.service.schedule(this, 5L, TimeUnit.SECONDS);
                    this.isScheduled = true;
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        public final void unregister(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this.infos.removeIf(arg_0 -> DockerAccountRecurrentCheckTask.unregister$lambda$1(arg_0 -> DockerAccountRecurrentCheckTask.unregister$lambda$0(module, arg_0), arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            List $i$a$-synchronized-PyDockerInterpretersUpdater$DockerAccountRecurrentCheckTask$run$infosCopy$2;
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                if (this.infos.isEmpty()) {
                    if (this.isScheduled) {
                        Logger $this$debug_u24default$iv = LOG;
                        Throwable e$iv = null;
                        boolean $i$f$debug = false;
                        if ($this$debug_u24default$iv.isDebugEnabled()) {
                            Logger logger = $this$debug_u24default$iv;
                            boolean bl2 = false;
                            logger.debug("No Docker interpreters to watch for updates within Docker account '" + this.dockerAccountName + "'", e$iv);
                        }
                    }
                    this.isScheduled = false;
                    return;
                }
                $i$a$-synchronized-PyDockerInterpretersUpdater$DockerAccountRecurrentCheckTask$run$infosCopy$2 = CollectionsKt.toList((Iterable)this.infos);
            }
            List infosCopy = $i$a$-synchronized-PyDockerInterpretersUpdater$DockerAccountRecurrentCheckTask$run$infosCopy$2;
            try {
                void $this$filterTo$iv$iv;
                Logger logger;
                Logger $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Checking " + CollectionsKt.joinToString$default((Iterable)infosCopy, null, null, null, (int)0, null, DockerAccountRecurrentCheckTask::run$lambda$1$0, (int)31, null) + " for updates (Docker account '" + this.dockerAccountName + "')", e$iv);
                }
                RemoteServer dockerServer = Companion.findDockerServer(this.dockerAccountName);
                if (dockerServer == null) {
                    Logger $this$debug_u24default$iv2 = LOG;
                    Throwable e$iv2 = null;
                    boolean $i$f$debug2 = false;
                    if ($this$debug_u24default$iv2.isDebugEnabled()) {
                        logger = $this$debug_u24default$iv2;
                        boolean bl = false;
                        logger.debug("Docker account '" + this.dockerAccountName + "' cannot be found", e$iv2);
                    }
                    return;
                }
                ServerConfiguration serverConfiguration = dockerServer.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)serverConfiguration, (String)"getConfiguration(...)");
                RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.Companion.create((DockerCloudConfiguration)serverConfiguration, null);
                CachedDockerRuntime cachedRuntime = new CachedDockerRuntime(dockerRuntime);
                Iterable $this$filter$iv = infosCopy;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    PyInterpreterInfo info = (PyInterpreterInfo)element$iv$iv;
                    boolean bl3 = false;
                    String currentImageId = Companion.findImageIdForInterpreter(cachedRuntime, info);
                    ImageSearchResult lastImageSearchResult = this.interpreterToLastImageSearchResult.get(info.getCredentials());
                    if (currentImageId == null) {
                        if (lastImageSearchResult == null) {
                            this.interpreterToLastImageSearchResult.put(info.getCredentials(), ImageSearchResult.ImageNotFound.INSTANCE);
                        }
                        bl = false;
                    } else {
                        ImageSearchResult.ImageFound currentImageSearchResult = new ImageSearchResult.ImageFound(currentImageId);
                        this.interpreterToLastImageSearchResult.put(info.getCredentials(), currentImageSearchResult);
                        bl = lastImageSearchResult != null && !Intrinsics.areEqual((Object)lastImageSearchResult, (Object)currentImageSearchResult);
                    }
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List infosToUpdate = (List)destination$iv$iv;
                Iterable $this$forEach$iv = infosToUpdate;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PyInterpreterInfo info = (PyInterpreterInfo)element$iv;
                    boolean bl = false;
                    this.updatePythonSdk(info.getModule(), info.getSdk(), info);
                }
            }
            catch (Exception e) {
                Companion.logException("Checking interpreters for updates (Docker account '" + this.dockerAccountName + "') failed", e);
            }
            finally {
                this.service.schedule(this, 5L, TimeUnit.SECONDS);
            }
        }

        private final void updatePythonSdk(Module module, Sdk sdk, PyInterpreterInfo<?> info) {
            if (module.isDisposed()) {
                Logger $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Skipping update of Python SDK '" + sdk.getName() + "' in module '" + module.getName() + "' because the module is disposed", e$iv);
                }
                return;
            }
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Triggering update of Python SDK '" + sdk.getName() + "' in module '" + module.getName() + "' for " + info.getCredentialsDetails(), e$iv);
            }
            PythonSdkUpdater.updateVersionAndPathsSynchronouslyAndScheduleRemaining((Sdk)sdk, (Project)module.getProject());
        }

        public final void shutdown() {
            this.service.shutdownNow();
        }

        private static final boolean register$lambda$0$0(PyInterpreterInfo $interpreterInfo, PyInterpreterInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return Intrinsics.areEqual((Object)info.getModule(), (Object)$interpreterInfo.getModule());
        }

        private static final boolean register$lambda$0$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean unregister$lambda$0(Module $module, PyInterpreterInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return Intrinsics.areEqual((Object)info.getModule(), (Object)$module);
        }

        private static final boolean unregister$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final CharSequence run$lambda$1$0(PyInterpreterInfo it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getCredentialsDetails();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/python/docker/watcher/PyDockerInterpretersUpdater$ImageSearchResult;", "", "<init>", "()V", "ImageNotFound", "ImageFound", "Lcom/intellij/python/docker/watcher/PyDockerInterpretersUpdater$ImageSearchResult$ImageFound;", "Lcom/intellij/python/docker/watcher/PyDockerInterpretersUpdater$ImageSearchResult$ImageNotFound;", "intellij.python.docker"})
    public static abstract sealed class ImageSearchResult {
        private ImageSearchResult() {
        }

        public /* synthetic */ ImageSearchResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/python/docker/watcher/PyDockerInterpretersUpdater$ImageSearchResult$ImageFound;", "Lcom/intellij/python/docker/watcher/PyDockerInterpretersUpdater$ImageSearchResult;", "imageId", "", "<init>", "(Ljava/lang/String;)V", "getImageId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.python.docker"})
        public static final class ImageFound
        extends ImageSearchResult {
            @NotNull
            private final String imageId;

            public ImageFound(@NotNull String imageId) {
                Intrinsics.checkNotNullParameter((Object)imageId, (String)"imageId");
                super(null);
                this.imageId = imageId;
            }

            @NotNull
            public final String getImageId() {
                return this.imageId;
            }

            @NotNull
            public final String component1() {
                return this.imageId;
            }

            @NotNull
            public final ImageFound copy(@NotNull String imageId) {
                Intrinsics.checkNotNullParameter((Object)imageId, (String)"imageId");
                return new ImageFound(imageId);
            }

            public static /* synthetic */ ImageFound copy$default(ImageFound imageFound, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = imageFound.imageId;
                }
                return imageFound.copy(string);
            }

            @NotNull
            public String toString() {
                return "ImageFound(imageId=" + this.imageId + ")";
            }

            public int hashCode() {
                return this.imageId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ImageFound)) {
                    return false;
                }
                ImageFound imageFound = (ImageFound)other;
                return Intrinsics.areEqual((Object)this.imageId, (Object)imageFound.imageId);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/python/docker/watcher/PyDockerInterpretersUpdater$ImageSearchResult$ImageNotFound;", "Lcom/intellij/python/docker/watcher/PyDockerInterpretersUpdater$ImageSearchResult;", "<init>", "()V", "intellij.python.docker"})
        public static final class ImageNotFound
        extends ImageSearchResult {
            @NotNull
            public static final ImageNotFound INSTANCE = new ImageNotFound();

            private ImageNotFound() {
                super(null);
            }
        }
    }
}

