/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.coverage;

import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManagerImpl;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageHelper;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.python.community.helpersLocator.PythonHelpersLocator;
import com.intellij.python.pro.coverage.PyCoverageEnabledConfiguration;
import com.intellij.python.pro.coverage.PyCoverageNotImportableException;
import com.intellij.python.pro.coverage.PyCoverageOptionsProvider;
import com.intellij.python.pro.coverage.PyCoverageRunner;
import com.intellij.python.pro.coverage.PyCoverageUtil;
import com.intellij.remote.ProcessControlWithMappings;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.remote.PyCredentialsContribution;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.remote.PythonRemoteInterpreterPluginNotAvailableException;
import com.jetbrains.python.remote.PythonSshInterpreterManager;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PathMappingsUtil;
import com.jetbrains.python.run.PythonRunConfigurationExtension;
import com.jetbrains.python.run.target.TargetProcessHandlers;
import com.jetbrains.python.sdk.CredentialsTypeExChecker;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonCoverageRunConfigurationExtension
extends PythonRunConfigurationExtension {
    private static final String ID = "PythonCoverageRunConfigurationExtension";
    public static final String RUN_COVERAGE = "PYCHARM_RUN_COVERAGE";
    private static final String BUNDLED_COVERAGE_PATH = "BUNDLED_COVERAGE_PATH";
    private static final String CREATE_TEMP_COVERAGE_FILE = "CREATE_TEMP_COVERAGE_FILE";

    @NotNull
    public String getSerializationId() {
        return ID;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void attachToProcess(@NotNull AbstractPythonRunConfiguration configuration, @NotNull ProcessHandler handler, RunnerSettings runnerSettings) {
        Sdk sdk;
        if (configuration == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(1);
        }
        SdkAdditionalData sdkAdditionalData = (sdk = configuration.getSdk()) != null ? sdk.getSdkAdditionalData() : null;
        TargetEnvironment targetEnvironment = TargetProcessHandlers.getTargetEnvironment((ProcessHandler)handler);
        if (targetEnvironment != null) {
            PythonCoverageRunConfigurationExtension.handleCoverageResults(configuration, handler, runnerSettings, targetEnvironment);
            return;
        }
        if (sdkAdditionalData instanceof PyRemoteSdkAdditionalData) {
            PyRemoteSdkAdditionalData remoteSdkAdditionalData = (PyRemoteSdkAdditionalData)sdkAdditionalData;
            if (!PythonCoverageRunConfigurationExtension.checkLanguageContribution(sdk, PyCredentialsContribution::isSpecificCoverageAttach)) {
                PythonCoverageRunConfigurationExtension.handleCoverageResults(configuration, handler, runnerSettings, remoteSdkAdditionalData);
                return;
            }
        }
        CoverageHelper.attachToProcess((RunConfigurationBase)configuration, (ProcessHandler)handler, (RunnerSettings)runnerSettings);
    }

    private static void handleCoverageResults(@NotNull AbstractPythonRunConfiguration<?> configuration, @NotNull ProcessHandler handler, @Nullable RunnerSettings runnerSettings, @NotNull TargetEnvironment targetEnvironment) {
        if (configuration == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(2);
        }
        if (handler == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(3);
        }
        if (targetEnvironment == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(4);
        }
        CoverageHelper.resetCoverageSuit(configuration);
        if (runnerSettings instanceof CoverageRunnerData) {
            PythonCoverageRunConfigurationExtension.addProcessTerminatedEventListener(handler, () -> {
                try {
                    PythonCoverageRunConfigurationExtension.setPythonCoveragePathMapper((PathMapper)PathMappingsUtil.collectAllPathMappings((TargetEnvironment)targetEnvironment));
                    PythonCoverageRunConfigurationExtension.runProcessWithProgressAsynchronously(configuration.getProject(), () -> {
                        try {
                            PythonCoverageRunConfigurationExtension.downloadAllVolumes(targetEnvironment);
                            CoverageDataManagerImpl.processGatheredCoverage((RunConfigurationBase)configuration);
                        }
                        catch (Exception e) {
                            PythonCoverageRunConfigurationExtension.showErrorDialogAndWait(e, CoverageBundle.message((String)"coverage.error.collecting.data", (Object[])new Object[0]));
                        }
                    });
                }
                catch (Exception e) {
                    PythonCoverageRunConfigurationExtension.showErrorDialogAndWait(e, CoverageBundle.message((String)"coverage.error.collecting.data", (Object[])new Object[0]));
                }
            });
        }
    }

    private static void downloadAllVolumes(@NotNull TargetEnvironment targetEnvironment) throws IOException {
        if (targetEnvironment == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(5);
        }
        for (TargetEnvironment.DownloadableVolume downloadableVolume : targetEnvironment.getDownloadVolumes().values()) {
            downloadableVolume.download(".", (ProgressIndicator)new EmptyProgressIndicator());
        }
    }

    @ApiStatus.Obsolete
    private static void handleCoverageResults(@NotNull AbstractPythonRunConfiguration<?> configuration, @NotNull ProcessHandler handler, @Nullable RunnerSettings runnerSettings, @NotNull PyRemoteSdkAdditionalData sdkAdditionalData) {
        PythonSshInterpreterManager manager;
        if (configuration == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(6);
        }
        if (handler == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(7);
        }
        if (sdkAdditionalData == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(8);
        }
        if ((manager = PythonSshInterpreterManager.Factory.getInstance()) != null) {
            CoverageHelper.resetCoverageSuit(configuration);
            if (runnerSettings instanceof CoverageRunnerData) {
                PythonCoverageRunConfigurationExtension.addProcessTerminatedEventListener(handler, () -> {
                    ProcessControlWithMappings remoteProcessHandler = (ProcessControlWithMappings)handler;
                    try {
                        RemoteCredentials credentials = sdkAdditionalData.getRemoteCredentials(null, false);
                        PythonCoverageRunConfigurationExtension.setPythonCoveragePathMapper(remoteProcessHandler.getMappingSettings());
                        Project project = configuration.getProject();
                        PythonCoverageRunConfigurationExtension.runProcessWithProgressAsynchronously(project, () -> {
                            try {
                                manager.copyFromRemote(project, credentials, (RemoteSdkProperties)sdkAdditionalData, remoteProcessHandler.getFileMappings());
                                CoverageDataManagerImpl.processGatheredCoverage((RunConfigurationBase)configuration);
                            }
                            catch (Exception e) {
                                PythonCoverageRunConfigurationExtension.showErrorDialogAndWait(e, CoverageBundle.message((String)"coverage.error.collecting.data", (Object[])new Object[0]));
                            }
                        });
                    }
                    catch (Exception e) {
                        PythonCoverageRunConfigurationExtension.showErrorDialogAndWait(e, CoverageBundle.message((String)"coverage.error.collecting.data", (Object[])new Object[0]));
                    }
                });
            }
        } else {
            throw new PythonRemoteInterpreterPluginNotAvailableException();
        }
    }

    private static boolean checkLanguageContribution(@Nullable Sdk sdk, final @NotNull Function<PyCredentialsContribution<?>, Boolean> predicate) {
        if (predicate == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(9);
        }
        return new CredentialsTypeExChecker(){

            protected boolean checkLanguageContribution(PyCredentialsContribution languageContribution) {
                return (Boolean)predicate.apply(languageContribution);
            }
        }.check(sdk);
    }

    private static void setPythonCoveragePathMapper(@NotNull PathMapper pathMapper) {
        PyCoverageRunner pyCoverageRunner;
        if (pathMapper == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(10);
        }
        if ((pyCoverageRunner = (PyCoverageRunner)CoverageRunner.getInstance(PyCoverageRunner.class)) != null) {
            pyCoverageRunner.setPathMapper(pathMapper);
        }
    }

    private static void addProcessTerminatedEventListener(@NotNull ProcessHandler processHandler, final @NotNull Runnable runnable) {
        if (processHandler == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(11);
        }
        if (runnable == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(12);
        }
        processHandler.addProcessListener(new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                runnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/python/pro/coverage/PythonCoverageRunConfigurationExtension$2", "processTerminated"));
            }
        });
    }

    private static void runProcessWithProgressAsynchronously(final @NotNull Project project, final @NotNull Runnable runnable) {
        if (project == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(13);
        }
        if (runnable == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(14);
        }
        Task.Backgroundable task = new Task.Backgroundable(project, CoverageBundle.message((String)"coverage.collecting.data", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (project.isDisposed()) {
                    return;
                }
                runnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/python/pro/coverage/PythonCoverageRunConfigurationExtension$3", "run"));
            }
        };
        ApplicationManager.getApplication().invokeAndWait(() -> {
            BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator(task);
            indicator.setIndeterminate(false);
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)indicator);
        });
    }

    private static void showErrorDialogAndWait(@NotNull Exception e, @NlsContexts.DialogTitle @NotNull String title) {
        if (e == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(15);
        }
        if (title == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(16);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> Messages.showErrorDialog((String)e.getMessage(), (String)title));
    }

    protected void readExternal(@NotNull AbstractPythonRunConfiguration runConfiguration, @NotNull Element element) throws InvalidDataException {
        if (runConfiguration == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(17);
        }
        if (element == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(18);
        }
        CoverageHelper.doReadExternal((RunConfigurationBase)runConfiguration, (Element)element);
    }

    protected void writeExternal(@NotNull AbstractPythonRunConfiguration runConfiguration, @NotNull Element element) {
        if (runConfiguration == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(19);
        }
        if (element == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(20);
        }
        CoverageHelper.doWriteExternal((RunConfigurationBase)runConfiguration, (Element)element);
    }

    protected String getEditorTitle() {
        return CoverageEngine.getEditorTitle();
    }

    public boolean isApplicableFor(@NotNull AbstractPythonRunConfiguration configuration) {
        if (configuration == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(21);
        }
        return configuration.canRunWithCoverage();
    }

    public boolean isEnabledFor(@NotNull AbstractPythonRunConfiguration applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(22);
        }
        return runnerSettings == null || runnerSettings instanceof CoverageRunnerData;
    }

    protected void patchCommandLine(@NotNull AbstractPythonRunConfiguration configuration, RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) throws ExecutionException {
        if (configuration == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(23);
        }
        if (cmdLine == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(24);
        }
        if (runnerId == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(25);
        }
        if (!(runnerSettings instanceof CoverageRunnerData)) {
            return;
        }
        PyCoverageEnabledConfiguration covEnabledConfig = PyCoverageEnabledConfiguration.getFrom((ModuleBasedConfiguration)configuration);
        assert (covEnabledConfig != null);
        if ("PythonCover".equals(runnerId)) {
            PyCoverageUtil.addCoverageFileEnv(cmdLine, covEnabledConfig.getCoverageFilePath());
            PyCoverageUtil.addRunCoverageEnv(cmdLine);
            if (PythonCoverageRunConfigurationExtension.useBundledCoverage(configuration)) {
                PyCoverageUtil.addBundledCoverageToPythonPath(configuration.getSdk(), cmdLine.getEnvironment());
            } else {
                cmdLine.getEnvironment().put(BUNDLED_COVERAGE_PATH, PythonHelper.COVERAGEPY_NEW.getPythonPathEntry());
                if (!PyCoverageUtil.isCoverageAvailable(configuration.getModule(), configuration.getInterpreterPath())) {
                    throw new PyCoverageNotImportableException(configuration.getProject(), configuration.getSdk());
                }
            }
            PyDebugRunner.disableBuiltinBreakpoint((Sdk)configuration.getSdk(), (Map)cmdLine.getEnvironment());
            ParamsGroup group = PythonCoverageRunConfigurationExtension.getOrCreateCoverageParamsGroup(cmdLine);
            PythonHelper.COVERAGE.addToGroup(group, cmdLine);
            group.addParameter("run");
            if (PyCoverageOptionsProvider.getInstance(configuration.getProject()).getBranchCoverage()) {
                group.addParameter("--branch");
            }
            group.addParameter("--omit=\"" + String.valueOf(PythonHelpersLocator.getCommunityHelpersRoot().toAbsolutePath()) + "*\"");
            if (PythonCoverageRunConfigurationExtension.checkLanguageContribution(configuration.getSdk(), PyCredentialsContribution::isSpecificCoveragePatch)) {
                String coverageFilePath = covEnabledConfig.getCoverageFilePath();
                if (coverageFilePath != null) {
                    PathMappingSettings mappings = PythonCoverageRunConfigurationExtension.createCoverageFileMappings(coverageFilePath);
                    cmdLine.putUserData(PythonRemoteInterpreterManager.ADDITIONAL_MAPPINGS, (Object)mappings);
                    PyCoverageUtil.addCoverageFileEnv(cmdLine, mappings.convertToRemote(coverageFilePath));
                }
            } else if (PythonSdkUtil.isRemote((Sdk)configuration.getSdk())) {
                cmdLine.getEnvironment().put(CREATE_TEMP_COVERAGE_FILE, "1");
            }
        }
    }

    @NotNull
    private static ParamsGroup getOrCreateCoverageParamsGroup(@NotNull GeneralCommandLine cmdLine) {
        ParametersList parametersList;
        ParamsGroup paramsGroup;
        if (cmdLine == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(26);
        }
        ParamsGroup paramsGroup2 = (paramsGroup = (parametersList = cmdLine.getParametersList()).getParamsGroup("Coverage")) != null ? paramsGroup : parametersList.addParamsGroup("Coverage");
        if (paramsGroup2 == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(27);
        }
        return paramsGroup2;
    }

    @NotNull
    private static PathMappingSettings createCoverageFileMappings(@NotNull String coverageFilePath) {
        if (coverageFilePath == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(28);
        }
        PathMappingSettings mappingSettings = new PathMappingSettings();
        mappingSettings.add(new PathMappingSettings.PathMapping(new File(coverageFilePath).getParent(), "/opt/.pycharm_coverage"));
        PathMappingSettings pathMappingSettings = mappingSettings;
        if (pathMappingSettings == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(29);
        }
        return pathMappingSettings;
    }

    private static boolean useBundledCoverage(@NotNull AbstractPythonRunConfiguration<?> configuration) {
        if (configuration == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(30);
        }
        return PyCoverageOptionsProvider.getInstance(configuration.getProject()).isUseBundledCoveragePy();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 27, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAdditionalData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/pro/coverage/PythonCoverageRunConfigurationExtension";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/pro/coverage/PythonCoverageRunConfigurationExtension";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateCoverageParamsGroup";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createCoverageFileMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleCoverageResults";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "downloadAllVolumes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkLanguageContribution";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setPythonCoveragePathMapper";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addProcessTerminatedEventListener";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressAsynchronously";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showErrorDialogAndWait";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableFor";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledFor";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateCoverageParamsGroup";
                break;
            }
            case 27: 
            case 29: {
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createCoverageFileMappings";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "useBundledCoverage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 27, 29 -> new IllegalStateException(string);
        };
    }
}

