/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.templateLanguages;

import com.google.common.collect.Sets;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.jinja.Jinja2FileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.impl.FileTypeRenderer;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.python.templateLanguages.PyTemplateFileTypeConfigurable;
import com.intellij.template.lang.core.templateLanguages.TemplatesService;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonProBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

final class PyTemplateFileTypesPanel
extends JPanel
implements PyTemplateFileTypeConfigurable {
    private final JList<FileType> myFileTypesList;
    private PyTemplateFileTypeConfigurable myController;
    private final CommonActionsPanel myActionsPanel;
    private final List<FileType> myTempFileTypes = new ArrayList<FileType>();
    private final Set<FileType> myToAddSet = new HashSet<FileType>();
    private final Set<FileType> myToRemoveSet = new HashSet<FileType>();

    PyTemplateFileTypesPanel() {
        super(new BorderLayout());
        this.myFileTypesList = new JBList(new DefaultListModel());
        this.myFileTypesList.setSelectionMode(0);
        this.myFileTypesList.setCellRenderer((ListCellRenderer<FileType>)new FileTypeRenderer(this.myFileTypesList.getModel()));
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator(this.myFileTypesList).setAddAction(button -> this.myController.addFileType()).setRemoveAction(button -> this.myController.removeFileType()).setRemoveActionUpdater(e -> PyTemplateFileTypesPanel.canBeModified(this.getSelectedFileType())).disableUpDownActions();
        this.add((Component)toolbarDecorator.createPanel(), "Center");
        this.setBorder((Border)IdeBorderFactory.createTitledBorder((String)PythonProBundle.message((String)"python.template.file.types"), (boolean)false));
        this.myActionsPanel = toolbarDecorator.getActionsPanel();
        ListSpeedSearch<FileType> search = new ListSpeedSearch<FileType>(this, this.myFileTypesList, null, null){

            protected String getElementText(Object element) {
                return element instanceof FileType ? ((FileType)element).getDescription() : super.getElementText(element);
            }
        };
        search.setupListeners();
        this.attachActions(this);
    }

    public CommonActionsPanel getActionsPanel() {
        return this.myActionsPanel;
    }

    private static boolean canBeModified(FileType type) {
        return !TemplatesService.BASIC_TEMPLATE_TYPES.contains(type);
    }

    public void attachActions(PyTemplateFileTypeConfigurable controller) {
        this.myController = controller;
    }

    public FileType getSelectedFileType() {
        return this.myFileTypesList.getSelectedValue();
    }

    public JComponent getComponent() {
        return this;
    }

    public void setFileTypes(@NotNull @NotNull FileType @NotNull [] types) {
        if (types == null) {
            PyTemplateFileTypesPanel.$$$reportNull$$$0(0);
        }
        this.myTempFileTypes.clear();
        this.myTempFileTypes.addAll(Arrays.asList(types));
        DefaultListModel listModel = (DefaultListModel)this.myFileTypesList.getModel();
        listModel.clear();
        for (FileType type : types) {
            if (type == FileTypes.UNKNOWN) continue;
            listModel.addElement(type);
        }
        ScrollingUtil.ensureSelectionExists(this.myFileTypesList);
    }

    public int getSelectedIndex() {
        return this.myFileTypesList.getSelectedIndex();
    }

    public void setSelectionIndex(int selectedIndex) {
        this.myFileTypesList.setSelectedIndex(selectedIndex);
    }

    public void selectFileType(FileType fileType) {
        this.myFileTypesList.setSelectedValue(fileType, true);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myFileTypesList, true));
    }

    @Override
    public void addFileType() {
        BaseListPopupStep<FileType> fileTypes = new BaseListPopupStep<FileType>(PyBundle.message((String)"python.template.select.file.type", (Object[])new Object[0]), this.createFileTypesToAdd()){

            public Icon getIconFor(FileType aValue) {
                return aValue.getIcon();
            }

            @NotNull
            public String getTextFor(FileType value2) {
                String string = value2.getDescription();
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            public PopupStep<?> onChosen(FileType fileType, boolean finalChoice) {
                PyTemplateFileTypesPanel.this.addFileType(fileType);
                return FINAL_CHOICE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/python/templateLanguages/PyTemplateFileTypesPanel$2", "getTextFor"));
            }
        };
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)fileTypes);
        popup.show(this.getActionsPanel().getAnActionButton(CommonActionsPanel.Buttons.ADD).getPreferredPopupPoint());
    }

    private void addFileType(FileType type) {
        this.myTempFileTypes.add(type);
        if (!this.myToRemoveSet.contains(type)) {
            this.myToAddSet.add(type);
        } else {
            this.myToRemoveSet.remove(type);
        }
        this.updateFileTypeList();
        this.selectFileType(type);
    }

    private FileType[] createFileTypesToAdd() {
        FileType[] types = this.getAvailableFileTypes();
        PyTemplateFileTypesPanel.sortTypes(types);
        return types;
    }

    private FileType[] getAvailableFileTypes() {
        FileType[] registeredFileTypes = FileTypeManager.getInstance().getRegisteredFileTypes();
        ArrayList<FileType> result = new ArrayList<FileType>();
        HashSet dontAdd = Sets.newHashSet((Object[])new FileType[]{Jinja2FileType.INSTANCE, PythonFileType.INSTANCE, ArchiveFileType.INSTANCE});
        dontAdd.addAll(this.myTempFileTypes);
        for (FileType fileType : registeredFileTypes) {
            if (fileType.isBinary() || fileType.isReadOnly() || dontAdd.contains(fileType)) continue;
            result.add(fileType);
        }
        return result.toArray(FileType.EMPTY_ARRAY);
    }

    @Override
    public void removeFileType() {
        FileType type = this.getSelectedFileType();
        if (type == null) {
            return;
        }
        this.myTempFileTypes.remove(type);
        if (!this.myToAddSet.contains(type)) {
            this.myToRemoveSet.add(type);
        } else {
            this.myToAddSet.remove(type);
        }
        this.updateFileTypeList();
    }

    private void updateFileTypeList() {
        FileType[] types = this.myTempFileTypes.toArray(FileType.EMPTY_ARRAY);
        PyTemplateFileTypesPanel.sortTypes(types);
        this.setFileTypes(types);
    }

    public boolean isModified() {
        return !this.myToAddSet.isEmpty() || !this.myToRemoveSet.isEmpty();
    }

    @NotNull
    public List<FileType> getFileTypes() {
        List<FileType> list = Collections.unmodifiableList(this.myTempFileTypes);
        if (list == null) {
            PyTemplateFileTypesPanel.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static void sortTypes(FileType[] types) {
        Arrays.sort(types, (o1, o2) -> o1.getDescription().compareToIgnoreCase(o2.getDescription()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/templateLanguages/PyTemplateFileTypesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/templateLanguages/PyTemplateFileTypesPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setFileTypes";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

