/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.structureView;

import com.google.common.collect.Lists;
import com.intellij.formatting.Block;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.jinja.template.formatter.DjangoTagBlock;
import com.intellij.jinja.template.formatter.MutableBlockWrapper;
import com.intellij.psi.PsiElement;
import com.jetbrains.django.lang.template.structureView.DjangoXmlRootTreeElement;
import com.jetbrains.django.lang.template.structureView.StructureViewBlockWrapper;
import com.jetbrains.django.lang.template.structureView.TreeElementBlock;
import java.util.ArrayList;
import java.util.List;

public final class DjangoStructureViewUtil {
    public static Block convertFromTreeViewToBlocks(PsiTreeElementBase<PsiElement> root) {
        return new TreeElementBlock(root);
    }

    public static StructureViewTreeElement convertFromBlockTreeToTreeView(DjangoXmlRootTreeElement root, Block block) {
        List<StructureViewTreeElement> res = DjangoStructureViewUtil.convertFromBlockTreeToTreeView(Lists.newArrayList((Object[])new Block[]{block}));
        if (res.size() == 1) {
            return res.get(0);
        }
        return DjangoStructureViewUtil.createBlockWrapper(root, res);
    }

    public static List<StructureViewTreeElement> convertFromBlockTreeToTreeView(List<? extends Block> blocks) {
        ArrayList<StructureViewTreeElement> result = new ArrayList<StructureViewTreeElement>();
        for (Block block : blocks) {
            DjangoStructureViewUtil.convertFromBlockTreeToTreeView(result, block);
        }
        return result;
    }

    public static List<StructureViewTreeElement> convertFromBlockTreeToTreeView(Block block) {
        ArrayList<StructureViewTreeElement> result = new ArrayList<StructureViewTreeElement>();
        DjangoStructureViewUtil.convertFromBlockTreeToTreeView(result, block);
        if (result.size() == 1 && result.get(0) instanceof StructureViewBlockWrapper) {
            return Lists.newArrayList((Object[])((StructureViewBlockWrapper)result.get(0)).getChildren());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void convertFromBlockTreeToTreeView(List<? super StructureViewTreeElement> result, Block b) {
        if (b instanceof TreeElementBlock) {
            List<StructureViewTreeElement> children = DjangoStructureViewUtil.convertFromBlockTreeToTreeView(b.getSubBlocks());
            result.add(DjangoStructureViewUtil.createBlockWrapper(((TreeElementBlock)b).getTreeElement(), children));
            return;
        } else if (b instanceof MutableBlockWrapper && ((MutableBlockWrapper)b).getOriginalBlock() instanceof TreeElementBlock) {
            List<StructureViewTreeElement> children = DjangoStructureViewUtil.convertFromBlockTreeToTreeView(b.getSubBlocks());
            Block originalBlock = ((MutableBlockWrapper)b).getOriginalBlock();
            if (!(originalBlock instanceof TreeElementBlock)) throw new IllegalStateException("this should not happen");
            result.add(DjangoStructureViewUtil.createBlockWrapper(((TreeElementBlock)originalBlock).getTreeElement(), children));
            return;
        } else if (b instanceof DjangoTagBlock) {
            TreeElementBlock treeElementBlock;
            List<StructureViewTreeElement> children = DjangoStructureViewUtil.convertFromBlockTreeToTreeView(b.getSubBlocks());
            Block openTag = ((DjangoTagBlock)b).getOpenTag();
            if (openTag instanceof TreeElementBlock) {
                treeElementBlock = (TreeElementBlock)openTag;
            } else {
                if (!(openTag instanceof MutableBlockWrapper)) throw new IllegalStateException("unexpected block:" + String.valueOf(openTag.getClass()));
                treeElementBlock = (TreeElementBlock)((MutableBlockWrapper)openTag).getOriginalBlock();
            }
            result.add(DjangoStructureViewUtil.createBlockWrapper(treeElementBlock.getTreeElement(), children));
            return;
        } else {
            result.addAll(DjangoStructureViewUtil.convertFromBlockTreeToTreeView(b.getSubBlocks()));
        }
    }

    private static StructureViewBlockWrapper createBlockWrapper(PsiTreeElementBase treeElement, List<StructureViewTreeElement> children) {
        return new StructureViewBlockWrapper((StructureViewTreeElement)treeElement, children);
    }
}

