/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model.fieldsAsArguments.fieldReferencesObtainer;

import com.jetbrains.django.model.relationalKeys.DjangoRelationType;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class FieldReferencesDirections {
    private final boolean myAllowLeaves;
    @NotNull
    private final Set<DjangoRelationType> myBranchesToAllow;
    @NotNull
    private final Set<DjangoRelationType> myDirectRelationsToFollow;
    @NotNull
    private final Set<DjangoRelationType> myReverseRelationsToFollow;
    private boolean myRemoveSetsFromReverse;
    private boolean myRemoveIdPostfix;
    private final boolean myAllowReverseRelationItself;
    public static final DjangoRelationType @NotNull [] ALL_RELATIONS = DjangoRelationType.values();
    public static final DjangoRelationType @NotNull [] ALL_EXCEPT_MANY_TO_MANY = new DjangoRelationType[]{DjangoRelationType.ONE_TO_ONE, DjangoRelationType.ONE_TO_MANY};

    public FieldReferencesDirections(boolean allowLeaves, boolean allowReverseRelationItself, DjangoRelationType ... branchesToAllow) {
        if (branchesToAllow == null) {
            FieldReferencesDirections.$$$reportNull$$$0(0);
        }
        this.myBranchesToAllow = EnumSet.noneOf(DjangoRelationType.class);
        this.myDirectRelationsToFollow = EnumSet.noneOf(DjangoRelationType.class);
        this.myReverseRelationsToFollow = EnumSet.noneOf(DjangoRelationType.class);
        this.myRemoveSetsFromReverse = false;
        this.myRemoveIdPostfix = false;
        this.myAllowLeaves = allowLeaves;
        this.myAllowReverseRelationItself = allowReverseRelationItself;
        this.myBranchesToAllow.addAll(Arrays.asList(branchesToAllow));
    }

    public FieldReferencesDirections(boolean allowLeaves, DjangoRelationType ... branchesToAllow) {
        if (branchesToAllow == null) {
            FieldReferencesDirections.$$$reportNull$$$0(1);
        }
        this(allowLeaves, true, branchesToAllow);
    }

    @NotNull
    public FieldReferencesDirections followDirectRelations(DjangoRelationType ... directRelations) {
        if (directRelations == null) {
            FieldReferencesDirections.$$$reportNull$$$0(2);
        }
        this.myDirectRelationsToFollow.addAll(Arrays.asList(directRelations));
        FieldReferencesDirections fieldReferencesDirections = this;
        if (fieldReferencesDirections == null) {
            FieldReferencesDirections.$$$reportNull$$$0(3);
        }
        return fieldReferencesDirections;
    }

    @NotNull
    public FieldReferencesDirections followReverseRelations(DjangoRelationType ... reverseRelations) {
        if (reverseRelations == null) {
            FieldReferencesDirections.$$$reportNull$$$0(4);
        }
        this.myReverseRelationsToFollow.addAll(Arrays.asList(reverseRelations));
        FieldReferencesDirections fieldReferencesDirections = this;
        if (fieldReferencesDirections == null) {
            FieldReferencesDirections.$$$reportNull$$$0(5);
        }
        return fieldReferencesDirections;
    }

    @NotNull
    public FieldReferencesDirections withRemovingSetsFromReverse() {
        this.myRemoveSetsFromReverse = true;
        FieldReferencesDirections fieldReferencesDirections = this;
        if (fieldReferencesDirections == null) {
            FieldReferencesDirections.$$$reportNull$$$0(6);
        }
        return fieldReferencesDirections;
    }

    @NotNull
    public FieldReferencesDirections withRemovingIdPostfix() {
        this.myRemoveIdPostfix = true;
        FieldReferencesDirections fieldReferencesDirections = this;
        if (fieldReferencesDirections == null) {
            FieldReferencesDirections.$$$reportNull$$$0(7);
        }
        return fieldReferencesDirections;
    }

    @NotNull
    Set<DjangoRelationType> getDirectRelationsToFollow() {
        Set<DjangoRelationType> set = Collections.unmodifiableSet(this.myDirectRelationsToFollow);
        if (set == null) {
            FieldReferencesDirections.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    Set<DjangoRelationType> getReverseRelationsToFollow() {
        Set<DjangoRelationType> set = Collections.unmodifiableSet(this.myReverseRelationsToFollow);
        if (set == null) {
            FieldReferencesDirections.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    public Set<DjangoRelationType> getBranchesToAllow() {
        Set<DjangoRelationType> set = Collections.unmodifiableSet(this.myBranchesToAllow);
        if (set == null) {
            FieldReferencesDirections.$$$reportNull$$$0(10);
        }
        return set;
    }

    boolean isAllowLeaves() {
        return this.myAllowLeaves;
    }

    boolean isRemoveSetsFromReverse() {
        return this.myRemoveSetsFromReverse;
    }

    public boolean isRemoveIdPostfix() {
        return this.myRemoveIdPostfix;
    }

    boolean isAllowReverseRelationItself() {
        return this.myAllowReverseRelationItself;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchesToAllow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directRelations";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/fieldsAsArguments/fieldReferencesObtainer/FieldReferencesDirections";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reverseRelations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/fieldsAsArguments/fieldReferencesObtainer/FieldReferencesDirections";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "followDirectRelations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "followReverseRelations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withRemovingSetsFromReverse";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withRemovingIdPostfix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectRelationsToFollow";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReverseRelationsToFollow";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchesToAllow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "followDirectRelations";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "followReverseRelations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

