/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.SocketException;
import java.util.logging.Logger;
import org.ice4j.socket.DatagramPacketFilter;
import org.ice4j.socket.DelegatingSocket;
import org.ice4j.socket.MultiplexedXXXSocket;
import org.ice4j.socket.MultiplexingSocket;
import org.ice4j.socket.SocketReceiveBuffer;

public class MultiplexedSocket
extends DelegatingSocket
implements MultiplexedXXXSocket {
    private static final Logger logger = Logger.getLogger(MultiplexedSocket.class.getName());
    private final DatagramPacketFilter filter;
    private final InputStream inputStream = new InputStreamImpl();
    private final MultiplexingSocket multiplexing;
    final SocketReceiveBuffer received = new SocketReceiveBuffer(this::getReceiveBufferSize);

    MultiplexedSocket(MultiplexingSocket multiplexing, DatagramPacketFilter filter) throws SocketException {
        super(multiplexing);
        if (multiplexing == null) {
            throw new NullPointerException("multiplexing");
        }
        this.multiplexing = multiplexing;
        this.filter = filter;
    }

    @Override
    public void close() {
        this.multiplexing.close(this);
    }

    @Override
    public DatagramPacketFilter getFilter() {
        return this.filter;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public void receive(DatagramPacket p) throws IOException {
        this.multiplexing.receive(this, p);
    }

    private class InputStreamImpl
    extends InputStream {
        private final byte[] buf = new byte[1500];
        private final DatagramPacket packet = new DatagramPacket(this.buf, 1500);

        @Override
        public int available() {
            return 0;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read() throws IOException {
            return 0;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (off == 0) {
                this.packet.setData(b);
                MultiplexedSocket.this.receive(this.packet);
                int lengthRead = this.packet.getLength();
                if (this.packet.getData() == b && lengthRead <= len) {
                    return lengthRead;
                }
                logger.warning("Failed to read directly into the provided buffer, len=" + len + " lengthRead=" + lengthRead + " (packet.getData() == b)=" + (this.packet.getData() == b));
            }
            this.packet.setData(this.buf);
            MultiplexedSocket.this.receive(this.packet);
            int packetLen = this.packet.getLength();
            int lengthRead = Math.min(len, packetLen);
            System.arraycopy(this.packet.getData(), this.packet.getOffset(), b, off, lengthRead);
            return lengthRead;
        }

        @Override
        public void reset() throws IOException {
            if (!this.markSupported()) {
                throw new IOException("InputStreamImpl does not support reset()");
            }
        }

        @Override
        public long skip(long n) throws IOException {
            throw new IOException("InputStreamImpl does not support skip.");
        }
    }
}

