/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.SqliteExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.dialects.SqliteIntermediateFacade;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.TypedKey;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqliteJdbcHelper
extends JdbcHelperImpl {
    private static final Pattern SPACES_PATTERN = Pattern.compile(" +");
    public static final TypedKey<Boolean> REGISTER_REGEXP = TypedKey.create("sqlite.register.regexp");

    public SqliteJdbcHelper(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        super("SQLITE", version, connection, jdbcClassLoader);
    }

    public SqliteJdbcHelper() {
        this(null, null, null);
    }

    private SqliteJdbcHelper(@NotNull SqliteJdbcHelper helper, @NotNull ClassLoader jdbcClassLoader) {
        if (helper == null) {
            SqliteJdbcHelper.$$$reportNull$$$0(0);
        }
        if (jdbcClassLoader == null) {
            SqliteJdbcHelper.$$$reportNull$$$0(1);
        }
        super(helper, jdbcClassLoader);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return SqliteJdbcHelper.extractVersion(version);
    }

    @Override
    public int fixJdbcType(@Nullable String typeName, @Nullable String clazz, int type) {
        if ("datetime".equalsIgnoreCase(typeName)) {
            return 93;
        }
        if ("bool".equalsIgnoreCase(typeName) || "boolean".equalsIgnoreCase(typeName)) {
            return 16;
        }
        return super.fixJdbcType(typeName, clazz, type);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            SqliteJdbcHelper.$$$reportNull$$$0(2);
        }
        if (e.length == 2000000000) {
            e.length = -1;
        }
        if (e.scale == 10) {
            e.scale = 0;
        }
        if (e.length != -1 && e.scale != 0) {
            e.length -= e.scale;
        }
    }

    @Override
    @Nullable
    protected JdbcHelperImpl.TemporalGetter getTemporalGetter(@Nullable String typeName, int type) {
        return type == 93 || type == 91 ? SqliteTemporalGetter.INSTANCE : super.getTemporalGetter(typeName, type);
    }

    @Override
    public String getCatalogName(@NotNull ResultSetMetaData delegate, int column) throws SQLException {
        if (delegate == null) {
            SqliteJdbcHelper.$$$reportNull$$$0(3);
        }
        return "";
    }

    @Override
    public JdbcHelperImpl bindClassLoader(@NotNull ClassLoader jdbcClassLoader) {
        if (jdbcClassLoader == null) {
            SqliteJdbcHelper.$$$reportNull$$$0(4);
        }
        return new SqliteJdbcHelper(this, jdbcClassLoader);
    }

    @Override
    public String getColumnTypeName(@NotNull ResultSetMetaData delegate, int idx) throws SQLException {
        String typeName;
        if (delegate == null) {
            SqliteJdbcHelper.$$$reportNull$$$0(5);
        }
        return (typeName = super.getColumnTypeName(delegate, idx)) != null ? SPACES_PATTERN.matcher(typeName).replaceAll(" ") : typeName;
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        return new SqliteJdbcHelper(version, connection, jdbcClassLoader);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull JdbcConnectionProvider ds) {
        if (ds == null) {
            SqliteJdbcHelper.$$$reportNull$$$0(6);
        }
        return new SqliteIntermediateFacade(ds, SqliteExceptionRecognizer.INSTANCE, this);
    }

    @Override
    public JdbcHelper.LikeSupport getLikeSupport() {
        return JdbcHelper.LikeSupport.SELECTS_ONLY;
    }

    @Override
    @Nullable
    public JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper, @Nullable ClassLoader jdbcClassLoader) throws Exception {
        if (!JdbcNativeUtil.detectString(product, "sqlite")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return SqliteJdbcHelper.create(delegate, productVer, jdbcClassLoader);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            SqliteJdbcHelper.$$$reportNull$$$0(7);
        }
        return SqliteJdbcHelper.classNameContains(driver, "org.sqlite.JDBC");
    }

    @Override
    @Nullable
    public Connection connect(@NotNull Driver driver, String url, @NotNull Properties properties, @NotNull Map<String, Serializable> extra) throws SQLException {
        if (driver == null) {
            SqliteJdbcHelper.$$$reportNull$$$0(8);
        }
        if (properties == null) {
            SqliteJdbcHelper.$$$reportNull$$$0(9);
        }
        if (extra == null) {
            SqliteJdbcHelper.$$$reportNull$$$0(10);
        }
        Connection connection = super.connect(driver, url, properties, extra);
        if (!Boolean.FALSE.equals(REGISTER_REGEXP.get(extra))) {
            try {
                ReflectionHelper.tryInvokeStaticMethod(driver.getClass().getClassLoader(), "com.intellij.database.remote.jdbc.SqliteShim", "registerRegexp", new Class[]{Connection.class}, new Object[]{connection});
            }
            catch (Throwable th) {
                JdbcNativeUtil.logWarn("Failed to register REGEXP function", th);
            }
        }
        return connection;
    }

    @Override
    @NotNull
    public JdbcHelper.Case getCaseMode(boolean sensitive, boolean forceLower, boolean forceUpper, boolean asIs) {
        if (sensitive && asIs) {
            JdbcHelper.Case case_ = JdbcHelper.Case.MIXED;
            if (case_ == null) {
                SqliteJdbcHelper.$$$reportNull$$$0(11);
            }
            return case_;
        }
        JdbcHelper.Case case_ = super.getCaseMode(sensitive, forceLower, forceUpper, asIs);
        if (case_ == null) {
            SqliteJdbcHelper.$$$reportNull$$$0(12);
        }
        return case_;
    }

    @NotNull
    private static SqliteJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer, @Nullable ClassLoader jdbcClassLoader) throws Exception {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        return new SqliteJdbcHelper(SqliteJdbcHelper.extractVersion(productVer), delegate, jdbcClassLoader);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcClassLoader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extra";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/SqliteJdbcHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/SqliteJdbcHelper";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCatalogName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindClassLoader";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getColumnTypeName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFacade";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SqliteTemporalGetter
    implements JdbcHelperImpl.TemporalGetter {
        static final JdbcHelperImpl.TemporalGetter INSTANCE = new SqliteTemporalGetter();

        private SqliteTemporalGetter() {
        }

        @Override
        public Object get(@NotNull ResultSet set, @NotNull RemoteResultSet.DataRetrievingOptions options, int idx) throws SQLException {
            if (set == null) {
                SqliteTemporalGetter.$$$reportNull$$$0(0);
            }
            if (options == null) {
                SqliteTemporalGetter.$$$reportNull$$$0(1);
            }
            return set.getObject(idx);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "set";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "options";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/remote/jdbc/helpers/SqliteJdbcHelper$SqliteTemporalGetter";
            objectArray[2] = "get";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

