/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.async.windows;

import java.util.ArrayList;

public class WindowsSymbolsResolver {
    private static WindowsSymbolsResolver instance;

    private WindowsSymbolsResolver() {
    }

    public static WindowsSymbolsResolver getInstance() {
        return WindowsSymbolsResolver.getInstance(null);
    }

    public static synchronized WindowsSymbolsResolver getInstance(String libPath) {
        if (instance != null) {
            return instance;
        }
        if (libPath == null) {
            System.loadLibrary("jniSymbolsResolver");
        } else {
            System.load(libPath);
        }
        instance = new WindowsSymbolsResolver();
        return instance;
    }

    public ResolveResult resolve(String libDbghelpPath, String additionalNtLibraryPath, String dllPath, ArrayList<String> offsets, long size, byte[] dbgInfo) {
        return this.doResolve(libDbghelpPath, additionalNtLibraryPath, dllPath, offsets, size, dbgInfo);
    }

    private native ResolveResult doResolve(String var1, String var2, String var3, ArrayList<String> var4, long var5, byte[] var7);

    public static class ResolveResult {
        public final String resolveLog;
        public final String errorMessage;
        public final ArrayList<String> resolvedSymbols;

        public ResolveResult() {
            this(null, null, null);
        }

        public ResolveResult(String errorMessage, ArrayList<String> resolvedSymbols, String resolveLog) {
            this.resolveLog = resolveLog;
            this.errorMessage = errorMessage;
            this.resolvedSymbols = resolvedSymbols;
        }
    }
}

