/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.FunctionStepIntoVariant;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.VariantsCollector;
import com.intellij.javascript.debugger.settings.JavaScriptDebuggerSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.PsiVisitors;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\t\u001a\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e0\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e0\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptSmartStepIntoHandler;", "Lcom/intellij/xdebugger/stepping/XSmartStepIntoHandler;", "Lcom/intellij/javascript/debugger/FunctionStepIntoVariant;", "mySession", "Lcom/intellij/xdebugger/XDebugSession;", "<init>", "(Lcom/intellij/xdebugger/XDebugSession;)V", "getMySession", "()Lcom/intellij/xdebugger/XDebugSession;", "getPopupTitle", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "computeSmartStepVariants", "", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "computeSmartStepVariantsAsync", "Lorg/jetbrains/concurrency/Promise;", "doComputeSmartStepVariants", "computeStepIntoVariants", "intellij.javascript.debugger.backend"})
public abstract class JavaScriptSmartStepIntoHandler
extends XSmartStepIntoHandler<FunctionStepIntoVariant> {
    @NotNull
    private final XDebugSession mySession;

    public JavaScriptSmartStepIntoHandler(@NotNull XDebugSession mySession) {
        Intrinsics.checkNotNullParameter((Object)mySession, (String)"mySession");
        this.mySession = mySession;
    }

    @NotNull
    protected final XDebugSession getMySession() {
        return this.mySession;
    }

    @NotNull
    public String getPopupTitle() {
        String string = JSDebuggerBundle.message("popup.title.step.into.function", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public List<FunctionStepIntoVariant> computeSmartStepVariants(@NotNull XSourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        throw new IllegalStateException("Should not be called");
    }

    @NotNull
    public Promise<List<FunctionStepIntoVariant>> computeSmartStepVariantsAsync(@NotNull XSourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        NonBlockingReadAction nonBlockingReadAction = ReadAction.nonBlocking(() -> JavaScriptSmartStepIntoHandler.computeSmartStepVariantsAsync$lambda$0(this, position));
        Intrinsics.checkNotNullExpressionValue((Object)nonBlockingReadAction, (String)"nonBlocking(...)");
        NonBlockingReadAction readAction = nonBlockingReadAction;
        XDebugProcess xDebugProcess = this.mySession.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugProcess, (String)"getDebugProcess(...)");
        XDebugProcess debugProcess = xDebugProcess;
        if (debugProcess instanceof Disposable) {
            NonBlockingReadAction nonBlockingReadAction2 = readAction.expireWith((Disposable)debugProcess);
            Intrinsics.checkNotNullExpressionValue((Object)nonBlockingReadAction2, (String)"expireWith(...)");
            readAction = nonBlockingReadAction2;
        }
        CancellablePromise cancellablePromise = readAction.submit((Executor)AppExecutorUtil.getAppExecutorService());
        Intrinsics.checkNotNullExpressionValue((Object)cancellablePromise, (String)"submit(...)");
        return (Promise)cancellablePromise;
    }

    private final List<FunctionStepIntoVariant> doComputeSmartStepVariants(XSourcePosition position) {
        VariantsCollector visitor2 = new VariantsCollector();
        PsiVisitors.visit((XSourcePosition)position, (Project)this.mySession.getProject(), null, (PsiVisitors.Visitor)visitor2);
        List list = visitor2.getVariants();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public Promise<List<FunctionStepIntoVariant>> computeStepIntoVariants(@NotNull XSourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (JavaScriptDebuggerSettings.getInstance().isAlwaysDoSmartStepInto()) {
            return this.computeSmartStepVariantsAsync(position);
        }
        return Promises.rejectedPromise();
    }

    private static final List computeSmartStepVariantsAsync$lambda$0(JavaScriptSmartStepIntoHandler this$0, XSourcePosition $position) {
        return this$0.doComputeSmartStepVariants($position);
    }
}

