/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.cloudExplorer.CloudConnectionData;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseNameColorExtension;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExpandableEditorSupport;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseNameComponent {
    private static final String NON_UNIQUE_NAME = "NON_UNIQUE_NAME";
    private JComponent myPanel;
    private ExtendableTextField myName;
    private EditorTextField myComment;
    private final AbstractDatabaseConfigurable<?> myConfigurable;
    private final DatabaseConfigEditor myController;
    private final DatabaseNameColorExtension myColorExtension;

    public DatabaseNameComponent(@NotNull AbstractDatabaseConfigurable<?> configurable, @NotNull DatabaseConfigEditor controller, boolean withColor) {
        if (configurable == null) {
            DatabaseNameComponent.$$$reportNull$$$0(0);
        }
        if (controller == null) {
            DatabaseNameComponent.$$$reportNull$$$0(1);
        }
        this.myConfigurable = configurable;
        this.myController = controller;
        this.$$$setupUI$$$();
        this.myName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                String name = DatabaseNameComponent.this.getNameValue();
                if (!DatabaseNameComponent.this.myController.isObjectNameUnique(DatabaseNameComponent.this.myConfigurable.getTarget(), name)) {
                    DatabaseNameComponent.this.myController.showErrorNotification(DatabaseNameComponent.this.myConfigurable, (Object)DatabaseNameComponent.NON_UNIQUE_NAME, DatabaseBundle.message((String)"notification.title.name.not.unique", (Object[])new Object[0]), DatabaseBundle.message((String)"notification.content.object.with.name.s.already.exists.please.choose.another.name", (Object[])new Object[]{name}), new Object[0]);
                } else {
                    DatabaseNameComponent.this.myController.showErrorNotification(DatabaseNameComponent.this.myConfigurable, (Object)DatabaseNameComponent.NON_UNIQUE_NAME, null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DatabaseNameComponent$1", "textChanged"));
            }
        });
        this.myColorExtension = withColor ? new DatabaseNameColorExtension(this) : null;
        this.myComment.setDisposedWith(configurable);
        if (withColor) {
            this.myName.addExtension((ExtendableTextComponent.Extension)this.myColorExtension);
            KeyboardShortcut shortcut = DatabaseNameColorExtension.getExtensionKeyboardShortcut();
            if (shortcut != null && shortcut.getSecondKeyStroke() == null) {
                this.myName.registerKeyboardAction(event -> this.myColorExtension.getActionOnClick().run(), shortcut.getFirstKeyStroke(), 0);
            }
        }
        this.myPanel.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        new ExpandableEditorSupport(this.myComment);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            DatabaseNameComponent.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    public void reset(@NotNull DatabaseDriverImpl driver, @Nullable Computable<String> nameGenerator) {
        if (driver == null) {
            DatabaseNameComponent.$$$reportNull$$$0(3);
        }
        this.reset(driver.getName(), driver.getComment(), nameGenerator);
    }

    public void reset(@NotNull CloudConnectionData data, @Nullable Computable<String> nameGenerator) {
        if (data == null) {
            DatabaseNameComponent.$$$reportNull$$$0(4);
        }
        this.reset(data.getName(), data.getComment(), nameGenerator);
    }

    public void reset(@NotNull AbstractDataSource dataSource, @Nullable Computable<String> nameGenerator) {
        if (dataSource == null) {
            DatabaseNameComponent.$$$reportNull$$$0(5);
        }
        this.reset(dataSource.getName(), dataSource.getComment(), nameGenerator);
        if (this.myColorExtension != null) {
            this.myColorExtension.reset((RawDataSource)dataSource);
        }
    }

    private void reset(String name, String comment, @Nullable Computable<String> nameGenerator) {
        String adjustedName = !StringUtil.isEmptyOrSpaces((String)name) ? name : (nameGenerator != null ? (String)nameGenerator.compute() : null);
        this.setNameValue(adjustedName);
        this.setCommentValue(comment);
    }

    public void save(@NotNull CloudConnectionData data) {
        if (data == null) {
            DatabaseNameComponent.$$$reportNull$$$0(6);
        }
        data.setName(this.getNameValue());
        data.setComment(this.getCommentValue());
    }

    public void save(@NotNull DatabaseDriverImpl driver) {
        if (driver == null) {
            DatabaseNameComponent.$$$reportNull$$$0(7);
        }
        driver.setName(this.getNameValue());
        driver.setComment(this.getCommentValue());
    }

    public void save(@NotNull AbstractDataSource dataSource) {
        if (dataSource == null) {
            DatabaseNameComponent.$$$reportNull$$$0(8);
        }
        dataSource.setName(this.getNameValue());
        dataSource.setComment(this.getCommentValue());
    }

    private String getCommentValue() {
        return StringUtil.nullize((String)this.myComment.getText(), (boolean)true);
    }

    public void apply(@NotNull AbstractDataSource dataSource) {
        if (dataSource == null) {
            DatabaseNameComponent.$$$reportNull$$$0(9);
        }
        if (this.myColorExtension != null) {
            this.myColorExtension.apply((RawDataSource)dataSource);
        }
    }

    public boolean isModified() {
        return this.myColorExtension != null && this.myColorExtension.isModified();
    }

    @NlsSafe
    @NotNull
    public String getNameValue() {
        String string = this.myName.getText();
        if (string == null) {
            DatabaseNameComponent.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void setGeneratedName(String name) {
        if (Objects.equals(name, this.myName.getText())) {
            return;
        }
        this.myName.setText(name);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myName;
    }

    public void setNameValue(@Nullable String name) {
        this.myName.setText(StringUtil.notNullize((String)name));
    }

    private void setCommentValue(@NlsSafe @Nullable String comment) {
        String s = StringUtil.notNullize((String)comment);
        this.myComment.setText(s);
        this.myComment.setToolTipText(StringUtil.shortenTextWithEllipsis((String)s, (int)2000, (int)0, (boolean)true));
    }

    AbstractDatabaseConfigurable<?> getConfigurable() {
        return this.myConfigurable;
    }

    ExtendableTextField getNameField() {
        return this.myName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseNameComponent";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseNameComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 10: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 10 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        EditorTextField editorTextField2;
        ExtendableTextField extendableTextField;
        JPanel jPanel = new JPanel();
        this.myPanel = jPanel;
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setHorizontalTextPosition(11);
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseNameComponent.class).getString("data.source.settings.name.label"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myName = extendableTextField = new ExtendableTextField();
        extendableTextField.setColumns(20);
        jPanel.add((Component)extendableTextField, new GridConstraints(0, 1, 1, 2, 0, 3, 6, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseNameComponent.class).getString("data.source.settings.comment.label"));
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myComment = editorTextField2 = new EditorTextField();
        jPanel.add((Component)editorTextField2, new GridConstraints(1, 1, 1, 2, 0, 1, 7, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 3, 1, 2, 0, 1, 6, 1, null, null, null));
        jBLabel.setLabelFor((Component)extendableTextField);
        jBLabel2.setLabelFor((Component)editorTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c2 = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

