/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.session;

import com.intellij.database.DataBus;
import com.intellij.database.console.client.SessionClient;
import com.intellij.database.console.client.SessionClientHolder;
import com.intellij.database.datagrid.BridgeDataBus;
import com.intellij.database.datagrid.ConsoleLogger;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.audit.SessionLogger;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.LogViewController;
import com.intellij.database.run.session.LogViewOwner;
import com.intellij.database.run.session.Session;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import icons.DatabaseIcons;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class BaseLogView<S extends LogViewOwner>
implements LogView<S> {
    public static final String OUTPUT_CONTENT_ID = "Input";
    private final LanguageConsoleView myConsoleView;
    private final RunnerLayoutUi myUi;
    private final ConsoleLogger myHistoryLogger;
    private final LogViewController myController;
    private final Content myContent;
    private final BridgeDataBus myDataBus;
    private SyntaxHighlighter myHighlighter;

    public BaseLogView(@NotNull Project project, @NotNull LanguageConsoleView consoleView, @NotNull LogViewController controller, @NotNull S logOwner, @NotNull DataBus.Consuming bus) {
        if (project == null) {
            BaseLogView.$$$reportNull$$$0(0);
        }
        if (consoleView == null) {
            BaseLogView.$$$reportNull$$$0(1);
        }
        if (controller == null) {
            BaseLogView.$$$reportNull$$$0(2);
        }
        if (logOwner == null) {
            BaseLogView.$$$reportNull$$$0(3);
        }
        if (bus == null) {
            BaseLogView.$$$reportNull$$$0(4);
        }
        this.myController = controller;
        this.myConsoleView = consoleView;
        this.myDataBus = new BridgeDataBus(logOwner, bus);
        String title = this.getTitle();
        this.myUi = RunnerLayoutUi.Factory.getInstance((Project)project).create(controller.id(), title, title, (Disposable)this);
        this.myUi.getContentManager().addUiDataProvider((UiDataProvider)this);
        this.myContent = ContentFactory.getInstance().createContent(this.myUi.getComponent(), title, false);
        this.myContent.setIcon(DatabaseIcons.Table);
        ((ConsoleViewImpl)consoleView).setEmulateCarriageReturn(false);
        this.myHistoryLogger = this.createHistoryLogger(consoleView);
        SessionLogger sessionLogger = this.createAuditor();
        this.myDataBus.addAuditor((DataAuditor)sessionLogger);
        Disposer.register((Disposable)this, (Disposable)this.myConsoleView);
        Disposer.register((Disposable)this, () -> AppUIUtil.invokeOnEdt(() -> this.myUi.getComponent().removeAll()));
    }

    public void setTarget(@NotNull S target, @NotNull DataBus.Consuming bus) {
        if (target == null) {
            BaseLogView.$$$reportNull$$$0(5);
        }
        if (bus == null) {
            BaseLogView.$$$reportNull$$$0(6);
        }
        this.myDataBus.setOwner(target, bus);
    }

    @NotNull
    public S getTarget() {
        LogViewOwner logViewOwner = (LogViewOwner)this.myDataBus.getOwner();
        if (logViewOwner == null) {
            BaseLogView.$$$reportNull$$$0(7);
        }
        return (S)logViewOwner;
    }

    public boolean isShowing() {
        return this.isValid() && this.myUi.getComponent().isShowing();
    }

    @NotNull
    public ConsoleLogger getHistoryLogger() {
        ConsoleLogger consoleLogger = this.myHistoryLogger;
        if (consoleLogger == null) {
            BaseLogView.$$$reportNull$$$0(8);
        }
        return consoleLogger;
    }

    @NotNull
    public LanguageConsoleView getConsoleView() {
        LanguageConsoleView languageConsoleView = this.myConsoleView;
        if (languageConsoleView == null) {
            BaseLogView.$$$reportNull$$$0(9);
        }
        return languageConsoleView;
    }

    @NotNull
    public RunnerLayoutUi getUi() {
        RunnerLayoutUi runnerLayoutUi = this.myUi;
        if (runnerLayoutUi == null) {
            BaseLogView.$$$reportNull$$$0(10);
        }
        return runnerLayoutUi;
    }

    @NotNull
    public Content getContent() {
        Content content = this.myContent;
        if (content == null) {
            BaseLogView.$$$reportNull$$$0(11);
        }
        return content;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myConsoleView.getProject();
        if (project == null) {
            BaseLogView.$$$reportNull$$$0(12);
        }
        return project;
    }

    @NotNull
    @Nls
    public String getTitle() {
        String string = this.myConsoleView.getTitle();
        if (string == null) {
            BaseLogView.$$$reportNull$$$0(13);
        }
        return string;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            BaseLogView.$$$reportNull$$$0(14);
        }
        sink.set(Session.SESSION_KEY, (Object)((Session)ObjectUtils.tryCast(this.getTarget(), Session.class)));
        sink.set(SessionClientHolder.CLIENT_KEY, (Object)((SessionClient)ObjectUtils.tryCast(this.getTarget(), SessionClient.class)));
    }

    @NotNull
    public Promise<Void> show(boolean activate, boolean requestFocus, @Nullable LogView.OutputType outputType) {
        Promise promise = this.getTarget().isValid() ? this.myController.show((LogView)this, activate, requestFocus, outputType) : Promises.rejectedPromise();
        if (promise == null) {
            BaseLogView.$$$reportNull$$$0(15);
        }
        return promise;
    }

    public void beforeExecution() {
        EditorHighlighter highlighter = this.myConsoleView.getConsoleEditor().getHighlighter();
        this.myHighlighter = highlighter instanceof LexerEditorHighlighter ? ((LexerEditorHighlighter)highlighter).getSyntaxHighlighter() : null;
    }

    public void addRequestToHistory(@NotNull DataRequest.Context context) {
        String query;
        if (context == null) {
            BaseLogView.$$$reportNull$$$0(16);
        }
        if (StringUtil.isEmpty((String)(query = context.getQuery()))) {
            return;
        }
        LanguageConsoleView console = this.getConsoleView();
        this.updatePrompt(context);
        String prompt = console.getPrompt();
        if (StringUtil.isNotEmpty((String)prompt)) {
            ConsoleViewContentType type = (ConsoleViewContentType)ObjectUtils.notNull((Object)console.getPromptAttributes(), (Object)ConsoleViewContentType.USER_INPUT);
            console.print(DataSourceUtil.currentTime(), type);
            console.print(prompt, type);
        }
        String adjustedQuery = StringUtil.convertLineSeparators((String)query);
        if (this.myHighlighter != null) {
            ConsoleViewUtil.printWithHighlighting((ConsoleView)console, (String)adjustedQuery, (SyntaxHighlighter)this.myHighlighter, () -> this.onLineBreak(console));
        } else {
            console.print(adjustedQuery, ConsoleViewContentType.USER_INPUT);
        }
        console.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
    }

    protected void updatePrompt(@NotNull DataRequest.Context context) {
        if (context == null) {
            BaseLogView.$$$reportNull$$$0(17);
        }
    }

    protected void onLineBreak(@NotNull LanguageConsoleView console) {
        if (console == null) {
            BaseLogView.$$$reportNull$$$0(18);
        }
    }

    @Nullable
    public Content getOutputContent() {
        return this.getUi().findContent(OUTPUT_CONTENT_ID);
    }

    public void dispose() {
        ContentManager manager = this.getContent().getManager();
        if (manager != null) {
            manager.removeContent(this.getContent(), false);
        }
        Disposer.dispose((Disposable)this.getContent());
    }

    public void startLoading() {
        this.withLoadingPanel((Consumer<JBLoadingPanel>)((Consumer)p -> p.startLoading()));
    }

    public void stopLoading() {
        this.withLoadingPanel((Consumer<JBLoadingPanel>)((Consumer)p -> p.stopLoading()));
    }

    public void ensureContentInitialized() {
        if (this.myContent.getDisposer() != null) {
            return;
        }
        this.myContent.setDisposer(() -> Disposer.dispose(this.getTarget()));
        this.buildConsoleUi();
    }

    public boolean isValid() {
        return !this.getUi().isDisposed() && !this.getConsoleView().getHistoryViewer().isDisposed() && this.getConsoleView().getVirtualFile().isValid();
    }

    public boolean isEmpty() {
        return this.getConsoleView().getHistoryViewer().getDocument().getTextLength() == 0;
    }

    @NotNull
    public LogViewController getController() {
        LogViewController logViewController = this.myController;
        if (logViewController == null) {
            BaseLogView.$$$reportNull$$$0(19);
        }
        return logViewController;
    }

    @NotNull
    protected ConsoleLogger createHistoryLogger(@NotNull LanguageConsoleView consoleView) {
        if (consoleView == null) {
            BaseLogView.$$$reportNull$$$0(20);
        }
        return new ConsoleLogger((ConsoleView)consoleView);
    }

    @NotNull
    protected SessionLogger createAuditor() {
        return new SessionLogger((LogView)this);
    }

    private void withLoadingPanel(@NotNull Consumer<JBLoadingPanel> consumer) {
        Content content;
        JComponent component;
        if (consumer == null) {
            BaseLogView.$$$reportNull$$$0(21);
        }
        JComponent jComponent = component = (content = this.getOutputContent()) == null ? null : content.getComponent();
        if (!(component instanceof JBLoadingPanel)) {
            return;
        }
        JBLoadingPanel loadingPanel = (JBLoadingPanel)component;
        consumer.consume((Object)loadingPanel);
    }

    protected abstract void buildConsoleUi();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10, 11, 12, 13, 15, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logOwner";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/session/BaseLogView";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/session/BaseLogView";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryLogger";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleView";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUi";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "show";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTarget";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addRequestToHistory";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updatePrompt";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onLineBreak";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createHistoryLogger";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "withLoadingPanel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 10, 11, 12, 13, 15, 19 -> new IllegalStateException(string);
        };
    }
}

