/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DbGridEditGuard;
import com.intellij.database.run.ui.GridEditGuard;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.DatabaseBoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelperImpl;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.database.run.ui.grid.editors.RangeFormatResolver;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.database.run.ui.grid.editors.UnparsedValueWithDomain;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbGridCellEditorHelper
extends GridCellEditorHelperImpl {
    @NotNull
    public UnparsedValue createUnparsedValue(@NotNull String text, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable UnparsedValue.ParsingError error, @NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (text == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(1);
        }
        if (row == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(2);
        }
        if (column == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(3);
        }
        UnparsedValue unparsedValue = UnparsedValueWithDomain.create((String)text, (Domain)GridCellEditorsUtil.guessDomainForEditing(grid, row, column), (UnparsedValue.ParsingError)error);
        if (unparsedValue == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(4);
        }
        return unparsedValue;
    }

    public EnumSet<ReservedCellValue> getSpecialValues(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridColumn> column) {
        if (grid == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(5);
        }
        if (column == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(6);
        }
        DasColumn dasColumn = DataGridUtil.getDatabaseColumn(grid, column);
        return DbImplUtil.getSpecialValues((DasColumn)dasColumn, (Dbms)DataGridUtilCore.getDbms(grid));
    }

    public boolean isNullable(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridColumn> idx) {
        DasColumn column;
        if (grid == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(7);
        }
        if (idx == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(8);
        }
        return (column = DataGridUtil.getDatabaseColumn(grid, idx)) != null && !column.isNotNull();
    }

    @NotNull
    public List<String> getEnumValues(@NotNull CoreGrid<GridRow, GridColumn> grid, ModelIndex<GridColumn> column) {
        ModelHelper modelHelper;
        DataType dataType;
        List values;
        if (grid == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(9);
        }
        List list = values = (dataType = (modelHelper = DbImplUtil.getModelHelper((Dbms)DataGridUtilCore.getDbms(grid))).getDataTypeForGridCompletion(grid, column)) != null ? dataType.enumValues : null;
        List list2 = values != null ? ContainerUtil.map((Collection)values, arg_0 -> ((ModelHelper)modelHelper).unquoteEnumValue(arg_0)) : ContainerUtil.emptyList();
        if (list2 == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NotNull
    public BoundaryValueResolver getResolver(@NotNull CoreGrid<GridRow, GridColumn> grid, @Nullable ModelIndex<GridColumn> column) {
        if (grid == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(11);
        }
        GridModel model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        BoundaryValueResolver boundaryValueResolver = DatabaseBoundaryValueResolver.getResolver((Dbms)DataGridUtilCore.getDbms(grid), column == null ? null : (GridColumn)model.getColumn(column));
        if (boundaryValueResolver == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(12);
        }
        return boundaryValueResolver;
    }

    public boolean useBigDecimalWithPriorityType(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(13);
        }
        return DataGridUtilCore.getDbms(grid).is(Dbms.MONGO);
    }

    public boolean parseBigIntAsLong(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(14);
        }
        return DataGridUtilCore.getDbms(grid).is(Dbms.BIGQUERY);
    }

    public boolean useLenientFormatterForTemporalObjects(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Dbms dbms;
        if (grid == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(15);
        }
        if ((dbms = DataGridUtilCore.getDbms(grid)) != Dbms.MYSQL) {
            return dbms.is(Dbms.SQLITE) || dbms.is(Dbms.SNOWFLAKE);
        }
        DbDataSource system = DataGridUtilCore.getDatabaseSystem(grid);
        LocalDataSource dataSource = DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)system);
        return dataSource != null && dataSource.getExactDriverVersion().isOrGreater(new int[]{8});
    }

    public int guessJdbcTypeForEditing(@NotNull CoreGrid<GridRow, GridColumn> grid, @Nullable ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (grid == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(16);
        }
        if (column == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(17);
        }
        if (row != null && !row.isValid(grid) || !column.isValid(grid)) {
            return 1111;
        }
        Domain overriddenType = GridCellEditorsUtil.getOverriddenType(grid, row, column);
        if (overriddenType != null) {
            return ExtractorsUtil.guessJdbcType((Domain)overriddenType, (Dbms)DataGridUtilCore.getDbms(grid));
        }
        GridModel model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        GridColumn c2 = (GridColumn)model.getColumn(column);
        return c2 == null ? 1111 : ExtractorsUtil.guessJdbcType((GridColumn)c2, (Object)(row == null ? null : model.getValueAt(row, column)), (Dbms)DataGridUtilCore.getDbms(grid));
    }

    @Nullable
    public ReservedCellValue getDefaultNullValue(@NotNull CoreGrid<GridRow, GridColumn> grid, @Nullable ModelIndex<GridColumn> column) {
        GridColumn c2;
        if (grid == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(18);
        }
        GridColumn gridColumn = c2 = column == null ? null : (GridColumn)grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column);
        if (GridUtilCore.isRowId(c2)) {
            return ReservedCellValue.COMPUTED;
        }
        DasColumn dasColumn = DataGridUtilCore.getDatabaseColumn(grid, (GridColumn)c2);
        return DbImplUtil.getDefaultNullValue((DasColumn)dasColumn, (Dbms)DataGridUtilCore.getDbms(grid));
    }

    protected BiFunction<Object, Object, ThreeState> numberEquals(@Nullable GridDataHookUp<GridRow, GridColumn> hookUp, @Nullable CoreGrid<GridRow, GridColumn> grid) {
        return DataGridUtilCore.numberEqualsInner((Dbms)DbGridCellEditorHelper.getDbms(hookUp, grid));
    }

    @NotNull
    private static Dbms getDbms(@Nullable GridDataHookUp<GridRow, GridColumn> hookUp, @Nullable CoreGrid<GridRow, GridColumn> grid) {
        DatabaseGridDataHookUp dbHookUp = (DatabaseGridDataHookUp)ObjectUtils.tryCast(hookUp, DatabaseGridDataHookUp.class);
        Dbms dbms = dbHookUp != null ? dbHookUp.getDbms() : DataGridUtilCore.getDbms(grid);
        if (dbms == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(19);
        }
        return dbms;
    }

    @Nullable
    public Set<GridEditGuard> getEditGuards() {
        return EnumSet.allOf(DbGridEditGuard.class);
    }

    public static boolean areValuesEqual(Object v1, Object v2, @Nullable GridDataHookUp<GridRow, GridColumn> hookUp) {
        return GridCellEditorHelper.areValuesEqual((Object)v1, (Object)v2, (BiFunction)DataGridUtilCore.numberEqualsInner((Dbms)DbGridCellEditorHelper.getDbms(hookUp, null)));
    }

    @Nullable
    protected Formatter getDateFormat(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridColumn> columnIdx) {
        if (grid == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(20);
        }
        if (columnIdx == null) {
            DbGridCellEditorHelper.$$$reportNull$$$0(21);
        }
        Dbms dbms = DataGridUtilCore.getDbms(grid);
        GridColumn column = (GridColumn)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx);
        if (column == null) {
            return null;
        }
        ObjectFormatter converter = ((DataGrid)grid).getObjectFormatter();
        boolean isPostgresRange = dbms.isPostgres() && StringUtil.findIgnoreCase((String)column.getTypeName(), (String[])new String[]{"tstzrange", "tsrange"});
        FormatterCreator creator = FormatterCreator.get(grid);
        FormatsCache cache = FormatsCache.get(grid);
        if (isPostgresRange) {
            return RangeFormatResolver.resolveFormatter(converter, column, dbms, creator, cache);
        }
        if (DbImplUtilCore.isZonedTimestampColumn((ColumnDescriptor)column, (Dbms)dbms)) {
            return (Formatter)cache.get(FormatsCache.getZonedTimestampFormatProvider((GridColumn)column, null), creator);
        }
        if (DbImplUtilCore.isZonedTimeColumn((ColumnDescriptor)column, (Dbms)dbms)) {
            return (Formatter)cache.get(FormatsCache.getZonedTimeFormatProvider((GridColumn)column, null), creator);
        }
        return super.getDateFormat(grid, columnIdx);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 10, 12, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 3: 
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DbGridCellEditorHelper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idx";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DbGridCellEditorHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnparsedValue";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumValues";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolver";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUnparsedValue";
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 19: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSpecialValues";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isNullable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEnumValues";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getResolver";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "useBigDecimalWithPriorityType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseBigIntAsLong";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "useLenientFormatterForTemporalObjects";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "guessJdbcTypeForEditing";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultNullValue";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDateFormat";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 10, 12, 19 -> new IllegalStateException(string);
        };
    }
}

