/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.view;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.TreeTableWidthController;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.CpuProfilingView;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8SwitchViewActionsFactory;
import com.jetbrains.nodejs.run.profile.cpu.view.LineColorProvider;
import com.jetbrains.nodejs.run.profile.cpu.view.SearchInV8TreeAction;
import com.jetbrains.nodejs.run.profile.cpu.view.StatisticsTreeTableWithDetails;
import com.jetbrains.nodejs.run.profile.cpu.view.TopCalledV8TreeTableModel;
import com.jetbrains.nodejs.run.profile.cpu.view.TopCallsSelfDiagram;
import com.jetbrains.nodejs.run.profile.cpu.view.V8CpuNavigationAction;
import com.jetbrains.nodejs.run.profile.cpu.view.V8NavigateToFlameChartIntervalAction;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeComponent;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeTable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TopCallsV8ProfilingComponent
implements CpuProfilingView {
    public static final Supplier<@Nls String> TOP_CALLS = NodeJSBundle.messagePointer("profile.cpu.top_calls.title", new Object[0]);
    @Nls
    private String myErrorText;
    @NotNull
    private final Project myProject;
    @NotNull
    private final V8LogCachingReader myReader;
    @Nullable
    private final List<Pair<String, List<V8ProfileLine>>> myLines;
    private final Disposable myDisposable;
    private final Consumer<String> myNotificator;
    private V8ProfilingCallTreeTable myTable;
    private StatisticsTreeTableWithDetails myMasterDetails;
    private Factory<SearchInV8TreeAction.Searcher> myFactory;
    private V8SwitchViewActionsFactory myActionsFactory;

    public TopCallsV8ProfilingComponent(@NotNull Project project, @NotNull V8LogCachingReader reader, @Nullable List<Pair<String, List<V8ProfileLine>>> lines, @NotNull LineColorProvider fileColor, Disposable disposable, Consumer<String> notificator) throws IOException {
        if (project == null) {
            TopCallsV8ProfilingComponent.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            TopCallsV8ProfilingComponent.$$$reportNull$$$0(1);
        }
        if (fileColor == null) {
            TopCallsV8ProfilingComponent.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myReader = reader;
        this.myLines = lines;
        this.myDisposable = disposable;
        this.myNotificator = notificator;
        this.createMainComponent(fileColor);
        this.myMasterDetails.addDetails(new TopCallsSelfDiagram(this.myProject, this.myReader, fileColor, JBUIScale.scale((int)140)).getComponent(), null, NodeJSBundle.message("profile.top_call_diagram.title", new Object[0]), false);
    }

    @Override
    public V8ProfilingCallTreeTable getTreeTable() {
        return this.myTable;
    }

    @Override
    public void defaultExpand() {
        this.expand();
    }

    @Override
    public JComponent getMainComponent() {
        return this.myMasterDetails.getComponent();
    }

    @Override
    public String getName() {
        return TOP_CALLS.get();
    }

    @Override
    public void addActions(DefaultActionGroup group) {
        group.add(V8ProfilingCallTreeComponent.createEditSourceAction((JComponent)((Object)this.myTable)));
        group.add((AnAction)V8ProfilingCallTreeComponent.createFilterAction(this.myTable, NodeJSBundle.message("profile.cpu.top_call.total.filter.text", new Object[0]), () -> this.expand(), null));
        group.add((AnAction)new SearchInV8TreeAction(this.myProject, this.myMasterDetails, this.myReader, this.getSearcherFactory()));
        V8CpuNavigationAction navigationAction = new V8CpuNavigationAction();
        group.add((AnAction)navigationAction.addActions(new AnAction[]{this.myActionsFactory.getToBottomUp(), this.myActionsFactory.getToTopDown()}));
        V8NavigateToFlameChartIntervalAction.addToGroup(navigationAction.getGroup(), this.myReader, this.myNotificator);
    }

    @Override
    public void registerItself(V8SwitchViewActionsFactory factory) {
        this.myActionsFactory = factory;
        this.myActionsFactory.setTopCalls(this);
    }

    @Override
    public StatisticsTreeTableWithDetails getMasterDetails() {
        return this.myMasterDetails;
    }

    @Override
    public Factory<SearchInV8TreeAction.Searcher> getSearcherFactory() {
        if (this.myFactory != null) {
            return this.myFactory;
        }
        this.myFactory = () -> new SearchInV8TreeAction.Searcher(){
            private final TopCalledV8TreeTableModel myModel;
            private final MultiMap<String, Pair<V8ProfileLine, String>> myMap;
            private final List<V8CpuLogCall> myCalls;
            private final List<Long> myNumbers;
            {
                this.myModel = (TopCalledV8TreeTableModel)TopCallsV8ProfilingComponent.this.myTable.getTableModel();
                this.myMap = new MultiMap();
                this.myCalls = new ArrayList<V8CpuLogCall>();
                this.myNumbers = new ArrayList<Long>();
            }

            @Override
            public boolean search(@NotNull String text, boolean caseSensitive) {
                Map<V8ProfileLine, String> map;
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((map = this.myModel.search(text, caseSensitive)).isEmpty()) {
                    return false;
                }
                for (Map.Entry<V8ProfileLine, String> entry : map.entrySet()) {
                    String key2 = entry.getKey().getPresentation(false);
                    this.myMap.putValue((Object)key2, (Object)Pair.create((Object)entry.getKey(), (Object)entry.getValue()));
                }
                this.myCalls.addAll(ContainerUtil.map((Collection)this.myMap.keySet(), key -> ((V8ProfileLine)((Pair)this.myMap.get(key).iterator().next()).getFirst()).getCall()));
                this.myCalls.sort(Comparator.comparing(o -> o.getPresentation(false)));
                for (V8CpuLogCall call : this.myCalls) {
                    this.myNumbers.add(Long.valueOf(this.myMap.get((Object)call.getPresentation(false)).size()));
                }
                return true;
            }

            @Override
            public List<V8CpuLogCall> getUniqueCalls() {
                return this.myCalls;
            }

            @Override
            public List<Long> getNumbersOfCalls() {
                return this.myNumbers;
            }

            @Override
            public List<TreePath> getPathsToExpand(@NotNull V8CpuLogCall call) {
                if (call == null) {
                    1.$$$reportNull$$$0(1);
                }
                Collection pairs = this.myMap.get((Object)call.getPresentation(false));
                ArrayList<TreePath> list = new ArrayList<TreePath>();
                for (Pair pair : pairs) {
                    list.add(this.myModel.createPathToCall((String)pair.getSecond(), ((V8ProfileLine)pair.getFirst()).getCall().getStringId()));
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/view/TopCallsV8ProfilingComponent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "search";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getPathsToExpand";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        return this.myFactory;
    }

    @Override
    public String getError() {
        return this.myErrorText;
    }

    private void createMainComponent(@NotNull LineColorProvider fileColor) {
        if (fileColor == null) {
            TopCallsV8ProfilingComponent.$$$reportNull$$$0(3);
        }
        if (this.myLines == null) {
            this.myErrorText = NodeJSBundle.message("profile.cpu.fragment_not_found.error.text", new Object[0]);
            return;
        }
        TopCalledV8TreeTableModel model = new TopCalledV8TreeTableModel(this.myLines, fileColor);
        model.filterByLevel(10);
        this.myTable = new V8ProfilingCallTreeTable(this.myProject, model, this.myDisposable);
        V8ProfilingCallTreeComponent.adjustTable(this.myTable, () -> this.defaultExpand());
        TreeTableWidthController controller = new TreeTableWidthController(this.myTable, this.myDisposable);
        controller.setMeaningfulRenderer((TreeCellRenderer)((Object)model.getZeroRenderer()));
        this.myTable.setController(controller);
        this.myMasterDetails = new StatisticsTreeTableWithDetails(this.myProject, this.myTable, V8ProfilingCallTreeComponent.TREE_PATH_V8_LINE_CONVERTOR, this.myDisposable);
    }

    public void expand() {
        if (this.myTable != null) {
            TreeUtil.expandAll((JTree)this.myTable.getTree());
            int maxSelf = 0;
            int selectedRow = -1;
            for (int i = 0; i < this.myTable.getTree().getRowCount(); ++i) {
                TreePath treePath = this.myTable.getTree().getPathForRow(i);
                Object o = treePath.getLastPathComponent();
                if (!(o instanceof V8ProfileLine) || ((V8ProfileLine)o).getSelfTensPercent() <= maxSelf) continue;
                maxSelf = ((V8ProfileLine)o).getSelfTensPercent();
                selectedRow = i;
            }
            if (selectedRow >= 0) {
                this.myTable.clearSelection();
                this.myTable.addRowSelectionInterval(selectedRow, selectedRow);
            }
            V8ProfilingCallTreeComponent.scrollToSelectedRow(this.myTable);
            this.myTable.revalidate();
            this.myTable.repaint();
        }
    }

    public boolean navigateByStackTrace(@NotNull Long stackId) {
        TreePath call;
        if (stackId == null) {
            TopCallsV8ProfilingComponent.$$$reportNull$$$0(4);
        }
        if ((call = ((TopCalledV8TreeTableModel)this.myTable.getTableModel()).createPathToCall("JavaScript", stackId)) != null) {
            V8ProfilingCallTreeComponent.resetDataToTable(this.myTable, () -> {
                this.myTable.revalidate();
                this.myTable.repaint();
                this.myTable.getTree().expandPath(call.getParentPath());
            }, () -> {
                int row = this.myTable.getTree().getRowForPath(call);
                if (row >= 0) {
                    this.myTable.clearSelection();
                    this.myTable.addRowSelectionInterval(row, row);
                    V8ProfilingCallTreeComponent.scrollToSelectedRow(this.myTable);
                }
            });
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileColor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackId";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/view/TopCallsV8ProfilingComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createMainComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateByStackTrace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

