"use strict";
var mocha_1 = require("mocha");
var testEventsHandler_1 = require("../core/testEventsHandler");
var cypressSuitNode_1 = require("./cypressSuitNode");
var cypressTestNode_1 = require("./cypressTestNode");
var constants_1 = require("./constants");
/* eslint-disable @typescript-eslint/no-unused-vars */
var _a = mocha_1.Runner.constants, EVENT_HOOK_BEGIN = _a.EVENT_HOOK_BEGIN, EVENT_HOOK_END = _a.EVENT_HOOK_END, EVENT_RUN_BEGIN = _a.EVENT_RUN_BEGIN, EVENT_DELAY_BEGIN = _a.EVENT_DELAY_BEGIN, EVENT_DELAY_END = _a.EVENT_DELAY_END, EVENT_RUN_END = _a.EVENT_RUN_END, EVENT_SUITE_BEGIN = _a.EVENT_SUITE_BEGIN, EVENT_SUITE_END = _a.EVENT_SUITE_END, EVENT_TEST_BEGIN = _a.EVENT_TEST_BEGIN, EVENT_TEST_END = _a.EVENT_TEST_END, EVENT_TEST_FAIL = _a.EVENT_TEST_FAIL, EVENT_TEST_PASS = _a.EVENT_TEST_PASS, EVENT_TEST_PENDING = _a.EVENT_TEST_PENDING, EVENT_TEST_RETRY = _a.EVENT_TEST_RETRY, STATE_IDLE = _a.STATE_IDLE, STATE_RUNNING = _a.STATE_RUNNING, STATE_STOPPED = _a.STATE_STOPPED;
/* eslint-enable @typescript-eslint/no-unused-vars */
var CypressReporter = /** @class */ (function () {
    function CypressReporter(runner) {
        var _this = this;
        var testStructure = new testEventsHandler_1.default();
        runner
            .once(EVENT_RUN_BEGIN, function () {
            var rootSuite = runner.suite;
            while (!rootSuite.root)
                rootSuite = rootSuite.parent;
            testStructure.startTesting(new cypressSuitNode_1.default(rootSuite));
        })
            .on(EVENT_SUITE_BEGIN, function (suite) {
            testStructure.startSuite(new cypressSuitNode_1.default(suite));
        })
            .on(EVENT_SUITE_END, function (suite) {
            testStructure.finishSuite(new cypressSuitNode_1.default(suite));
        })
            .on(EVENT_TEST_PENDING, function (test) {
            testStructure.startTest(new cypressTestNode_1.default(test));
            testStructure.ignoreTest(new cypressTestNode_1.default(test));
        })
            .on(EVENT_TEST_BEGIN, function (test) {
            test[constants_1.TEST_STARTED_TIMESTAMP_INDEX] = performance.now();
            testStructure.startTest(new cypressTestNode_1.default(test));
        })
            .on(EVENT_TEST_PASS, function (test) {
            testStructure.finishTest(new cypressTestNode_1.default(test));
        })
            .on(EVENT_TEST_FAIL, function (test, err) {
            testStructure.finishTest(new cypressTestNode_1.default(test), _this.normalizeError(err));
        })
            .once(EVENT_RUN_END, function () {
            testStructure.finishTesting();
        });
    }
    CypressReporter.prototype.normalizeError = function (_a) {
        var name = _a.name, message = _a.message, stack = _a.stack;
        var newStack = stack.split(message, 2).pop();
        // Removes all ANSI colors/styles
        message = "".concat(name, ": ") + message.replace(/[\u001b\u009b][[()#;?]*(?:[0-9]{1,4}(?:;[0-9]{0,4})*)?[0-9A-ORZcf-nqry=><]/g, '');
        return {
            name: name,
            stack: newStack,
            message: message
        };
    };
    return CypressReporter;
}());
module.exports = CypressReporter;
//# sourceMappingURL=data:application/json;base64,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