import type {Connection} from "@volar/language-server"
import type {createServer} from "@volar/language-server/node"
import {URI} from "vscode-uri"
import {RequestType} from "vscode-jsonrpc/lib/common/messages"
import type {LspIdeTypeScriptCommandRequest} from "tsc-ide-plugin/protocol"
import {handleCustomTsServerCommand} from "./handle-custom-ts-server-command"
import {CancellationToken} from "vscode-jsonrpc/lib/common/cancellation"

export function addIjServerPlugin(ts: typeof import("tsc-ide-plugin/tsserverlibrary.shim"), connection: Connection, server: ReturnType<typeof createServer>) {
  async function getService(uri: string) {
    return (await server.project.getLanguageService(URI.parse(uri)));
  }

  connection.onRequest(new RequestType<LspIdeTypeScriptCommandRequest, any, any>('$/ij/handleCustomTsServerCommand'), async (params: LspIdeTypeScriptCommandRequest, cancellationToken: CancellationToken) => {
    const requestArgs = params.args
    return handleCustomTsServerCommand(ts, getService, cancellationToken, params.ideCommand, requestArgs);
  });
}