/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ps extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "ګرينويچ معياري وخت",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "اپیا معياري وخت",
               "",
               "اپيا د ورځې روښانه وخت",
               "",
               "اپیا وخت",
               "",
            };
        final String[] Cook = new String[] {
               "کوک ټاپوګانو معياري وخت",
               "",
               "کوک ټاپوګانو نيم اوړي وخت",
               "",
               "کوک ټاپوګانو وخت",
               "",
            };
        final String[] Cuba = new String[] {
               "کیوبا معياري وخت",
               "CST",
               "کیوبا د رڼا ورځې وخت",
               "CDT",
               "کيوبا وخت",
               "CT",
            };
        final String[] Fiji = new String[] {
               "فجی معياري وخت",
               "",
               "فجي د اوړي وخت",
               "",
               "فجی وخت",
               "",
            };
        final String[] Gulf = new String[] {
               "خلیج معياري وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "هاوډ معیاری وخت",
               "",
               "هاوډ اوړي وخت",
               "",
               "هاوډ وخت",
               "",
            };
        final String[] Iran = new String[] {
               "ایران معياري وخت",
               "",
               "ايران د ورځې روښانه وخت",
               "",
               "ایران وخت",
               "",
            };
        final String[] Niue = new String[] {
               "نییو وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "اومسک معياري وخت",
               "",
               "اومسک اوړي وخت",
               "",
               "اومسک وخت",
               "",
            };
        final String[] Peru = new String[] {
               "پیرو معياري وخت",
               "",
               "پیرو اوړي وخت",
               "",
               "پیرو وخت",
               "",
            };
        final String[] Truk = new String[] {
               "چوک وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "ويک تاپو وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "چلی معیاری وخت",
               "",
               "چلی اوړي وخت",
               "",
               "چلی وخت",
               "",
            };
        final String[] China = new String[] {
               "چین معیاري وخت",
               "CST",
               "د چين د رڼا ورځې وخت",
               "CDT",
               "چين وخت",
               "CT",
            };
        final String[] Cocos = new String[] {
               "کوکوز ټاپوګانو وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "ډيوس وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "هند معیاري وخت",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "جاپان معياري وخت",
               "JST",
               "جاپان د ورځې روښانه وخت",
               "JDT",
               "جاپان وخت",
               "JT",
            };
        final String[] Korea = new String[] {
               "کوريايي معياري وخت",
               "KST",
               "کوريايي د ورځې روښانه وخت",
               "KST",
               "کوريايي وخت",
               "KST",
            };
        final String[] Nauru = new String[] {
               "ناورو وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "نیپال وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "پالاو وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "سموا معياري وخت",
               "SST",
               "سموا د ورځې روښانه وخت",
               "SST",
               "سموا وخت",
               "SST",
            };
        final String[] Syowa = new String[] {
               "سیوا وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "د ټونګ معياري وخت",
               "",
               "ټونګا اوړي وخت",
               "",
               "ټونګا وخت",
               "",
            };
        final String[] Yukon = new String[] {
               "د یوکون وخت",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "الاسکا معياري وخت",
               "AKST",
               "الاسکا د ورځې روښانه وخت",
               "AKDT",
               "الاسکا وخت",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "ایمیزون معیاری وخت",
               "",
               "ایمیزون اوړي وخت",
               "",
               "ایمیزون وخت",
               "",
            };
        final String[] Azores = new String[] {
               "ايزورس معياري وخت",
               "",
               "ايزورس اوړي وخت",
               "",
               "ايزورس وخت",
               "",
            };
        final String[] Bhutan = new String[] {
               "بهوټان وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "برونايي دارالسلام وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ايستر ټاپو معياري وخت",
               "",
               "ايستر ټاپو اوړي وخت",
               "",
               "ايستر ټاپو وخت",
               "",
            };
        final String[] Guyana = new String[] {
               "د ګوانانا وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "هوایی الیوتین معیاری وخت",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "اسراییل معياري وخت",
               "IST",
               "اسراييل د ورځې روښانه وخت",
               "IDT",
               "اسراییل وخت",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "کوسراي وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "ماوسن وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "ماسکو معياري وخت",
               "MSK",
               "ماسکو سمر وخت",
               "MSK",
               "ماسکو وخت",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "پونيپ وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "ټهيټي وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "تايپي معياري وخت",
               "CST",
               "تايپي د ورځې روښانه وخت",
               "CDT",
               "تايپي وخت",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "تووالو وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "واستوک وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "والس او فوتونا وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "عربي معیاري وخت",
               "",
               "عربي د ورځې روښانه وخت",
               "",
               "عربي وخت",
               "",
            };
        final String[] Armenia = new String[] {
               "ارمنستان معياري وخت",
               "",
               "ارمنستان اوړي وخت",
               "",
               "ارمنستان وخت",
               "",
            };
        final String[] Bolivia = new String[] {
               "بولیویا وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "چاتام معياري وخت",
               "",
               "چاتام د ورځې روښانه وخت",
               "",
               "چاتام وخت",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "همغږى نړیوال وخت",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "د اکوادور وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "ګيمبير وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "جورجیا معیاري وخت",
               "",
               "د جورجيا د اوړي وخت",
               "",
               "جورجیا وخت",
               "",
            };
        final String[] Irkutsk = new String[] {
               "ارکوټسک معياري وخت",
               "",
               "ارکوټسک اوړي وخت",
               "",
               "ارکوټسک وخت",
               "",
            };
        final String[] Magadan = new String[] {
               "ميګډان معياري وخت",
               "",
               "ميګډان اوړي وخت",
               "",
               "ميګډان وخت",
               "",
            };
        final String[] Myanmar = new String[] {
               "میانمار وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "د نورفکاس ټاپو معياري وخت",
               "",
               "د نورفکاس ټاپو اوړي وخت",
               "",
               "نورفوک ټاپو وخت",
               "",
            };
        final String[] Noronha = new String[] {
               "فرنانڈو دي نورونها معیاری وخت",
               "",
               "فرنانڈو دي نورونھا اوړي وخت",
               "",
               "فرنانڈو دي نورونها وخت",
               "",
            };
        final String[] Reunion = new String[] {
               "ري يونين وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "رودرا وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "سلیمان ټاپوګانو وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "توکیلاو وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "یوروګوای معياري وخت",
               "",
               "یوروګوای اوړي وخت",
               "",
               "یوروګوای وخت",
               "",
            };
        final String[] Vanuatu = new String[] {
               "ونواتو معياري وخت",
               "",
               "ونواتو اوړي وخت",
               "",
               "د وناتو وخت",
               "",
            };
        final String[] Yakutsk = new String[] {
               "ياکوټسک معياري وخت",
               "",
               "ياکوټسک د اوړي وخت",
               "",
               "ياکوټسک وخت",
               "",
            };
        final String[] Atlantic = new String[] {
               "اتلانتیک معياري وخت",
               "AST",
               "اتلانتیک د رڼا ورځې وخت",
               "AST",
               "اتلانتیک وخت",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "برسلیا معیاری وخت",
               "",
               "برسلیا اوړي وخت",
               "",
               "برسلیا وخت",
               "",
            };
        final String[] Chamorro = new String[] {
               "چمارو معياري وخت",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "کولمبیا معیاری وخت",
               "",
               "کولمبیا اوړي وخت",
               "",
               "کولمبیا وخت",
               "",
            };
        final String[] Falkland = new String[] {
               "د فوکلنډ ټاپو معیاری وخت",
               "",
               "د فوکلنډ ټاپو اوړي وخت",
               "",
               "فوکلنډ ټاپو وخت",
               "",
            };
        final String[] Malaysia = new String[] {
               "ملائیشیا وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "مالديپ وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "اولان باټر معیاري وخت",
               "",
               "اولان باټر اوړي وخت",
               "",
               "اولان باټر وخت",
               "",
            };
        final String[] Pakistan = new String[] {
               "پاکستان معیاري وخت",
               "PKT",
               "پاکستان اوړي وخت",
               "PKST",
               "پاکستان وخت",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "پیراګوای معياري وخت",
               "",
               "پاراګوای اوړي وخت",
               "",
               "پيراګوای وخت",
               "",
            };
        final String[] Pitcairn = new String[] {
               "پیټ کارین وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "سورینام وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "ارجنټاین معیاری وخت",
               "",
               "ارجنټاین اوړي وخت",
               "",
               "ارجنټاین وخت",
               "",
            };
        final String[] Christmas = new String[] {
               "کريسمس ټاپو وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "ګالپګوس وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "هانګ کانګ معياري وخت",
               "HKT",
               "هانګ کانګ اوړي وخت",
               "HKST",
               "هانګ کانګ وخت",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "انډوچاینه وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "کرغیزستان وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "لارډ هوي معياري وخت",
               "",
               "لارډ هوي د ورځې روښانه وخت",
               "",
               "لارډ هوي وخت",
               "",
            };
        final String[] Marquesas = new String[] {
               "مارکسس وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "ماریشیس معياري وخت",
               "",
               "ماريشيس د اوړي وخت",
               "",
               "ماريشيس وخت",
               "",
            };
        final String[] Singapore = new String[] {
               "سنګاپور معیاري وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "وینزویلا وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "آذربايجان معياري وخت",
               "",
               "اذرباییجان اوړي وخت",
               "",
               "د آذربايجان وخت",
               "",
            };
        final String[] Bangladesh = new String[] {
               "بنګلادیش معیاري وخت",
               "",
               "بنګله ديش اوړي وخت",
               "",
               "بنگله دېش وخت",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "کیپ وردډ معياري وخت",
               "",
               "کیپ وردډ سمر وخت",
               "",
               "کیپ وردډ وخت",
               "",
            };
        final String[] East_Timor = new String[] {
               "ختيځ تيمور وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "قزاقستان وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "سیچیلس وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "تاجکستان وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "ازبکستان معياري وخت",
               "",
               "ازبکستان اوړي وخت",
               "",
               "ازبکستان وخت",
               "",
            };
        final String[] Afghanistan = new String[] {
               "افغانستان وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "کريسنويارسک معياري وخت",
               "",
               "کريسنويارسک اوړي وخت",
               "",
               "کريسنويارسک وخت",
               "",
            };
        final String[] New_Zealand = new String[] {
               "نيوزي لېنډ معياري وخت",
               "NZST",
               "نيوزي لېنډ د ورځې روښانه وخت",
               "NZDT",
               "نيوزي لېنډ وخت",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "فلپاين معياري وخت",
               "PST",
               "فلپاين اوړي وخت",
               "PDT",
               "فلپاين وخت",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "ولاديوستاک معياري وخت",
               "",
               "ولاديوستاک اوړي وخت",
               "",
               "ولادیوستاک وخت",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "د هند سمندر وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "لاين ټاپوګانو وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "د نوي فیلډلینډ معیاری وخت",
               "NST",
               "نيو فاونډلېنډ د ورځې روښانه وخت",
               "NDT",
               "نيو فاونډلېنډ وخت",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "ترکمنستان معياري وخت",
               "",
               "ترکمنستان اوړي وخت",
               "",
               "ترکمانستان وخت",
               "",
            };
        final String[] French_Guiana = new String[] {
               "د فرانسوي ګانا وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "نيو کالیډونیا معياري وخت",
               "",
               "نيو کايډونيا اوړي وخت",
               "",
               "نیو کالیډونیا وخت",
               "",
            };
        final String[] South_Georgia = new String[] {
               "د سویل جورجیا وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "د ياکيټرنبرګ معياري وخت",
               "",
               "د ياکټرنبرګ د اوړي وخت",
               "",
               "یکاټیرینبرګ وخت",
               "",
            };
        final String[] Africa_Central = new String[] {
               "منځنی افريقا وخت",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "ختيځ افريقا وخت",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "لوېديځ افريقا وخت",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "ډومونټ ډي ارول",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "د مرکزي اروپا معیاري وخت",
               "CET",
               "مرکزي اروپايياوړي وخت",
               "CEST",
               "مرکزي اروپايي وخت",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "ختيځ اروپايي معياري وخت",
               "EET",
               "ختيځ اروپايي اوړي وخت",
               "EEST",
               "ختيځ اروپايي وخت",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "لوېديځ اروپايي معياري وخت",
               "WET",
               "لوېديځ اروپايي اوړي وخت",
               "WEST",
               "لوېديځ اروپايي وخت",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "مکسیکن پیسفک معیاری وخت",
               "MST",
               "مکسیکن پیسفک رڼا ورځې وخت",
               "MDT",
               "مکسیکن پیسفک وخت",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "جنوبي افريقا معياري وخت",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "مرکزي معياري وخت",
               "CST",
               "مرکزي د ورځې روښانه وخت",
               "CDT",
               "مرکزي وخت",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "ختيځ معياري وخت",
               "EST",
               "ختيځ د رڼا ورځې وخت",
               "EST",
               "ختیځ وخت",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "د پیسفک معياري وخت",
               "PST",
               "پیسفک د رڼا ورځې وخت",
               "PDT",
               "پیسفک وخت",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "د فرانسې سویل او انټارټيک وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "جلبرټ ټاپوګانو وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "هوایی الیوتین معیاری وخت",
               "HST",
               "هوایی الیوتین رڼا ورځې وخت",
               "HDT",
               "هوایی الیوتین وخت",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "د فینکس ټاپو وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "سینټ پییرا و ميکلين معیاری وخت",
               "",
               "سینټ پییرا و ميکلين رڼا ورځې وخت",
               "",
               "سینټ پییرا و ميکلين وخت",
               "",
            };
        final String[] America_Mountain = new String[] {
               "د غره معياري وخت",
               "MST",
               "د غره د رڼا ورځې وخت",
               "MST",
               "د غره د وخت",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "مارشل ټاپوګانو وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "پاپوا نیو ګنی وخت",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "آسترالوي مرکزي معياري وخت",
               "ACST",
               "آسترالوي مرکزي د ورځې روښانه وخت",
               "ACDT",
               "مرکزي آستراليا وخت",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "آسترالوي ختيځ معياري وخت",
               "AEST",
               "آسترالوي ختيځ د ورځې روښانه وخت",
               "AEDT",
               "ختيځ آستراليا وخت",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "آسترالوي لوېديځ معياري وخت",
               "AWST",
               "آسترالوي لوېديځ د ورځې روښانه وخت",
               "AWDT",
               "لوېديځ آستراليا وخت",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "مرکزي ادونيزيا وخت",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "اندونیزیا وخت",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "لویدیځ اندونیزیا وخت",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "آسترالوي مرکزي لوېديځ معياري وخت",
               "",
               "آسترالوي مرکزي لوېديځ د ورځې روښانه وخت",
               "",
               "آسترالوي مرکزي لوېديځ وخت",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "ګرينويچ معياري وخت",
                    "GMT",
                    "بريتانوي د اوړي وخت",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "همغږى نړیوال وخت",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "ګرينويچ معياري وخت",
                    "GMT",
                    "آيرش معياري وخت",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "همغږى نړیوال وخت",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "همغږى نړیوال وخت",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "ګرينويچ معياري وخت",
                    "GMT",
                    "بريتانوي د اوړي وخت",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "همغږى نړیوال وخت",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "همغږى نړیوال وخت",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "همغږى نړیوال وخت",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "ګرينويچ معياري وخت",
                    "GMT",
                    "آيرش معياري وخت",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "ګرينويچ معياري وخت",
                    "GMT",
                    "بريتانوي د اوړي وخت",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "ګرينويچ معياري وخت",
                    "GMT",
                    "بريتانوي د اوړي وخت",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "ګرينويچ معياري وخت",
                    "GMT",
                    "بريتانوي د اوړي وخت",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "ګرينويچ معياري وخت",
                    "GMT",
                    "بريتانوي د اوړي وخت",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "ګرينويچ معياري وخت",
                    "GMT",
                    "بريتانوي د اوړي وخت",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "اډن" },
            { "timezone.excity.Asia/Baku", "باکو" },
            { "timezone.excity.Asia/Dili", "دلي" },
            { "timezone.excity.Asia/Gaza", "غزه" },
            { "timezone.excity.Asia/Hovd", "هاوډ" },
            { "timezone.excity.Asia/Omsk", "اومسک" },
            { "timezone.excity.Asia/Oral", "اورل" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "اممان" },
            { "timezone.excity.Asia/Aqtau", "اکټاو" },
            { "timezone.excity.Asia/Chita", "چيتا" },
            { "timezone.excity.Asia/Dhaka", "ډهاکه" },
            { "timezone.excity.Asia/Dubai", "دوبی" },
            { "timezone.excity.Asia/Kabul", "کابل" },
            { "timezone.excity.Asia/Macau", "مکاو" },
            { "timezone.excity.Asia/Qatar", "قطر" },
            { "timezone.excity.Asia/Seoul", "سیول" },
            { "timezone.excity.Asia/Tokyo", "ټوکیو" },
            { "timezone.excity.Asia/Tomsk", "توماس" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "جوبا" },
            { "timezone.excity.Africa/Lome", "لووم" },
            { "timezone.excity.Asia/Almaty", "الماتی" },
            { "timezone.excity.Asia/Anadyr", "اناډير" },
            { "timezone.excity.Asia/Aqtobe", "اکتوب" },
            { "timezone.excity.Asia/Atyrau", "اېټراو" },
            { "timezone.excity.Asia/Beirut", "بیروت" },
            { "timezone.excity.Asia/Brunei", "برویني" },
            { "timezone.excity.Asia/Hebron", "هبرون" },
            { "timezone.excity.Asia/Kuwait", "کوېت" },
            { "timezone.excity.Asia/Manila", "منیلا" },
            { "timezone.excity.Asia/Muscat", "مسقط" },
            { "timezone.excity.Asia/Riyadh", "رياض" },
            { "timezone.excity.Asia/Saigon", "هو چي من ښار" },
            { "timezone.excity.Asia/Taipei", "تايپي" },
            { "timezone.excity.Asia/Tehran", "تهران" },
            { "timezone.excity.Asia/Urumqi", "اورومقي" },
            { "timezone.excity.Etc/Unknown", "نامعلوم ښار" },
            { "timezone.excity.Europe/Kiev", "کیف" },
            { "timezone.excity.Europe/Oslo", "اوسلو" },
            { "timezone.excity.Europe/Riga", "ريګا" },
            { "timezone.excity.Europe/Rome", "روم" },
            { "timezone.excity.Indian/Mahe", "ماهي" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "اکرا" },
            { "timezone.excity.Africa/Cairo", "قاهره" },
            { "timezone.excity.Africa/Ceuta", "سيوټا" },
            { "timezone.excity.Africa/Dakar", "ډاکار" },
            { "timezone.excity.Africa/Lagos", "لاگوس" },
            { "timezone.excity.Africa/Tunis", "تونس" },
            { "timezone.excity.America/Adak", "اداک" },
            { "timezone.excity.America/Lima", "لیما" },
            { "timezone.excity.America/Nome", "نوم" },
            { "timezone.excity.Asia/Baghdad", "بغداد" },
            { "timezone.excity.Asia/Bahrain", "بحرین" },
            { "timezone.excity.Asia/Bangkok", "بنکاک" },
            { "timezone.excity.Asia/Barnaul", "برنول" },
            { "timezone.excity.Asia/Bishkek", "بشکیک" },
            { "timezone.excity.Asia/Colombo", "کولمبو" },
            { "timezone.excity.Asia/Irkutsk", "ارکوټسک" },
            { "timezone.excity.Asia/Jakarta", "جکارتا" },
            { "timezone.excity.Asia/Karachi", "کراچي" },
            { "timezone.excity.Asia/Kuching", "کوچنګ" },
            { "timezone.excity.Asia/Magadan", "مګدان" },
            { "timezone.excity.Asia/Nicosia", "نیکوسیا" },
            { "timezone.excity.Asia/Rangoon", "یانګون" },
            { "timezone.excity.Asia/Tbilisi", "تبلیسي" },
            { "timezone.excity.Asia/Thimphu", "تهيمفو" },
            { "timezone.excity.Asia/Yakutsk", "ياکوټسک" },
            { "timezone.excity.Asia/Yerevan", "يريوان" },
            { "timezone.excity.Europe/Kirov", "کیروف" },
            { "timezone.excity.Europe/Malta", "مالټا" },
            { "timezone.excity.Europe/Minsk", "منسک" },
            { "timezone.excity.Europe/Paris", "پاریس" },
            { "timezone.excity.Europe/Sofia", "صوفیا" },
            { "timezone.excity.Europe/Vaduz", "واډوز" },
            { "timezone.excity.Indian/Cocos", "کوکوز" },
            { "timezone.excity.Pacific/Apia", "اپیا" },
            { "timezone.excity.Pacific/Fiji", "فجي" },
            { "timezone.excity.Pacific/Guam", "ګوام" },
            { "timezone.excity.Pacific/Niue", "نیوو" },
            { "timezone.excity.Pacific/Truk", "چوک" },
            { "timezone.excity.Pacific/Wake", "ویک" },
            { "timezone.excity.Africa/Asmera", "اسماره" },
            { "timezone.excity.Africa/Bamako", "بامیکو" },
            { "timezone.excity.Africa/Bangui", "بانګوي" },
            { "timezone.excity.Africa/Banjul", "بانجول" },
            { "timezone.excity.Africa/Bissau", "بساؤ" },
            { "timezone.excity.Africa/Douala", "دوالا" },
            { "timezone.excity.Africa/Harare", "هرارې" },
            { "timezone.excity.Africa/Kigali", "کيگالي" },
            { "timezone.excity.Africa/Luanda", "لونده" },
            { "timezone.excity.Africa/Lusaka", "لوساکا" },
            { "timezone.excity.Africa/Malabo", "مالابو" },
            { "timezone.excity.Africa/Maputo", "ماپوټو" },
            { "timezone.excity.Africa/Maseru", "مسيرو" },
            { "timezone.excity.Africa/Niamey", "نیمي" },
            { "timezone.excity.America/Aruba", "آروبا" },
            { "timezone.excity.America/Bahia", "بهیا" },
            { "timezone.excity.America/Belem", "بلم" },
            { "timezone.excity.America/Boise", "بوز" },
            { "timezone.excity.America/Jujuy", "جوجوي" },
            { "timezone.excity.America/Sitka", "سیټکا" },
            { "timezone.excity.America/Thule", "تول" },
            { "timezone.excity.Asia/Ashgabat", "اشغ آباد" },
            { "timezone.excity.Asia/Calcutta", "کولکته" },
            { "timezone.excity.Asia/Damascus", "دمشق" },
            { "timezone.excity.Asia/Dushanbe", "دوشنبي" },
            { "timezone.excity.Asia/Jayapura", "جاياپورا" },
            { "timezone.excity.Asia/Katmandu", "کټمنډو" },
            { "timezone.excity.Asia/Khandyga", "خنديګا" },
            { "timezone.excity.Asia/Makassar", "مکاسار" },
            { "timezone.excity.Asia/Qostanay", "کوستانې" },
            { "timezone.excity.Asia/Sakhalin", "سخالين" },
            { "timezone.excity.Asia/Shanghai", "شنگھائی" },
            { "timezone.excity.Asia/Tashkent", "تاشقند" },
            { "timezone.excity.Asia/Ust-Nera", "اوستنيرا" },
            { "timezone.excity.Europe/Athens", "ايتنز" },
            { "timezone.excity.Europe/Berlin", "برلن" },
            { "timezone.excity.Europe/Dublin", "ډبلن" },
            { "timezone.excity.Europe/Jersey", "جرسی" },
            { "timezone.excity.Europe/Lisbon", "لیسبون" },
            { "timezone.excity.Europe/London", "لندن" },
            { "timezone.excity.Europe/Madrid", "میډریډ" },
            { "timezone.excity.Europe/Monaco", "موناکو" },
            { "timezone.excity.Europe/Moscow", "ماسکو" },
            { "timezone.excity.Europe/Prague", "پراګ" },
            { "timezone.excity.Europe/Samara", "سمارا" },
            { "timezone.excity.Europe/Skopje", "سکپوګ" },
            { "timezone.excity.Europe/Tirane", "تيران" },
            { "timezone.excity.Europe/Vienna", "ویانا" },
            { "timezone.excity.Europe/Warsaw", "وارسا" },
            { "timezone.excity.Europe/Zagreb", "زګرب" },
            { "timezone.excity.Europe/Zurich", "زریچ" },
            { "timezone.excity.Indian/Chagos", "چاګوس" },
            { "timezone.excity.Indian/Comoro", "کومورو" },
            { "timezone.excity.Pacific/Efate", "عفات" },
            { "timezone.excity.Pacific/Nauru", "نایرو" },
            { "timezone.excity.Pacific/Palau", "پلاو" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "ابيجان" },
            { "timezone.excity.Africa/Algiers", "الجييرز" },
            { "timezone.excity.Africa/Conakry", "کونکري" },
            { "timezone.excity.Africa/Kampala", "کمپاله" },
            { "timezone.excity.Africa/Mbabane", "مبابانې" },
            { "timezone.excity.Africa/Nairobi", "نايروبي" },
            { "timezone.excity.Africa/Tripoli", "تريپولي" },
            { "timezone.excity.America/Belize", "بلیز" },
            { "timezone.excity.America/Bogota", "بوګټا" },
            { "timezone.excity.America/Cancun", "کينکن" },
            { "timezone.excity.America/Cayman", "کیمن" },
            { "timezone.excity.America/Cuiaba", "کویابا" },
            { "timezone.excity.America/Dawson", "داوسن" },
            { "timezone.excity.America/Denver", "ډنور" },
            { "timezone.excity.America/Guyana", "ګیانا" },
            { "timezone.excity.America/Havana", "هوانا" },
            { "timezone.excity.America/Inuvik", "انوک" },
            { "timezone.excity.America/Juneau", "جونو" },
            { "timezone.excity.America/La_Paz", "لا پاز" },
            { "timezone.excity.America/Maceio", "ماسيو" },
            { "timezone.excity.America/Manaus", "مناوس" },
            { "timezone.excity.America/Merida", "ميريډا" },
            { "timezone.excity.America/Nassau", "نیساو" },
            { "timezone.excity.America/Panama", "پاناما" },
            { "timezone.excity.America/Recife", "ریسیفي" },
            { "timezone.excity.America/Regina", "ریګینا" },
            { "timezone.excity.Asia/Famagusta", "فاماګستا" },
            { "timezone.excity.Asia/Hong_Kong", "هانګ کانګ" },
            { "timezone.excity.Asia/Jerusalem", "يروشلم" },
            { "timezone.excity.Asia/Kamchatka", "کامچاتکا" },
            { "timezone.excity.Asia/Pontianak", "پونټینیک" },
            { "timezone.excity.Asia/Pyongyang", "پيانګ يانګ" },
            { "timezone.excity.Asia/Qyzylorda", "قيزي لورډا" },
            { "timezone.excity.Asia/Samarkand", "سمرقند" },
            { "timezone.excity.Asia/Singapore", "سینګاپور" },
            { "timezone.excity.Asia/Vientiane", "وينټين" },
            { "timezone.excity.Europe/Andorra", "اندورا" },
            { "timezone.excity.Europe/Saratov", "سراتف" },
            { "timezone.excity.Europe/Tallinn", "تالين" },
            { "timezone.excity.Europe/Vatican", "ویټیکان" },
            { "timezone.excity.Europe/Vilnius", "ويلنيوس" },
            { "timezone.excity.Indian/Mayotte", "میټوت" },
            { "timezone.excity.Indian/Reunion", "ري يونين" },
            { "timezone.excity.Pacific/Easter", "ایسټر" },
            { "timezone.excity.Pacific/Kosrae", "کوسراي" },
            { "timezone.excity.Pacific/Majuro", "مجورو" },
            { "timezone.excity.Pacific/Midway", "ميډوی" },
            { "timezone.excity.Pacific/Noumea", "نوميا" },
            { "timezone.excity.Pacific/Ponape", "پونپي" },
            { "timezone.excity.Pacific/Saipan", "سيپان" },
            { "timezone.excity.Pacific/Tahiti", "ټهيټي" },
            { "timezone.excity.Pacific/Tarawa", "تاراوا" },
            { "timezone.excity.Pacific/Wallis", "والس" },
            { "timezone.excity.Africa/Blantyre", "بلنټاير" },
            { "timezone.excity.Africa/Djibouti", "جبوتي" },
            { "timezone.excity.Africa/El_Aaiun", "الیون" },
            { "timezone.excity.Africa/Freetown", "فریټون" },
            { "timezone.excity.Africa/Gaborone", "ګابرون" },
            { "timezone.excity.Africa/Khartoum", "خرتوم" },
            { "timezone.excity.Africa/Kinshasa", "کينشاسا" },
            { "timezone.excity.Africa/Monrovia", "مونروفیا" },
            { "timezone.excity.Africa/Ndjamena", "نجامینا" },
            { "timezone.excity.Africa/Sao_Tome", "ساو ټوم" },
            { "timezone.excity.Africa/Windhoek", "وینهوک" },
            { "timezone.excity.America/Antigua", "انټيګ" },
            { "timezone.excity.America/Caracas", "کاراکاس" },
            { "timezone.excity.America/Cayenne", "کیین" },
            { "timezone.excity.America/Chicago", "شیکاګو" },
            { "timezone.excity.America/Cordoba", "کورډوبا" },
            { "timezone.excity.America/Creston", "کرسټون" },
            { "timezone.excity.America/Curacao", "کوراکاؤ" },
            { "timezone.excity.America/Detroit", "ډایټروټ" },
            { "timezone.excity.America/Godthab", "نووک" },
            { "timezone.excity.America/Grenada", "ګرنادا" },
            { "timezone.excity.America/Halifax", "هیلفکس" },
            { "timezone.excity.America/Iqaluit", "اقلیټ" },
            { "timezone.excity.America/Jamaica", "جمایکه" },
            { "timezone.excity.America/Managua", "منګوا" },
            { "timezone.excity.America/Marigot", "ميريګاټ" },
            { "timezone.excity.America/Mendoza", "مینډوزا" },
            { "timezone.excity.America/Moncton", "مونکټون" },
            { "timezone.excity.America/Noronha", "نورونها" },
            { "timezone.excity.America/Ojinaga", "اوجنګا" },
            { "timezone.excity.America/Phoenix", "فینکس" },
            { "timezone.excity.America/Tijuana", "تجوانا" },
            { "timezone.excity.America/Toronto", "ټورنټو" },
            { "timezone.excity.America/Tortola", "ټورتولا" },
            { "timezone.excity.America/Yakutat", "ياکوټټ" },
            { "timezone.excity.Asia/Phnom_Penh", "پنوم پن" },
            { "timezone.excity.Atlantic/Azores", "ايزورس" },
            { "timezone.excity.Atlantic/Canary", "کناري" },
            { "timezone.excity.Atlantic/Faeroe", "فارو" },
            { "timezone.excity.Australia/Eucla", "ايوکلا" },
            { "timezone.excity.Australia/Perth", "پرت" },
            { "timezone.excity.Europe/Belgrade", "بلغاد" },
            { "timezone.excity.Europe/Brussels", "بروسلز" },
            { "timezone.excity.Europe/Budapest", "بداپسټ" },
            { "timezone.excity.Europe/Busingen", "بوسينجن" },
            { "timezone.excity.Europe/Chisinau", "چیسینو" },
            { "timezone.excity.Europe/Guernsey", "ګرنسي" },
            { "timezone.excity.Europe/Helsinki", "هیلسنکی" },
            { "timezone.excity.Europe/Istanbul", "استنبول" },
            { "timezone.excity.Europe/Sarajevo", "سيراجيوا" },
            { "timezone.excity.Indian/Maldives", "مالديپ" },
            { "timezone.excity.Pacific/Chatham", "چاتام" },
            { "timezone.excity.Pacific/Fakaofo", "فوکافو" },
            { "timezone.excity.Pacific/Gambier", "ګيمبير" },
            { "timezone.excity.Pacific/Norfolk", "نورفک" },
            { "timezone.excity.Africa/Bujumbura", "بجوګورا" },
            { "timezone.excity.Africa/Mogadishu", "موگديشو" },
            { "timezone.excity.America/Anguilla", "انګیلا" },
            { "timezone.excity.America/Asuncion", "اسونسيون" },
            { "timezone.excity.America/Barbados", "باربادوس" },
            { "timezone.excity.America/Dominica", "دومینیکا" },
            { "timezone.excity.America/Edmonton", "ایډمونټن" },
            { "timezone.excity.America/Eirunepe", "اییرونپ" },
            { "timezone.excity.America/Mazatlan", "مزاتلان" },
            { "timezone.excity.America/Miquelon", "ميکويلان" },
            { "timezone.excity.America/New_York", "نیویارک" },
            { "timezone.excity.America/Resolute", "ريسالوټ" },
            { "timezone.excity.America/Santarem", "سناترم" },
            { "timezone.excity.America/Santiago", "سنتياګو" },
            { "timezone.excity.America/St_Johns", "سینټ جانز" },
            { "timezone.excity.America/St_Kitts", "سینټ کټس" },
            { "timezone.excity.America/St_Lucia", "سینټ لوسیا" },
            { "timezone.excity.America/Winnipeg", "وینپیګ" },
            { "timezone.excity.Antarctica/Casey", "کیسي" },
            { "timezone.excity.Antarctica/Davis", "ډيوس" },
            { "timezone.excity.Antarctica/Syowa", "سیوا" },
            { "timezone.excity.Antarctica/Troll", "ټرول" },
            { "timezone.excity.Asia/Krasnoyarsk", "کريسنويارسک" },
            { "timezone.excity.Asia/Novosibirsk", "نووسيبرسک" },
            { "timezone.excity.Asia/Ulaanbaatar", "اولان باټر" },
            { "timezone.excity.Asia/Vladivostok", "ولادیوستاک" },
            { "timezone.excity.Atlantic/Bermuda", "برمودا" },
            { "timezone.excity.Atlantic/Madeira", "مديرا" },
            { "timezone.excity.Atlantic/Stanley", "سټنلي" },
            { "timezone.excity.Australia/Darwin", "ډارون" },
            { "timezone.excity.Australia/Hobart", "هوبارټ" },
            { "timezone.excity.Australia/Sydney", "سډني" },
            { "timezone.excity.Europe/Amsterdam", "امستردام" },
            { "timezone.excity.Europe/Astrakhan", "استرا خان" },
            { "timezone.excity.Europe/Bucharest", "بخارست" },
            { "timezone.excity.Europe/Gibraltar", "جبل الطارق" },
            { "timezone.excity.Europe/Ljubljana", "لوبجانا" },
            { "timezone.excity.Europe/Mariehamn", "ميريهام" },
            { "timezone.excity.Europe/Podgorica", "پوډګوريکا" },
            { "timezone.excity.Europe/Stockholm", "استولوم" },
            { "timezone.excity.Europe/Ulyanovsk", "اليانوسک" },
            { "timezone.excity.Europe/Volgograd", "والګوګراډ" },
            { "timezone.excity.Indian/Christmas", "کريسمس" },
            { "timezone.excity.Indian/Kerguelen", "کرګولين" },
            { "timezone.excity.Indian/Mauritius", "ماريشيس" },
            { "timezone.excity.Pacific/Auckland", "اکلند" },
            { "timezone.excity.Pacific/Funafuti", "فونافوتي" },
            { "timezone.excity.Pacific/Honolulu", "هینولولو" },
            { "timezone.excity.Pacific/Pitcairn", "پيټيکيرن" },
            { "timezone.excity.Africa/Casablanca", "کاسابلانکا" },
            { "timezone.excity.Africa/Libreville", "لیبریل" },
            { "timezone.excity.Africa/Lubumbashi", "لبوباشي" },
            { "timezone.excity.Africa/Nouakchott", "نوکوچټ" },
            { "timezone.excity.Africa/Porto-Novo", "پورټو - نوو" },
            { "timezone.excity.America/Anchorage", "اینکریج" },
            { "timezone.excity.America/Araguaina", "ارګینیا" },
            { "timezone.excity.America/Boa_Vista", "بوا ویسټا" },
            { "timezone.excity.America/Catamarca", "کټامارکا" },
            { "timezone.excity.America/Chihuahua", "چھواھوا" },
            { "timezone.excity.America/Coyhaique", "کوهيک" },
            { "timezone.excity.America/Fortaleza", "فورتیلزا" },
            { "timezone.excity.America/Glace_Bay", "ګیسس بيی" },
            { "timezone.excity.America/Goose_Bay", "گوز بي" },
            { "timezone.excity.America/Guatemala", "ګواتمالا" },
            { "timezone.excity.America/Guayaquil", "ګوياکل" },
            { "timezone.excity.America/Matamoros", "ميټاموروس" },
            { "timezone.excity.America/Menominee", "مینومین" },
            { "timezone.excity.America/Monterrey", "منټرري" },
            { "timezone.excity.America/Sao_Paulo", "ساو پاولو" },
            { "timezone.excity.America/St_Thomas", "سينټ تهامس" },
            { "timezone.excity.America/Vancouver", "وینکوور" },
            { "timezone.excity.Antarctica/Mawson", "ماوسن" },
            { "timezone.excity.Antarctica/Palmer", "پالمر" },
            { "timezone.excity.Antarctica/Vostok", "واستوک" },
            { "timezone.excity.Asia/Kuala_Lumpur", "کولالمپور" },
            { "timezone.excity.Asia/Novokuznetsk", "نووکوزنیټک" },
            { "timezone.excity.Europe/Bratislava", "براټسلاوا" },
            { "timezone.excity.Europe/Copenhagen", "کوپن هيګن" },
            { "timezone.excity.Europe/Luxembourg", "لوګزامبورګ" },
            { "timezone.excity.Europe/San_Marino", "سان مارینو" },
            { "timezone.excity.Europe/Simferopol", "سیمفروپول" },
            { "timezone.excity.Pacific/Enderbury", "کانټون" },
            { "timezone.excity.Pacific/Galapagos", "ګالپګوس" },
            { "timezone.excity.Pacific/Kwajalein", "کواجلين" },
            { "timezone.excity.Pacific/Marquesas", "مارکيساس" },
            { "timezone.excity.Pacific/Pago_Pago", "پيګو پيګو" },
            { "timezone.excity.Pacific/Rarotonga", "راروټونګا" },
            { "timezone.excity.Pacific/Tongatapu", "ټونګاتاپو" },
            { "timezone.excity.Africa/Addis_Ababa", "اديس ابابا" },
            { "timezone.excity.Africa/Brazzaville", "برازاويل" },
            { "timezone.excity.Africa/Ouagadougou", "اوګوډوګو" },
            { "timezone.excity.America/Costa_Rica", "کوستاریکا" },
            { "timezone.excity.America/Grand_Turk", "لوی ترک" },
            { "timezone.excity.America/Guadeloupe", "ګالډیپ" },
            { "timezone.excity.America/Hermosillo", "هرموسیلو" },
            { "timezone.excity.America/Kralendijk", "کلینډیزج" },
            { "timezone.excity.America/Louisville", "لوئس ویل" },
            { "timezone.excity.America/Martinique", "مارټینیک" },
            { "timezone.excity.America/Metlakatla", "میتلاکاټلا" },
            { "timezone.excity.America/Montevideo", "مونټ وډیو" },
            { "timezone.excity.America/Montserrat", "مانټیسیرت" },
            { "timezone.excity.America/Paramaribo", "پاراماربو" },
            { "timezone.excity.America/Rio_Branco", "ریو برانکو" },
            { "timezone.excity.America/St_Vincent", "سېنټ ویسنټ" },
            { "timezone.excity.America/Whitehorse", "وايټ هارس" },
            { "timezone.excity.Antarctica/McMurdo", "مکمرډو" },
            { "timezone.excity.Antarctica/Rothera", "رودرا" },
            { "timezone.excity.Asia/Srednekolymsk", "سريډنيکوليمسک" },
            { "timezone.excity.Asia/Yekaterinburg", "يکاټيرنبرګ" },
            { "timezone.excity.Atlantic/Reykjavik", "ريکجاويک" },
            { "timezone.excity.Atlantic/St_Helena", "سینټ هیلینا" },
            { "timezone.excity.Australia/Adelaide", "اډیلایډ" },
            { "timezone.excity.Australia/Brisbane", "بریسبن" },
            { "timezone.excity.Australia/Lindeman", "لینډامین" },
            { "timezone.excity.Europe/Isle_of_Man", "د آئل آف مین" },
            { "timezone.excity.Europe/Kaliningrad", "کيلنينګراډ" },
            { "timezone.excity.Pacific/Kiritimati", "کيريټماټي" },
            { "timezone.excity.Africa/Johannesburg", "جوهانسبرګ" },
            { "timezone.excity.America/El_Salvador", "ايل سلوادور" },
            { "timezone.excity.America/Fort_Nelson", "فورټ نیلسن" },
            { "timezone.excity.America/Los_Angeles", "لاس اینجلس" },
            { "timezone.excity.America/Mexico_City", "مکسيکو ښار" },
            { "timezone.excity.America/Porto_Velho", "پورټو ویلهو" },
            { "timezone.excity.America/Puerto_Rico", "پورتو ریکو" },
            { "timezone.excity.America/Tegucigalpa", "ټګسیګالپا" },
            { "timezone.excity.Arctic/Longyearbyen", "لانګيربين" },
            { "timezone.excity.Atlantic/Cape_Verde", "کيپ ورډ" },
            { "timezone.excity.Australia/Lord_Howe", "لارډ هوي" },
            { "timezone.excity.Australia/Melbourne", "میلبورن" },
            { "timezone.excity.Indian/Antananarivo", "انتانناريوو" },
            { "timezone.excity.Pacific/Guadalcanal", "ګواډلکينال" },
            { "timezone.excity.Africa/Dar_es_Salaam", "دار السلام" },
            { "timezone.excity.America/Blanc-Sablon", "بلانک-سابلون" },
            { "timezone.excity.America/Buenos_Aires", "بينوس اييرز" },
            { "timezone.excity.America/Campo_Grande", "کمپو ګرډی" },
            { "timezone.excity.America/Danmarkshavn", "ډنمارکشان" },
            { "timezone.excity.America/Dawson_Creek", "داسن کریک" },
            { "timezone.excity.America/Indiana/Knox", "نوکس انډيانا" },
            { "timezone.excity.America/Indianapolis", "انډيانا پوليس" },
            { "timezone.excity.America/Punta_Arenas", "پنټا آریناس" },
            { "timezone.excity.America/Rankin_Inlet", "رينکن انلټ" },
            { "timezone.excity.America/Scoresbysund", "اټوکوټورمیټ" },
            { "timezone.excity.Antarctica/Macquarie", "مکواري" },
            { "timezone.excity.Pacific/Bougainville", "بوګن ویل" },
            { "timezone.excity.Pacific/Port_Moresby", "پورټ مورسبی" },
            { "timezone.excity.America/Cambridge_Bay", "کیمبرج بي" },
            { "timezone.excity.America/Ciudad_Juarez", "سیوداد جیوریز" },
            { "timezone.excity.America/Coral_Harbour", "اتیکوکن" },
            { "timezone.excity.America/Indiana/Vevay", "ویوی، انډيانا" },
            { "timezone.excity.America/Lower_Princes", "لوور پرنس کوارټر" },
            { "timezone.excity.America/Port_of_Spain", "د اسپانیا بندر" },
            { "timezone.excity.America/Santo_Domingo", "سنتو ډومینګو" },
            { "timezone.excity.America/St_Barthelemy", "سینټ بارټیلیم" },
            { "timezone.excity.America/Swift_Current", "سويفټ کرنټ" },
            { "timezone.excity.Australia/Broken_Hill", "بروکن هل" },
            { "timezone.excity.America/Bahia_Banderas", "بهیا بینډراس" },
            { "timezone.excity.America/Port-au-Prince", "پورټ ایو - پرنس" },
            { "timezone.excity.Atlantic/South_Georgia", "سويلي جورجيا" },
            { "timezone.excity.America/Argentina/Salta", "سالټا" },
            { "timezone.excity.America/Indiana/Marengo", "مورينګو انډيانا" },
            { "timezone.excity.America/Indiana/Winamac", "وينامک انډيانا" },
            { "timezone.excity.America/Argentina/Tucuman", "ټيکووم" },
            { "timezone.excity.America/Argentina/Ushuaia", "اوشوایا" },
            { "timezone.excity.America/Indiana/Tell_City", "ټل سټي، انډيانا" },
            { "timezone.excity.America/Indiana/Vincennes", "وينسينس، انډيانا" },
            { "timezone.excity.Antarctica/DumontDUrville", "ډومونټ ډي ارول" },
            { "timezone.excity.America/Argentina/La_Rioja", "لاريوجا" },
            { "timezone.excity.America/Argentina/San_Juan", "سان جوان" },
            { "timezone.excity.America/Argentina/San_Luis", "سان لویس" },
            { "timezone.excity.America/Indiana/Petersburg", "پيټسبرګ، انډيانا" },
            { "timezone.excity.America/Kentucky/Monticello", "مونټيسيلو، کونټکی" },
            { "timezone.excity.America/North_Dakota/Beulah", "بيولا، شمالي ډاکوټا" },
            { "timezone.excity.America/North_Dakota/Center", "مرکز، شمالي ډاکوټا" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "ريو ګيليګوس" },
            { "timezone.excity.America/North_Dakota/New_Salem", "نوی سلیم، شمالي داکوتا" },
        };
        return data;
    }
}
