/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;

public class SubsequenceIterator<T extends Item<?>>
implements SequenceIterator<T>,
LastPositionFinder,
LookaheadIterator<T> {
    private SequenceIterator<T> base;
    private int basePosition = 0;
    private int min;
    private int max;
    private T nextItem = null;

    private SubsequenceIterator(SequenceIterator<T> base, int min2, int max) throws XPathException {
        this.base = base;
        this.min = min2;
        if (min2 < 1) {
            min2 = 1;
        }
        this.max = max;
        if (max < min2) {
            this.nextItem = null;
            return;
        }
        int i = 1;
        while (i++ <= min2) {
            this.nextItem = base.next();
            ++this.basePosition;
            if (this.nextItem != null) continue;
            break;
        }
    }

    public static <T extends Item<?>> SequenceIterator<T> make(SequenceIterator<T> base, int min2, int max) throws XPathException {
        if (base instanceof ArrayIterator) {
            return ((ArrayIterator)base).makeSliceIterator(min2, max);
        }
        if (max == Integer.MAX_VALUE) {
            return TailIterator.make(base, min2);
        }
        if ((base.getProperties() & 1) != 0 && min2 > 4) {
            GroundedValue<T> value = base.materialize();
            value = value.subsequence(min2 - 1, max - min2 + 1);
            return value.iterate();
        }
        return new SubsequenceIterator<T>(base, min2, max);
    }

    @Override
    public boolean hasNext() {
        return this.nextItem != null;
    }

    @Override
    public T next() throws XPathException {
        if (this.nextItem == null) {
            return null;
        }
        T current = this.nextItem;
        if (this.basePosition < this.max) {
            this.nextItem = this.base.next();
            ++this.basePosition;
        } else {
            this.nextItem = null;
            this.base.close();
        }
        return current;
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public int getProperties() {
        int p = 4;
        return p |= this.base.getProperties() & 2;
    }

    @Override
    public int getLength() throws XPathException {
        int lastBase = ((LastPositionFinder)((Object)this.base)).getLength();
        int z = Math.min(lastBase, this.max);
        return Math.max(z - this.min + 1, 0);
    }
}

