/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.ui.internal.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.openhab.core.ui.internal.proxy.ProxyServletService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingProxyServlet
extends HttpServlet {
    private final Logger logger = LoggerFactory.getLogger(BlockingProxyServlet.class);
    private static final long serialVersionUID = -4716754591953017794L;
    private final ProxyServletService service;
    private static HttpClient httpClient = new HttpClient((SslContextFactory)new SslContextFactory.Client());
    private static final int TIMEOUT = 15000;

    BlockingProxyServlet(ProxyServletService service) {
        this.service = service;
        if (!httpClient.isStarted()) {
            try {
                httpClient.start();
            }
            catch (Exception e) {
                this.logger.warn("Cannot start HttpClient!", (Throwable)e);
            }
        }
    }

    public String getServletInfo() {
        return "Proxy (blocking)";
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        URI uri = this.service.uriFromRequest(request);
        if (uri == null) {
            this.service.sendError(request, response);
        } else {
            Request httpRequest = httpClient.newRequest(uri);
            this.service.maybeAppendAuthHeader(uri, httpRequest);
            InputStreamResponseListener listener = new InputStreamResponseListener();
            try {
                httpRequest.send((Response.CompleteListener)listener);
                Response httpResponse = listener.get(15000L, TimeUnit.MILLISECONDS);
                for (HttpField header : httpResponse.getHeaders()) {
                    response.setHeader(header.getName(), header.getValue());
                }
            }
            catch (TimeoutException e) {
                this.logger.warn("Proxy servlet failed to stream content due to a timeout");
                response.sendError(504);
                return;
            }
            catch (Exception e) {
                this.logger.warn("Proxy servlet failed to stream content: {}", (Object)e.getMessage());
                response.sendError(400, e.getMessage());
                return;
            }
            Throwable throwable = null;
            Object var7_11 = null;
            try (InputStream responseContent = listener.getInputStream();){
                responseContent.transferTo((OutputStream)response.getOutputStream());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

